/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.connect.sysmex;

import ch.elexis.connect.sysmex.Logger;
import ch.elexis.connect.sysmex.Messages;
import ch.elexis.connect.sysmex.packages.IProbe;
import ch.elexis.connect.sysmex.packages.KX21Data;
import ch.elexis.connect.sysmex.packages.KX21NData;
import ch.elexis.connect.sysmex.packages.PackageException;
import ch.elexis.connect.sysmex.packages.PocH100iData;
import ch.elexis.connect.sysmex.packages.UC1000Data;
import ch.elexis.connect.sysmex.ui.WhichPatientDialog;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.serial.Connection;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.importer.div.rs232.SerialConnectionUi;
import ch.elexis.core.ui.util.Log;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.LabItem;
import ch.elexis.data.Labor;
import ch.elexis.data.Patient;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.slf4j.LoggerFactory;

public class SysmexAction
extends Action
implements Connection.ComPortListener {
    Connection _ctrl;
    Labor _myLab;
    Logger _rs232log;
    Log _elexislog = Log.get((String)"SysmexAction");
    Thread msgDialogThread;
    Patient selectedPatient;
    boolean background = false;
    private ShutdownThread shutdownThread = null;
    String simulate = null;

    public SysmexAction() {
        super(Messages.SysmexAction_ButtonName, 2);
        this.setToolTipText(Messages.SysmexAction_ToolTip);
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"ch.elexis.connect.sysmex", (String)"icons/sysmex.png"));
    }

    private void initConnection() {
        if (this._ctrl != null && this._ctrl.isOpen()) {
            this._ctrl.close();
        }
        this._ctrl = new Connection(Messages.SysmexAction_ConnectionName, CoreHub.localCfg.get("connectors/sysmex/port", Messages.SysmexAction_DefaultPort), CoreHub.localCfg.get("connectors/sysmex/params", Messages.SysmexAction_DefaultParams), (Connection.ComPortListener)this).withStartOfChunk(new byte[]{2}).withEndOfChunk((byte[][])new byte[][]{{3}}).excludeDelimiters(true);
    }

    private void initPreferences() {
        if (CoreHub.localCfg.get("connectors/sysmex/log", "n").equalsIgnoreCase("y")) {
            try {
                this._rs232log = new Logger(String.valueOf(System.getProperty("user.home")) + File.separator + "elexis" + File.separator + "sysmex.log");
            }
            catch (FileNotFoundException e) {
                SWTHelper.showError((String)Messages.SysmexAction_LogError_Title, (String)Messages.SysmexAction_LogError_Text);
                this._rs232log = new Logger();
            }
        } else {
            this._rs232log = new Logger(false);
        }
        this.background = CoreHub.localCfg.get("connectors/sysmex/background", "n").equalsIgnoreCase("y");
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        block28: {
            if (!this.isChecked()) ** GOTO lbl70
            this.initPreferences();
            if (this.simulate == null) {
                this.initConnection();
                if (this._ctrl.connect()) {
                    timeoutStr = CoreHub.localCfg.get("connectors/sysmex/timeout", Messages.SysmexAction_DefaultTimeout);
                    timeout = 20;
                    try {
                        timeout = Integer.parseInt(timeoutStr);
                    }
                    catch (NumberFormatException var3_7) {
                        // empty catch block
                    }
                    SerialConnectionUi.awaitFrame((Connection)this._ctrl, (Shell)UiDesk.getTopShell(), (String)Messages.SysmexAction_WaitMsg, (int)timeout, (boolean)this.background, (boolean)true);
                    return;
                }
                this._rs232log.log("Error");
                SWTHelper.showError((String)Messages.SysmexAction_RS232_Error_Title, (String)Messages.SysmexAction_RS232_Error_Text);
            } else {
                SWTHelper.showInfo((String)"Simulating!!!", (String)this.simulate);
                inputStream = null;
                try {
                    inputStream = new FileInputStream(this.simulate);
                    test = inputStream.read();
                    while (test != -1) {
                        if (test == 2) {
                            test = inputStream.read();
                        }
                        baos = new ByteArrayOutputStream();
                        while (test != -1 && test != 3) {
                            baos.write(test);
                            test = inputStream.read();
                        }
                        data = baos.toByteArray();
                        this.gotData(null, data);
                        while (test != -1 && test != 2) {
                            test = inputStream.read();
                        }
                    }
                }
                catch (FileNotFoundException fne) {
                    fne.printStackTrace();
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    break block28;
                }
                catch (IOException ioe) {
                    try {
                        ioe.printStackTrace();
                        break block28;
                    }
                    catch (Throwable var5_14) {
                        throw var5_14;
                    }
                    finally {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                ** if (inputStream == null) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block28;
                }
lbl70:
                // 1 sources

                if (this._ctrl.isOpen()) {
                    this._ctrl.sendBreak();
                    this._ctrl.close();
                }
            }
        }
        this.setChecked(false);
    }

    private static void showError(final String title, final String message) {
        UiDesk.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = UiDesk.getTopShell();
                MessageDialog.openError((Shell)shell, (String)title, (String)message);
            }
        });
    }

    private void processProbe(final IProbe probe) {
        UiDesk.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                UiDesk.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Patient suggestedPatient;
                        (this).SysmexAction.this.selectedPatient = Patient.loadByPatientID((String)probe.getPatientId());
                        if (!((this).SysmexAction.this.selectedPatient != null && (this).SysmexAction.this.selectedPatient.exists() || (suggestedPatient = SysmexAction.this.findSuggestedPatient(probe.getPatientId())) == null)) {
                            WhichPatientDialog wpDialog = new WhichPatientDialog(UiDesk.getTopShell(), suggestedPatient);
                            wpDialog.open();
                            (this).SysmexAction.this.selectedPatient = wpDialog.getPatient();
                        }
                        if ((this).SysmexAction.this.selectedPatient == null || !(this).SysmexAction.this.selectedPatient.exists()) {
                            KontaktSelektor ksl = new KontaktSelektor(Hub.getActiveShell(), Patient.class, Messages.SysmexAction_Patient_Title, Messages.SysmexAction_Patient_Text, Patient.DEFAULT_SORT);
                            ksl.create();
                            ksl.getShell().setText(Messages.SysmexAction_Patient_Title);
                            (this).SysmexAction.this.selectedPatient = ksl.open() == 0 ? (Patient)ksl.getSelection() : null;
                        }
                        if ((this).SysmexAction.this.selectedPatient == null || !(this).SysmexAction.this.selectedPatient.exists()) {
                            LoggerFactory.getLogger(this.getClass()).info("No patient for id [" + probe.getPatientId() + "]");
                        } else {
                            LoggerFactory.getLogger(this.getClass()).info("Found patient [" + (this).SysmexAction.this.selectedPatient + "] for id [" + probe.getPatientId() + "]");
                        }
                    }
                });
                if (SysmexAction.this.selectedPatient != null && SysmexAction.this.selectedPatient.exists()) {
                    try {
                        probe.write(SysmexAction.this.selectedPatient);
                    }
                    catch (PackageException e) {
                        SysmexAction.showError(Messages.SysmexAction_ProbeError_Title, e.getMessage());
                    }
                } else {
                    SysmexAction.showError(Messages.SysmexAction_Patient_Title, Messages.SysmexAction_NoPatientMsg);
                }
            }
        });
    }

    private Patient findSuggestedPatient(String sysmexPatId) {
        if (sysmexPatId == null || sysmexPatId.isEmpty()) {
            return ElexisEventDispatcher.getSelectedPatient();
        }
        Patient suggestedPatient = Patient.loadByPatientID((String)sysmexPatId);
        if (suggestedPatient == null) {
            return ElexisEventDispatcher.getSelectedPatient();
        }
        return suggestedPatient;
    }

    public void gotData(Connection connection, byte[] data) {
        this.stopShutdownSequence();
        String content = new String(data);
        if (connection != null) {
            this._rs232log.logSTX();
            this._rs232log.log(content);
        }
        IProbe analysisProbe = null;
        String model = CoreHub.localCfg.get("connectors/sysmex/model", "KX-21");
        analysisProbe = "KX-21N".equals(model) ? new KX21NData() : ("pocH-100i".equals(model) ? new PocH100iData() : ("UC-1000".equals(model) ? new UC1000Data() : new KX21Data()));
        if (content.length() == analysisProbe.getSize()) {
            analysisProbe.parse(content);
            this.processProbe(analysisProbe);
        } else {
            SysmexAction.showError(Messages.SysmexAction_ErrorTitle, Messages.SysmexAction_WrongDataFormat);
        }
        if (connection != null) {
            this._rs232log.logETX();
        }
        ElexisEventDispatcher.reload(LabItem.class);
        boolean background = CoreHub.localCfg.get("connectors/sysmex/background", "n").equalsIgnoreCase("y");
        if (!background) {
            this.startShutdownSequence();
        }
    }

    private void stopShutdownSequence() {
        if (this.shutdownThread != null) {
            this.shutdownThread.stopSequence();
        }
    }

    private void startShutdownSequence() {
        if (this.shutdownThread == null) {
            this.shutdownThread = new ShutdownThread();
            this.shutdownThread.setPriority(1);
            this.shutdownThread.start();
        }
        this.shutdownThread.startSequence();
    }

    private void close() {
        if (this.shutdownThread != null) {
            this.shutdownThread.interrupt();
            this.shutdownThread = null;
        }
        this._ctrl.close();
    }

    public void closed() {
        this._elexislog.log("Closed", 4);
        this.setChecked(false);
    }

    private class ShutdownThread
    extends Thread {
        private boolean shouldShutdown = false;

        private ShutdownThread() {
        }

        public void startSequence() {
            SysmexAction.this._elexislog.log("Start sysmex shutdown sequence", 5);
            this.shouldShutdown = true;
        }

        public void stopSequence() {
            SysmexAction.this._elexislog.log("Stop sysmex shutdown sequence", 5);
            this.shouldShutdown = false;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    SysmexAction.this._elexislog.log("Waiting for sysmex shutdown..", 5);
                    while (!this.shouldShutdown) {
                    }
                    SysmexAction.this._elexislog.log("Sysmex shutdown sequence started (5 sec)..", 5);
                    Thread.sleep(5000L);
                    SysmexAction.this._elexislog.log("Sysmex shutdown sequence over. Should shutdown sysmex=" + this.shouldShutdown, 5);
                    if (!this.shouldShutdown) continue;
                    SysmexAction.this._elexislog.log("Shutdown", 4);
                    SysmexAction.this.close();
                }
            }
            catch (Exception exception) {
                return;
            }
        }
    }
}

