/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.connect.mythic;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.importer.div.importers.ImportHandler;
import ch.elexis.core.importer.div.importers.TransientLabResult;
import ch.elexis.core.importer.div.service.holder.LabImportUtilHolder;
import ch.elexis.core.model.ILabItem;
import ch.elexis.core.model.ILaboratory;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.serial.Connection;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.importer.div.importers.DefaultLabImportUiHandler;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.LabItem;
import ch.elexis.data.Patient;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MythicAction
extends Action
implements Connection.ComPortListener {
    private static final Logger logger = LoggerFactory.getLogger(MythicAction.class);
    ILaboratory myLab;
    Patient actPatient;
    private Connection ctrl;
    String[] results = new String[]{"WBC", "RBC", "HGB", "HCT", "MCV", "MCH", "MCHC", "RDW", "PLT", "MPV", "THT", "PDW", "LYM%", "MON%", "GRA%", "LYM", "MON", "GRA"};
    String[] units = new String[]{"G/l", "G/l", "g/dl", "%", "fl", "pg", "g/dl", "%", "G/l", "fl", "%", "%", "%", "%", "%", "G/l", "G/l", "G/l"};

    public MythicAction() {
        super("Mythic", 2);
        this.setToolTipText("Daten von Mythic einlesen");
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"ch.elexis.connect.mythic", (String)"icons/mythic.ico"));
        this.myLab = LabImportUtilHolder.get().getOrCreateLabor("Mythic");
    }

    public void run() {
        this.ctrl = new Connection("Elexis-Mythic", CoreHub.localCfg.get("connectors/mythic/port", "COM1"), CoreHub.localCfg.get("connectors/mythic/params", "9600,8,n,1"), (Connection.ComPortListener)this).withStartOfChunk("MYTHIC".getBytes()).withEndOfChunk((byte[][])new byte[][]{"END_RESULT".getBytes()}).excludeDelimiters(false);
        if (this.isChecked()) {
            KontaktSelektor ksl = new KontaktSelektor(Hub.getActiveShell(), Patient.class, "Patient ausw\u00e4hlen", "Wem soll der Mythic-Befund zugeordnet werden?", Patient.DEFAULT_SORT);
            ksl.create();
            ksl.getShell().setText("Mythic Patientenauswahl");
            if (ksl.open() == 0) {
                this.actPatient = (Patient)ksl.getSelection();
                if (this.ctrl.connect()) {
                    return;
                }
                SWTHelper.showError((String)"Fehler mit Port", (String)"Konnte seriellen Port nicht \u00f6ffnen");
            }
        } else if (this.ctrl.isOpen()) {
            this.actPatient = null;
            this.ctrl.sendBreak();
            this.ctrl.close();
        }
        this.setChecked(false);
    }

    public void gotChunk(Connection connection, String chunk) {
        String[] lines = chunk.split("\r");
        logger.debug("Got chunk with " + lines.length + " lines.");
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String data = stringArray[n2];
            if (this.actPatient != null) {
                if (data.startsWith("END_RESULT")) {
                    this.actPatient = null;
                    this.ctrl.close();
                    this.setChecked(false);
                    ElexisEventDispatcher.reload(LabItem.class);
                } else if (!data.startsWith("MYTHIC")) {
                    this.fetchResult(data);
                }
            }
            ++n2;
        }
    }

    private void fetchResult(String data) {
        String[] line = data.split(";");
        int idx = StringTool.getIndex((String[])this.results, (String)line[0]);
        if (idx != -1 && line.length > 7) {
            String ref = "";
            if (StringUtils.isNotBlank((CharSequence)line[5]) && StringUtils.isNotBlank((CharSequence)line[6])) {
                ref = String.valueOf(line[5]) + "-" + line[6];
            } else if (StringUtils.isNotBlank((CharSequence)line[5])) {
                ref = ">" + line[5];
            } else if (StringUtils.isNotBlank((CharSequence)line[6])) {
                ref = "<" + line[6];
            }
            ILabItem li = LabImportUtilHolder.get().getLabItem(line[0], this.myLab);
            if (li == null) {
                li = LabImportUtilHolder.get().createLabItem(line[0], line[0], this.myLab, ref, ref, this.units[idx], LabItemTyp.NUMERIC, "MTH Mythic", "50");
            }
            String comment = "";
            if (line[2].length() > 0 || line[3].length() > 0) {
                comment = String.valueOf(line[2]) + ";" + line[3];
            }
            IPatient iPatient = CoreModelServiceHolder.get().load(this.actPatient.getId(), IPatient.class).orElse(null);
            TransientLabResult tLabResult = new TransientLabResult.Builder(iPatient, this.myLab, li, line[1]).date(new TimeTool()).ref(ref).comment(comment).build(LabImportUtilHolder.get());
            LabImportUtilHolder.get().importLabResults(Collections.singletonList(tLabResult), (ImportHandler)new DefaultLabImportUiHandler());
        }
    }

    public void closed() {
        this.setChecked(false);
    }
}

