/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.connect.fuji.drichem3500;

import ch.elexis.connect.fuji.drichem3500.ConnectAction;
import ch.elexis.connect.fuji.drichem3500.EthernetClientThread;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EthernetListener
implements Runnable {
    protected static Logger log = LoggerFactory.getLogger(EthernetListener.class);
    private int serverPort;
    private Thread thread;
    private ServerSocket serverSocket;
    private ConnectAction action;
    public static boolean active;

    public EthernetListener(int serverPort, ConnectAction action) {
        this.serverPort = serverPort;
        this.action = action;
    }

    @Override
    public void run() {
        try {
            if (this.serverSocket == null || this.serverSocket.isClosed()) {
                this.serverSocket = new ServerSocket(this.serverPort);
                this.serverSocket.setSoTimeout(3000);
                log.debug("Fuji Drichem listening on PORT: " + this.serverPort + ", " + this.serverSocket);
            }
            while (active) {
                try {
                    Socket clientSocket = this.serverSocket.accept();
                    log.debug("serverSocket.accept()");
                    if (!active) continue;
                    EthernetClientThread cliThread = new EthernetClientThread(clientSocket, this.action);
                    cliThread.start();
                }
                catch (SocketTimeoutException clientSocket) {
                    // empty catch block
                }
            }
            this.serverSocket.close();
            this.serverSocket = null;
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            e.printStackTrace();
        }
    }

    public void startThread() {
        if (this.thread == null || this.thread.getState() == Thread.State.TERMINATED) {
            this.thread = new Thread(this);
            log.debug("Started thread for Fuji Drichem");
        }
        this.thread.start();
        active = true;
    }

    public void stopThread() {
        log.debug("Stopping Fuji Drichem listener");
        this.thread = null;
        active = false;
    }
}

