/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.connect.fuji.drichem3500;

import ch.elexis.connect.fuji.drichem3500.ConnectAction;
import ch.elexis.connect.fuji.drichem3500.FujiMessageHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EthernetClientThread
extends Thread {
    protected static Logger logger = LoggerFactory.getLogger(EthernetClientThread.class);
    final byte STX_BYTE = (byte)2;
    final byte ETX_BYTE = (byte)3;
    final byte[] ACK = new byte[]{6};
    private Socket clientSocket;
    private boolean running;
    private FujiMessageHandler messageHandler;

    public EthernetClientThread(Socket clientSocket, ConnectAction action) {
        this.clientSocket = clientSocket;
        this.messageHandler = new FujiMessageHandler(action);
    }

    @Override
    public void run() {
        InputStream in = null;
        this.running = true;
        try {
            try {
                in = this.clientSocket.getInputStream();
                while (this.running) {
                    String fujiMessage = this.readIncomingData(in);
                    if (!this.messageHandler.handle(fujiMessage)) continue;
                    this.running = false;
                }
            }
            catch (Exception e) {
                logger.info("Stop client connection.", (Throwable)e);
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (this.clientSocket != null) {
                        this.clientSocket.close();
                    }
                }
                catch (IOException e2) {
                    logger.warn("Stopped client connection.", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (this.clientSocket != null) {
                    this.clientSocket.close();
                }
            }
            catch (IOException e) {
                logger.warn("Stopped client connection.", (Throwable)e);
            }
        }
    }

    protected String readIncomingData(InputStream input) throws IOException {
        logger.debug("Received input stream " + input);
        StringBuilder sBuilder = new StringBuilder();
        boolean startOfMessage = false;
        boolean endOfMessage = false;
        int readByte = -1;
        while ((readByte = input.read()) != -1 && !endOfMessage) {
            if (readByte == 2) {
                logger.debug("STX (" + (char)readByte + ")");
                startOfMessage = true;
            }
            if (!startOfMessage) continue;
            if (readByte == 3) {
                logger.debug("ETX (" + (char)readByte + ")");
                endOfMessage = true;
                continue;
            }
            sBuilder.append((char)readByte);
        }
        logger.debug("End of Stream (etx " + endOfMessage + "). Data: " + sBuilder.toString());
        return sBuilder.toString();
    }
}

