/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.connect.afinion.packages;

import ch.elexis.connect.afinion.packages.HeaderPart;
import ch.elexis.connect.afinion.packages.PackageException;
import ch.elexis.connect.afinion.packages.SubRecordPart;
import ch.elexis.connect.afinion.packages.Value;
import ch.elexis.core.importer.div.importers.ImportHandler;
import ch.elexis.core.importer.div.importers.TransientLabResult;
import ch.elexis.core.importer.div.service.holder.LabImportUtilHolder;
import ch.elexis.core.ui.importer.div.importers.DefaultLabImportUiHandler;
import ch.elexis.data.Patient;
import java.util.ArrayList;
import java.util.Calendar;

public class Record {
    private HeaderPart header;
    private SubRecordPart[] parts = new SubRecordPart[4];
    private boolean isValid = false;
    private boolean isOutOfRange = false;

    public Record(byte[] bytes) {
        this.parse(bytes);
    }

    private void parse(byte[] bytes) {
        this.header = new HeaderPart(bytes);
        int pos = this.header.length();
        int i = 0;
        while (i < 4) {
            this.parts[i] = new SubRecordPart(bytes, pos);
            if (this.parts[i].isValid()) {
                this.isValid = true;
            }
            if (this.parts[i].isOutOfRange()) {
                this.isOutOfRange = true;
            }
            pos += this.parts[i].length();
            ++i;
        }
    }

    public String getId() {
        return this.header.getId();
    }

    public int getRecordNum() {
        return this.header.getRecordNum();
    }

    public Calendar getCalendar() {
        return this.header.getCalendar();
    }

    public int getRunNr() {
        return this.header.getRunNr();
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean isOutOfRange() {
        return this.isOutOfRange;
    }

    public String getText() {
        String text = "";
        int i = 0;
        while (i < this.parts.length) {
            if (this.parts[i].isValid()) {
                if (text.length() > 0) {
                    text = String.valueOf(text) + ", ";
                }
                text = String.valueOf(text) + this.parts[i].getKuerzel() + " " + this.parts[i].getResultStr() + " " + this.parts[i].getUnit();
            }
            ++i;
        }
        return text;
    }

    public void write(Patient patient) throws PackageException {
        ArrayList<TransientLabResult> results = new ArrayList<TransientLabResult>();
        int i = 0;
        while (i < this.parts.length) {
            if (this.parts[i].isValid()) {
                Value val = Value.getValue(this.parts[i].getKuerzel(), this.parts[i].getUnit());
                results.add(val.fetchValue(patient, this.parts[i].getResultStr(), "", this.header.getDate()));
            }
            ++i;
        }
        LabImportUtilHolder.get().importLabResults(results, (ImportHandler)new DefaultLabImportUiHandler());
    }

    public String toString() {
        String str = String.valueOf(this.header.toString()) + "\n";
        int i = 0;
        while (i < this.parts.length) {
            str = String.valueOf(str) + "S-Record " + i + ";";
            str = String.valueOf(str) + this.parts[i].toString() + "\n";
            ++i;
        }
        return str;
    }
}

