/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.connect.afinion.packages;

import ch.elexis.connect.afinion.packages.AbstractPart;
import ch.rgw.tools.TimeTool;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class HeaderPart
extends AbstractPart {
    private int recordNum;
    private int runNr;
    private String lotNr;
    private String id;
    private Calendar cal;

    public HeaderPart(byte[] bytes) {
        this.parse(bytes);
    }

    public static Calendar getUTCBaseCalendar() {
        GregorianCalendar cal0_utc = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal0_utc.set(1970, 0, 1, 0, 0, 0);
        cal0_utc.set(14, 0);
        return cal0_utc;
    }

    public void parse(byte[] bytes) {
        this.recordNum = this.getInteger(bytes, 0);
        this.runNr = this.getInteger(bytes, 4);
        this.lotNr = this.getString(bytes, 25, 17);
        this.id = this.getString(bytes, 42, 17);
        int dateSeconds = this.getInteger(bytes, 60);
        this.cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        this.cal.set(1970, 0, 1, 0, 0, 0);
        this.cal.set(13, dateSeconds);
        this.cal.getTime();
    }

    @Override
    public int length() {
        return 68;
    }

    public int getRecordNum() {
        return this.recordNum;
    }

    public String getLotNr() {
        return this.lotNr;
    }

    public int getRunNr() {
        return this.runNr;
    }

    public String getId() {
        return this.id;
    }

    public Calendar getCalendar() {
        return this.cal;
    }

    public TimeTool getDate() {
        return new TimeTool(this.getCalendar().getTimeInMillis());
    }

    private static String toTimeStampString(Calendar cal) {
        int date = cal.get(5);
        int month = cal.get(2) + 1;
        int year = cal.get(1);
        int hour = cal.get(11);
        int minutes = cal.get(12);
        int seconds = cal.get(13);
        String dateStr = String.valueOf(date < 10 ? "0" : "") + Integer.valueOf(date).toString();
        String monthStr = String.valueOf(month < 10 ? "0" : "") + Integer.valueOf(month).toString();
        String yearStr = Integer.valueOf(year).toString();
        String hourStr = String.valueOf(hour < 10 ? "0" : "") + Integer.valueOf(hour).toString();
        String minuteStr = String.valueOf(minutes < 10 ? "0" : "") + Integer.valueOf(minutes).toString();
        String secondStr = String.valueOf(seconds < 10 ? "0" : "") + Integer.valueOf(seconds).toString();
        return String.valueOf(dateStr) + "." + monthStr + "." + yearStr + " " + hourStr + ":" + minuteStr + ":" + secondStr + " (" + cal.getTimeZone().getID() + ")";
    }

    public String toString() {
        String str = "";
        str = String.valueOf(str) + "H-Record " + this.recordNum + ";";
        str = String.valueOf(str) + " " + HeaderPart.toTimeStampString(this.getCalendar()) + ";";
        str = String.valueOf(str) + " Run#:" + this.runNr + ";";
        str = String.valueOf(str) + " ID:" + this.id + ";";
        str = String.valueOf(str) + " Lot#:" + this.lotNr + ";";
        return str;
    }
}

