/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.buchhaltung.model;

import ch.elexis.base.ch.arzttarife.tarmed.ITarmedLeistung;
import ch.elexis.buchhaltung.model.Messages;
import ch.elexis.buchhaltung.util.PatientIdFormatter;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.status.ElexisStatus;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.VersionInfo;
import ch.unibe.iam.scg.archie.model.AbstractTimeSeries;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.LoggerFactory;

public class AlleLeistungen
extends AbstractTimeSeries {
    private static final String NAME = Messages.AlleLeistungen_Title;
    private static final DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private boolean hasUserId;

    public AlleLeistungen() {
        super(NAME);
        VersionInfo elexisVersion = new VersionInfo(CoreHub.Version);
        this.hasUserId = !elexisVersion.isOlder("2.1.7");
    }

    public String getDescription() {
        return Messages.AlleLeistungen_Description;
    }

    protected List<String> createHeadings() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(Messages.AlleLeistungen_InvoicingParty);
        ret.add(Messages.AlleLeistungen_Mandator);
        if (this.hasUserId) {
            ret.add(Messages.AlleLeistungen_User);
        }
        ret.add(Messages.AlleLeistungen_Doctor);
        ret.add(Messages.AlleLeistungen_TreatmentDate);
        ret.add(Messages.AlleLeistungen_PatientName);
        ret.add(Messages.AlleLeistungen_PatientFirstname);
        ret.add(Messages.AlleLeistungen_PatientId);
        ret.add(Messages.AlleLeistungen_PatientDateOfBirth);
        ret.add(Messages.AlleLeistungen_PatientSex);
        ret.add(Messages.AlleLeistungen_PatientZip);
        ret.add(Messages.AlleLeistungen_PatientCity);
        ret.add(Messages.AlleLeistungen_ActivityText);
        ret.add(Messages.AlleLeistungen_TarmedCode);
        ret.add(Messages.AlleLeistungen_TarmedAL);
        ret.add(Messages.AlleLeistungen_TarmedTL);
        ret.add(Messages.AlleLeistungen_TariffType);
        ret.add(Messages.AlleLeistungen_TaxPointValue);
        ret.add(Messages.AlleLeistungen_Quantity);
        ret.add(Messages.AlleLeistungen_PurchaseCosts);
        ret.add(Messages.AlleLeistungen_SaleCosts);
        ret.add(Messages.AlleLeistungen_Sales);
        ret.add(Messages.AlleLeistungen_VAT);
        ret.add(Messages.AlleLeistungen_BillState);
        return ret;
    }

    protected IStatus createContent(IProgressMonitor monitor) {
        int total = 10000000;
        IQuery query = CoreModelServiceHolder.get().getQuery(IEncounter.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IENCOUNTER__DATE, IQuery.COMPARATOR.GREATER_OR_EQUAL, (Object)new TimeTool(this.getStartDate().getTimeInMillis()).toLocalDate());
        query.and((EStructuralFeature)ModelPackage.Literals.IENCOUNTER__DATE, IQuery.COMPARATOR.LESS_OR_EQUAL, (Object)new TimeTool(this.getEndDate().getTimeInMillis()).toLocalDate());
        monitor.beginTask(NAME, total);
        monitor.subTask(Messages.FakturaJournal_DatabaseQuery);
        List consultations = query.execute();
        int sum = consultations.size();
        ArrayList<Comparable[]> result = new ArrayList<Comparable[]>();
        if (sum == 0) {
            monitor.done();
            this.dataSet.setContent(result);
            return Status.OK_STATUS;
        }
        int step = total / sum;
        monitor.worked(20 * step);
        PatientIdFormatter pif = new PatientIdFormatter(8);
        long time = System.currentTimeMillis();
        for (IEncounter cons : consultations) {
            IPatient patient = cons.getPatient();
            IMandator mandant = cons.getMandator();
            IInvoice consInvoice = cons.getInvoice();
            InvoiceState consInvoiceState = cons.getInvoiceState();
            String billState = String.valueOf(consInvoice != null ? "RG " + consInvoice.getNumber() + ": " : "") + consInvoiceState.getLocaleText();
            if (consInvoiceState.numericValue() >= InvoiceState.FROM_TODAY.numericValue() && consInvoiceState.numericValue() <= InvoiceState.NOT_FROM_YOU.numericValue()) {
                billState = Messages.AlleLeistungen_NoBill;
            }
            List activities = cons.getBilled();
            if (mandant != null && patient != null && activities != null && !activities.isEmpty()) {
                for (IBilled verrechnet : activities) {
                    IBillable verrechenbar = verrechnet.getBillable();
                    Comparable[] row = new Comparable[this.dataSet.getHeadings().size()];
                    int index = 0;
                    row[index++] = mandant.getBiller().getLabel();
                    row[index++] = mandant.getLabel();
                    if (this.hasUserId) {
                        IContact user = verrechnet.getBiller();
                        row[index++] = user != null ? user.getLabel() : "";
                    }
                    IContact familyDoctor = patient.getFamilyDoctor();
                    row[index++] = familyDoctor != null ? familyDoctor.getLabel() : "";
                    row[index++] = cons.getDate().format(dateFormat);
                    row[index++] = patient.getLastName();
                    row[index++] = patient.getFirstName();
                    row[index++] = pif.format(patient.getPatientNr());
                    row[index++] = this.getGeburtsDatum(patient);
                    row[index++] = patient.getGender();
                    row[index++] = patient.getZip();
                    row[index++] = patient.getCity();
                    row[index++] = verrechnet.getText();
                    if (verrechenbar != null) {
                        try {
                            row[index++] = verrechenbar.getCode() == null ? "?" : verrechenbar.getCode();
                            row[index++] = verrechenbar instanceof ITarmedLeistung ? Double.toString((double)((ITarmedLeistung)verrechenbar).getAL() / 100.0) : "";
                            row[index++] = verrechenbar instanceof ITarmedLeistung ? Double.toString((double)((ITarmedLeistung)verrechenbar).getTL() / 100.0) : "";
                        }
                        catch (NoClassDefFoundError error) {
                            ElexisStatus status = new ElexisStatus(4, "ch.elexis.buchhaltung.basis", 1, Messages.AlleLeistungen_TarmedMissing, 1);
                            StatusManager.getManager().handle((IStatus)status, 2);
                            return Status.CANCEL_STATUS;
                        }
                        row[index++] = verrechenbar.getCodeSystemName();
                    } else {
                        row[index++] = "";
                        row[index++] = "";
                        row[index++] = "";
                        row[index++] = "";
                    }
                    row[index++] = Double.valueOf(verrechnet.getFactor());
                    row[index++] = Double.valueOf(verrechnet.getAmount());
                    row[index++] = verrechnet.getNetPrice();
                    row[index++] = "";
                    row[index++] = Double.valueOf(verrechnet.getTotal().getAmount());
                    row[index++] = this.getVatScale(verrechnet);
                    row[index++] = billState;
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    result.add(row);
                }
            }
            monitor.worked(step);
        }
        LoggerFactory.getLogger(AlleLeistungen.class).debug("calculation of konsultations size: " + consultations.size() + " took " + Long.valueOf((System.currentTimeMillis() - time) / 1000L) + " seconds.");
        this.dataSet.setContent(result);
        monitor.done();
        return Status.OK_STATUS;
    }

    private String getVatScale(IBilled verrechnet) {
        String scale = (String)verrechnet.getExtInfo((Object)"vat_scale");
        if (scale != null) {
            return scale;
        }
        return "0.0";
    }

    private int getVatInfoCode(IBilled verrechnet) {
        String scale = this.getVatScale(verrechnet);
        if (scale != null) {
            return this.guessVatCode(scale);
        }
        return 0;
    }

    private int guessVatCode(String vatRate) {
        if (vatRate != null && !vatRate.isEmpty()) {
            double scale = Double.parseDouble(vatRate);
            if (scale == 0.0) {
                return 0;
            }
            if (scale < 7.0) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    private String getGeburtsDatum(IPatient patient) {
        LocalDateTime dob = patient.getDateOfBirth();
        return dob != null ? dob.format(dateFormat) : "";
    }
}

