/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.solr.task;

import ch.elexis.base.solr.task.DocumentIndexerIdentifiedRunnable;
import ch.elexis.base.solr.task.EncounterIndexerIdentifiedRunnable;
import ch.elexis.base.solr.task.LetterIndexerIdentifiedRunnable;
import ch.elexis.base.solr.task.SolrIndexerIdentifiedRunnableTaskDescriptor;
import ch.elexis.core.model.tasks.IIdentifiedRunnable;
import ch.elexis.core.model.tasks.IIdentifiedRunnableFactory;
import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.tasks.model.ITaskService;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.ComponentException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class SolrIndexerIdentifiedRunnableFactory
implements IIdentifiedRunnableFactory {
    @Reference
    private ITaskService taskService;
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;
    @Reference(target="(service.model.name=ch.elexis.omnivore.data.model)")
    private IModelService omnivoreModelService;
    @Reference
    private IConfigService configService;

    public List<IIdentifiedRunnable> getProvidedRunnables() {
        ArrayList<IIdentifiedRunnable> ret = new ArrayList<IIdentifiedRunnable>();
        ret.add(new EncounterIndexerIdentifiedRunnable(this.coreModelService, this.configService));
        ret.add(new LetterIndexerIdentifiedRunnable(this.coreModelService));
        ret.add(new DocumentIndexerIdentifiedRunnable(this.omnivoreModelService));
        return ret;
    }

    @Activate
    public void activate() {
        try {
            SolrIndexerIdentifiedRunnableTaskDescriptor.getOrCreateForEncounter(this.taskService);
            SolrIndexerIdentifiedRunnableTaskDescriptor.getOrCreateForLetter(this.taskService);
            SolrIndexerIdentifiedRunnableTaskDescriptor.getOrCreateForDocument(this.taskService);
        }
        catch (TaskException e) {
            LoggerFactory.getLogger(this.getClass()).error("initialize", (Throwable)e);
            throw new ComponentException((Throwable)e);
        }
        this.taskService.bindIIdentifiedRunnableFactory((IIdentifiedRunnableFactory)this);
    }

    @Deactivate
    public void deactivate() {
        this.taskService.unbindIIdentifiedRunnableFactory((IIdentifiedRunnableFactory)this);
    }
}

