/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.solr.task;

import ch.elexis.base.solr.internal.bean.IDocumentBean;
import ch.elexis.base.solr.task.AbstractIndexerIdentifiedRunnable;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.tasks.SingleIdentifiableTaskResult;
import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.time.TimeUtil;
import ch.elexis.core.types.DocumentStatus;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BaseHttpSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.response.SolrResponseBase;
import org.apache.solr.common.SolrException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;

public abstract class AbstractIDocumentIndexerIdentifiedRunnable
extends AbstractIndexerIdentifiedRunnable {
    public Map<String, Serializable> run(Map<String, Serializable> runContext, IProgressMonitor progressMonitor, Logger logger) throws TaskException {
        super.init(runContext);
        ArrayList<IDocument> indexedList = new ArrayList<IDocument>();
        ArrayList<IDocument> indexRemovedList = new ArrayList<IDocument>();
        HttpSolrClient.Builder solrClientBuilder = super.getSolrClientBuilder();
        String currentDocumentId = null;
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (HttpSolrClient solr = solrClientBuilder.build();){
                this.checkResponse((SolrResponseBase)solr.ping(this.getSolrCore()));
                List<?> docHandles = this.getDocuments();
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)docHandles.size());
                for (Object id : docHandles) {
                    byte[] content;
                    String patientId;
                    currentDocumentId = id.toString();
                    subMonitor.worked(1);
                    IDocument document = this.loadDocument(currentDocumentId);
                    if (document == null) {
                        logger.warn("[{}] not loadable , skipping", (Object)currentDocumentId);
                        this.failures.add(new SingleIdentifiableTaskResult(currentDocumentId, "not loadable (null), skipping"));
                        continue;
                    }
                    if (new HashSet(document.getStatus()).contains(DocumentStatus.INDEXED) && document.isDeleted()) {
                        try {
                            this.checkResponse((SolrResponseBase)solr.deleteById(this.getSolrCore(), currentDocumentId));
                            document.setStatus(DocumentStatus.INDEXED, false);
                            this.getModelService().save((Identifiable)document);
                            indexRemovedList.add(document);
                        }
                        catch (SolrServerException sse) {
                            logger.warn("[{}] could not be deleted from solr index", (Object)currentDocumentId, (Object)sse);
                            this.failures.add(new SingleIdentifiableTaskResult(currentDocumentId, "could not be deleted from solr index"));
                        }
                        continue;
                    }
                    String string = patientId = document.getPatient() != null ? document.getPatient().getId() : null;
                    if (patientId == null) {
                        logger.warn("[{}] no associated patient, skipping", (Object)currentDocumentId);
                        this.failures.add(new SingleIdentifiableTaskResult(currentDocumentId, "no assocatied patient, skipping"));
                        continue;
                    }
                    Throwable throwable2 = null;
                    Object var19_25 = null;
                    try (InputStream is = document.getContent();){
                        if (is == null) {
                            logger.info("[{}] content is null, marking and skipping", (Object)document.getId());
                            this.failures.add(new SingleIdentifiableTaskResult(currentDocumentId, "content is null, marking and skipping"));
                            document.setStatus(DocumentStatus.NOT_FOUND_OR_NO_CONTENT, true);
                            this.getModelService().save((Identifiable)document);
                            continue;
                        }
                        content = IOUtils.toByteArray((InputStream)is);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                    String[] solrCellData = null;
                    if (content.length == 0) {
                        logger.info("[{}] content length is 0, marking indexed", (Object)document.getId());
                        this.failures.add(new SingleIdentifiableTaskResult(currentDocumentId, "content length is 0, marking indexed "));
                    } else {
                        try {
                            solrCellData = this.getUtil().performSolrCellRequest(solr, this.getSolrCore(), content);
                        }
                        catch (SolrException e) {
                            if (e.getMessage().contains("EncryptedDocumentException")) {
                                logger.warn("[{}] " + e.getMessage() + ", marking indexed", (Object)document.getId());
                                this.failures.add(new SingleIdentifiableTaskResult(document.getId(), String.valueOf(e.getMessage()) + ", marking indexed"));
                            }
                            logger.error("[{}] " + e.getMessage(), id);
                            throw e;
                        }
                    }
                    document.setStatus(DocumentStatus.INDEXED, true);
                    try {
                        this.getModelService().save((Identifiable)document);
                    }
                    catch (IllegalStateException e) {
                        logger.warn("[{}] could not be saved, see logs", (Object)currentDocumentId);
                        this.failures.add(new SingleIdentifiableTaskResult(currentDocumentId, "could not be saved, see logs"));
                        continue;
                    }
                    if (solrCellData != null) {
                        IDocumentBean documentBean = new IDocumentBean();
                        documentBean.setId(document.getId());
                        LocalDate localDate = TimeUtil.toLocalDate((Date)document.getCreated());
                        String date = localDate != null ? TimeUtil.formatSafe((LocalDate)localDate) : "??.??.????";
                        String title = StringUtils.isNotBlank((CharSequence)document.getTitle()) ? document.getTitle().trim() : document.getKeywords();
                        documentBean.setLabel(String.valueOf(date) + " - " + title);
                        documentBean.setPatientId(patientId);
                        documentBean.setLastUpdate(document.getLastupdate());
                        documentBean.setCreationDate(document.getCreated());
                        documentBean.setContent(solrCellData[0]);
                        try {
                            this.checkResponse((SolrResponseBase)solr.addBean(this.getSolrCore(), (Object)documentBean));
                            indexedList.add(document);
                        }
                        catch (SolrServerException sse) {
                            this.handleWarn(logger, document, currentDocumentId, (Exception)((Object)sse));
                            continue;
                        }
                        catch (BaseHttpSolrClient.RemoteSolrException rse) {
                            if (rse.getMessage().contains("OOXMLParser")) {
                                this.handleWarn(logger, document, currentDocumentId, (Exception)((Object)rse));
                                continue;
                            }
                            throw rse;
                        }
                    }
                    if (subMonitor.isCanceled()) {
                        logger.info("Task is cancelled");
                        break;
                    }
                    boolean isOverMaxRunTime = super.checkIsOverMaxRunTime();
                    if (isOverMaxRunTime) break;
                }
                try {
                    this.checkResponse((SolrResponseBase)solr.commit(this.getSolrCore()));
                }
                catch (SolrServerException sse) {
                    indexedList.stream().forEach(letter -> {
                        letter.setStatus(DocumentStatus.INDEXED, false);
                        this.getModelService().save((Identifiable)letter);
                    });
                    indexRemovedList.stream().forEach(letter -> {
                        letter.setStatus(DocumentStatus.INDEXED, true);
                        this.getModelService().save((Identifiable)letter);
                    });
                    throw sse;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException | SolrServerException e) {
            throw new TaskException(6, currentDocumentId, e);
        }
        this.resultMap.put("resultData", String.valueOf(indexedList.size()) + " indexed / " + indexRemovedList.size() + " index removed");
        if (this.failures.size() > 0) {
            this.resultMap.put("markerWarn", null);
            this.resultMap.put("resultClass", SingleIdentifiableTaskResult.class.getName());
            this.resultMap.put("resultDataList", this.failures);
        }
        if (indexedList.size() == 0 && indexRemovedList.size() == 0 && this.failures.size() == 0) {
            this.resultMap.put("markerDoNotPersist", true);
        }
        return this.resultMap;
    }

    private void handleWarn(Logger logger, IDocument document, String currentDocumentId, Exception ex) {
        logger.warn("[{}] could not add to solr index, unsetting index status", (Object)currentDocumentId, (Object)ex);
        this.failures.add(new SingleIdentifiableTaskResult(currentDocumentId, "could not add to solr index, unsetting index status"));
        document.setStatus(DocumentStatus.INDEXED, false);
        this.getModelService().save((Identifiable)document);
    }

    protected abstract String getSolrCore();

    protected abstract IModelService getModelService();

    protected abstract IDocument loadDocument(String var1);

    protected abstract List<?> getDocuments();
}

