/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.solr.internal.bean;

import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import java.time.ZoneId;
import java.util.Date;
import org.apache.solr.client.solrj.beans.Field;

public class EncounterBean {
    @Field
    public String id;
    @Field
    public String patient_id;
    @Field
    public String mandator_id;
    @Field
    public String label;
    @Field(value="content")
    public String content;
    @Field(value="cr_date")
    public Date cr_date;

    public static EncounterBean of(IEncounter orig) {
        EncounterBean bean = new EncounterBean();
        bean.setId(orig.getId());
        IPatient patient = orig.getPatient();
        if (patient == null) {
            throw new IllegalArgumentException("patient is null");
        }
        bean.setPatient_id(patient.getId());
        bean.setLabel(orig.getDate() + " - " + patient.getLabel());
        IMandator mandator = orig.getMandator();
        if (mandator != null) {
            bean.setMandator_id(mandator.getId());
        } else {
            bean.setMandator_id("");
        }
        bean.setContent(orig.getHeadVersionInPlaintext());
        Date cr_date = Date.from(orig.getDate().atTime(9, 0).atZone(ZoneId.systemDefault()).toInstant());
        bean.setCr_date(cr_date);
        return bean;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPatient_id() {
        return this.patient_id;
    }

    public void setPatient_id(String patient_id) {
        this.patient_id = patient_id;
    }

    public String getMandator_id() {
        return this.mandator_id;
    }

    public void setMandator_id(String mandator_id) {
        this.mandator_id = mandator_id;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Date getCr_date() {
        return this.cr_date;
    }

    public void setCr_date(Date cr_date) {
        this.cr_date = cr_date;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }
}

