/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.messages;

import ch.elexis.base.messages.Messages;
import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IMessage;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.IUserGroup;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.builder.IMessageBuilder;
import ch.elexis.core.model.builder.IReminderBuilder;
import ch.elexis.core.model.format.UserFormatUtil;
import ch.elexis.core.model.issue.ProcessStatus;
import ch.elexis.core.model.issue.Visibility;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.util.SWTHelper;
import ch.rgw.tools.TimeTool;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MsgDetailDialog
extends Dialog {
    private Label lblFrom;
    private ComboViewer cbTo;
    private Button groupBtn;
    private Text txtMessage;
    private IMessage incomingMsg;
    private Button bOK;
    private Button bAnswer;

    MsgDetailDialog(Shell shell, IMessage msg) {
        super(shell);
        this.setShellStyle(2144);
        this.incomingMsg = msg;
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        ret.setLayout((Layout)new GridLayout(5, false));
        Label lblMessageInfo = new Label(ret, 0);
        lblMessageInfo.setLayoutData((Object)SWTHelper.getFillGridData((int)5, (boolean)true, (int)1, (boolean)false));
        String msgLabel = this.incomingMsg == null ? new TimeTool().toString(0) : new TimeTool(this.incomingMsg.getCreateDateTime()).toString(0);
        lblMessageInfo.setText(String.valueOf(Messages.MsgDetailDialog_messageDated) + msgLabel);
        new Label(ret, 0).setText(Messages.MsgDetailDialog_from);
        this.lblFrom = new Label(ret, 0);
        new Label(ret, 0).setText(Messages.MsgDetailDialog_to);
        this.cbTo = new ComboViewer(ret, 12);
        this.cbTo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cbTo.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IContact && e2 instanceof IContact) {
                    IContact anw1 = (IContact)e1;
                    IContact anw2 = (IContact)e2;
                    return String.CASE_INSENSITIVE_ORDER.compare(UserFormatUtil.getUserLabel((IContact)anw1), UserFormatUtil.getUserLabel((IContact)anw2));
                }
                if (e1 instanceof IUserGroup && e2 instanceof IUserGroup) {
                    IUserGroup ug1 = (IUserGroup)e1;
                    IUserGroup ug2 = (IUserGroup)e2;
                    return String.CASE_INSENSITIVE_ORDER.compare(ug1.getGroupname(), ug2.getGroupname());
                }
                return 0;
            }
        });
        this.cbTo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IContact) {
                    IContact anw = (IContact)element;
                    return UserFormatUtil.getUserLabel((IContact)anw);
                }
                if (element instanceof IUserGroup) {
                    return ((IUserGroup)element).getGroupname();
                }
                return super.getText(element);
            }
        });
        List<IContact> users = this.setComboUserInput();
        this.groupBtn = new Button(ret, 32);
        this.groupBtn.setText(" Gruppe");
        this.groupBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MsgDetailDialog.this.groupBtn.getSelection()) {
                    MsgDetailDialog.this.setComboGroupInput();
                } else {
                    MsgDetailDialog.this.setComboUserInput();
                }
            }
        });
        new Label(ret, 258).setLayoutData((Object)SWTHelper.getFillGridData((int)5, (boolean)true, (int)1, (boolean)false));
        if (this.incomingMsg != null) {
            String senderString = this.incomingMsg.getSender();
            Optional<IContact> sender = this.getSender(this.incomingMsg);
            if (sender.isPresent()) {
                senderString = UserFormatUtil.getUserLabel((IContact)sender.get());
            }
            this.lblFrom.setText(senderString);
            Optional<IContact> destination = this.getDestination(this.incomingMsg);
            if (destination.isPresent() && sender.isPresent()) {
                for (IContact anwender : users) {
                    if (!destination.get().getId().equals(anwender.getId())) continue;
                    sender = Optional.of(anwender);
                    break;
                }
            }
            if (sender.isPresent()) {
                this.cbTo.setSelection((ISelection)new StructuredSelection((Object)sender.get()));
            }
            this.cbTo.getCombo().setEnabled(false);
            this.groupBtn.setEnabled(false);
            new Label(ret, 0).setText(Messages.MsgDetailDialog_message);
            final Text txtIncomingMsg = new Text(ret, 2056);
            GridData gd_txtIncomingMsg = new GridData(4, 0x1000000, true, false, 3, 1);
            txtIncomingMsg.setLayoutData((Object)gd_txtIncomingMsg);
            txtIncomingMsg.setText(this.incomingMsg.getMessageText());
            Button copyButton = new Button(ret, 8);
            copyButton.setText(Messages.MsgDetailDialog_Copy);
            GridData gd_copyButton = new GridData(131072, 0x1000000, false, false, 1, 1);
            copyButton.setLayoutData((Object)gd_copyButton);
            copyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Clipboard clipboard = new Clipboard(Display.getCurrent());
                    String textToCopy = txtIncomingMsg.getText();
                    clipboard.setContents(new Object[]{textToCopy}, new Transfer[]{TextTransfer.getInstance()});
                    clipboard.dispose();
                }
            });
            new Label(ret, 0).setText(Messages.MsgDetailDialog_answer);
        } else {
            this.lblFrom.setText(UserFormatUtil.getUserLabel((IContact)((IContact)ContextServiceHolder.get().getActiveUserContact().get())));
            new Label(ret, 0).setText(Messages.MsgDetailDialog_message);
        }
        this.txtMessage = SWTHelper.createText((Composite)ret, (int)1, (int)2048);
        this.txtMessage.setLayoutData((Object)SWTHelper.getFillGridData((int)4, (boolean)true, (int)1, (boolean)true));
        this.txtMessage.addModifyListener(e -> {
            if (this.txtMessage.getText() != null && this.txtMessage.getText().length() > 0) {
                this.getShell().setDefaultButton(this.bAnswer);
            } else {
                this.getShell().setDefaultButton(this.bOK);
            }
        });
        return ret;
    }

    private void setComboGroupInput() {
        List<IUserGroup> groups = this.getUserGroups();
        this.cbTo.setInput(groups);
        this.cbTo.refresh();
    }

    private List<IUserGroup> getUserGroups() {
        List userGroups = CoreModelServiceHolder.get().getQuery(IUserGroup.class).execute();
        userGroups.sort((u1, u2) -> u1.getLabel().compareTo(u2.getLabel()));
        return userGroups;
    }

    private List<IContact> setComboUserInput() {
        List<IContact> users = this.getUsers();
        this.cbTo.setInput(users);
        String preferenceKey = this.getPreferenceKeyForUser();
        String savedRecipientId = ConfigServiceHolder.getUser((String)preferenceKey, null);
        if (savedRecipientId != null && !savedRecipientId.isEmpty()) {
            for (IContact user : users) {
                if (!user.getId().equals(savedRecipientId)) continue;
                this.cbTo.setSelection((ISelection)new StructuredSelection((Object)user));
                break;
            }
        } else {
            this.cbTo.setSelection((ISelection)new StructuredSelection((Object)users.get(0)));
        }
        return users;
    }

    private Optional<IContact> getSender(IMessage message) {
        if (StringUtils.isNotBlank((CharSequence)message.getSender())) {
            return CoreModelServiceHolder.get().load(message.getSender(), IContact.class, true);
        }
        return Optional.empty();
    }

    private Optional<IContact> getDestination(IMessage message) {
        if (message.getReceiver() != null && !message.getReceiver().isEmpty()) {
            return CoreModelServiceHolder.get().load((String)message.getReceiver().get(0), IContact.class, true);
        }
        return Optional.empty();
    }

    private List<IContact> getUsers() {
        IQuery userQuery = CoreModelServiceHolder.get().getQuery(IUser.class);
        userQuery.and((EStructuralFeature)ModelPackage.Literals.IUSER__ASSIGNED_CONTACT, IQuery.COMPARATOR.NOT_EQUALS, null);
        List users = userQuery.execute();
        return users.stream().filter(u -> this.isActive((IUser)u)).map(u -> u.getAssignedContact()).collect(Collectors.toList());
    }

    private boolean isActive(IUser user) {
        IMandator mandator;
        if (user == null || user.getAssignedContact() == null) {
            return false;
        }
        if (!user.isActive()) {
            return false;
        }
        return user.getAssignedContact() == null || !user.getAssignedContact().isMandator() || (mandator = (IMandator)CoreModelServiceHolder.get().load(user.getAssignedContact().getId(), IMandator.class).orElse(null)) == null || mandator.isActive();
    }

    public void create() {
        super.create();
        if (this.incomingMsg == null) {
            this.getShell().setText(Messages.MsgDetailDialog_createMessage);
        } else {
            this.getShell().setText(Messages.MsgDetailDialog_readMessage);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        String sOK = this.incomingMsg == null ? Messages.MsgDetailDialog_send : Messages.MsgDetailDialog_delete;
        this.bOK = this.createButton(parent, 0, sOK, false);
        parent.getShell().setDefaultButton(this.bOK);
        this.bAnswer = this.createButton(parent, 1025, Messages.MsgDetailDialog_reply, false);
        if (this.incomingMsg == null) {
            this.bAnswer.setEnabled(false);
        }
        Button bReminder = this.createButton(parent, 1026, Messages.MsgDetailDialog_asReminder, false);
        if (this.incomingMsg == null) {
            bReminder.setEnabled(false);
        }
        this.createButton(parent, 1, Messages.MsgDetailDialog_cancel, false);
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 0: {
                this.okPressed();
                return;
            }
            case 1025: {
                if (this.incomingMsg != null) {
                    ContextServiceHolder.get().getActiveUserContact().ifPresent(uc -> this.getSender(this.incomingMsg).ifPresent(sc -> {
                        IMessage message = (IMessage)new IMessageBuilder(CoreModelServiceHolder.get(), uc, sc).build();
                        message.setMessageText(this.txtMessage.getText());
                        CoreModelServiceHolder.get().save((Identifiable)message);
                    }));
                }
                this.okPressed();
            }
            case 1026: {
                StructuredSelection ss = (StructuredSelection)this.cbTo.getSelection();
                if (!ss.isEmpty()) {
                    IContact destination = (IContact)ss.getFirstElement();
                    new IReminderBuilder(CoreModelServiceHolder.get(), ContextServiceHolder.get(), Visibility.ALWAYS, ProcessStatus.OPEN, this.incomingMsg.getMessageText()).addResponsible(destination).buildAndSave();
                }
                this.okPressed();
            }
        }
        super.buttonPressed(buttonId);
    }

    protected void okPressed() {
        if (this.incomingMsg == null) {
            StructuredSelection ss = (StructuredSelection)this.cbTo.getSelection();
            if (!ss.isEmpty()) {
                ContextServiceHolder.get().getActiveUserContact().ifPresent(uc -> {
                    if (ss.getFirstElement() instanceof IContact) {
                        this.createMessage((IContact)uc, (IContact)ss.getFirstElement());
                    } else if (ss.getFirstElement() instanceof IUserGroup) {
                        IUserGroup userGoup = (IUserGroup)ss.getFirstElement();
                        for (IUser user : userGoup.getUsers()) {
                            if (user.getAssignedContact() == null) continue;
                            this.createMessage((IContact)uc, user.getAssignedContact());
                        }
                    }
                });
            }
        } else {
            CoreModelServiceHolder.get().delete((Deleteable)this.incomingMsg);
        }
        super.okPressed();
    }

    private void createMessage(IContact sender, IContact receiver) {
        IMessage message = (IMessage)new IMessageBuilder(CoreModelServiceHolder.get(), sender, receiver).build();
        message.setMessageText(this.txtMessage.getText());
        CoreModelServiceHolder.get().save((Identifiable)message);
    }

    private String getPreferenceKeyForUser() {
        String userId = ((IContact)ContextServiceHolder.get().getActiveUserContact().get()).getId();
        return "messages/default_recipient_" + userId;
    }
}

