/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.konsextension.bildanzeige;

import ch.elexis.base.konsextension.bildanzeige.Messages;
import ch.elexis.core.ui.icons.ImageSize;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.images.Bild;
import java.io.File;
import java.io.FileOutputStream;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class BildanzeigeFenster
extends TitleAreaDialog {
    Bild bild;
    Image img;

    public BildanzeigeFenster(Shell shell, Bild bild) {
        super(shell);
        this.bild = bild;
    }

    protected Control createDialogArea(Composite parent) {
        ScrolledComposite ret = new ScrolledComposite(parent, 2816);
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        Composite canvas = new Composite((Composite)ret, 0);
        ret.setContent((Control)canvas);
        this.img = this.bild.createImage();
        Rectangle r = this.img.getBounds();
        canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                gc.drawImage(BildanzeigeFenster.this.img, 0, 0);
            }
        });
        canvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                BildanzeigeFenster.this.img.dispose();
            }
        });
        canvas.setSize(r.width, r.height);
        return ret;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button bClose = this.createButton(parent, 0, Messages.BildanzeigeFenster_Close, true);
        bClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BildanzeigeFenster.this.okPressed();
            }
        });
        Button bExport = this.createButton(parent, 4, Messages.BildanzeigeFenster_Export, false);
        bExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(BildanzeigeFenster.this.getShell(), 8192);
                fd.setFileName(BildanzeigeFenster.this.bild.get("Titel"));
                String fname = fd.open();
                if (fname != null) {
                    File file = new File(fname);
                    try {
                        if (!file.createNewFile() || !file.canWrite()) {
                            SWTHelper.showError((String)Messages.BildanzeigeFenster_Error, (String)(String.valueOf(Messages.BildanzeigeFenster_Cannot) + fname + Messages.BildanzeigeFenster_Create));
                        } else {
                            byte[] arr = BildanzeigeFenster.this.bild.getData();
                            FileOutputStream fout = new FileOutputStream(file);
                            fout.write(arr);
                            fout.close();
                        }
                    }
                    catch (Exception ex) {
                        SWTHelper.showError((String)Messages.BildanzeigeFenster_Error, (String)(String.valueOf(Messages.BildanzeigeFenster_ErrorWriting) + fname));
                    }
                }
            }
        });
    }

    public void create() {
        super.create();
        this.getShell().setText(this.bild.getPatient().getLabel());
        this.setTitle(this.bild.getLabel());
        this.setMessage(this.bild.get("Info"));
        this.setTitleImage(Images.IMG_LOGO.getImage(ImageSize._75x66_TitleDialogIconSize));
    }
}

