/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.ticode;

import ch.elexis.base.ch.ticode.Messages;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.model.IDiagnosisTree;
import ch.elexis.core.model.IXid;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Optional;
import org.slf4j.LoggerFactory;

public class TessinerCode
implements IDiagnosisTree {
    public static final String CODESYSTEM_NAME = "TI-Code";
    private static Hashtable<String, TessinerCode> hash = new Hashtable();
    private String text;
    private String code;
    public static final String[][] ticode = new String[][]{{"A", Messages.TICode_Heart, Messages.TICode_valves, Messages.TICode_coronaria, Messages.TICode_rhythm, Messages.TICode_hypertonia, Messages.TICode_arteries, Messages.TICode_veins, Messages.TICode_lymphVessels, Messages.TICode_heartOther}, {"B", Messages.TICode_blood, Messages.TICode_anemia, Messages.TICode_coagulo, Messages.TICode_boneMarrow, Messages.TICode_spleen, Messages.TICode_bloodOther}, {"C", Messages.TICode_lung, Messages.TICode_asthma, Messages.TICode_cough, Messages.TICode_embolism, Messages.TICode_lungPleural, Messages.TICode_lungOther}, {"D", Messages.TICode_locomotion, Messages.TICode_muscle, Messages.TICode_joint, Messages.TICode_arthtiris, Messages.TICode_arthrosis, Messages.TICode_vertebral, Messages.TICode_locoOther}, {"E", Messages.TICode_digestive, Messages.TICode_esophagus, Messages.TICode_bowel, Messages.TICode_rectum, Messages.TICode_liver, Messages.TICode_pancreas, Messages.TICode_diaphragm, Messages.TICode_hernia, Messages.TICode_digestiveOther}, {"F", Messages.TICode_metabolic, Messages.TICode_diabetes, Messages.TICode_thyroid, Messages.TICode_metabolicOther}, {"G", Messages.TICode_infections, Messages.TICode_simpleInfection, Messages.TICode_tuberculosis, Messages.TICode_hepatitis, Messages.TICode_infectionOther}, {"H", Messages.TICode_urinary, Messages.TICode_kidney, Messages.TICode_stones, Messages.TICode_ureters, Messages.TICode_urinaryOther}, {"I", Messages.TICode_sexual, Messages.TICode_male, Messages.TICode_vaginal, Messages.TICode_uterus, Messages.TICode_adnexes, Messages.TICode_cycle, Messages.TICode_mammae, Messages.TICode_sterilisation, Messages.TICode_sexualOther}, {"K", Messages.TICode_reproduction, Messages.TICode_pregnancyNormal, Messages.TICode_pregnancyAbnormal, Messages.TICode_sterility, Messages.TICode_reproductionOther}, {"L", Messages.TICode_nervous, Messages.TICode_brain, Messages.TICode_nerves, Messages.TICode_palsy, Messages.TICode_migraine, Messages.TICode_epilepsy, Messages.TICode_nervousOther}, {"M", Messages.TICode_psyche, Messages.TICode_sleep, Messages.TICode_psychic, Messages.TICode_psychoorganic, Messages.TICode_psycheOther}, {"N", Messages.TICode_skin, Messages.TICode_allergic, Messages.TICode_inflammation, Messages.TICode_ekcema, Messages.TICode_vaskular, Messages.TICode_psoriasis, Messages.TICode_scars, Messages.TICode_skinOther}, {"O", Messages.TICode_orl, Messages.TICode_nose, Messages.TICode_sinuses, Messages.TICode_mouth, Messages.TICode_tonsil, Messages.TICode_larynx, Messages.TICode_earform, Messages.TICode_middleEar, Messages.TICode_innerEar, Messages.TICode_orlOther}, {"P", Messages.TICode_eye, Messages.TICode_lid, Messages.TICode_cornea, Messages.TICode_eyemuscles, Messages.TICode_iris, Messages.TICode_retina, Messages.TICode_eyeOther}, {"Q", Messages.TICode_jaw, Messages.TICode_cyst, Messages.TICode_toothabscess, Messages.TICode_fibroma, Messages.TICode_jawOther}, {"R", Messages.TICode_accidents, Messages.TICode_accidentHead, Messages.TICode_accisdentThorax, Messages.TICode_accidentAbdomen, Messages.TICode_accidentArm, Messages.TICode_accidentLeg, Messages.TICode_AccidentOther}, {"S", Messages.TICode_nonmust, Messages.TICode_nonmust}, {"T", Messages.TICode_prevention, Messages.TICode_preventionCheck, Messages.TICode_vaccination, Messages.TICode_other}, {"U", Messages.TICode_docInformed, Messages.TICode_docInformed}, {"0", Messages.TICode_accessory, Messages.TICode_right, Messages.TICode_left, Messages.TICode_acute, Messages.TICode_chronic, Messages.TICode_infectiuous, Messages.TICode_functional, Messages.TICode_neoplastic, Messages.TICode_professional}};
    private static List<ICodeElement> allLeafNodes;

    private TessinerCode(String code, String text) {
        this.code = code;
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public String getCode() {
        return this.code;
    }

    public String getLabel() {
        return String.valueOf(this.code) + " " + this.text;
    }

    public String getCodeSystemName() {
        return CODESYSTEM_NAME;
    }

    public static TessinerCode load(String code) {
        return TessinerCode.getFromCode(code).get();
    }

    public static TessinerCode[] getRootNodes() {
        TessinerCode[] ret = new TessinerCode[ticode.length];
        int i = 0;
        while (i < ticode.length) {
            String[] line = ticode[i];
            ret[i] = new TessinerCode(line[0], line[1]);
            ++i;
        }
        return ret;
    }

    public static Optional<TessinerCode> getFromCode(String code) {
        TessinerCode ret = hash.get(code);
        if (ret == null && !code.isEmpty()) {
            String chapter = code.substring(0, 1);
            int subch = 0;
            if (code.length() == 2) {
                try {
                    subch = Integer.parseInt(code.substring(1));
                }
                catch (NumberFormatException nfe) {
                    LoggerFactory.getLogger(TessinerCode.class).warn("Invalid numeric code [{}] returning empty", (Object)code.substring(1));
                    return Optional.empty();
                }
            }
            int i = 0;
            while (i < ticode.length) {
                if (ticode[i][0].startsWith(chapter)) {
                    if (subch == 9) {
                        subch = ticode[i].length - 2;
                        ret = new TessinerCode(String.valueOf(chapter) + "9", ticode[i][subch + 1]);
                    } else {
                        ret = new TessinerCode(String.valueOf(chapter) + subch, ticode[i][subch + 1]);
                    }
                    hash.put(code, ret);
                    return Optional.of(ret);
                }
                ++i;
            }
        }
        return Optional.ofNullable(ret);
    }

    public TessinerCode getParent() {
        if (this.getCode().length() == 1) {
            return null;
        }
        return TessinerCode.getFromCode(this.getCode().substring(0, 1)).get();
    }

    public boolean hasChildren() {
        return this.getCode().length() == 1;
    }

    public List<IDiagnosisTree> getChildren() {
        if (this.getCode().length() > 1) {
            return null;
        }
        String chapter = this.getCode().substring(0, 1);
        int i = 0;
        while (i < ticode.length) {
            if (ticode[i][0].equals(chapter)) {
                TessinerCode[] ret = new TessinerCode[ticode[i].length - 2];
                int j = 2;
                while (j < ticode[i].length) {
                    String x = j == ticode[i].length - 1 ? "9" : Integer.toString(j - 1);
                    ret[j - 2] = new TessinerCode(String.valueOf(chapter) + x, ticode[i][j]);
                    ++j;
                }
                return Arrays.asList(ret);
            }
            ++i;
        }
        return null;
    }

    public String getId() {
        return this.getCode();
    }

    public boolean addXid(String domain, String id, boolean updateIfExists) {
        throw new UnsupportedOperationException();
    }

    public IXid getXid(String domain) {
        return null;
    }

    public Long getLastupdate() {
        return 0L;
    }

    public String getDescription() {
        return this.getText();
    }

    public void setDescription(String value) {
        throw new UnsupportedOperationException();
    }

    public void setCode(String value) {
        throw new UnsupportedOperationException();
    }

    public void setText(String value) {
        throw new UnsupportedOperationException();
    }

    public void setParent(IDiagnosisTree value) {
        throw new UnsupportedOperationException();
    }

    public static List<ICodeElement> getLeafNodes() {
        if (allLeafNodes == null) {
            allLeafNodes = new ArrayList<ICodeElement>();
            TessinerCode[] tessinerCodeArray = TessinerCode.getRootNodes();
            int n = tessinerCodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TessinerCode rootNode = tessinerCodeArray[n2];
                allLeafNodes.addAll(rootNode.getChildren());
                ++n2;
            }
        }
        return allLeafNodes;
    }
}

