/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.migel.ui;

import ch.elexis.base.ch.migel.Messages;
import ch.elexis.core.interfaces.IReferenceDataImporter;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IReferenceDataImporterService;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.types.ArticleTyp;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.util.ImporterPage;
import ch.elexis.core.ui.util.SWTHelper;
import ch.rgw.tools.Money;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import javax.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiGelImporter
extends ImporterPage {
    boolean bDelete = false;
    Button bClear;
    String mode;
    private static Logger log = LoggerFactory.getLogger(MiGelImporter.class);
    @Inject
    private IReferenceDataImporterService importerService;

    public MiGelImporter() {
        CoreUiUtil.injectServicesWithContext((Object)((Object)this));
    }

    public String getTitle() {
        return "MiGeL";
    }

    public String getDescription() {
        return Messages.MiGelImporter_PleaseSelectFile;
    }

    public List<String> getObjectClass() {
        return Collections.singletonList(IArticle.class.getName());
    }

    public IStatus doImport(IProgressMonitor monitor) throws Exception {
        this.mode = Messages.MiGelImporter_ModeUpdateAdd;
        if (this.bDelete) {
            IQuery query = CoreModelServiceHolder.get().getQuery(IArticle.class, true);
            query.and((EStructuralFeature)ModelPackage.Literals.IARTICLE__TYP, IQuery.COMPARATOR.EQUALS, (Object)ArticleTyp.MIGEL);
            List existing = query.execute();
            existing.forEach(a -> CoreModelServiceHolder.get().remove((Identifiable)a));
            this.mode = Messages.MiGelImporter_ModeCreateNew;
        }
        try {
            IReferenceDataImporter importer;
            File file = new File(this.results[0]);
            log.info("Checking file " + file.getAbsolutePath() + " importerService " + this.importerService);
            if (file.getName().toLowerCase().endsWith("csv")) {
                importer = (IReferenceDataImporter)this.importerService.getImporter("migel_csv").orElseThrow(() -> new IllegalStateException("No IReferenceDataImporter available."));
                return importer.performImport(monitor, (InputStream)new FileInputStream(this.results[0]), null);
            }
            if (file.getName().toLowerCase().endsWith("xlsx")) {
                importer = (IReferenceDataImporter)this.importerService.getImporter("migel_xlsx").orElseThrow(() -> new IllegalStateException("No IReferenceDataImporter available."));
                return importer.performImport(monitor, (InputStream)new FileInputStream(this.results[0]), null);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String msg = String.format("Unable to import file %s", ex.getMessage());
            log.info(ex.getStackTrace().toString());
            log.error(msg);
            SWTHelper.showError((String)ch.elexis.core.l10n.Messages.Core_Error_while_importing, (String)msg);
        }
        return Status.CANCEL_STATUS;
    }

    public void collect() {
        this.bDelete = this.bClear.getSelection();
    }

    public Composite createPage(Composite parent) {
        ImporterPage.FileBasedImporter ret = new ImporterPage.FileBasedImporter(parent, (ImporterPage)this);
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.bClear = new Button(parent, 96);
        this.bClear.setText(Messages.MiGelImporter_ClearAllData);
        this.bClear.setSelection(true);
        this.bClear.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        return ret;
    }

    private static enum ImportFields {
        POSNUMER(0),
        NAME(1),
        UNIT(2),
        PRICE(3),
        CATEGORY(4),
        SUBCATEGORY(5),
        AMOUNT(6);

        private int index;

        private ImportFields(int index) {
            this.index = index;
        }

        private boolean exists(String[] line) {
            return line.length > this.index;
        }

        public String getStringValue(String[] line) {
            if (this.exists(line)) {
                if (this == NAME && line[this.index].contains("\n")) {
                    line[this.index] = this.getJoinedFirstLines(line[this.index]);
                }
                return line[this.index];
            }
            return "";
        }

        private String getJoinedFirstLines(String string) {
            String[] parts = string.split("\n");
            if (parts.length > 1) {
                StringBuilder ret = new StringBuilder();
                if (!parts[1].isEmpty()) {
                    if (parts[0].endsWith(",")) {
                        ret.append(String.valueOf(parts[0]) + " " + parts[1]);
                    } else {
                        ret.append(String.valueOf(parts[0]) + ", " + parts[1]);
                    }
                } else {
                    ret.append(String.valueOf(parts[0]) + "\n");
                }
                StringJoiner rest = new StringJoiner("\n");
                int i = 2;
                while (i < parts.length) {
                    rest.add(parts[i]);
                    ++i;
                }
                if (rest.length() > 0) {
                    ret.append("\n").append(rest);
                }
                return ret.toString();
            }
            return string;
        }

        public Money getMoneyValue(String[] line) {
            if (this.exists(line)) {
                try {
                    return new Money(this.getStringValue(line));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return new Money();
        }
    }
}

