/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.migel;

import ch.elexis.base.ch.migel.Messages;
import ch.elexis.base.ch.migel.ui.MiGelImporter;
import ch.elexis.core.interfaces.AbstractReferenceDataImporter;
import ch.elexis.core.interfaces.IReferenceDataImporter;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.IArticleBuilder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.types.ArticleTyp;
import ch.rgw.tools.Money;
import ch.rgw.tools.StringTool;
import com.opencsv.CSVReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.ParseException;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"referenceDataId=migel_csv"})
public class MigelCsvDataImporter
extends AbstractReferenceDataImporter
implements IReferenceDataImporter {
    private static Logger log = LoggerFactory.getLogger(MiGelImporter.class);
    static Pattern pattern = Pattern.compile("([a-z0-9A-Z])([A-Z][a-z])");
    private final String SRC_ENCODING = "iso-8859-1";

    public static String getShortname(String text) {
        String shortname = StringTool.getFirstLine((String)text, (int)120, (String)"[\\n\\r]");
        Matcher matcher = pattern.matcher(shortname);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, String.valueOf(matcher.group(1)) + " " + matcher.group(2));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private boolean isFieldsLine(String[] line) {
        return this.containsDigits(line[0]);
    }

    private boolean containsDigits(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char character = cArray[n2];
            if (Character.isDigit(character)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public IStatus performImport(@Nullable IProgressMonitor monitor, InputStream input, @Nullable Integer newVersion) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            String[] line;
            InputStreamReader isr = new InputStreamReader(input, "iso-8859-1");
            CSVReader reader = new CSVReader((Reader)isr);
            Integer nrLine = 0;
            monitor.subTask(Messages.MiGelImporter_ReadMigel);
            while ((line = reader.readNext()) != null) {
                String[] parts;
                if (!this.isFieldsLine(line) || line.length < 3) continue;
                StringBuilder text = new StringBuilder();
                String category = ImportFields.SUBCATEGORY.getStringValue(line);
                if (category.isEmpty()) {
                    category = ImportFields.CATEGORY.getStringValue(line);
                }
                if (!category.isEmpty()) {
                    text.append(StringTool.getFirstLine((String)category, (int)80, (String)"[\\n\\r]")).append(" - ");
                }
                text.append(ImportFields.NAME.getStringValue(line));
                String amount = ImportFields.AMOUNT.getStringValue(line);
                String unit = ImportFields.UNIT.getStringValue(line);
                if (amount.isEmpty() && !unit.isEmpty() && Character.isDigit(unit.charAt(0)) && (parts = unit.split(" ")) != null && parts.length > 1) {
                    amount = parts[0];
                    StringJoiner unitWithoutDigit = new StringJoiner(" ");
                    int i = 1;
                    while (i < parts.length) {
                        unitWithoutDigit.add(parts[i]);
                        ++i;
                    }
                    unit = unitWithoutDigit.toString();
                }
                String code = ImportFields.POSNUMER.getStringValue(line);
                String shortname = MigelCsvDataImporter.getShortname(text.toString());
                IArticle migelArticle = (IArticle)new IArticleBuilder(CoreModelServiceHolder.get(), shortname, ImportFields.POSNUMER.getStringValue(line), ArticleTyp.MIGEL).build();
                nrLine = nrLine + 1;
                log.trace("csv: row {} id {} pos {} code {} shortname {} unit <{}> size <{}> price {} text length {}", new Object[]{nrLine, "MiGeL" + code, ImportFields.POSNUMER.getStringValue(line), code, shortname, unit, amount, ImportFields.PRICE.getMoneyValue(line), text.toString().length()});
                CoreModelServiceHolder.get().setEntityProperty("id", (Object)("MiGeL" + code), (Identifiable)migelArticle);
                migelArticle.setPackageUnit(unit);
                migelArticle.setSellingPrice(ImportFields.PRICE.getMoneyValue(line));
                migelArticle.setExtInfo((Object)"FullText", (Object)text.toString());
                if (!amount.isEmpty()) {
                    try {
                        double amountDbl = Double.parseDouble(amount);
                        migelArticle.setPackageSize((int)amountDbl);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                CoreModelServiceHolder.get().save((Identifiable)migelArticle);
                monitor.worked(1);
            }
            reader.close();
            monitor.done();
            return Status.OK_STATUS;
        }
        catch (IOException e1) {
            log.error("Exception {} while running import", (Object)e1.getMessage());
            return Status.CANCEL_STATUS;
        }
    }

    public int getCurrentVersion() {
        return 0;
    }

    private static enum ImportFields {
        POSNUMER(0),
        NAME(1),
        UNIT(2),
        PRICE(3),
        CATEGORY(4),
        SUBCATEGORY(5),
        AMOUNT(6);

        private int index;

        private ImportFields(int index) {
            this.index = index;
        }

        private boolean exists(String[] line) {
            return line.length > this.index;
        }

        public String getStringValue(String[] line) {
            if (this.exists(line)) {
                if (this == NAME && line[this.index].contains("\n")) {
                    line[this.index] = this.getJoinedFirstLines(line[this.index]);
                }
                return line[this.index];
            }
            return "";
        }

        private String getJoinedFirstLines(String string) {
            String[] parts = string.split("\n");
            if (parts.length > 1) {
                StringBuilder ret = new StringBuilder();
                if (!parts[1].isEmpty()) {
                    if (parts[0].endsWith(",")) {
                        ret.append(String.valueOf(parts[0]) + " " + parts[1]);
                    } else {
                        ret.append(String.valueOf(parts[0]) + ", " + parts[1]);
                    }
                } else {
                    ret.append(String.valueOf(parts[0]) + "\n");
                }
                StringJoiner rest = new StringJoiner("\n");
                int i = 2;
                while (i < parts.length) {
                    rest.add(parts[i]);
                    ++i;
                }
                if (rest.length() > 0) {
                    ret.append("\n").append(rest);
                }
                return ret.toString();
            }
            return string;
        }

        public Money getMoneyValue(String[] line) {
            if (this.exists(line)) {
                try {
                    return new Money(this.getStringValue(line));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return new Money();
        }
    }
}

