/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.icd10.importer;

import ch.elexis.base.ch.icd10.importer.EntityUtil;
import ch.elexis.core.interfaces.AbstractReferenceDataImporter;
import ch.elexis.core.interfaces.IReferenceDataImporter;
import ch.elexis.core.jpa.entities.ICD10;
import ch.elexis.core.jpa.model.util.JpaModelUtil;
import ch.rgw.io.FileTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"referenceDataId=icd10"})
public class Icd10ReferenceDataImporter
extends AbstractReferenceDataImporter
implements IReferenceDataImporter {
    private Pattern pat_group;
    private static final String regex_group = "([A-Z][0-9][0-9]-[A-Z][0-9][0-9])(.+?):";
    private static final Logger logger = LoggerFactory.getLogger(Icd10ReferenceDataImporter.class);
    static final int LEVEL = 0;
    static final int TERMINAL = 1;
    static final int GENERATED = 2;
    static final int KIND = 3;
    static final int CHAPTER = 4;
    static final int GROUP = 5;
    static final int SUPERCODE = 6;
    static final int CODE = 7;
    static final int CODE_SHORT = 8;
    static final int CODE_COMPACT = 9;
    static final int TEXT = 10;

    public IStatus performImport(IProgressMonitor monitor, InputStream input, Integer newVersion) {
        List<ICD10> existing = EntityUtil.loadAll(ICD10.class);
        if (existing.size() > 1) {
            EntityUtil.removeAll(existing);
        }
        monitor.beginTask("ICD-10 Import", 15000);
        try {
            File zipFile = Files.createTempFile("icd10_", ".zip", new FileAttribute[0]).toFile();
            FileUtils.copyInputStreamToFile((InputStream)input, (File)zipFile);
            File unzipDirectory = Files.createTempDirectory("icd10_", new FileAttribute[0]).toFile();
            FileTool.unzip((File)zipFile, (File)unzipDirectory);
            monitor.worked(500);
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            monitor.subTask("Lese Codes");
            this.pat_group = Pattern.compile(regex_group, 2);
            File codes = new File(unzipDirectory, "codes.txt");
            InputStreamReader ir = new InputStreamReader((InputStream)new FileInputStream(codes), "iso-8859-1");
            Throwable throwable = null;
            Object var10_12 = null;
            try (BufferedReader br = new BufferedReader(ir);){
                String in;
                Hashtable<String, ICD10> chapters = new Hashtable<String, ICD10>();
                Hashtable<String, ICD10> groups = new Hashtable<String, ICD10>();
                Hashtable<String, ICD10> supercodes = new Hashtable<String, ICD10>();
                while ((in = br.readLine()) != null) {
                    ICD10 node;
                    ICD10 mygroup;
                    String[] fields = in.split(";");
                    String kap = fields[4];
                    String group = fields[5];
                    String supercode = fields[6];
                    ICD10 kapitel = (ICD10)chapters.get(kap);
                    if (kapitel == null) {
                        kapitel = new ICD10();
                        kapitel.setParent("NIL");
                        kapitel.setCode(kap);
                        kapitel.setEncoded("1;N;X;X;" + kap + ";" + kap + ";" + kap + ";" + kap + ";" + kap + ";" + kap + ";Kapitel " + kap + ";;;;;");
                        kapitel.setText(kapitel.getEnoded().split(";")[10]);
                        chapters.put(kap, kapitel);
                        LineFeeder lf = new LineFeeder(new File(unzipDirectory, "KAP" + kap + ".asc"));
                        block15: while (lf.peek() == '0') {
                            String t = lf.nextLine();
                            switch (t.charAt(1)) {
                                case 'T': {
                                    kapitel.setText(t.substring(2).replaceAll("\n", " - "));
                                    break;
                                }
                                case 'I': {
                                    Icd10ReferenceDataImporter.setExtInfo("Incl:", t.substring(2), kapitel);
                                    break;
                                }
                                case 'E': {
                                    Icd10ReferenceDataImporter.setExtInfo("Excl:", t.substring(2), kapitel);
                                    break;
                                }
                                case 'G': {
                                    String gruppen = t.substring(2).replaceAll("\n", "::");
                                    Icd10ReferenceDataImporter.setExtInfo("Gruppen", t.substring(2), kapitel);
                                    Matcher match = this.pat_group.matcher(String.valueOf(gruppen) + "::");
                                    while (match.find()) {
                                        String code = match.group(1);
                                        String[] gs = code.split("-");
                                        if (groups.get(gs[0]) != null) continue;
                                        ICD10 icdgroup = new ICD10();
                                        icdgroup.setParent(kapitel.getId());
                                        icdgroup.setCode(code);
                                        icdgroup.setEncoded("1;N;X;X;" + kap + ";" + code + ";" + gs[0] + ";" + gs[0] + ";" + code + ";" + code + ";" + match.group(2));
                                        icdgroup.setText(icdgroup.getEnoded().split(";")[10]);
                                        groups.put(gs[0], icdgroup);
                                    }
                                    continue block15;
                                }
                                default: {
                                    Icd10ReferenceDataImporter.setExtInfo("Zusatz", t.substring(2), kapitel);
                                }
                            }
                        }
                        EntityUtil.save(new ArrayList<Object>(chapters.values()));
                        EntityUtil.save(new ArrayList<Object>(groups.values()));
                    }
                    if ((mygroup = (ICD10)groups.get(group)) == null) {
                        node = new ICD10();
                        node.setParent(kapitel.getId());
                        node.setCode(fields[7]);
                        node.setEncoded(in);
                        node.setText(node.getEnoded().split(";")[10]);
                    } else if (fields[0].equals("3")) {
                        node = new ICD10();
                        node.setParent(mygroup.getId());
                        node.setCode(fields[7]);
                        node.setEncoded(in);
                        node.setText(node.getEnoded().split(";")[10]);
                        supercodes.put(fields[7], node);
                    } else {
                        ICD10 icdSuper = (ICD10)supercodes.get(supercode);
                        if (icdSuper == null) {
                            node = new ICD10();
                            node.setParent(mygroup.getId());
                            node.setCode(fields[7]);
                            node.setEncoded(in);
                            node.setText(node.getEnoded().split(";")[10]);
                        } else {
                            node = new ICD10();
                            node.setParent(icdSuper.getId());
                            node.setCode(fields[7]);
                            node.setEncoded(in);
                            node.setText(node.getEnoded().split(";")[10]);
                        }
                    }
                    EntityUtil.save(Collections.singletonList(node));
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    node = null;
                    kap = null;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.error("Error importing icd10 zip file", (Throwable)e);
            return new Status(4, "ch.elexis.base.ch.icd10", "Error importing icd10 zip file [" + e.getMessage() + "]");
        }
        return Status.OK_STATUS;
    }

    public int getCurrentVersion() {
        return -1;
    }

    private static void setExtInfo(Object key, Object value, ICD10 icd) {
        Map<Object, Object> extInfo = new Hashtable();
        byte[] bytes = icd.getExtInfo();
        if (bytes != null) {
            extInfo = JpaModelUtil.extInfoFromBytes((byte[])bytes);
        }
        if (value == null) {
            extInfo.remove(key);
        } else {
            extInfo.put(key, value);
        }
        icd.setExtInfo(JpaModelUtil.extInfoToBytes(extInfo));
    }

    private class LineFeeder {
        String prev;
        BufferedReader br;

        LineFeeder(File file) throws Exception {
            this.br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "iso-8859-1"));
            this.prev = this.br.readLine();
        }

        char peek() {
            return this.prev.charAt(0);
        }

        /*
         * Unable to fully structure code
         */
        String nextLine() throws Exception {
            if (this.prev == null) {
                return null;
            }
            ret = this.prev;
            this.prev = this.br.readLine();
            if (this.prev != null) ** GOTO lbl13
            this.br.close();
            return ret;
lbl-1000:
            // 1 sources

            {
                ret = String.valueOf(ret) + "\n" + this.prev.trim();
                this.prev = this.br.readLine();
                if (this.prev != null) continue;
                this.br.close();
                return ret;
lbl13:
                // 2 sources

                ** while (this.prev.startsWith((String)" ") || this.prev.startsWith((String)"P"))
            }
lbl14:
            // 1 sources

            if (!this.prev.substring(0, 2).equals(ret.substring(0, 2))) ** GOTO lbl21
            ret = String.valueOf(ret) + "\n" + this.nextLine().substring(2);
            return ret;
lbl-1000:
            // 1 sources

            {
                this.prev = this.br.readLine();
                if (this.prev != null) continue;
                this.br.close();
                break;
lbl21:
                // 2 sources

                ** while (this.prev.startsWith((String)"LZ"))
            }
lbl22:
            // 2 sources

            return ret;
        }

        boolean atEOF() {
            return this.prev == null;
        }

        public void close() throws Exception {
            this.br.close();
        }
    }
}

