/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.ebanking.print;

import ch.elexis.base.ch.ebanking.model.IEsrRecord;
import ch.elexis.base.ch.ebanking.print.ESRJournalRecord;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.esr.ESRCode;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.rgw.tools.Money;
import java.io.File;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class ESRJournalLetter {
    @XmlElement
    private String file;
    @XmlElement
    private String user;
    @XmlElement
    private String date;
    @XmlElementWrapper(name="booked")
    @XmlElement(name="record")
    private List<ESRJournalRecord> bookedRecords;
    @XmlElement
    private String sumBooked;
    @XmlElementWrapper(name="notbooked")
    @XmlElement(name="record")
    private List<ESRJournalRecord> notBookedRecords;
    @XmlElement
    private String sumNotBooked;

    public ESRJournalLetter() {
    }

    public ESRJournalLetter(File esrFile, List<IEsrRecord> records) {
        this.file = esrFile.getAbsolutePath();
        Optional activeUser = ContextServiceHolder.get().getActiveUser();
        this.user = activeUser.isPresent() ? ((IUser)activeUser.get()).getLabel() : "?";
        this.date = LocalDate.now().format(DateTimeFormatter.ofPattern("dd.MM.yyyy"));
        this.bookedRecords = records.stream().filter(r -> r.hasBookedDate() && r.getCode() != ESRCode.Summenrecord).map(r -> new ESRJournalRecord((IEsrRecord)r)).collect(Collectors.toList());
        Money sumBookedMoney = new Money();
        records.stream().filter(r -> r.hasBookedDate() && r.getCode() != ESRCode.Summenrecord).forEach(r -> {
            Money money2 = sumBookedMoney.addMoney(r.getAmount());
        });
        this.sumBooked = sumBookedMoney.getAmountAsString();
        this.notBookedRecords = records.stream().filter(r -> !r.hasBookedDate() && r.getCode() != ESRCode.Summenrecord).map(r -> new ESRJournalRecord((IEsrRecord)r)).collect(Collectors.toList());
        Money sumNotBookedMoney = new Money();
        records.stream().filter(r -> !r.hasBookedDate() && r.getCode() != ESRCode.Summenrecord).forEach(r -> {
            Money money2 = sumNotBookedMoney.addMoney(r.getAmount());
        });
        this.sumNotBooked = sumNotBookedMoney.getAmountAsString();
    }
}

