/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.ebanking.esr;

import ch.elexis.base.ch.ebanking.model.IEsrRecord;
import ch.elexis.base.ch.ebanking.model.service.holder.ModelServiceHolder;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.Rechnung;
import ch.elexis.ebanking.parser.Camt054Record;
import ch.rgw.tools.Money;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.VersionInfo;
import org.apache.commons.lang3.StringUtils;

public class ESRRecord
extends PersistentObject {
    public static final String FLD_REJECT_CODE = "RejectCode";
    public static final String FLD_DATE = "Datum";
    public static final String FLD_BOOKING_DATE = "Gebucht";
    public static final String MANDANT_ID = "MandantID";
    public static final String PATIENT_ID = "PatientID";
    public static final String RECHNUNGS_ID = "RechnungsID";
    public static final String CODE = "Code";
    private static final String VERSION = "2";
    public static final String TABLENAME = "ESRRECORDS";
    private static final int POSITION_PAT_NR = 11;
    private static final int POSITION_RN_NR = 20;
    private static final String createDB = "DROP TABLE ESRRECORDS;DROP INDEX ESR1;DROP INDEX ESR2;DROP INDEX ESR3;CREATE TABLE ESRRECORDS(ID\t\t\tVARCHAR(25) PRIMARY KEY,lastupdate BIGINT,deleted\tCHAR(1) default '0',Datum CHAR(8),EINGELESEN\t\tCHAR(8),VERARBEITET\tCHAR(8),GUTSCHRIFT\t\tCHAR(8),BETRAGINRP\t\tCHAR(8),CODE\t\t\tCHAR(3),RECHNUNGSID VARCHAR(25),PATIENTID\t VARCHAR(25),MANDANTID\t VARCHAR(25),REJECTCODE\t CHAR(3),KOSTEN\t\t CHAR(4),Gebucht CHAR(8),FILE\t\t VARCHAR(80));CREATE INDEX ESR1 ON ESRRECORDS (DATUM);CREATE INDEX ESR2 ON ESRRECORDS (PATIENTID);CREATE INDEX ESR3 ON ESRRECORDS (REJECTCODE);INSERT INTO ESRRECORDS (ID,FILE) VALUES ('1','2');";
    private static final String upd2 = "ALTER TABLE ESRRECORDS ADD lastupdate BIGINT;";

    static {
        ESRRecord.addMapping((String)TABLENAME, (String[])new String[]{"id", "Datum=S:D:Datum", "Eingelesen=S:D:EINGELESEN", "Verarbeitet=S:D:VERARBEITET", "Gutgeschrieben=S:D:GUTSCHRIFT", "BetragInRp=BETRAGINRP", CODE, RECHNUNGS_ID, PATIENT_ID, MANDANT_ID, FLD_REJECT_CODE, "Gebucht=S:D:GEBUCHT", "File"});
        ESRRecord init = ESRRecord.load("1");
        if (init == null) {
            ESRRecord.createOrModifyTable((String)createDB);
        } else {
            String v = init.get("File");
            if (StringTool.isNothing((Object)v)) {
                ESRRecord.getConnection().exec("ALTER TABLE ESRRECORDS ADD deleted CHAR(1) default '0';");
                init.set("File", VERSION);
            } else {
                VersionInfo vi = new VersionInfo(v);
                if (vi.isOlder("2.0.0")) {
                    ESRRecord.createOrModifyTable((String)upd2);
                }
                init.set("File", VERSION);
            }
        }
    }

    public String getLabel() {
        return null;
    }

    public Rechnung getRechnung() {
        String rnid = this.get(RECHNUNGS_ID);
        return Rechnung.load((String)rnid);
    }

    public Money getBetrag() {
        return new Money(ESRRecord.checkZero((Object)this.get("BetragInRp")));
    }

    public MODE getTyp() {
        int m = this.getInt(CODE);
        MODE ret = MODE.values()[m];
        return ret;
    }

    public REJECT getRejectCode() {
        int code = this.getInt(FLD_REJECT_CODE);
        return REJECT.values()[code];
    }

    public void setGebucht(TimeTool date) {
        if (date == null) {
            date = new TimeTool();
        }
        this.set(FLD_BOOKING_DATE, date.toString(4));
        this.set(FLD_REJECT_CODE, "0");
    }

    public ESRRecord(String file, String codeline) {
        super.create(null);
        Rechnung rn = null;
        String[] vals = new String[11];
        vals[0] = new TimeTool().toString(9);
        vals[10] = file;
        REJECT rejectCode = REJECT.OK;
        MODE mode = MODE.Unbekannt;
        String smd = codeline.substring(0, 3);
        if (smd.equals("002")) {
            mode = MODE.Gutschrift_edv;
        } else if (smd.equals("012")) {
            mode = MODE.Gutschrift_Schalter;
        } else if (smd.equals("005")) {
            mode = MODE.Storno_edv;
        } else if (smd.equals("015")) {
            mode = MODE.Storno_Schalter;
        } else if (smd.equals("008")) {
            mode = MODE.Korrektur_edv;
        } else if (smd.equals("018")) {
            mode = MODE.Korrektur_Schalter;
        } else if (smd.equals("999")) {
            mode = MODE.Summenrecord;
        }
        vals[5] = Integer.toString(mode.ordinal());
        String prefix = vals[0].substring(0, 2);
        TimeTool dat = new TimeTool(String.valueOf(prefix) + codeline.substring(59, 65));
        vals[1] = dat.toString(4);
        dat.set(String.valueOf(prefix) + codeline.substring(65, 71));
        vals[2] = dat.toString(4);
        dat.set(String.valueOf(prefix) + codeline.substring(71, 77));
        vals[3] = dat.toString(4);
        if (mode.equals((Object)MODE.Summenrecord)) {
            vals[4] = Integer.toString(Integer.parseInt(codeline.substring(39, 51).trim()));
        } else {
            String mandantID;
            vals[4] = Integer.toString(Integer.parseInt(codeline.substring(39, 49).trim()));
            Query qbe_r = new Query(Rechnung.class);
            String esrline = codeline.substring(12, 39);
            int rnnr = Integer.parseInt(esrline.substring(20, 26));
            String rnid = qbe_r.findSingle("RnNummer", "=", Integer.toString(rnnr));
            if (rnid == null) {
                rejectCode = REJECT.RN_NUMMER;
                vals[6] = "";
                mandantID = "";
            } else {
                vals[6] = rnid;
                rn = Rechnung.load((String)rnid);
                if (rn == null) {
                    rejectCode = REJECT.RN_NUMMER;
                    vals[6] = "";
                    mandantID = "";
                } else {
                    Mandant m = rn.getMandant();
                    if (m == null) {
                        rejectCode = REJECT.MANDANT;
                        vals[6] = "";
                        mandantID = "";
                    } else {
                        mandantID = m.getId();
                    }
                }
            }
            String PatNr = esrline.substring(11, 20);
            long patnr = Long.parseLong(PatNr);
            String PatID = new Query(Patient.class).findSingle("PatientNr", "=", Long.toString(patnr));
            if (PatID == null) {
                if (rejectCode == REJECT.OK) {
                    rejectCode = REJECT.PAT_NUMMER;
                }
                vals[7] = "";
            } else if (rn != null && !rn.getFall().getPatient().getId().equals(PatID)) {
                if (rejectCode == REJECT.OK) {
                    rejectCode = REJECT.PAT_FALSCH;
                }
                vals[7] = "";
            } else {
                vals[7] = PatID;
            }
            vals[8] = mandantID;
        }
        vals[9] = Integer.toString(rejectCode.ordinal());
        this.set(new String[]{FLD_DATE, "Eingelesen", "Verarbeitet", "Gutgeschrieben", "BetragInRp", CODE, RECHNUNGS_ID, PATIENT_ID, MANDANT_ID, FLD_REJECT_CODE, "File"}, vals);
    }

    public ESRRecord(String file, Camt054Record camt054Record) {
        super.create(null);
        Rechnung rn = null;
        MODE mode = MODE.Unbekannt;
        String smd = camt054Record.getMode();
        if (smd != null) {
            if (smd.equals("002")) {
                mode = MODE.Gutschrift_edv;
            } else if (smd.equals("005")) {
                mode = MODE.Storno_edv;
            } else if (smd.equals("999")) {
                mode = MODE.Summenrecord;
            }
        }
        String[] vals = new String[11];
        vals[0] = new TimeTool().toString(9);
        vals[1] = camt054Record.getReadDate() != null ? new TimeTool(camt054Record.getReadDate()).toString(4) : "";
        vals[2] = camt054Record.getBookingDate() != null ? new TimeTool(camt054Record.getBookingDate()).toString(4) : "";
        vals[3] = camt054Record.getValuDate() != null ? new TimeTool(camt054Record.getValuDate()).toString(4) : "";
        vals[10] = file;
        REJECT rejectCode = REJECT.OK;
        vals[5] = Integer.toString(mode.ordinal());
        vals[4] = camt054Record.getAmount();
        if (!mode.equals((Object)MODE.Summenrecord)) {
            String reference = camt054Record.getReference();
            if (this.isValidReference(reference)) {
                String mandantID;
                Query qbe_r = new Query(Rechnung.class);
                int rnnr = Integer.parseInt(reference.substring(20, 26));
                String rnid = qbe_r.findSingle("RnNummer", "=", Integer.toString(rnnr));
                if (rnid == null) {
                    rejectCode = REJECT.RN_NUMMER;
                    vals[6] = "";
                    mandantID = "";
                } else {
                    vals[6] = rnid;
                    rn = Rechnung.load((String)rnid);
                    if (rn == null) {
                        rejectCode = REJECT.RN_NUMMER;
                        vals[6] = "";
                        mandantID = "";
                    } else {
                        Mandant m = rn.getMandant();
                        if (m == null) {
                            rejectCode = REJECT.MANDANT;
                            vals[6] = "";
                            mandantID = "";
                        } else {
                            mandantID = m.getId();
                        }
                    }
                }
                String PatNr = reference.substring(11, 20);
                long patnr = Long.parseLong(PatNr);
                String PatID = new Query(Patient.class).findSingle("PatientNr", "=", Long.toString(patnr));
                if (PatID == null) {
                    if (rejectCode == REJECT.OK) {
                        rejectCode = REJECT.PAT_NUMMER;
                    }
                    vals[7] = "";
                } else if (rn != null && !rn.getFall().getPatient().getId().equals(PatID)) {
                    if (rejectCode == REJECT.OK) {
                        rejectCode = REJECT.PAT_FALSCH;
                    }
                    vals[7] = "";
                } else {
                    vals[7] = PatID;
                }
                vals[8] = mandantID;
            } else {
                rejectCode = REJECT.REFERNECE;
                vals[6] = "";
                vals[7] = "";
                vals[8] = "";
            }
        }
        vals[9] = Integer.toString(rejectCode.ordinal());
        this.set(new String[]{FLD_DATE, "Eingelesen", "Verarbeitet", "Gutgeschrieben", "BetragInRp", CODE, RECHNUNGS_ID, PATIENT_ID, MANDANT_ID, FLD_REJECT_CODE, "File"}, vals);
    }

    private boolean isValidReference(String reference) {
        return StringUtils.isNotBlank((CharSequence)reference) && reference.length() == 27;
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public static ESRRecord load(String id) {
        ESRRecord ret = new ESRRecord(id);
        if (ret.exists()) {
            return ret;
        }
        return null;
    }

    protected ESRRecord(String id) {
        super(id);
    }

    public ESRRecord() {
    }

    public String getEinlesedatatum() {
        return this.get("Eingelesen");
    }

    public String getVerarbeitungsdatum() {
        return this.get("Verarbeitet");
    }

    public String getValuta() {
        return this.get("Gutgeschrieben");
    }

    public Patient getPatient() {
        String pid = this.get(PATIENT_ID);
        return Patient.load((String)pid);
    }

    public String getGebucht() {
        return this.get(FLD_BOOKING_DATE);
    }

    public String getFile() {
        return ESRRecord.checkNull((Object)this.get("File"));
    }

    public String getESRCode() {
        return MODE.values()[ESRRecord.checkZero((Object)this.get(CODE))].toString();
    }

    public IEsrRecord toIEsrRecord() {
        return (IEsrRecord)ModelServiceHolder.get().load(this.getId(), IEsrRecord.class).get();
    }

    public static enum MODE {
        Gutschrift_edv,
        Storno_edv,
        Korrektur_edv,
        Gutschrift_Schalter,
        Storno_Schalter,
        Korrektur_Schalter,
        Summenrecord,
        Unbekannt;

    }

    public static enum REJECT {
        OK,
        ESRREJECT,
        MASSENREJECT,
        BETRAG,
        MANDANT,
        RN_NUMMER,
        PAT_NUMMER,
        DUPLIKAT,
        ANDERE,
        PAT_FALSCH,
        REFERNECE;

    }
}

