/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.ebanking.command;

import ch.elexis.base.ch.ebanking.ESRView;
import ch.elexis.base.ch.ebanking.command.ESRRecordsRunnable;
import ch.elexis.base.ch.ebanking.esr.ESRFile;
import ch.elexis.base.ch.ebanking.esr.ESRRecord;
import ch.elexis.base.ch.ebanking.esr.Messages;
import ch.elexis.base.ch.ebanking.model.IEsrRecord;
import ch.elexis.base.ch.ebanking.print.ESRJournalLetter;
import ch.elexis.base.ch.ebanking.print.ESRLetter;
import ch.elexis.core.data.util.ResultAdapter;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.utils.CoreUtil;
import ch.rgw.io.FileTool;
import ch.rgw.tools.ExHandler;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;

public class LoadESRFileHandler
extends AbstractHandler
implements IElementUpdater {
    public static final String COMMAND_ID = "ch.elexis.ebanking_ch.command.loadESRFile";

    public Object execute(final ExecutionEvent event) throws ExecutionException {
        FileDialog fld = new FileDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 4098);
        fld.setText(Messages.ESRView_selectESR);
        fld.setFilterExtensions(new String[]{"*.xml;*.zip;*.v11"});
        if (fld.open() != null) {
            String[] filenames;
            String filepath = fld.getFilterPath();
            String[] stringArray = filenames = fld.getFileNames();
            int n = filenames.length;
            int n2 = 0;
            while (n2 < n) {
                String filename = stringArray[n2];
                if (filename != null) {
                    final File file = new File(String.valueOf(filepath) + File.separator + filename);
                    if (file.isFile() && file.exists() && file.canRead()) {
                        try {
                            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                                /*
                                 * Unable to fully structure code
                                 */
                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    block12: {
                                        tmpDir = null;
                                        esrFiles = new ArrayList<File>();
                                        try {
                                            extension = FilenameUtils.getExtension((String)file.getName());
                                            if ("zip".equalsIgnoreCase(extension)) {
                                                tmpDir = new File(CoreUtil.getTempDir(), "esr_zip_" + System.currentTimeMillis());
                                                if (tmpDir.mkdirs()) {
                                                    try {
                                                        FileTool.unzip((File)file, (File)tmpDir);
                                                        esrFiles.addAll(Arrays.asList(tmpDir.listFiles(new FilenameFilter(){

                                                            @Override
                                                            public boolean accept(File dir, String name) {
                                                                if (file.isFile()) {
                                                                    String extension = FilenameUtils.getExtension((String)name);
                                                                    return "xml".equalsIgnoreCase(extension);
                                                                }
                                                                return false;
                                                            }
                                                        })));
                                                    }
                                                    catch (IOException e) {
                                                        ExHandler.handle((Throwable)e);
                                                    }
                                                }
                                            } else if ("xml".equalsIgnoreCase(extension) || "v11".equalsIgnoreCase(extension)) {
                                                esrFiles.add(file);
                                            }
                                            for (File esrFile : esrFiles) {
                                                monitor.beginTask(String.valueOf(Messages.ESRView_reading_ESR) + " " + esrFile.getName(), (int)(esrFile.length() / 25L));
                                                esrf = new ESRFile();
                                                result = esrf.read(esrFile, monitor);
                                                if (result.isOK()) {
                                                    recordsRunnable = new ESRRecordsRunnable(monitor, (List)result.get());
                                                    recordsRunnable.run();
                                                    LoadESRFileHandler.this.openESRJournalPdf(esrFile, (List)result.get());
                                                    if (!monitor.isCanceled()) continue;
                                                }
                                                ResultAdapter.displayResult(result, (String)Messages.ESRView_errorESR);
                                            }
                                        }
                                        finally {
                                            LoadESRFileHandler.this.updateEsrView(event);
                                            if (tmpDir == null) break block12;
                                            var14_13 = tmpDir.listFiles();
                                            var13_15 = var14_13.length;
                                            var12_17 = 0;
                                            ** while (var12_17 < var13_15)
                                        }
lbl-1000:
                                        // 1 sources

                                        {
                                            file = var14_13[var12_17];
                                            file.delete();
                                            ++var12_17;
                                            continue;
                                        }
lbl44:
                                        // 1 sources

                                        tmpDir.delete();
                                    }
                                }
                            });
                        }
                        catch (InvocationTargetException e) {
                            ExHandler.handle((Throwable)e);
                            SWTHelper.showError((String)Messages.ESRView_errorESR2, (String)Messages.ESRView_errrorESR2, (String)(String.valueOf(Messages.ESRView_couldnotread) + e.getMessage() + e.getCause().getMessage()));
                        }
                        catch (InterruptedException e) {
                            ExHandler.handle((Throwable)e);
                            SWTHelper.showError((String)"ESR interrupted", (String)Messages.ESRView_interrupted, (String)e.getMessage());
                        }
                    } else {
                        SWTHelper.showInfo((String)Messages.ESRView_errrorESR2, (String)(String.valueOf(Messages.ESRView_couldnotread) + filename));
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    private void openESRJournalPdf(File esrFile, List<ESRRecord> readRecords) {
        List<IEsrRecord> records = readRecords.stream().map(r -> r.toIEsrRecord()).collect(Collectors.toList());
        ESRLetter.print(new ESRJournalLetter(esrFile, records));
    }

    public void updateElement(UIElement element, Map parameters) {
        element.setIcon(Images.IMG_IMPORT.getImageDescriptor());
        element.setTooltip(Messages.ESRView_read_ESR_explain);
    }

    private void updateEsrView(final ExecutionEvent event) {
        UiDesk.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                ESRView view;
                IWorkbenchPage page;
                IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
                if (window != null && (page = window.getActivePage()) != null && (view = (ESRView)page.findView("ch.elexis.ebanking_ch.ESRView")) != null) {
                    view.updateView();
                }
            }
        });
    }
}

