/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.ebanking.command;

import ch.elexis.base.ch.ebanking.esr.ESR;
import ch.elexis.base.ch.ebanking.esr.ESRRecord;
import ch.elexis.base.ch.ebanking.esr.Messages;
import ch.elexis.core.model.IAccountTransaction;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.AccountTransaction;
import ch.elexis.data.Rechnung;
import ch.elexis.data.Zahlung;
import ch.rgw.tools.Money;
import ch.rgw.tools.TimeTool;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESRRecordsRunnable
implements Runnable {
    private IProgressMonitor monitor;
    private List<ESRRecord> records;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public ESRRecordsRunnable(IProgressMonitor monitor, List<ESRRecord> records) {
        this.monitor = monitor == null ? new NullProgressMonitor() : monitor;
        this.records = records;
    }

    @Override
    public void run() {
        boolean skipPaidAll = false;
        boolean bookPaidAll = false;
        for (ESRRecord rec : this.records) {
            this.monitor.worked(1);
            if (rec.getRejectCode().equals((Object)ESRRecord.REJECT.OK)) {
                Money offen;
                Money zahlung;
                Rechnung rn;
                if (rec.getTyp().equals((Object)ESRRecord.MODE.Summenrecord)) {
                    this.log.info(String.valueOf(Messages.ESRView_ESR_finished) + rec.getBetrag());
                    continue;
                }
                if (rec.getTyp().equals((Object)ESRRecord.MODE.Storno_edv) || rec.getTyp().equals((Object)ESRRecord.MODE.Storno_Schalter)) {
                    Money zahlung2;
                    rn = rec.getRechnung();
                    Zahlung zahlungsObj = rn.addZahlung(zahlung2 = rec.getBetrag().negate(), String.valueOf(Messages.ESRView_storno_for) + rn.getNr() + " / " + rec.getPatient().getPatCode(), new TimeTool(rec.getValuta()));
                    if (zahlungsObj != null && ESR.getAccount() != null) {
                        IAccountTransaction transaction = zahlungsObj.getTransaction().toIAccountTransaction();
                        transaction.setAccount(ESR.getAccount());
                        CoreModelServiceHolder.get().save((Identifiable)transaction);
                    }
                    rec.setGebucht(null);
                    continue;
                }
                rn = rec.getRechnung();
                if (rn.getStatus() == 16) {
                    if (skipPaidAll) continue;
                    if (!bookPaidAll) {
                        int ret = SWTHelper.ask((String)Messages.ESRView_paid, (String)(String.valueOf(Messages.ESRView_rechnung) + rn.getNr() + Messages.ESRView_ispaid), (String[])new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL, String.valueOf(IDialogConstants.OK_LABEL) + " f\u00fcr Alle", String.valueOf(IDialogConstants.CANCEL_LABEL) + " f\u00fcr Alle"});
                        if (ret == 3) {
                            skipPaidAll = true;
                        } else if (ret == 2) {
                            bookPaidAll = true;
                        }
                        if (ret == 1 || skipPaidAll) continue;
                    }
                }
                if (rn.getStatus() == 12 && !SWTHelper.askYesNo((String)Messages.ESRView_compulsoryExecution, (String)(String.valueOf(Messages.ESRView_rechnung) + rn.getNr() + Messages.ESRView_isInCompulsoryExecution)) || (zahlung = rec.getBetrag()).isMoreThan(offen = rn.getOffenerBetrag()) && zahlung.doubleValue() - offen.doubleValue() > 0.03 && !SWTHelper.askYesNo((String)Messages.ESRView_toohigh, (String)(String.valueOf(Messages.ESRView_paymentfor) + rn.getNr() + Messages.ESRView_morethan))) continue;
                Zahlung zahlungsObj = rn.addZahlung(zahlung, String.valueOf(Messages.ESRView_vesrfor) + rn.getNr() + " / " + rec.getPatient().getPatCode(), new TimeTool(rec.getValuta()));
                if (zahlungsObj != null && ESR.getAccount() != null) {
                    IAccountTransaction transaction = zahlungsObj.getTransaction().toIAccountTransaction();
                    transaction.setAccount(ESR.getAccount());
                    CoreModelServiceHolder.get().save((Identifiable)transaction);
                }
                rec.setGebucht(null);
                continue;
            }
            if (!rec.getRejectCode().equals((Object)ESRRecord.REJECT.RN_NUMMER)) continue;
            TimeTool valutaDate = new TimeTool(rec.getValuta());
            IAccountTransaction transaction = new AccountTransaction(rec.getPatient(), null, rec.getBetrag(), valutaDate.toString(4), Messages.LoadESRFileHandler_notAssignable).toIAccountTransaction();
            if (ESR.getAccount() == null) continue;
            transaction.setAccount(ESR.getAccount());
            CoreModelServiceHolder.get().save((Identifiable)transaction);
        }
        this.monitor.done();
    }
}

