/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.ebanking;

import ch.elexis.base.ch.ebanking.DatePeriodSelectorDialog;
import ch.elexis.base.ch.ebanking.ESRContentProvider;
import ch.elexis.base.ch.ebanking.ESRLabelProvider;
import ch.elexis.base.ch.ebanking.FilterKeyListener;
import ch.elexis.base.ch.ebanking.FilterSearchField;
import ch.elexis.base.ch.ebanking.esr.ESRRecordDialog;
import ch.elexis.base.ch.ebanking.esr.Messages;
import ch.elexis.base.ch.ebanking.model.IEsrRecord;
import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.ac.EvACEs;
import ch.elexis.core.model.esr.ESRRejectCode;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.wb.swt.SWTResourceManager;
import org.eclipse.wb.swt.TableViewerColumnSorter;
import org.slf4j.LoggerFactory;

public class ESRView
extends ViewPart {
    public static final String ID = "ch.elexis.ebanking_ch.ESRView";
    private Table table;
    private Text txtFilter;
    private Label lblSUMME;
    private TableViewer tableViewer;
    private TimeTool startDate;
    private TimeTool endDate;
    protected final SimpleDateFormat sdf = (SimpleDateFormat)DateFormat.getDateInstance(2);
    private SELECTION_TYPE selectionType = SELECTION_TYPE.NOTPOSTED;
    static final int DATUM_INDEX = 0;
    static final int RN_NUMMER_INDEX = 1;
    static final int BETRAG_INDEX = 2;
    static final int EINGELESEN_INDEX = 3;
    static final int VERRECHNET_INDEX = 4;
    static final int GUTGESCHRIEBEN_INDEX = 5;
    static final int PATIENT_INDEX = 6;
    static final int BUCHUNG_INDEX = 7;
    static final int DATEI_INDEX = 8;
    private static final String[] COLUMN_TEXTS = new String[]{Messages.ESRView2_date, Messages.ESRView2_billNumber, Messages.ESRView2_amount, Messages.ESRView2_readDate, Messages.ESRView2_accountedDate, Messages.ESRView2_addedDate, Messages.ESRView2_patient, Messages.ESRView2_booking, Messages.ESRView2_file};
    private Button btnDatePeriod;
    private Button btnNotPosted;
    private Button btnThisMonth;
    private Button btnLastMonth;
    private Button btnThisWeek;
    private Button btnLastWeek;
    @Inject
    @Service(filterExpression="(service.model.name=ch.elexis.base.ch.ebanking.model)")
    private IModelService esrModelService;
    @Inject
    private IContextService contextService;

    @Optional
    @Inject
    void activeUser(IUser user) {
        Display.getDefault().asyncExec(() -> this.updateView());
    }

    public ESRView() {
        this.endDate = new TimeTool();
        this.startDate = new TimeTool();
        this.startDate.add(2, -3);
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        GC gc = new GC((Drawable)parent);
        FontMetrics fm = gc.getFontMetrics();
        gc.dispose();
        int dateLength = (this.sdf.toPattern().length() + 2) * fm.getAverageCharWidth();
        Composite headerContainer = new Composite(parent, 0);
        headerContainer.setLayout((Layout)new GridLayout(7, false));
        headerContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtFilter = new Text(headerContainer, 2432);
        this.txtFilter.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtFilter.setMessage("Suche - #RechnungsNr, $Betrag, Text zB $>100 f\u00fcr alle Betr\u00e4ge gr\u00f6\u00dfer 100");
        Listener selectionListener = new Listener(){

            public void handleEvent(Event event) {
                ESRView.this.selectionType = (SELECTION_TYPE)((Object)event.widget.getData());
                ESRView.this.updateView();
            }
        };
        this.btnNotPosted = new Button(headerContainer, 0x800002);
        this.btnNotPosted.setToolTipText("Noch nicht verbuchte Zahlungen");
        this.btnNotPosted.setText("Nicht verbucht");
        this.btnNotPosted.setData((Object)SELECTION_TYPE.NOTPOSTED);
        this.btnNotPosted.addListener(13, selectionListener);
        this.btnThisMonth = new Button(headerContainer, 0x800002);
        this.btnThisMonth.setToolTipText("Dieser Monat");
        this.btnThisMonth.setText("DM");
        this.btnThisMonth.setData((Object)SELECTION_TYPE.THISMONTH);
        this.btnThisMonth.addListener(13, selectionListener);
        this.btnLastMonth = new Button(headerContainer, 0x800002);
        this.btnLastMonth.setToolTipText("Letzter Monat");
        this.btnLastMonth.setText("LM");
        this.btnLastMonth.setData((Object)SELECTION_TYPE.LASTMONTH);
        this.btnLastMonth.addListener(13, selectionListener);
        this.btnThisWeek = new Button(headerContainer, 0x800002);
        this.btnThisWeek.setToolTipText("Diese Woche");
        this.btnThisWeek.setText("DW");
        this.btnThisWeek.setData((Object)SELECTION_TYPE.THISWEEK);
        this.btnThisWeek.addListener(13, selectionListener);
        this.btnLastWeek = new Button(headerContainer, 0x800002);
        this.btnLastWeek.setToolTipText("Letzte Woche");
        this.btnLastWeek.setText("LW");
        this.btnLastWeek.setData((Object)SELECTION_TYPE.LASTWEEK);
        this.btnLastWeek.addListener(13, selectionListener);
        this.btnDatePeriod = new Button(headerContainer, 0x800002);
        this.btnDatePeriod.setToolTipText("Selektion \u00fcber Zeitraum");
        this.btnDatePeriod.setData((Object)SELECTION_TYPE.PERIOD);
        this.btnDatePeriod.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ESRView.this.selectionType = (SELECTION_TYPE)((Object)event.widget.getData());
                DatePeriodSelectorDialog dpsd = new DatePeriodSelectorDialog(Display.getCurrent().getActiveShell(), ESRView.this.startDate, ESRView.this.endDate);
                int retVal = dpsd.open();
                if (retVal == 0) {
                    ESRView.this.updateView();
                }
            }
        });
        Composite tableViewerComposite = new Composite(parent, 0);
        tableViewerComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tcl_tableViewerComposite = new TableColumnLayout();
        tableViewerComposite.setLayout((Layout)tcl_tableViewerComposite);
        this.tableViewer = new TableViewer(tableViewerComposite, 0x10010800);
        this.table = this.tableViewer.getTable();
        this.tableViewer.setUseHashlookup(true);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableViewerColumn tableViewerColumnDate = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnDate = tableViewerColumnDate.getColumn();
        tcl_tableViewerComposite.setColumnData((Widget)tblclmnDate, (ColumnLayoutData)new ColumnPixelData(dateLength, true, false));
        tblclmnDate.setText(COLUMN_TEXTS[0]);
        new TableViewerColumnSorter(tableViewerColumnDate){

            @Override
            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                IEsrRecord esr1 = (IEsrRecord)e1;
                IEsrRecord esr2 = (IEsrRecord)e2;
                return esr1.getDate().compareTo(esr2.getDate());
            }
        };
        TableViewerColumn tableViewerColumnBillNumber = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnRnnum = tableViewerColumnBillNumber.getColumn();
        tcl_tableViewerComposite.setColumnData((Widget)tblclmnRnnum, (ColumnLayoutData)new ColumnPixelData(70, true, true));
        tblclmnRnnum.setText(COLUMN_TEXTS[1]);
        new TableViewerColumnSorter(tableViewerColumnBillNumber){

            @Override
            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                IInvoice r1 = ((IEsrRecord)e1).getInvoice();
                IInvoice r2 = ((IEsrRecord)e2).getInvoice();
                String rNr1 = r1 != null ? r1.getNumber() : "";
                String rNr2 = r2 != null ? r2.getNumber() : "";
                return StringTool.compareNumericStrings((String)rNr1, (String)rNr2);
            }
        };
        TableViewerColumn tableViewerColumnAmount = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnAmount = tableViewerColumnAmount.getColumn();
        tcl_tableViewerComposite.setColumnData((Widget)tblclmnAmount, (ColumnLayoutData)new ColumnPixelData(70, true, true));
        tblclmnAmount.setText(COLUMN_TEXTS[2]);
        new TableViewerColumnSorter(tableViewerColumnAmount){

            @Override
            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                IEsrRecord esr1 = (IEsrRecord)e1;
                IEsrRecord esr2 = (IEsrRecord)e2;
                return esr1.getAmount().compareTo(esr2.getAmount());
            }
        };
        TableViewerColumn tableViewerColumnEingelesen = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnEingelesen = tableViewerColumnEingelesen.getColumn();
        tcl_tableViewerComposite.setColumnData((Widget)tblclmnEingelesen, (ColumnLayoutData)new ColumnPixelData(dateLength, true, false));
        tblclmnEingelesen.setText(COLUMN_TEXTS[3]);
        new TableViewerColumnSorter(tableViewerColumnEingelesen){

            @Override
            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                IEsrRecord esr1 = (IEsrRecord)e1;
                IEsrRecord esr2 = (IEsrRecord)e2;
                return esr1.getImportDate().compareTo(esr2.getImportDate());
            }
        };
        TableViewerColumn tableViewerColumnVerrechnet = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnVerrechnet = tableViewerColumnVerrechnet.getColumn();
        tcl_tableViewerComposite.setColumnData((Widget)tblclmnVerrechnet, (ColumnLayoutData)new ColumnPixelData(dateLength, true, false));
        tblclmnVerrechnet.setText(COLUMN_TEXTS[4]);
        new TableViewerColumnSorter(tableViewerColumnVerrechnet){

            @Override
            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                IEsrRecord esr1 = (IEsrRecord)e1;
                IEsrRecord esr2 = (IEsrRecord)e2;
                return esr1.getProcessingDate().compareTo(esr2.getProcessingDate());
            }
        };
        TableViewerColumn tableViewerColumnGutgeschrieben = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnGutgeschrieben = tableViewerColumnGutgeschrieben.getColumn();
        tcl_tableViewerComposite.setColumnData((Widget)tblclmnGutgeschrieben, (ColumnLayoutData)new ColumnPixelData(dateLength, true, false));
        tblclmnGutgeschrieben.setText(COLUMN_TEXTS[5]);
        new TableViewerColumnSorter(tableViewerColumnGutgeschrieben){

            @Override
            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                IEsrRecord esr1 = (IEsrRecord)e1;
                IEsrRecord esr2 = (IEsrRecord)e2;
                return esr1.getValutaDate().compareTo(esr2.getValutaDate());
            }
        };
        TableViewerColumn tableViewerColumnPatient = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnPatient = tableViewerColumnPatient.getColumn();
        tcl_tableViewerComposite.setColumnData((Widget)tblclmnPatient, (ColumnLayoutData)new ColumnWeightData(1, 20, true));
        tblclmnPatient.setText(COLUMN_TEXTS[6]);
        new TableViewerColumnSorter(tableViewerColumnPatient){

            @Override
            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                IPatient pat1 = ((IEsrRecord)e1).getPatient();
                IPatient pat2 = ((IEsrRecord)e2).getPatient();
                String patLab1 = pat1 != null ? pat1.getLabel() : "";
                String patLab2 = pat2 != null ? pat2.getLabel() : "";
                return patLab1.compareTo(patLab2);
            }
        };
        TableViewerColumn tableViewerColumnBooking = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnBuchung = tableViewerColumnBooking.getColumn();
        tcl_tableViewerComposite.setColumnData((Widget)tblclmnBuchung, (ColumnLayoutData)new ColumnWeightData(1, 20, true));
        tblclmnBuchung.setText(COLUMN_TEXTS[7]);
        new TableViewerColumnSorter(tableViewerColumnBooking){

            @Override
            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                IEsrRecord esr1 = (IEsrRecord)e1;
                IEsrRecord esr2 = (IEsrRecord)e2;
                return esr1.getBookedDate().compareTo(esr2.getBookedDate());
            }
        };
        TableViewerColumn tableViewerColumnFile = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnDatei = tableViewerColumnFile.getColumn();
        tcl_tableViewerComposite.setColumnData((Widget)tblclmnDatei, (ColumnLayoutData)new ColumnWeightData(1, 20, true));
        tblclmnDatei.setText(COLUMN_TEXTS[8]);
        new TableViewerColumnSorter(tableViewerColumnFile){

            @Override
            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                IEsrRecord esr1 = (IEsrRecord)e1;
                IEsrRecord esr2 = (IEsrRecord)e2;
                return esr1.getProcessingDate().compareTo(esr2.getProcessingDate());
            }
        };
        final Text filterText = new Text((Composite)tblclmnDatei.getParent(), 2048);
        filterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String filter = filterText.getText();
            }
        });
        Composite footerComposite = new Composite(parent, 0);
        footerComposite.setLayout((Layout)new GridLayout(2, false));
        footerComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblSumme = new Label(footerComposite, 0);
        lblSumme.setFont(SWTResourceManager.getFont("Lucida Grande", 11, 1));
        lblSumme.setBounds(0, 0, 59, 14);
        lblSumme.setText("Summe \u00fcber gew\u00e4hlte Eintr\u00e4ge ");
        this.lblSUMME = new Label(footerComposite, 0);
        this.lblSUMME.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel != null && !sel.isEmpty()) {
                    Object element = sel.getFirstElement();
                    ESRRecordDialog erd = new ESRRecordDialog(ESRView.this.getViewSite().getShell(), (IEsrRecord)element);
                    erd.open();
                    ESRView.this.updateView();
                }
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ESRLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new ESRContentProvider(this.lblSUMME));
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection ss = (StructuredSelection)ESRView.this.tableViewer.getSelection();
                Object firstElement = ss.getFirstElement();
                if (firstElement != null) {
                    IEsrRecord selRecord = (IEsrRecord)firstElement;
                    ESRView.this.contextService.getRootContext().setTyped((Object)selRecord);
                    IInvoice rn = selRecord.getInvoice();
                    if (rn != null) {
                        ESRView.this.contextService.getRootContext().setTyped((Object)rn);
                    }
                } else {
                    ESRView.this.contextService.getRootContext().removeTyped(IEsrRecord.class);
                }
            }
        });
        ViewerFilter[] filters = new ViewerFilter[]{FilterSearchField.getInstance()};
        this.tableViewer.setFilters(filters);
        this.txtFilter.addKeyListener((KeyListener)new FilterKeyListener(this.txtFilter, (StructuredViewer)this.tableViewer));
        this.txtFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (e.detail == 256) {
                    FilterSearchField.getInstance().setSearchText(null);
                    ESRView.this.tableViewer.refresh();
                }
            }
        });
        this.updateView();
    }

    public void updateView() {
        this.updateButtonToggleState();
        if (SELECTION_TYPE.NOTPOSTED == this.selectionType) {
            this.btnDatePeriod.setText("Zeitraum: \u2264" + this.sdf.format(new Date()));
        } else {
            LocalDateTime dateHolder = LocalDateTime.now();
            switch (this.selectionType) {
                case LASTMONTH: {
                    dateHolder = dateHolder.minusMonths(1L);
                }
                case THISMONTH: {
                    this.startDate = new TimeTool(dateHolder.withDayOfMonth(1));
                    this.endDate = new TimeTool(dateHolder.withDayOfMonth(dateHolder.getMonth().maxLength()));
                    break;
                }
                case LASTWEEK: {
                    dateHolder = dateHolder.minusWeeks(1L);
                }
                case THISWEEK: {
                    this.startDate = new TimeTool(dateHolder.with(DayOfWeek.MONDAY));
                    this.endDate = new TimeTool(dateHolder.with(DayOfWeek.SUNDAY));
                    break;
                }
            }
            this.btnDatePeriod.setText("Zeitraum: " + this.sdf.format(this.startDate.getTime()) + " - " + this.sdf.format(this.endDate.getTime()));
        }
        if (AccessControlServiceHolder.get().evaluate(EvACE.of(IEsrRecord.class, (Right)Right.READ).and(Right.VIEW))) {
            Job job = Job.create((String)"ESR loading ...", monitor -> {
                IQuery esrQuery = this.esrModelService.getQuery(IEsrRecord.class);
                esrQuery.and("id", IQuery.COMPARATOR.NOT_EQUALS, (Object)"1");
                if (!AccessControlServiceHolder.get().evaluate(EvACEs.ACCOUNTING_GLOBAL)) {
                    this.contextService.getActiveMandator().ifPresent(m -> {
                        esrQuery.startGroup();
                        esrQuery.and("mandant", IQuery.COMPARATOR.EQUALS, m);
                        esrQuery.startGroup();
                        esrQuery.and("mandant", IQuery.COMPARATOR.EQUALS, null);
                        esrQuery.and("rejectcode", IQuery.COMPARATOR.NOT_EQUALS, (Object)ESRRejectCode.OK);
                        esrQuery.orJoinGroups();
                        esrQuery.andJoinGroups();
                    });
                }
                if (SELECTION_TYPE.NOTPOSTED == this.selectionType) {
                    esrQuery.startGroup();
                    esrQuery.and("gebucht", IQuery.COMPARATOR.EQUALS, null);
                    esrQuery.or("gebucht", IQuery.COMPARATOR.EQUALS, (Object)LocalDate.MIN);
                    esrQuery.andJoinGroups();
                } else {
                    esrQuery.and("Datum", IQuery.COMPARATOR.GREATER_OR_EQUAL, (Object)this.startDate.toLocalDate());
                    esrQuery.and("Datum", IQuery.COMPARATOR.LESS_OR_EQUAL, (Object)this.endDate.toLocalDate());
                }
                List esrQueryResult = esrQuery.execute();
                Display.getDefault().asyncExec(() -> this.tableViewer.setInput((Object)esrQueryResult));
            });
            job.schedule();
        } else {
            this.tableViewer.setInput(null);
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("User has no right for class [" + IEsrRecord.class.getSimpleName() + "]");
        }
    }

    private void updateButtonToggleState() {
        this.btnNotPosted.setSelection(this.btnNotPosted.getData() == this.selectionType);
        this.btnDatePeriod.setSelection(this.btnDatePeriod.getData() == this.selectionType);
        this.btnLastMonth.setSelection(this.btnLastMonth.getData() == this.selectionType);
        this.btnThisMonth.setSelection(this.btnThisMonth.getData() == this.selectionType);
        this.btnLastWeek.setSelection(this.btnLastWeek.getData() == this.selectionType);
        this.btnThisWeek.setSelection(this.btnThisWeek.getData() == this.selectionType);
    }

    public void setFocus() {
    }

    private static enum SELECTION_TYPE {
        NOTPOSTED,
        LASTMONTH,
        THISMONTH,
        LASTWEEK,
        THISWEEK,
        PERIOD;

    }
}

