/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.ebanking;

import ch.elexis.base.ch.ebanking.model.IEsrRecord;
import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.model.esr.ESRCode;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.rgw.tools.Money;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public class ESRContentProvider
extends ArrayContentProvider {
    private Label _lblSUMME;
    private Money sum;
    private IEsrRecord sumRecord;
    private List<Object> retList;

    public ESRContentProvider(Label lblSUMME) {
        this._lblSUMME = lblSUMME;
    }

    public Object[] getElements(Object inputElement) {
        if (!AccessControlServiceHolder.get().evaluate((EvaluatableACE)EvACE.of(IEsrRecord.class, (Right)Right.VIEW))) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ESRContentProvider.this._lblSUMME.setForeground(Display.getCurrent().getSystemColor(4));
                    ESRContentProvider.this._lblSUMME.setText("Insufficient rights");
                }
            });
            return Collections.emptyList().toArray();
        }
        this.retList = new ArrayList<Object>(Arrays.asList(super.getElements(inputElement)));
        this.sum = new Money();
        Display.getCurrent().syncExec(new Runnable(){

            @Override
            public void run() {
                ESRContentProvider.this._lblSUMME.setText("");
            }
        });
        Iterator<Object> iterator = this.retList.iterator();
        while (iterator.hasNext()) {
            IEsrRecord rec = (IEsrRecord)iterator.next();
            if (rec.getCode() == ESRCode.Summenrecord) {
                this.sumRecord = rec;
                iterator.remove();
                continue;
            }
            this.sum.addMoney(rec.getAmount());
        }
        Display.getCurrent().syncExec(new Runnable(){

            @Override
            public void run() {
                ESRContentProvider.this._lblSUMME.setText("" + ESRContentProvider.this.sum);
                if (ESRContentProvider.this.sum.isNegative()) {
                    ESRContentProvider.this._lblSUMME.setForeground(Display.getCurrent().getSystemColor(3));
                } else {
                    ESRContentProvider.this._lblSUMME.setForeground(Display.getCurrent().getSystemColor(6));
                }
            }
        });
        return this.retList.toArray();
    }
}

