/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.diagnosecodes.views;

import ch.elexis.base.ch.diagnosecodes.service.CodeElementServiceHolder;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.model.IDiagnosisTree;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.ICodeElementServiceContribution;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.DefaultControlFieldProvider;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.codesystems.CodeSelectorFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class TICodeSelectorFactory
extends CodeSelectorFactory {
    public ViewerConfigurer createViewerConfigurer(CommonViewer cv) {
        ViewerConfigurer vc = new ViewerConfigurer((ViewerConfigurer.ICommonViewerContentProvider)new TICodeContentProvider(cv), (LabelProvider)new TICodeLabelProvider(), (ViewerConfigurer.ControlFieldProvider)new DefaultControlFieldProvider(cv, new String[]{"Text"}), (ViewerConfigurer.ButtonProvider)new ViewerConfigurer.DefaultButtonProvider(), (ViewerConfigurer.WidgetProvider)new SimpleWidgetProvider(0, 0, null));
        cv.setNamedSelection("ch.elexis.base.ch.diagnosecodes.ti.selection");
        vc.setContentType(ViewerConfigurer.ContentType.GENERICOBJECT);
        return vc;
    }

    public Class getElementClass() {
        return IDiagnosisTree.class;
    }

    public void dispose() {
    }

    public String getCodeSystemName() {
        return "TI-Code";
    }

    static class TICodeContentProvider
    implements ITreeContentProvider,
    ViewerConfigurer.ICommonViewerContentProvider {
        private CommonViewer viewer;
        private String value;
        private String TICKey = "Text";
        private ICodeElementServiceContribution tiCodeElementContribution;
        private List<ICodeElement> roots;

        public TICodeContentProvider(CommonViewer viewer) {
            this.viewer = viewer;
            this.tiCodeElementContribution = (ICodeElementServiceContribution)CodeElementServiceHolder.get().getContribution(ICodeElementService.CodeElementTyp.DIAGNOSE, "TI-Code").orElseThrow(() -> new IllegalStateException("No TI CodeElementContribution available"));
            this.roots = this.tiCodeElementContribution.getElements(Collections.singletonMap(ICodeElementService.ContextKeys.TREE_ROOTS, Boolean.TRUE));
            this.value = "";
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IDiagnosisTree) {
                return ((IDiagnosisTree)parentElement).getChildren().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            IDiagnosisTree c = (IDiagnosisTree)element;
            return c.getParent();
        }

        public boolean hasChildren(Object element) {
            IDiagnosisTree c = (IDiagnosisTree)element;
            if (c.getChildren() == null) {
                return false;
            }
            return !c.getChildren().isEmpty();
        }

        public Object[] getElements(Object inputElement) {
            if (this.value == null || this.value.isEmpty()) {
                return this.roots.toArray();
            }
            List foundSubs = this.tiCodeElementContribution.getElements(Collections.emptyMap()).stream().map(ce -> ce).filter(dt -> this.matchFilter((IDiagnosisTree)dt)).collect(Collectors.toList());
            List foundRoots = this.roots.stream().map(ce -> ce).filter(dt -> this.matchFilter((IDiagnosisTree)dt)).collect(Collectors.toList());
            ArrayList<Object> foundElements = new ArrayList<Object>(foundRoots);
            foundElements.addAll(foundSubs);
            return foundElements.toArray(new Object[foundElements.size()]);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void startListening() {
            this.viewer.getConfigurer().getControlFieldProvider().addChangeListener((ViewerConfigurer.ControlFieldListener)this);
        }

        public void stopListening() {
            this.viewer.getConfigurer().getControlFieldProvider().removeChangeListener((ViewerConfigurer.ControlFieldListener)this);
        }

        public void changed(HashMap<String, String> values) {
            String filterText = values.get(this.TICKey).toLowerCase();
            if (filterText == null || filterText.isEmpty() || filterText.equals("%")) {
                this.setFilterValue("");
            } else {
                this.setFilterValue(filterText);
            }
            this.viewer.notify(CommonViewer.Message.update);
        }

        public boolean matchFilter(IDiagnosisTree element) {
            if (StringUtils.isNotBlank((CharSequence)this.value)) {
                return (String.valueOf(element.getCode()) + " " + element.getText().toLowerCase()).contains(this.value.toLowerCase());
            }
            return true;
        }

        public void reorder(String field) {
        }

        public void selected() {
        }

        public void init() {
        }

        private void setFilterValue(String value) {
            this.value = value;
        }
    }

    static class TICodeLabelProvider
    extends LabelProvider {
        TICodeLabelProvider() {
        }

        public String getText(Object element) {
            IDiagnosisTree c = (IDiagnosisTree)element;
            return String.valueOf(c.getCode()) + " " + c.getText();
        }

        public Image getImage(Object element) {
            return null;
        }
    }
}

