/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.views;

import ch.elexis.base.ch.arzttarife.service.ArzttarifeModelServiceHolder;
import ch.elexis.base.ch.arzttarife.tarmed.ITarmedLeistung;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;

public class TarmedCodeSelectorContentProvider
implements ViewerConfigurer.ICommonViewerContentProvider,
ITreeContentProvider {
    private List<ITarmedLeistung> roots;
    private CommonViewer commonViewer;
    private boolean isFiltered;
    private HashMap<String, List<ITarmedLeistung>> filteredLeafs;
    private RefreshExecutor refreshExecutor;
    private String currentZiffer;
    private String currentText;
    private INamedQuery<ITarmedLeistung> childrenQuery;
    private INamedQuery<ITarmedLeistung> childrenChapterQuery;

    public TarmedCodeSelectorContentProvider(CommonViewer commonViewer) {
        this.commonViewer = commonViewer;
        this.childrenQuery = ArzttarifeModelServiceHolder.get().getNamedQuery(ITarmedLeistung.class, new String[]{"parent"});
        this.childrenChapterQuery = ArzttarifeModelServiceHolder.get().getNamedQuery(ITarmedLeistung.class, new String[]{"parent", "chapter"});
        this.filteredLeafs = new HashMap();
        this.refreshExecutor = new RefreshExecutor();
    }

    public void changed(HashMap<String, String> values) {
        this.currentZiffer = values.get("Ziffer");
        this.currentText = values.get("Text");
        if (this.shouldFilter(this.currentZiffer, this.currentText)) {
            if (!this.isFiltered) {
                this.isFiltered = true;
            }
            this.refreshExecutor.add(new RefreshRunnable(this.currentZiffer, this.currentText));
        } else if (this.isFiltered) {
            this.isFiltered = false;
            this.commonViewer.getViewerWidget().getControl().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    StructuredViewer viewer = TarmedCodeSelectorContentProvider.this.commonViewer.getViewerWidget();
                    viewer.setSelection((ISelection)new StructuredSelection());
                    viewer.getControl().setRedraw(false);
                    viewer.refresh();
                    viewer.getControl().setRedraw(true);
                }
            });
        }
    }

    private void refreshLeafs(String queryZiffer, String queryText) {
        this.filteredLeafs.clear();
        IQuery leafsQuery = ArzttarifeModelServiceHolder.get().getQuery(ITarmedLeistung.class);
        if (queryZiffer != null && queryZiffer.length() > 2) {
            leafsQuery.and("code_", IQuery.COMPARATOR.LIKE, (Object)(String.valueOf(queryZiffer) + "%"));
        }
        if (queryText != null && queryText.length() > 2) {
            leafsQuery.and("tx255", IQuery.COMPARATOR.LIKE, (Object)("%" + queryText + "%"));
        }
        leafsQuery.and("isChapter", IQuery.COMPARATOR.EQUALS, (Object)false);
        leafsQuery.orderBy("code_", IQuery.ORDER.ASC);
        List leafs = leafsQuery.execute();
        for (ITarmedLeistung tarmedLeistung : leafs) {
            String parentId = tarmedLeistung.getParent().getId();
            List<ITarmedLeistung> list = this.filteredLeafs.get(parentId);
            if (list == null) {
                list = new ArrayList<ITarmedLeistung>();
            }
            list.add(tarmedLeistung);
            this.filteredLeafs.put(parentId, list);
        }
    }

    private boolean shouldFilter(String ziffer, String text) {
        return ziffer.length() > 2 || text.length() > 2;
    }

    public void reorder(String field) {
        System.out.println(field);
    }

    public void selected() {
    }

    public void init() {
    }

    public void startListening() {
        this.commonViewer.getConfigurer().getControlFieldProvider().addChangeListener((ViewerConfigurer.ControlFieldListener)this);
    }

    public void stopListening() {
        this.commonViewer.getConfigurer().getControlFieldProvider().removeChangeListener((ViewerConfigurer.ControlFieldListener)this);
    }

    public Object[] getElements(Object inputElement) {
        if (this.roots == null) {
            this.roots = this.getRoots();
        }
        List<ITarmedLeistung> ret = this.roots;
        if (this.isFiltered) {
            ret = this.purgeRoots(ret);
        }
        return ret.toArray();
    }

    private List<ITarmedLeistung> getRoots() {
        return this.childrenQuery.executeWithParameters(this.childrenQuery.getParameterMap(new Object[]{"parent", "NIL"}));
    }

    private List<ITarmedLeistung> purgeRoots(List<ITarmedLeistung> roots) {
        ArrayList<ITarmedLeistung> ret = new ArrayList<ITarmedLeistung>();
        for (ITarmedLeistung root : roots) {
            if (this.currentZiffer != null && this.currentZiffer.length() > 2) {
                if (!root.getCode().equals(this.currentZiffer.substring(0, 2))) continue;
                ret.add(root);
                continue;
            }
            if (!this.subChaptersHaveChildren(root)) continue;
            ret.add(root);
        }
        return ret;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ITarmedLeistung) {
            ITarmedLeistung parentLeistung = (ITarmedLeistung)parentElement;
            if (!this.isFiltered) {
                return this.childrenQuery.executeWithParameters(this.childrenQuery.getParameterMap(new Object[]{"parent", parentLeistung.getId()})).toArray();
            }
            if (this.subChaptersHaveChildren(parentLeistung)) {
                return this.getFilteredChapterChildren(parentLeistung).toArray();
            }
        }
        return null;
    }

    private boolean subChaptersHaveChildren(ITarmedLeistung parentLeistung) {
        List<ITarmedLeistung> children = this.getFilteredChapterChildren(parentLeistung);
        for (ITarmedLeistung tarmedLeistung : children) {
            if (tarmedLeistung.isChapter()) {
                if (!this.subChaptersHaveChildren(tarmedLeistung)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public Object getParent(Object element) {
        if (element instanceof ITarmedLeistung) {
            ITarmedLeistung leistung = (ITarmedLeistung)element;
            return leistung.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object parentElement) {
        if (parentElement instanceof ITarmedLeistung) {
            ITarmedLeistung parentLeistung = (ITarmedLeistung)parentElement;
            if (!this.isFiltered) {
                return !this.childrenQuery.executeWithParameters(this.childrenQuery.getParameterMap(new Object[]{"parent", parentLeistung.getId()})).isEmpty();
            }
            List<ITarmedLeistung> filteredChildren = this.getFilteredChapterChildren(parentLeistung);
            return !filteredChildren.isEmpty();
        }
        return false;
    }

    private List<ITarmedLeistung> getFilteredChapterChildren(ITarmedLeistung parentLeistung) {
        List<ITarmedLeistung> leafs;
        ArrayList<ITarmedLeistung> ret = new ArrayList<ITarmedLeistung>();
        List<ITarmedLeistung> chapterChildren = this.getChapterChildren(parentLeistung);
        if (!chapterChildren.isEmpty()) {
            for (ITarmedLeistung chapter : chapterChildren) {
                if (!this.subChaptersHaveChildren(chapter)) continue;
                ret.add(chapter);
            }
        }
        if ((leafs = this.filteredLeafs.get(parentLeistung.getId())) != null && !leafs.isEmpty()) {
            ret.addAll(leafs);
        }
        return ret;
    }

    private List<ITarmedLeistung> getChapterChildren(ITarmedLeistung parentLeistung) {
        return this.childrenChapterQuery.executeWithParameters(this.childrenChapterQuery.getParameterMap(new Object[]{"parent", parentLeistung.getId(), "chapter", true}));
    }

    private class RefreshExecutor {
        private Executor executor = Executors.newSingleThreadExecutor();
        private boolean isRunning = false;
        private Timer timer;
        private int timerCountDown;
        private RefreshRunnable currentRunnable;
        private long currentRunnableMs;

        private RefreshExecutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(RefreshRunnable refreshRunnable) {
            this.checkTimer();
            Class<RefreshExecutor> clazz = RefreshExecutor.class;
            synchronized (RefreshExecutor.class) {
                this.currentRunnable = refreshRunnable;
                this.currentRunnable.setExecutor(this);
                this.currentRunnableMs = System.currentTimeMillis();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkTimer() {
            Class<RefreshExecutor> clazz = RefreshExecutor.class;
            synchronized (RefreshExecutor.class) {
                if (this.timer == null) {
                    this.timer = new Timer();
                    this.timerCountDown = 30;
                    this.timer.scheduleAtFixedRate(new TimerTask(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Class<RefreshExecutor> clazz = RefreshExecutor.class;
                            synchronized (RefreshExecutor.class) {
                                if (!RefreshExecutor.this.isRunning && RefreshExecutor.this.currentRunnable != null && System.currentTimeMillis() - RefreshExecutor.this.currentRunnableMs > 750L) {
                                    RefreshExecutor.this.executor.execute(RefreshExecutor.this.currentRunnable);
                                    RefreshExecutor.this.setIsRunning(true);
                                    RefreshExecutor.this.currentRunnable = null;
                                }
                                if (--RefreshExecutor.this.timerCountDown == 0) {
                                    RefreshExecutor.this.timer.cancel();
                                    RefreshExecutor.this.timer = null;
                                }
                                // ** MonitorExit[var1_1] (shouldn't be in output)
                                return;
                            }
                        }
                    }, 250L, 250L);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        public void setIsRunning(boolean value) {
            this.isRunning = value;
            this.timerCountDown = 30;
        }
    }

    private class RefreshRunnable
    implements Runnable {
        private RefreshExecutor refreshExecutor;
        private String queryZiffer;
        private String queryText;
        private Display display;

        public RefreshRunnable(String queryZiffer, String queryText) {
            this.queryText = queryText;
            this.queryZiffer = queryZiffer;
            this.display = TarmedCodeSelectorContentProvider.this.commonViewer.getViewerWidget().getControl().getDisplay();
        }

        public void setExecutor(RefreshExecutor refreshExecutor) {
            this.refreshExecutor = refreshExecutor;
        }

        @Override
        public void run() {
            if (this.queryText != null && this.queryText.length() > 2) {
                this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ProgressMonitorDialog pmd = new ProgressMonitorDialog(RefreshRunnable.this.display.getActiveShell());
                        try {
                            pmd.run(true, false, new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    monitor.beginTask("Text Suche nach (" + (this).RefreshRunnable.this.queryText + ")", -1);
                                    RefreshRunnable.this.doWork();
                                }
                            });
                        }
                        catch (InterruptedException | InvocationTargetException exception) {
                            // empty catch block
                        }
                    }
                });
            } else {
                this.doWork();
            }
        }

        private void doWork() {
            TarmedCodeSelectorContentProvider.this.refreshLeafs(this.queryZiffer, this.queryText);
            if (this.refreshExecutor != null) {
                this.refreshExecutor.setIsRunning(false);
            }
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    StructuredViewer viewer = ((RefreshRunnable)RefreshRunnable.this).TarmedCodeSelectorContentProvider.this.commonViewer.getViewerWidget();
                    viewer.setSelection((ISelection)new StructuredSelection());
                    viewer.getControl().setRedraw(false);
                    viewer.refresh();
                    if (RefreshRunnable.this.queryZiffer != null && RefreshRunnable.this.queryZiffer.length() > 4 || RefreshRunnable.this.queryText != null && RefreshRunnable.this.queryText.length() > 4) {
                        if (viewer instanceof TreeViewer) {
                            ((TreeViewer)viewer).expandAll();
                        }
                    } else {
                        ((TreeViewer)viewer).collapseAll();
                    }
                    viewer.getControl().setRedraw(true);
                }
            });
        }
    }
}

