/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.views;

import ch.elexis.base.ch.arzttarife.psycho.IPsychoLeistung;
import ch.elexis.base.ch.arzttarife.service.ArzttarifeModelServiceHolder;
import ch.elexis.core.model.IBillingSystem;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.ch.BillingLaw;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.selectors.FieldDescriptor;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.CommonViewerContentProvider;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.core.ui.util.viewers.SelectorPanelProvider;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.codesystems.CodeSelectorFactory;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;

public class PsychoLeistungCodeSelectorFactory
extends CodeSelectorFactory {
    private ViewerConfigurer vc;

    @Inject
    public void selectedEncounter(@Optional IEncounter encounter) {
        if (this.vc != null && this.vc.getControlFieldProvider() != null) {
            this.vc.getControlFieldProvider().fireChangedEvent();
        }
    }

    public ViewerConfigurer createViewerConfigurer(CommonViewer cv) {
        cv.setSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TableViewer tv = (TableViewer)event.getSource();
                StructuredSelection ss = (StructuredSelection)tv.getSelection();
                if (!ss.isEmpty()) {
                    IPsychoLeistung selected = (IPsychoLeistung)ss.getFirstElement();
                    ContextServiceHolder.get().getRootContext().setNamed("ch.elexis.views.codeselector.psycho.selection", (Object)selected);
                } else {
                    ContextServiceHolder.get().getRootContext().setNamed("ch.elexis.views.codeselector.psycho.selection", null);
                }
            }
        });
        FieldDescriptor[] fd = new FieldDescriptor[]{new FieldDescriptor("Ziffer", "code", null), new FieldDescriptor("Text", "codeText", null)};
        SelectorPanelProvider slp = new SelectorPanelProvider(fd, true);
        this.vc = new ViewerConfigurer((ViewerConfigurer.ICommonViewerContentProvider)new PsychoContentProvider(cv, (ViewerConfigurer.ControlFieldProvider)slp), (LabelProvider)new DefaultLabelProvider(), (ViewerConfigurer.ControlFieldProvider)slp, (ViewerConfigurer.ButtonProvider)new ViewerConfigurer.DefaultButtonProvider(), (ViewerConfigurer.WidgetProvider)new SimpleWidgetProvider(3, 0, cv));
        return this.vc.setContentType(ViewerConfigurer.ContentType.GENERICOBJECT);
    }

    public static boolean isPsycho(IEncounter encounter) {
        IBillingSystem billingSystem = encounter.getCoverage().getBillingSystem();
        if (billingSystem != null) {
            return "tarpsy".equalsIgnoreCase(billingSystem.getName()) || "psycho".equalsIgnoreCase(billingSystem.getName()) || "psychotherapie".equals(billingSystem.getName());
        }
        return false;
    }

    public void dispose() {
    }

    public String getCodeSystemName() {
        return "Psychotherapie";
    }

    public Class<?> getElementClass() {
        return IPsychoLeistung.class;
    }

    private class PsychoContentProvider
    extends CommonViewerContentProvider {
        private ViewerConfigurer.ControlFieldProvider controlFieldProvider;

        public PsychoContentProvider(CommonViewer commonViewer, ViewerConfigurer.ControlFieldProvider controlFieldProvider) {
            super(commonViewer);
            this.controlFieldProvider = controlFieldProvider;
        }

        public Object[] getElements(Object inputElement) {
            java.util.Optional encounter = ContextServiceHolder.get().getTyped(IEncounter.class);
            if (encounter.isPresent() && ((IEncounter)encounter.get()).getCoverage().getBillingSystem().getLaw() == BillingLaw.KVG && PsychoLeistungCodeSelectorFactory.isPsycho((IEncounter)encounter.get())) {
                IQuery<?> query = this.getBaseQuery();
                query.and("validFrom", IQuery.COMPARATOR.LESS_OR_EQUAL, (Object)((IEncounter)encounter.get()).getDate());
                query.startGroup();
                query.or("validUntil", IQuery.COMPARATOR.GREATER_OR_EQUAL, (Object)((IEncounter)encounter.get()).getDate());
                query.or("validUntil", IQuery.COMPARATOR.EQUALS, null);
                query.andJoinGroups();
                this.controlFieldProvider.setQuery(query);
                this.applyQueryFilters(query);
                query.orderBy("code", IQuery.ORDER.ASC);
                List elements = query.execute();
                return elements.toArray(new Object[elements.size()]);
            }
            return Collections.emptyList().toArray();
        }

        protected IQuery<?> getBaseQuery() {
            IQuery query = ArzttarifeModelServiceHolder.get().getQuery(IPsychoLeistung.class);
            query.and("id", IQuery.COMPARATOR.NOT_EQUALS, (Object)"VERSION");
            return query;
        }
    }
}

