/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.views;

import ch.elexis.base.ch.arzttarife.util.ArzttarifeUtil;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.selectors.FieldDescriptor;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.SelectorPanelProvider;
import ch.elexis.views.PhysioLawFilter;
import ch.elexis.views.PhysioValidDateFilter;
import java.time.LocalDate;
import java.util.Optional;
import javax.inject.Inject;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class PhysioSelectorPanelProvider
extends SelectorPanelProvider {
    private static FieldDescriptor<?>[] fields = new FieldDescriptor[]{new FieldDescriptor("Ziffer", "ziffer", null), new FieldDescriptor("Text", "titel", null)};
    private CommonViewer commonViewer;
    private StructuredViewer viewer;
    private PhysioLawFilter lawFilter = new PhysioLawFilter();
    private PhysioValidDateFilter validDateFilter = new PhysioValidDateFilter();
    private IEncounter previousKons;
    private ICoverage previousFall;
    private boolean dirty;

    public PhysioSelectorPanelProvider(CommonViewer viewer) {
        super(fields, true);
        this.commonViewer = viewer;
        CoreUiUtil.injectServicesWithContext((Object)((Object)this));
    }

    @Inject
    public void selectedEncounter(@org.eclipse.e4.core.di.annotations.Optional IEncounter encounter) {
        if (encounter != null) {
            this.updateLawFilter(encounter);
            this.updateValidFilter(encounter);
            this.updateDirty(encounter);
        } else {
            this.lawFilter.setLaw(null);
            this.validDateFilter.setValidDate(null);
            this.updateDirty(null);
        }
    }

    @org.eclipse.e4.core.di.annotations.Optional
    @Inject
    void udpateEncounter(@UIEventTopic(value="info/elexis/model/update") IEncounter encounter) {
        if (encounter != null) {
            this.updateLawFilter(encounter);
            this.updateValidFilter(encounter);
            this.updateDirty(encounter);
        }
    }

    public void setFocus() {
        super.setFocus();
        if (this.viewer == null) {
            Optional selectedEncounter = ContextServiceHolder.get().getTyped(IEncounter.class);
            this.viewer = this.commonViewer.getViewerWidget();
            selectedEncounter.ifPresent(encounter -> this.updateLawFilter((IEncounter)encounter));
            this.viewer.addFilter((ViewerFilter)this.lawFilter);
            selectedEncounter.ifPresent(encounter -> this.updateValidFilter((IEncounter)encounter));
            this.viewer.addFilter((ViewerFilter)this.validDateFilter);
        }
        this.refreshViewer();
    }

    private void refreshViewer() {
        if (this.viewer != null && this.dirty) {
            this.dirty = false;
            this.viewer.getControl().setRedraw(false);
            this.viewer.setSelection((ISelection)new StructuredSelection());
            this.viewer.refresh();
            this.viewer.getControl().setRedraw(true);
        }
    }

    private void updateValidFilter(IEncounter encounter) {
        this.validDateFilter.setValidDate(encounter.getDate());
    }

    private void updateLawFilter(IEncounter encounter) {
        if (encounter.getDate().isAfter(LocalDate.of(2025, 6, 30))) {
            String konsLaw;
            ICoverage coverage = encounter.getCoverage();
            String law = "";
            if (coverage != null && ArzttarifeUtil.isAvailableLaw((String)(konsLaw = coverage.getBillingSystem().getLaw().name()))) {
                law = konsLaw;
            }
            this.lawFilter.setLaw(law);
        } else {
            this.lawFilter.setLaw("");
        }
    }

    private void updateDirty(IEncounter encounter) {
        if (encounter != this.previousKons) {
            this.dirty = true;
            this.previousKons = encounter;
        }
        if (encounter != null && encounter.getCoverage() != this.previousFall) {
            this.dirty = true;
            this.previousFall = encounter.getCoverage();
        }
    }

    public void toggleFilters() {
        this.validDateFilter.setDoFilter(!this.validDateFilter.getDoFilter());
        this.lawFilter.setDoFilter(!this.lawFilter.getDoFilter());
        this.dirty = true;
        this.refreshViewer();
    }
}

