/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.views;

import ch.elexis.base.ch.arzttarife.physio.IPhysioLeistung;
import ch.elexis.base.ch.arzttarife.service.ArzttarifeModelServiceHolder;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.CommonViewerContentProvider;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.codesystems.CodeSelectorFactory;
import ch.elexis.views.PhysioSelectorPanelProvider;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;

public class PhysioLeistungsCodeSelectorFactory
extends CodeSelectorFactory {
    PhysioSelectorPanelProvider slp;
    private ViewerConfigurer vc;

    @Inject
    public void selectedEncounter(@Optional IEncounter encounter) {
        if (this.vc != null && this.vc.getControlFieldProvider() != null) {
            this.vc.getControlFieldProvider().fireChangedEvent();
        }
    }

    public ViewerConfigurer createViewerConfigurer(CommonViewer cv) {
        cv.setSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TableViewer tv = (TableViewer)event.getSource();
                StructuredSelection ss = (StructuredSelection)tv.getSelection();
                if (!ss.isEmpty()) {
                    IPhysioLeistung selected = (IPhysioLeistung)ss.getFirstElement();
                    ContextServiceHolder.get().getRootContext().setNamed("ch.elexis.views.codeselector.physio.selection", (Object)selected);
                } else {
                    ContextServiceHolder.get().getRootContext().setNamed("ch.elexis.views.codeselector.physio.selection", null);
                }
            }
        });
        this.slp = new PhysioSelectorPanelProvider(cv);
        this.slp.addActions(new IAction[]{new ToggleFiltersAction()});
        this.vc = new ViewerConfigurer((ViewerConfigurer.ICommonViewerContentProvider)new PhysioContentProvider(cv, (ViewerConfigurer.ControlFieldProvider)this.slp), (LabelProvider)new DefaultLabelProvider(), (ViewerConfigurer.ControlFieldProvider)this.slp, (ViewerConfigurer.ButtonProvider)new ViewerConfigurer.DefaultButtonProvider(), (ViewerConfigurer.WidgetProvider)new SimpleWidgetProvider(3, 0, cv));
        return this.vc.setContentType(ViewerConfigurer.ContentType.GENERICOBJECT);
    }

    public void dispose() {
    }

    public String getCodeSystemName() {
        return "Physiotherapie";
    }

    public Class<?> getElementClass() {
        return IPhysioLeistung.class;
    }

    private class PhysioContentProvider
    extends CommonViewerContentProvider {
        private ViewerConfigurer.ControlFieldProvider controlFieldProvider;

        public PhysioContentProvider(CommonViewer commonViewer, ViewerConfigurer.ControlFieldProvider controlFieldProvider) {
            super(commonViewer);
            this.controlFieldProvider = controlFieldProvider;
        }

        public Object[] getElements(Object inputElement) {
            IQuery<?> query = this.getBaseQuery();
            this.controlFieldProvider.setQuery(query);
            this.applyQueryFilters(query);
            query.orderBy("ziffer", IQuery.ORDER.ASC);
            List elements = query.execute();
            return elements.toArray(new Object[elements.size()]);
        }

        protected IQuery<?> getBaseQuery() {
            IQuery query = ArzttarifeModelServiceHolder.get().getQuery(IPhysioLeistung.class);
            query.and("id", IQuery.COMPARATOR.NOT_EQUALS, (Object)"VERSION");
            return query;
        }
    }

    private class ToggleFiltersAction
    extends Action {
        public ToggleFiltersAction() {
            super("", 2);
            this.setChecked(true);
        }

        public String getToolTipText() {
            return "Kontext (Konsultation, Fall, etc.) Filter (de)aktivieren";
        }

        public ImageDescriptor getImageDescriptor() {
            return Images.IMG_FILTER.getImageDescriptor();
        }

        public void run() {
            PhysioLeistungsCodeSelectorFactory.this.slp.toggleFilters();
        }
    }
}

