/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.tarmedprefs;

import ch.elexis.TarmedRechnung.TarmedACL;
import ch.elexis.base.ch.arzttarife.importer.TrustCenters;
import ch.elexis.base.ch.arzttarife.tarmed.MandantType;
import ch.elexis.base.ch.arzttarife.util.ArzttarifeUtil;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.KontaktExtDialog;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Organisation;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.tarmedprefs.Messages;
import ch.elexis.tarmedprefs.ResponsibleComposite;
import ch.elexis.tarmedprefs.TardocSpecialistComposite;
import ch.elexis.tarmedprefs.TarmedRequirements;
import ch.rgw.tools.StringTool;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class RechnungsPrefs
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PREF_ADDCHILDREN = "tarmed/addchildrentp";
    Combo cbMands;
    HashMap<String, Mandant> hMandanten;
    Hyperlink hTreat;
    Hyperlink hPost;
    Hyperlink hBank;
    IHyperlinkListener hDetailListener;
    FocusListener focusListener;
    Text tTreat;
    Text tPost;
    Text tBank;
    Button bPost;
    Button bBank;
    IMandator actMandant;
    IContact actBank;
    Button bUseTC;
    Combo cbTC;
    Button bBillsElec;
    private ResponsibleComposite responsible;
    private ComboViewer cvMandantType;
    private Label lblFixProvider;
    private TardocSpecialistComposite tardocSpecialist;
    static TarmedACL ta = TarmedACL.getInstance();
    static final String[] ExtFlds = new String[]{"Anrede=www.elexis.ch/xid/kontakt/anrede", "Kanton=www.elexis.ch/xid/kontakt/kanton", "EAN=www.xid.ch/id/ean", "NIF=www.xid.ch/id/nif", "KSK=www.xid.ch/id/ksk", RechnungsPrefs.ta.ESR5OR9, RechnungsPrefs.ta.ESRPLUS, RechnungsPrefs.ta.TIERS, RechnungsPrefs.ta.SPEC, RechnungsPrefs.ta.KANTON, RechnungsPrefs.ta.LOCAL, RechnungsPrefs.ta.DIAGSYS, "Rolle=www.elexis.ch/xid/kontakt/rolle"};

    public RechnungsPrefs() {
        super(Messages.RechnungsPrefs_BillPrefs);
    }

    public void dispose() {
    }

    protected Control createContents(Composite parent) {
        Color blau = UiDesk.getColor((String)"blau");
        this.hDetailListener = new DetailListener();
        this.focusListener = new TextListener();
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout());
        this.hMandanten = new HashMap();
        this.cbMands = new Combo(ret, 8);
        this.cbMands.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.cbMands.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = RechnungsPrefs.this.cbMands.getSelectionIndex();
                if (i == -1) {
                    return;
                }
                Mandant selectedMandant = RechnungsPrefs.this.hMandanten.get(RechnungsPrefs.this.cbMands.getItem(i));
                RechnungsPrefs.this.setMandant((IMandator)NoPoUtil.loadAsIdentifiable((PersistentObject)selectedMandant, IMandator.class).get());
            }
        });
        Query qbe = new Query(Mandant.class);
        List list = qbe.execute();
        Collections.sort(list, new Comparator<Mandant>(){

            @Override
            public int compare(Mandant o1, Mandant o2) {
                return o1.getLabel(true).compareToIgnoreCase(o2.getLabel(true));
            }
        });
        for (Mandant m : list) {
            this.cbMands.add(m.getLabel());
            this.hMandanten.put(m.getLabel(), m);
        }
        Group adrs = new Group(ret, 0);
        adrs.setLayout((Layout)new GridLayout(2, false));
        adrs.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        adrs.setText(Messages.RechnungsPrefs_BillDetails);
        this.hTreat = new Hyperlink((Composite)adrs, 0);
        this.hTreat.setText(Messages.RechnungsPrefs_Treator);
        this.hTreat.setForeground(blau);
        this.hTreat.addHyperlinkListener(this.hDetailListener);
        this.tTreat = new Text((Composite)adrs, 2056);
        this.tTreat.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        Label lMandantType = new Label((Composite)adrs, 0);
        lMandantType.setText(Messages.RechnungsPrefs_MandantType);
        lMandantType.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.cvMandantType = new ComboViewer((Composite)adrs);
        this.cvMandantType.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.cvMandantType.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof MandantType) {
                    if (element == MandantType.SPECIALIST) {
                        return Messages.RechnungsPrefs_MandantType_SPECIALIST;
                    }
                    if (element == MandantType.PRACTITIONER) {
                        return Messages.RechnungsPrefs_MandantType_PRACTITIONER;
                    }
                    if (element == MandantType.TARPSYAPPRENTICE) {
                        return Messages.RechnungsPrefs_MandantType_TARPSYAPPRENTICE;
                    }
                }
                return element.toString();
            }
        });
        this.cvMandantType.setInput((Object)MandantType.values());
        this.cvMandantType.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object element;
                ISelection selection = event.getSelection();
                if (selection instanceof StructuredSelection && !selection.isEmpty() && (element = ((StructuredSelection)selection).getFirstElement()) instanceof MandantType && RechnungsPrefs.this.actMandant != null) {
                    IMandator mandator = (IMandator)CoreModelServiceHolder.get().load(RechnungsPrefs.this.actMandant.getId(), IMandator.class).get();
                    ArzttarifeUtil.setMandantType((IMandator)mandator, (MandantType)((MandantType)element));
                    CoreModelServiceHolder.get().save((Identifiable)mandator);
                }
            }
        });
        this.cvMandantType.getCombo().setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        Hyperlink hTardocSpecialist = new Hyperlink((Composite)adrs, 0);
        hTardocSpecialist.setText(Messages.RechnungsPrefs_TardocSpecialistLink);
        hTardocSpecialist.setForeground(blau);
        hTardocSpecialist.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        hTardocSpecialist.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (RechnungsPrefs.this.tardocSpecialist != null && !RechnungsPrefs.this.tardocSpecialist.isDisposed()) {
                    RechnungsPrefs.this.tardocSpecialist.openSelectionDialog();
                }
            }
        });
        this.tardocSpecialist = new TardocSpecialistComposite((Composite)adrs, 0);
        this.tardocSpecialist.setLayoutData(SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.bBillsElec = new Button((Composite)adrs, 32);
        this.bBillsElec.setText(Messages.RechnungsPrefs_BillsElectronically);
        if (this.actMandant != null) {
            this.bBillsElec.setSelection(ConfigServiceHolder.get().get((IContact)this.actMandant, "TarmedBillElectronic", false));
        }
        this.bBillsElec.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigServiceHolder.get().set((IContact)RechnungsPrefs.this.actMandant, "TarmedBillElectronic", RechnungsPrefs.this.bBillsElec.getSelection());
            }
        });
        Composite cFinanzinstitut = new Composite((Composite)adrs, 0);
        cFinanzinstitut.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        cFinanzinstitut.setLayout((Layout)new GridLayout(2, false));
        Label lFinanzinstitut = new Label(cFinanzinstitut, 0);
        lFinanzinstitut.setText(Messages.RechnungsPrefs_Financeinst);
        lFinanzinstitut.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        this.bPost = new Button(cFinanzinstitut, 16);
        GridData gd = SWTHelper.getFillGridData((int)1, (boolean)false, (int)1, (boolean)false);
        gd.verticalAlignment = 128;
        this.bPost.setLayoutData((Object)gd);
        this.bPost.setText(Messages.RechnungsPrefs_post);
        this.bPost.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RechnungsPrefs.this.bPost.getSelection()) {
                    if (RechnungsPrefs.this.actBank != null) {
                        RechnungsPrefs.this.actBank = null;
                        RechnungsPrefs.this.actMandant.setExtInfo((Object)RechnungsPrefs.ta.RNBANK, (Object)"");
                        RechnungsPrefs.this.actMandant.setExtInfo((Object)RechnungsPrefs.ta.ESRNUMBER, (Object)"");
                        RechnungsPrefs.this.actMandant.setExtInfo((Object)RechnungsPrefs.ta.ESRSUB, (Object)"");
                        RechnungsPrefs.this.actMandant.setExtInfo((Object)Messages.RechnungsPrefs_department, (Object)"");
                        RechnungsPrefs.this.actMandant.setExtInfo((Object)Messages.RechnungsPrefs_POBox, (Object)"");
                        RechnungsPrefs.this.actMandant.setExtInfo((Object)"IBAN", (Object)"");
                        CoreModelServiceHolder.get().save((Identifiable)RechnungsPrefs.this.actMandant);
                    }
                    if (StringTool.isNothing((Object)RechnungsPrefs.this.actMandant.getExtInfo((Object)RechnungsPrefs.ta.ESRNUMBER))) {
                        new PostDialog(RechnungsPrefs.this.getShell()).open();
                    }
                    RechnungsPrefs.this.setMandant(RechnungsPrefs.this.actMandant);
                }
            }
        });
        Composite cPost = new Composite(cFinanzinstitut, 0);
        gd = SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false);
        gd.verticalAlignment = 128;
        cPost.setLayoutData((Object)gd);
        cPost.setLayout((Layout)new GridLayout(1, false));
        this.hPost = new Hyperlink(cPost, 0);
        this.hPost.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.hPost.setText(Messages.RechnungsPrefs_POAccount);
        this.hPost.setForeground(blau);
        this.hPost.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                new PostDialog(RechnungsPrefs.this.getShell()).open();
                RechnungsPrefs.this.setMandant(RechnungsPrefs.this.actMandant);
            }
        });
        this.tPost = new Text(cPost, 2056);
        this.tPost.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.bBank = new Button(cFinanzinstitut, 16);
        gd = SWTHelper.getFillGridData((int)1, (boolean)false, (int)1, (boolean)false);
        gd.verticalAlignment = 128;
        this.bBank.setLayoutData((Object)gd);
        this.bBank.setText(Messages.RechnungsPrefs_bank);
        this.bBank.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RechnungsPrefs.this.bBank.getSelection() && RechnungsPrefs.this.actBank == null) {
                    RechnungsPrefs.this.actMandant.setExtInfo((Object)RechnungsPrefs.ta.ESRNUMBER, (Object)"");
                    CoreModelServiceHolder.get().save((Identifiable)RechnungsPrefs.this.actMandant);
                    new BankLister(RechnungsPrefs.this.getShell()).open();
                }
            }
        });
        Composite cBank = new Composite(cFinanzinstitut, 0);
        gd = SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false);
        gd.verticalAlignment = 128;
        cBank.setLayoutData((Object)gd);
        cBank.setLayout((Layout)new GridLayout(1, false));
        this.hBank = new Hyperlink(cBank, 0);
        this.hBank.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.hBank.setText(Messages.RechnungsPrefs_bankconnection);
        this.hBank.setForeground(blau);
        this.hBank.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                BankLister dlg = new BankLister(RechnungsPrefs.this.getShell());
                dlg.open();
            }
        });
        this.tBank = new Text(cBank, 2056);
        this.tBank.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        Group gTC = new Group(ret, 0);
        gTC.setText(Messages.RechnungsPrefs_trustcenter);
        gTC.setLayout((Layout)new GridLayout());
        gTC.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.bUseTC = new Button((Composite)gTC, 32);
        this.bUseTC.setText(Messages.RechnungsPrefs_TrustCenterUsed);
        this.bUseTC.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IMandator mandator = CoreModelServiceHolder.get().load(RechnungsPrefs.this.actMandant.getId(), IMandator.class).orElse(null);
                if (mandator != null) {
                    TarmedRequirements.setHasTCContract((IContact)mandator, RechnungsPrefs.this.bUseTC.getSelection());
                    CoreModelServiceHolder.get().save((Identifiable)mandator);
                }
            }
        });
        this.cbTC = new Combo((Composite)gTC, 0);
        for (String k : TrustCenters.tc.keySet()) {
            this.cbTC.add(k);
        }
        this.cbTC.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IMandator mandator = CoreModelServiceHolder.get().load(RechnungsPrefs.this.actMandant.getId(), IMandator.class).orElse(null);
                if (mandator != null) {
                    TarmedRequirements.setTC((IContact)mandator, RechnungsPrefs.this.cbTC.getText());
                    CoreModelServiceHolder.get().save((Identifiable)mandator);
                }
            }
        });
        Group gResponsible = new Group(ret, 0);
        gResponsible.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        gResponsible.setLayout((Layout)new FillLayout());
        gResponsible.setText(Messages.RechnungsPrefs_Responsible_Doctor);
        this.responsible = new ResponsibleComposite((Composite)gResponsible, 0);
        Group gAuto = new Group(ret, 0);
        gAuto.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        gAuto.setLayout((Layout)new FillLayout());
        final Button bAddChildren = new Button((Composite)gAuto, 32);
        bAddChildren.setText(Messages.RechnungsPrefs_AddChildren);
        bAddChildren.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigServiceHolder.setMandator((String)RechnungsPrefs.PREF_ADDCHILDREN, (boolean)bAddChildren.getSelection());
            }
        });
        bAddChildren.setSelection(ConfigServiceHolder.getMandator((String)PREF_ADDCHILDREN, (boolean)false));
        final Group gFixProvider = new Group(ret, 0);
        gFixProvider.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        gFixProvider.setLayout((Layout)new GridLayout(2, false));
        gFixProvider.setText(Messages.RechnungsPrefs_FixProviderGroupTitle);
        Hyperlink fixProvider = new Hyperlink((Composite)gFixProvider, 0);
        fixProvider.setText(Messages.RechnungsPrefs_FixProviderLink);
        fixProvider.setForeground(blau);
        fixProvider.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                KontaktSelektor ks = new KontaktSelektor(UiDesk.getTopShell(), Kontakt.class, Messages.RechnungsPrefs_SelectContactTitle, Messages.RechnungsPrefs_SelectFixProviderMessage, new String[0]);
                int ret = ks.open();
                if (ret == 0) {
                    Kontakt k = (Kontakt)ks.getSelection();
                    ConfigServiceHolder.get().set("TarmedBillFixProvider", k != null ? k.getId() : null);
                    String label = k != null ? k.getLabel() : "";
                    RechnungsPrefs.this.lblFixProvider.setText(label);
                } else {
                    ConfigServiceHolder.get().set("TarmedBillFixProvider", null);
                    RechnungsPrefs.this.lblFixProvider.setText("");
                }
                gFixProvider.layout();
            }
        });
        this.lblFixProvider = new Label((Composite)gFixProvider, 0);
        this.lblFixProvider.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        if (StringUtils.isNotBlank((CharSequence)ConfigServiceHolder.getGlobal((String)"TarmedBillFixProvider", null))) {
            Kontakt k = Kontakt.load((String)ConfigServiceHolder.getGlobal((String)"TarmedBillFixProvider", null));
            String label = k != null ? k.getLabel() : "";
            this.lblFixProvider.setText(label);
        }
        this.cbMands.select(0);
        Mandant selectedMandant = this.hMandanten.get(this.cbMands.getItem(0));
        this.setMandant((IMandator)NoPoUtil.loadAsIdentifiable((PersistentObject)selectedMandant, IMandator.class).get());
        return ret;
    }

    public void init(IWorkbench workbench) {
    }

    void setMandant(IMandator m) {
        this.actMandant = m;
        this.tTreat.setText(this.actMandant.getLabel());
        this.cvMandantType.setSelection((ISelection)new StructuredSelection((Object)ArzttarifeUtil.getMandantType((IMandator)this.actMandant)));
        this.tardocSpecialist.setMandator(m);
        this.actBank = CoreModelServiceHolder.get().load((String)this.actMandant.getExtInfo((Object)RechnungsPrefs.ta.RNBANK), IContact.class).orElse(null);
        if (this.actBank != null) {
            this.tPost.setText("");
            this.tBank.setText(this.actBank.getLabel());
            this.hBank.setEnabled(true);
            this.hPost.setEnabled(false);
        } else {
            this.tPost.setText(StringUtils.defaultString((String)((String)this.actMandant.getExtInfo((Object)RechnungsPrefs.ta.ESRNUMBER))));
            this.tBank.setText("");
            this.hBank.setEnabled(false);
            this.hPost.setEnabled(true);
        }
        this.bPost.setSelection(this.actBank == null);
        this.bBank.setSelection(this.actBank != null);
        this.bUseTC.setSelection(TarmedRequirements.hasTCContract(CoreModelServiceHolder.get().load(this.actMandant.getId(), IMandator.class).orElse(null)));
        String tcName = TarmedRequirements.getTCName(CoreModelServiceHolder.get().load(this.actMandant.getId(), IMandator.class).orElse(null));
        if (tcName != null) {
            this.cbTC.setText(tcName);
        } else {
            this.cbTC.setText("");
        }
        this.bBillsElec.setSelection(ConfigServiceHolder.get().get((IContact)this.actMandant, "TarmedBillElectronic", false));
        this.responsible.setMandant(Mandant.load((String)m.getId()));
    }

    class BankLister
    extends TitleAreaDialog {
        final String[] flds;
        private Text tInvoiceInfo;
        private KontaktExtDialog.ExtInfoTable exTable;

        BankLister(Shell shell) {
            super(shell);
            this.flds = new String[]{Messages.RechnungsPrefs_department, Messages.RechnungsPrefs_POBox, RechnungsPrefs.ta.ESRNUMBER, RechnungsPrefs.ta.ESRSUB, "IBAN"};
        }

        protected Control createDialogArea(Composite parent) {
            Composite ret = new Composite(parent, 0);
            ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
            ret.setLayout((Layout)new GridLayout(2, false));
            final Hyperlink hlBank = UiDesk.getToolkit().createHyperlink(ret, Messages.RechnungsPrefs_FinanceInst, 0);
            hlBank.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    KontaktSelektor ksl = new KontaktSelektor(BankLister.this.getShell(), Organisation.class, Messages.RechnungsPrefs_paymentinst, Messages.RechnungsPrefs_PleseChooseBank, new String[]{"Bezeichnung1", "Bezeichnung2"});
                    if (ksl.open() == 0) {
                        ((BankLister)BankLister.this).RechnungsPrefs.this.actBank = NoPoUtil.loadAsIdentifiable((PersistentObject)((Kontakt)ksl.getSelection()), IContact.class).orElse(null);
                        ((BankLister)BankLister.this).RechnungsPrefs.this.actMandant.setExtInfo((Object)RechnungsPrefs.ta.RNBANK, (Object)((BankLister)BankLister.this).RechnungsPrefs.this.actBank.getId());
                        CoreModelServiceHolder.get().save((Identifiable)((BankLister)BankLister.this).RechnungsPrefs.this.actMandant);
                    }
                    BankLister.this.updateMandantContactHyper(hlBank, RechnungsPrefs.ta.RNBANK);
                }
            });
            this.updateMandantContactHyper(hlBank, RechnungsPrefs.ta.RNBANK);
            hlBank.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)true));
            final Hyperlink hlOwner = UiDesk.getToolkit().createHyperlink(ret, Messages.RechnungsPrefs_AccountOwner, 0);
            hlOwner.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    KontaktSelektor ksl = new KontaktSelektor(BankLister.this.getShell(), Kontakt.class, Messages.RechnungsPrefs_AccountOwner, Messages.RechnungsPrefs_SelectAccountOwnerMessage, new String[]{"Bezeichnung1", "Bezeichnung2"});
                    if (ksl.open() == 0) {
                        Kontakt accountOwner = (Kontakt)ksl.getSelection();
                        ((BankLister)BankLister.this).RechnungsPrefs.this.actMandant.setExtInfo((Object)RechnungsPrefs.ta.RNACCOUNTOWNER, (Object)accountOwner.getId());
                        CoreModelServiceHolder.get().save((Identifiable)((BankLister)BankLister.this).RechnungsPrefs.this.actMandant);
                    } else {
                        ((BankLister)BankLister.this).RechnungsPrefs.this.actMandant.setExtInfo((Object)RechnungsPrefs.ta.RNACCOUNTOWNER, null);
                        CoreModelServiceHolder.get().save((Identifiable)((BankLister)BankLister.this).RechnungsPrefs.this.actMandant);
                    }
                    BankLister.this.updateMandantContactHyper(hlOwner, RechnungsPrefs.ta.RNACCOUNTOWNER);
                }
            });
            this.updateMandantContactHyper(hlOwner, RechnungsPrefs.ta.RNACCOUNTOWNER);
            hlOwner.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)true));
            Label lbl = new Label(ret, 0);
            lbl.setText(Messages.RechnungsPrefs_InvoiceInfoLabel);
            this.tInvoiceInfo = new Text(ret, 2050);
            GridData gd = new GridData(4, 0x1000000, true, false, 2, 1);
            gd.heightHint = 50;
            this.tInvoiceInfo.setLayoutData((Object)gd);
            this.tInvoiceInfo.setToolTipText(Messages.RechnungsPrefs_InvoiceInfoTooltip);
            this.tInvoiceInfo.setTextLimit(140);
            if (RechnungsPrefs.this.actMandant.getExtInfo((Object)RechnungsPrefs.ta.RNINFORMATION) != null) {
                this.tInvoiceInfo.setText((String)RechnungsPrefs.this.actMandant.getExtInfo((Object)RechnungsPrefs.ta.RNINFORMATION));
            }
            this.exTable = new KontaktExtDialog.ExtInfoTable(parent, this.flds);
            this.exTable.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
            this.exTable.setKontakt((IContact)RechnungsPrefs.this.actMandant);
            return ret;
        }

        private void updateMandantContactHyper(Hyperlink hb, String objectKey) {
            IContact contact;
            String[] parts = hb.getText().split(" - ");
            if (RechnungsPrefs.this.actMandant != null && RechnungsPrefs.this.actMandant.getExtInfo((Object)objectKey) != null && (contact = (IContact)CoreModelServiceHolder.get().load((String)RechnungsPrefs.this.actMandant.getExtInfo((Object)objectKey), IContact.class).orElse(null)) != null) {
                if (parts.length == 1 || parts.length == 2) {
                    hb.setText(String.valueOf(parts[0]) + " - " + contact.getLabel());
                }
                return;
            }
            hb.setText(parts[0]);
        }

        public void create() {
            super.create();
            this.getShell().setText(Messages.RechnungsPrefs_ChooseBank);
            this.setTitle(RechnungsPrefs.this.actMandant.getLabel());
            this.setMessage(Messages.RechnungsPrefs_ChosseInst);
        }

        protected void okPressed() {
            IContact accountOwner;
            if (StringUtils.isEmpty((CharSequence)((String)RechnungsPrefs.this.actMandant.getExtInfo((Object)RechnungsPrefs.ta.RNBANK)))) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.RechnungsPrefs_ChooseBank, (String)Messages.RechnungsPrefs_NoFinanceInstituteSelected);
                return;
            }
            this.exTable.okPressed((IContact)RechnungsPrefs.this.actMandant);
            RechnungsPrefs.this.setMandant(RechnungsPrefs.this.actMandant);
            if (RechnungsPrefs.this.actMandant.getExtInfo((Object)RechnungsPrefs.ta.RNACCOUNTOWNER) != null && (accountOwner = (IContact)CoreModelServiceHolder.get().load((String)RechnungsPrefs.this.actMandant.getExtInfo((Object)RechnungsPrefs.ta.RNACCOUNTOWNER), IContact.class).orElse(null)) != null) {
                accountOwner.setExtInfo((Object)"IBAN", RechnungsPrefs.this.actMandant.getExtInfo((Object)"IBAN"));
                CoreModelServiceHolder.get().save((Identifiable)accountOwner);
            }
            if (StringUtils.isNotBlank((CharSequence)this.tInvoiceInfo.getText())) {
                RechnungsPrefs.this.actMandant.setExtInfo((Object)RechnungsPrefs.ta.RNINFORMATION, (Object)this.tInvoiceInfo.getText());
            } else {
                RechnungsPrefs.this.actMandant.setExtInfo((Object)RechnungsPrefs.ta.RNINFORMATION, null);
            }
            CoreModelServiceHolder.get().save((Identifiable)RechnungsPrefs.this.actMandant);
            super.okPressed();
        }

        protected void cancelPressed() {
            RechnungsPrefs.this.setMandant(RechnungsPrefs.this.actMandant);
            super.cancelPressed();
        }
    }

    class DetailListener
    extends HyperlinkAdapter {
        DetailListener() {
        }

        public void linkActivated(HyperlinkEvent e) {
            if (RechnungsPrefs.this.actMandant == null) {
                return;
            }
            KontaktExtDialog dlg = new KontaktExtDialog(RechnungsPrefs.this.getShell(), (IContact)RechnungsPrefs.this.actMandant, ExtFlds);
            dlg.create();
            dlg.setTitle(Messages.RechnungsPrefs_MandatorDetails);
            dlg.open();
        }
    }

    class PostDialog
    extends TitleAreaDialog {
        final String[] flds;
        KontaktExtDialog.ExtInfoTable exTable;

        PostDialog(Shell shell) {
            super(shell);
            this.flds = new String[]{RechnungsPrefs.ta.ESRNUMBER, "IBAN"};
        }

        protected Control createDialogArea(Composite parent) {
            Composite ret = new Composite(parent, 0);
            ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
            ret.setLayout((Layout)new GridLayout(2, false));
            this.exTable = new KontaktExtDialog.ExtInfoTable(parent, this.flds);
            this.exTable.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)true));
            this.exTable.setKontakt((IContact)RechnungsPrefs.this.actMandant);
            return ret;
        }

        public void create() {
            super.create();
            this.getShell().setText(Messages.RechnungsPrefs_postAccount);
            this.setTitle(RechnungsPrefs.this.actMandant.getLabel());
            this.setMessage(Messages.RechnungsPrefs_InfoPostAccount);
        }

        protected void okPressed() {
            this.exTable.okPressed((IContact)RechnungsPrefs.this.actMandant);
            RechnungsPrefs.this.setMandant(RechnungsPrefs.this.actMandant);
            super.okPressed();
        }

        protected void cancelPressed() {
            RechnungsPrefs.this.setMandant(RechnungsPrefs.this.actMandant);
            super.cancelPressed();
        }
    }

    class TextListener
    extends FocusAdapter {
        TextListener() {
        }

        public void focusLost(FocusEvent e) {
            Text t = (Text)e.getSource();
            String fld = (String)t.getData();
            RechnungsPrefs.this.actMandant.setExtInfo((Object)fld, (Object)t.getText());
            CoreModelServiceHolder.get().save((Identifiable)RechnungsPrefs.this.actMandant);
        }
    }
}

