/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.xml.exporter;

import ch.elexis.TarmedRechnung.Messages;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.CoverageServiceHolder;
import ch.elexis.tarmedprefs.TarmedRequirements;
import ch.fd.invoice450.request.RequestType;
import ch.rgw.tools.Result;
import ch.rgw.tools.StringTool;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Tarmed45Validator {
    private static Validator validator;

    public synchronized List<String> validateRequest(InputStream request) {
        if (validator == null) {
            try {
                validator = this.initValidator();
            }
            catch (SAXException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error creating validator", (Throwable)e);
                throw new IllegalStateException("Error creating validator");
            }
        }
        return this.validate(new StreamSource(request));
    }

    private Validator initValidator() throws SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        factory.setResourceResolver(new LSResourceResolver(){
            private DOMImplementationLS impl;

            public DOMImplementationLS getDOMImpl() {
                if (this.impl == null) {
                    try {
                        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
                        this.impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS 3.0"));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                return this.impl;
            }

            @Override
            public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                InputStream is;
                LoggerFactory.getLogger(Tarmed45Validator.class).info("Resolve resource ns[" + namespaceURI + "] pubid[" + systemId + "] sysid[" + systemId + "]");
                if (StringUtils.isNotBlank((CharSequence)systemId) && systemId.contains("://")) {
                    systemId = systemId.substring(systemId.lastIndexOf(47) + 1);
                }
                if ((is = Tarmed45Validator.class.getResourceAsStream("/rsc/" + systemId)) == null) {
                    LoggerFactory.getLogger(Tarmed45Validator.class).warn("Could not resolve resource using impl [" + this.impl + "]");
                    return null;
                }
                LSInput lsInput = this.getDOMImpl().createLSInput();
                lsInput.setByteStream(is);
                return lsInput;
            }
        });
        LoggerFactory.getLogger(Tarmed45Validator.class).warn("Loading generalInvoiceRequest_450.xsd using factory [" + factory + "]");
        factory.setFeature("http://apache.org/xml/features/honour-all-schemaLocations", false);
        Schema schema = factory.newSchema(new StreamSource(Tarmed45Validator.class.getResourceAsStream("/rsc/generalInvoiceRequest_450.xsd")));
        return schema.newValidator();
    }

    private List<String> validate(Source source) {
        MyErrorHandler errorHandler = new MyErrorHandler();
        try {
            validator.setErrorHandler(errorHandler);
            validator.validate(source);
        }
        catch (Exception ex) {
            errorHandler.exception(ex);
        }
        return errorHandler.getMessageList();
    }

    public Result<IInvoice> checkInvoice(IInvoice invoice, RequestType invoiceRequest) {
        String bez;
        IContact costBearer;
        String ean;
        ICoverage coverage;
        Result res = new Result();
        IMandator m = invoice.getMandator();
        if (invoice.getState().numericValue() > InvoiceState.OPEN.numericValue()) {
            return res;
        }
        if (m == null) {
            invoice.reject(InvoiceState.REJECTCODE.NO_MANDATOR, Messages.Validator_NoMandator);
            CoreModelServiceHolder.get().save((Identifiable)invoice);
            res.add(Result.SEVERITY.ERROR, 2, Messages.Validator_NoMandator, (Object)invoice, true);
        }
        if ((coverage = invoice.getCoverage()) == null || !CoverageServiceHolder.get().isValid(coverage)) {
            invoice.reject(InvoiceState.REJECTCODE.NO_CASE, Messages.Validator_NoCase);
            CoreModelServiceHolder.get().save((Identifiable)invoice);
            res.add(Result.SEVERITY.ERROR, 4, Messages.Validator_NoCase, (Object)invoice, true);
        }
        if (StringTool.isNothing((Object)(ean = TarmedRequirements.getEAN((IContact)m)))) {
            invoice.reject(InvoiceState.REJECTCODE.NO_MANDATOR, Messages.Validator_NoEAN);
            CoreModelServiceHolder.get().save((Identifiable)invoice);
            res.add(Result.SEVERITY.ERROR, 3, Messages.Validator_NoEAN, (Object)invoice, true);
        }
        if (invoiceRequest.getPayload().getBody().getTreatment().getDiagnosis().isEmpty()) {
            invoice.reject(InvoiceState.REJECTCODE.NO_DIAG, Messages.Validator_NoDiagnosis);
            CoreModelServiceHolder.get().save((Identifiable)invoice);
            res.add(Result.SEVERITY.ERROR, 8, Messages.Validator_NoDiagnosis, (Object)invoice, true);
        }
        IContact iContact = costBearer = coverage != null ? coverage.getCostBearer() : null;
        if (costBearer == null && invoiceRequest.getPayload().getBody().getTiersGarant() != null) {
            return res;
        }
        if (costBearer == null) {
            invoice.reject(InvoiceState.REJECTCODE.NO_GUARANTOR, Messages.Validator_NoName);
            CoreModelServiceHolder.get().save((Identifiable)invoice);
            res.add(Result.SEVERITY.ERROR, 7, Messages.Validator_NoName, (Object)invoice, true);
            return res;
        }
        ean = TarmedRequirements.getEAN(costBearer);
        if (StringTool.isNothing((Object)ean) || !ean.matches("[0-9]{13}")) {
            invoice.reject(InvoiceState.REJECTCODE.NO_GUARANTOR, Messages.Validator_NoEAN2);
            CoreModelServiceHolder.get().save((Identifiable)invoice);
            res.add(Result.SEVERITY.ERROR, 6, Messages.Validator_NoEAN2, (Object)invoice, true);
        }
        if (StringTool.isNothing((Object)(bez = costBearer.getDescription1()))) {
            invoice.reject(InvoiceState.REJECTCODE.NO_GUARANTOR, Messages.Validator_NoName);
            CoreModelServiceHolder.get().save((Identifiable)invoice);
            res.add(Result.SEVERITY.ERROR, 7, Messages.Validator_NoName, (Object)invoice, true);
        }
        return res;
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        public List<Exception> exceptions = new ArrayList<Exception>();

        private MyErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.exceptions.add(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.exceptions.add(exception);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }

        public void exception(Exception exception) {
        }

        public List<String> getMessageList() {
            ArrayList<String> messageList = new ArrayList<String>();
            for (Exception ex : this.exceptions) {
                String msg = ex.getMessage();
                if (msg == null || msg.length() == 0) {
                    msg = ex.toString();
                }
                messageList.add(msg);
            }
            return messageList;
        }
    }
}

