/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.TarmedRechnung;

import ch.elexis.TarmedRechnung.Messages;
import ch.elexis.TarmedRechnung.XMLExporter;
import ch.elexis.TarmedRechnung.XMLExporterUtil;
import ch.elexis.base.ch.arzttarife.physio.IPhysioLeistung;
import ch.elexis.base.ch.arzttarife.rfe.IReasonForEncounter;
import ch.elexis.base.ch.arzttarife.tarmed.ITarmedLeistung;
import ch.elexis.base.ch.arzttarife.util.ArzttarifeUtil;
import ch.elexis.base.ch.labortarif.ILaborLeistung;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IBillingSystem;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.ICustomService;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.ch.BillingLaw;
import ch.elexis.core.types.ArticleSubTyp;
import ch.elexis.core.types.ArticleTyp;
import ch.elexis.tarmedprefs.TarmedRequirements;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Money;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.XMLTool;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLExporterServices {
    private static Logger logger = LoggerFactory.getLogger(XMLExporterServices.class);
    public static final String ELEMENT_SERVICES = "services";
    public static final String ELEMENT_DETAIL = "detail";
    private static final String ATTR_RECORD_ID = "record_id";
    private static final String ELEMENT_RECORD_OTHER = "record_other";
    private static final String ELEMENT_RECORD_PARAMED = "record_paramed";
    private static final String ELEMENT_RECORD_MIGEL = "record_migel";
    private static final String ELEMENT_RECORD_DRUG = "record_drug";
    private static final String ATTR_UNIT_FACTOR = "unit_factor";
    private static final String ATTR_UNIT = "unit";
    private static final String ELEMENT_RECORD_LAB = "record_lab";
    private static final String ATTR_OBLIGATION = "obligation";
    private static final String ATTR_VALIDATE = "validate";
    private static final String ATTR_EXTERNAL_FACTOR_TT = "external_factor_tt";
    private static final String ATTR_SCALE_FACTOR_TT = "scale_factor_tt";
    private static final String ATTR_UNIT_FACTOR_TT = "unit_factor_tt";
    private static final String ATTR_UNIT_TT = "unit_tt";
    private static final String ATTR_EXTERNAL_FACTOR_MT = "external_factor_mt";
    private static final String ATTR_SCALE_FACTOR_MT = "scale_factor_mt";
    private static final String ATTR_UNIT_FACTOR_MT = "unit_factor_mt";
    private static final String ATTR_UNIT_MT = "unit_mt";
    private static final String ATTR_BODY_LOCATION = "body_location";
    private static final String ATTR_MEDICAL_ROLE = "medical_role";
    private static final String ATTR_BILLING_ROLE = "billing_role";
    private static final String ATTR_EAN_RESPONSIBLE = "responsible_id";
    private static final String ATTR_EAN_PROVIDER = "provider_id";
    private static final String ATTR_TREATMENT = "treatment";
    private static final String ATTR_DATE_BEGIN = "date_begin";
    private static final String ATTR_SESSION = "session";
    private static final String ELEMENT_RECORD_TARMED = "record_tarmed";
    private static final String TARMED_FALSE = "false";
    private static final String TARMED_TRUE = "true";
    private Element servicesElement;
    private double sumTarmedAL = 0.0;
    private double sumTarmedTL = 0.0;
    private double tpTarmedTL = 0.0;
    private double tpTarmedAL = 0.0;
    private Money mTarmed;
    private Money mKant;
    private Money mUebrige;
    private Money mAnalysen;
    private Money mMigel;
    private Money mPhysio;
    private Money mMedikament;
    private Money mObligations;
    boolean initialized = false;

    public XMLExporterServices(Element services) {
        this.servicesElement = services;
        this.mTarmed = new Money();
        this.mKant = new Money();
        this.mUebrige = new Money();
        this.mAnalysen = new Money();
        this.mMigel = new Money();
        this.mPhysio = new Money();
        this.mMedikament = new Money();
        this.mObligations = new Money();
    }

    public Element getElement() {
        return this.servicesElement;
    }

    public double getSumTarmedAL() {
        if (!this.initialized) {
            this.initFromElement();
        }
        return this.sumTarmedAL;
    }

    public double getSumTarmedTL() {
        if (!this.initialized) {
            this.initFromElement();
        }
        return this.sumTarmedTL;
    }

    public double getTpTarmedAL() {
        if (!this.initialized) {
            this.initFromElement();
        }
        return this.tpTarmedAL;
    }

    public double getTpTarmedTL() {
        if (!this.initialized) {
            this.initFromElement();
        }
        return this.tpTarmedTL;
    }

    public Money getTarmedMoney() {
        if (!this.initialized) {
            this.initFromElement();
        }
        return this.mTarmed;
    }

    public Money getKantMoney() {
        if (!this.initialized) {
            this.initFromElement();
        }
        return this.mKant;
    }

    public Money getUebrigeMoney() {
        if (!this.initialized) {
            this.initFromElement();
        }
        return this.mUebrige;
    }

    public Money getAnalysenMoney() {
        if (!this.initialized) {
            this.initFromElement();
        }
        return this.mAnalysen;
    }

    public Money getMigelMoney() {
        if (!this.initialized) {
            this.initFromElement();
        }
        return this.mMigel;
    }

    public Money getPhysioMoney() {
        if (!this.initialized) {
            this.initFromElement();
        }
        return this.mPhysio;
    }

    public Money getMedikamentMoney() {
        if (!this.initialized) {
            this.initFromElement();
        }
        return this.mMedikament;
    }

    public Money getObligationsMoney() {
        if (!this.initialized) {
            this.initFromElement();
        }
        return this.mObligations;
    }

    public void negateAll() {
        List sr = this.servicesElement.getChildren();
        for (Element el : sr) {
            try {
                XMLExporterUtil.negate(el, "quantity");
                XMLExporterUtil.negate(el, "amount_mt");
                XMLExporterUtil.negate(el, "amount_tt");
                XMLExporterUtil.negate(el, "amount");
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
            }
        }
    }

    private void initFromElement() {
        List records = this.servicesElement.getChildren();
        for (Object object : records) {
            if (!(object instanceof Element)) continue;
            Element element = (Element)object;
            try {
                if (element.getName().equals(ELEMENT_RECORD_TARMED)) {
                    this.mTarmed.addAmount(element.getAttributeValue("amount"));
                } else if (element.getName().equals(ELEMENT_RECORD_LAB)) {
                    this.mAnalysen.addAmount(element.getAttributeValue("amount"));
                } else if (element.getName().equals(ELEMENT_RECORD_DRUG)) {
                    this.mMedikament.addAmount(element.getAttributeValue("amount"));
                } else if (element.getName().equals(ELEMENT_RECORD_MIGEL)) {
                    this.mMigel.addAmount(element.getAttributeValue("amount"));
                } else if (element.getName().equals(ELEMENT_RECORD_PARAMED)) {
                    this.mPhysio.addAmount(element.getAttributeValue("amount"));
                } else if (element.getName().equals(ELEMENT_RECORD_OTHER)) {
                    this.mUebrige.addAmount(element.getAttributeValue("amount"));
                }
                String obligation = element.getAttributeValue(ATTR_OBLIGATION);
                if (obligation == null || !TARMED_TRUE.equals(obligation)) continue;
                this.mObligations.addAmount(obligation);
            }
            catch (ParseException e) {
                logger.error("Error parsing services " + e);
            }
        }
        this.initialized = true;
    }

    public static XMLExporterServices buildServices(IInvoice invoice, XMLExporter.VatRateSum vatSummer) {
        XMLExporterServices ret = new XMLExporterServices(new Element(ELEMENT_SERVICES, XMLExporter.nsinvoice));
        if (invoice != null) {
            List encounters = invoice.getEncounters();
            int recordNumber = 1;
            LocalDate lastEncounterDate = null;
            int session = 1;
            for (IEncounter encounter : encounters) {
                List encounterBilled = encounter.getBilled();
                LocalDate encounterDate = encounter.getDate();
                if (encounterDate.equals(lastEncounterDate)) {
                    ++session;
                } else {
                    lastEncounterDate = encounterDate;
                    session = 1;
                }
                String dateForTarmed = XMLExporterUtil.makeTarmedDatum(encounterDate);
                ICoverage coverage = encounter.getCoverage();
                IBillingSystem billingSystem = coverage.getBillingSystem();
                BillingLaw law = billingSystem.getLaw();
                boolean bRFE = false;
                for (IBilled billed : encounterBilled) {
                    Element el;
                    double amount = billed.getAmount();
                    IBillable billable = billed.getBillable();
                    if (billable == null) {
                        logger.error(String.valueOf(Messages.XMLExporter_ErroneusBill) + invoice.getNumber() + " Null-Verrechenbar bei Kons " + encounter.getLabel());
                        continue;
                    }
                    if (billable instanceof ITarmedLeistung) {
                        ITarmedLeistung tl = (ITarmedLeistung)billable;
                        double primaryScale = billed.getPrimaryScaleFactor();
                        double secondaryScale = 1.0;
                        if (!billed.isNonIntegerAmount()) {
                            secondaryScale = billed.getSecondaryScaleFactor();
                        }
                        double mult = billed.getFactor();
                        double tlAL = ArzttarifeUtil.getAL((IBilled)billed);
                        double tlTL = ArzttarifeUtil.getTL((IBilled)billed);
                        Money mAL = ArzttarifeUtil.getALMoney((IBilled)billed);
                        Money mTL = ArzttarifeUtil.getTLMoney((IBilled)billed);
                        Money mAmountLocal = billed.getTotal();
                        ret.tpTarmedTL += tlTL * amount;
                        ret.tpTarmedAL += tlAL * amount;
                        ret.sumTarmedAL += mAL.doubleValue();
                        ret.sumTarmedTL += mTL.doubleValue();
                        ret.mTarmed.addCent(mAmountLocal.getCents());
                        el = new Element(ELEMENT_RECORD_TARMED, XMLExporter.nsinvoice);
                        el.setAttribute(ATTR_TREATMENT, "ambulatory");
                        el.setAttribute("tariff_type", "001");
                        String bezug = (String)tl.getExtension().getExtInfo((Object)"Bezug");
                        if (StringTool.isNothing((Object)bezug)) {
                            bezug = (String)billed.getExtInfo((Object)"Bezug");
                        }
                        if (!StringTool.isNothing((Object)bezug)) {
                            el.setAttribute("ref_code", bezug);
                        }
                        el.setAttribute(ATTR_EAN_PROVIDER, TarmedRequirements.getEAN((IContact)encounter.getMandator()));
                        el.setAttribute(ATTR_EAN_RESPONSIBLE, XMLExporterUtil.getResponsibleEAN(encounter));
                        el.setAttribute(ATTR_BILLING_ROLE, "both");
                        el.setAttribute(ATTR_MEDICAL_ROLE, "self_employed");
                        el.setAttribute(ATTR_BODY_LOCATION, ArzttarifeUtil.getSide((IBilled)billed));
                        el.setAttribute(ATTR_UNIT_MT, XMLTool.doubleToXmlDouble((double)(tlAL / 100.0), (int)2));
                        XMLExporterUtil.getALNotScaled(billed).ifPresent(d -> el.setAttribute(ATTR_UNIT_MT, XMLTool.doubleToXmlDouble((double)(d / 100.0), (int)2)));
                        el.setAttribute(ATTR_UNIT_FACTOR_MT, XMLTool.doubleToXmlDouble((double)mult, (int)2));
                        el.setAttribute(ATTR_SCALE_FACTOR_MT, XMLTool.doubleToXmlDouble((double)primaryScale, (int)1));
                        XMLExporterUtil.getALScalingFactor(billed).ifPresent(f -> {
                            f = f * primaryScale;
                            el.setAttribute(ATTR_SCALE_FACTOR_MT, XMLTool.doubleToXmlDouble((double)f, (int)1));
                        });
                        el.setAttribute(ATTR_EXTERNAL_FACTOR_MT, XMLTool.doubleToXmlDouble((double)secondaryScale, (int)1));
                        el.setAttribute("amount_mt", XMLTool.moneyToXmlDouble((Money)mAL));
                        el.setAttribute(ATTR_UNIT_TT, XMLTool.doubleToXmlDouble((double)(tlTL / 100.0), (int)2));
                        el.setAttribute(ATTR_UNIT_FACTOR_TT, XMLTool.doubleToXmlDouble((double)mult, (int)2));
                        el.setAttribute(ATTR_SCALE_FACTOR_TT, XMLTool.doubleToXmlDouble((double)primaryScale, (int)1));
                        el.setAttribute(ATTR_EXTERNAL_FACTOR_TT, XMLTool.doubleToXmlDouble((double)secondaryScale, (int)1));
                        el.setAttribute("amount_tt", XMLTool.moneyToXmlDouble((Money)mTL));
                        el.setAttribute("amount", XMLTool.moneyToXmlDouble((Money)mAmountLocal));
                        XMLExporterUtil.setVatAttribute(billed, mAmountLocal, el, vatSummer);
                        el.setAttribute(ATTR_VALIDATE, TARMED_TRUE);
                        if (ArzttarifeUtil.isObligation((IBilled)billed)) {
                            el.setAttribute(ATTR_OBLIGATION, TARMED_TRUE);
                            ret.mObligations.addMoney(mAmountLocal);
                        } else {
                            el.setAttribute(ATTR_OBLIGATION, TARMED_FALSE);
                        }
                        if (!bRFE) {
                            List<IReasonForEncounter> rfes = XMLExporterUtil.getReasonsForEncounter(encounter);
                            if (rfes.size() > 0) {
                                StringBuilder sb = new StringBuilder();
                                for (IReasonForEncounter rfe : rfes) {
                                    sb.append("551_").append(rfe.getCode()).append(" ");
                                }
                                el.setAttribute("remark", sb.toString());
                            }
                            bRFE = true;
                        }
                    } else if (billable instanceof ILaborLeistung) {
                        el = new Element(ELEMENT_RECORD_LAB, XMLExporter.nsinvoice);
                        el.setAttribute("tariff_type", billable.getCodeSystemCode());
                        el.setAttribute(ATTR_EAN_PROVIDER, TarmedRequirements.getEAN((IContact)encounter.getMandator()));
                        el.setAttribute(ATTR_EAN_RESPONSIBLE, XMLExporterUtil.getResponsibleEAN(encounter));
                        double mult = billed.getFactor();
                        preis = billed.getScaledPrice();
                        double korr = (double)preis.getCents() / mult;
                        el.setAttribute(ATTR_UNIT, XMLTool.doubleToXmlDouble((double)(korr / 100.0), (int)2));
                        el.setAttribute(ATTR_UNIT_FACTOR, XMLTool.doubleToXmlDouble((double)mult, (int)2));
                        Money mAmountLocal = billed.getTotal();
                        el.setAttribute("amount", XMLTool.moneyToXmlDouble((Money)mAmountLocal));
                        XMLExporterUtil.setVatAttribute(billed, mAmountLocal, el, vatSummer);
                        el.setAttribute(ATTR_OBLIGATION, TARMED_TRUE);
                        ret.mObligations.addMoney(mAmountLocal);
                        el.setAttribute(ATTR_VALIDATE, TARMED_TRUE);
                        ret.mAnalysen.addMoney(mAmountLocal);
                    } else if ("Medikamente".equals(billable.getCodeSystemName()) || "Medicals".equals(billable.getCodeSystemName()) || "400".equals(billable.getCodeSystemCode()) || "402".equals(billable.getCodeSystemCode())) {
                        el = new Element(ELEMENT_RECORD_DRUG, XMLExporter.nsinvoice);
                        IArticle art = (IArticle)billable;
                        double mult = billed.getFactor();
                        el.setAttribute(ATTR_UNIT, XMLTool.moneyToXmlDouble((Money)billed.getPrice()));
                        el.setAttribute(ATTR_UNIT_FACTOR, XMLTool.doubleToXmlDouble((double)mult, (int)2));
                        if (TARMED_TRUE.equals((String)billed.getExtInfo((Object)"indicated"))) {
                            el.setAttribute("name", String.valueOf(billed.getText()) + " (medizinisch indiziert: 207)");
                        }
                        el.setAttribute("tariff_type", billable.getCodeSystemCode());
                        if ("402".equals(billable.getCodeSystemCode())) {
                            String gtin = ((IArticle)billable).getGtin();
                            el.setAttribute("code", gtin);
                        } else if ("400".equals(billable.getCodeSystemCode())) {
                            String pk = XMLExporterServices.getPharmaCode((IArticle)billable);
                            el.setAttribute("code", StringTool.pad((int)1, (char)'0', (String)pk, (int)7));
                        } else {
                            logger.warn("Unknown medical code " + billable.getCodeSystemCode() + " encountered for " + billable.getCodeSystemName() + "@" + billable);
                        }
                        el.setAttribute("amount", XMLTool.moneyToXmlDouble((Money)billed.getTotal()));
                        XMLExporterUtil.setVatAttribute(billed, billed.getTotal(), el, vatSummer);
                        if (art.isObligation()) {
                            el.setAttribute(ATTR_OBLIGATION, TARMED_TRUE);
                            ret.mObligations.addMoney(billed.getTotal());
                        } else {
                            el.setAttribute(ATTR_OBLIGATION, TARMED_FALSE);
                        }
                        el.setAttribute(ATTR_VALIDATE, TARMED_TRUE);
                        el.setAttribute(ATTR_EAN_PROVIDER, TarmedRequirements.getEAN((IContact)encounter.getMandator()));
                        el.setAttribute(ATTR_EAN_RESPONSIBLE, XMLExporterUtil.getResponsibleEAN(encounter));
                        ret.mMedikament.addMoney(billed.getTotal());
                    } else if ("MiGeL".equals(billable.getCodeSystemName())) {
                        el = new Element(ELEMENT_RECORD_MIGEL, XMLExporter.nsinvoice);
                        Money preis = billed.getScaledPrice();
                        el.setAttribute(ATTR_UNIT, XMLTool.moneyToXmlDouble((Money)preis));
                        el.setAttribute(ATTR_UNIT_FACTOR, "1.0");
                        el.setAttribute("tariff_type", "452");
                        el.setAttribute("code", billable.getCode());
                        el.setAttribute(ATTR_EAN_PROVIDER, TarmedRequirements.getEAN((IContact)encounter.getMandator()));
                        el.setAttribute(ATTR_EAN_RESPONSIBLE, XMLExporterUtil.getResponsibleEAN(encounter));
                        Money mAmountLocal = new Money(preis);
                        mAmountLocal.multiply(amount);
                        el.setAttribute("amount", XMLTool.moneyToXmlDouble((Money)mAmountLocal));
                        XMLExporterUtil.setVatAttribute(billed, mAmountLocal, el, vatSummer);
                        el.setAttribute(ATTR_OBLIGATION, TARMED_TRUE);
                        ret.mObligations.addMoney(mAmountLocal);
                        el.setAttribute(ATTR_VALIDATE, TARMED_TRUE);
                        ret.mMigel.addMoney(mAmountLocal);
                    } else if (billable instanceof IPhysioLeistung) {
                        el = new Element(ELEMENT_RECORD_PARAMED, XMLExporter.nsinvoice);
                        el.setAttribute("tariff_type", billable.getCodeSystemCode());
                        if (law == BillingLaw.KVG) {
                            el.setAttribute("tariff_type", "312");
                        }
                        double mult = billed.getFactor();
                        preis = billed.getScaledPrice();
                        double korr = (double)preis.getCents() / mult;
                        el.setAttribute(ATTR_UNIT, XMLTool.doubleToXmlDouble((double)(korr / 100.0), (int)2));
                        el.setAttribute(ATTR_UNIT_FACTOR, XMLTool.doubleToXmlDouble((double)mult, (int)2));
                        Money mAmountLocal = new Money(preis);
                        mAmountLocal.multiply(amount);
                        el.setAttribute("amount", XMLTool.moneyToXmlDouble((Money)mAmountLocal));
                        XMLExporterUtil.setVatAttribute(billed, mAmountLocal, el, vatSummer);
                        el.setAttribute(ATTR_OBLIGATION, TARMED_TRUE);
                        ret.mObligations.addMoney(mAmountLocal);
                        el.setAttribute(ATTR_VALIDATE, TARMED_TRUE);
                        String ean = TarmedRequirements.getEAN((IContact)encounter.getMandator());
                        if (ean.equals("2000000000000")) {
                            ean = "unknown";
                        }
                        el.setAttribute(ATTR_EAN_PROVIDER, ean);
                        ean = XMLExporterUtil.getResponsibleEAN(encounter);
                        if (ean.equals("2000000000000")) {
                            ean = "unknown";
                        }
                        el.setAttribute(ATTR_EAN_RESPONSIBLE, ean);
                        ret.mPhysio.addMoney(mAmountLocal);
                    } else {
                        el = new Element(ELEMENT_RECORD_OTHER, XMLExporter.nsinvoice);
                        String codeSystemCode = billable.getCodeSystemCode();
                        el.setAttribute("tariff_type", codeSystemCode);
                        if ("406".equals(codeSystemCode) && !XMLExporterServices.isCovid(billable)) {
                            el.setAttribute("code", "2000");
                            el.setAttribute("name", String.valueOf(billed.getText()) + " [" + XMLExporterServices.getServiceCode(billed) + "]");
                        }
                        if ("590".equals(codeSystemCode) && billable instanceof IArticle) {
                            el.setAttribute("code", "1310");
                        }
                        el.setAttribute(ATTR_UNIT, XMLTool.moneyToXmlDouble((Money)billed.getPrice()));
                        el.setAttribute(ATTR_UNIT_FACTOR, "1.0");
                        el.setAttribute("amount", XMLTool.moneyToXmlDouble((Money)billed.getTotal()));
                        XMLExporterUtil.setVatAttribute(billed, billed.getTotal(), el, vatSummer);
                        el.setAttribute(ATTR_VALIDATE, TARMED_TRUE);
                        if ("351".equals(codeSystemCode) || "510".equals(codeSystemCode)) {
                            el.setAttribute(ATTR_OBLIGATION, TARMED_TRUE);
                        } else {
                            el.setAttribute(ATTR_OBLIGATION, TARMED_FALSE);
                        }
                        el.setAttribute("external_factor", "1.0");
                        el.setAttribute(ATTR_EAN_PROVIDER, TarmedRequirements.getEAN((IContact)encounter.getMandator()));
                        el.setAttribute(ATTR_EAN_RESPONSIBLE, XMLExporterUtil.getResponsibleEAN(encounter));
                        ret.mUebrige.addMoney(billed.getTotal());
                    }
                    el.setAttribute(ATTR_SESSION, Integer.toString(session));
                    el.setAttribute(ATTR_RECORD_ID, Integer.toString(recordNumber++));
                    el.setAttribute("quantity", Double.toString(amount));
                    el.setAttribute(ATTR_DATE_BEGIN, dateForTarmed);
                    if (el.getAttribute("name") == null) {
                        el.setAttribute("name", billed.getText());
                    }
                    if (el.getAttribute("code") == null) {
                        XMLExporterUtil.setAttributeWithDefault(el, "code", XMLExporterServices.getServiceCode(billed), "0");
                    }
                    ret.servicesElement.addContent((Content)el);
                }
            }
        }
        ret.initialized = true;
        return ret;
    }

    private static String getPharmaCode(IArticle iArticle) {
        String ret = "";
        String systemName = iArticle.getCodeSystemName();
        if (systemName != null && systemName.equals("Artikelstamm")) {
            try {
                ret = BeanUtils.getProperty((Object)iArticle, (String)"PHAR");
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                logger.warn("Could not get pharma code from [" + iArticle + "]", (Throwable)e);
            }
        } else {
            try {
                ret = BeanUtils.getProperty((Object)iArticle, (String)"pharmaCode");
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                logger.warn("Could not get pharma code from [" + iArticle + "]", (Throwable)e);
            }
        }
        return ret;
    }

    private static String getServiceCode(IBilled verrechnet) {
        String ret = verrechnet.getCode();
        IBillable billable = verrechnet.getBillable();
        if ((billable instanceof ICustomService || billable instanceof IArticle && ((IArticle)billable).getTyp() == ArticleTyp.EIGENARTIKEL) && billable.getId().equals(ret)) {
            ret = "";
        }
        return ret;
    }

    private static boolean isCovid(IBillable billable) {
        if (billable instanceof IArticle) {
            return ((IArticle)billable).getTyp() == ArticleTyp.EIGENARTIKEL && ((IArticle)billable).getSubTyp() == ArticleSubTyp.COVID;
        }
        return false;
    }
}

