/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.TarmedRechnung;

import at.medevit.elexis.tarmed.model.TarmedJaxbUtil;
import ch.elexis.TarmedRechnung.Messages;
import ch.elexis.TarmedRechnung.TarmedACL;
import ch.elexis.TarmedRechnung.XMLExporterBalance;
import ch.elexis.TarmedRechnung.XMLExporterProcessing;
import ch.elexis.TarmedRechnung.XMLExporterServices;
import ch.elexis.TarmedRechnung.XMLExporterUtil;
import ch.elexis.TarmedRechnung.XMLFileUtil;
import ch.elexis.base.ch.arzttarife.importer.TrustCenters;
import ch.elexis.base.ch.arzttarife.xml.exporter.Tarmed45Exporter;
import ch.elexis.base.ch.arzttarife.xml.exporter.Tarmed45Validator;
import ch.elexis.base.ch.arzttarife.xml.exporter.Tarmed50Exporter;
import ch.elexis.base.ch.arzttarife.xml.exporter.Tarmed50Validator;
import ch.elexis.base.ch.arzttarife.xml.update.XmlVersionUpdate44to45;
import ch.elexis.base.ch.ebanking.esr.ESR;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.IRnOutputter;
import ch.elexis.core.model.IBlob;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.services.LocalConfigService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.CoverageServiceHolder;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.rechnung.RnOutputDialog;
import ch.elexis.core.utils.CoreUtil;
import ch.elexis.core.utils.PlatformHelper;
import ch.elexis.data.Fall;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Rechnung;
import ch.elexis.tarmedprefs.TarmedRequirements;
import ch.fd.invoice500.request.RequestType;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Money;
import ch.rgw.tools.Result;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.XMLTool;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Properties;
import javax.xml.transform.Source;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.transform.JDOMSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLExporter
implements IRnOutputter {
    private static Logger logger = LoggerFactory.getLogger(XMLExporter.class);
    public static final String VAT_ISMANDANTVAT = "at.medevit.medelexis.vat_ch/IsMandantVat";
    public static final String VAT_MANDANTVATNUMBER = "at.medevit.medelexis.vat_ch/MandantVatNumber";
    public static final String ATTR_REMARK = "remark";
    public static final String ELEMENT_TIERS_PAYANT = "tiers_payant";
    public static final String ELEMENT_TIERS_GARANT = "tiers_garant";
    public static final String ATTR_CODE = "code";
    public static final String BIRTHDEFECT = "birthdefect";
    public static final String DISEASE = "disease";
    public static final String FREETEXT = "freetext";
    public static final String ATTR_BIRTHDATE = "birthdate";
    public static final String ELEMENT_VAT = "vat";
    public static final String ELEMENT_VAT_NUMBER = "vat_number";
    public static final String ATTR_VAT_RATE = "vat_rate";
    public static final String ATTR_TARIFF_TYPE = "tariff_type";
    public static final String ELEMENT_REMARK = "remark";
    private static final String ELEMENT_PAYLOAD = "payload";
    private static final String ATTR_PAYLOAD_TYPE = "type";
    private static final String ATTR_PAYLOAD_COPY = "copy";
    private static final String ATTR_PAYLOAD_STORNO = "storno";
    public static final String ATTR_EAN_PARTY = "ean_party";
    private static final String ATTR_MODUS = "modus";
    private static final String ATTR_LANGUAGE = "language";
    private static final String ELEMENT_REQUEST = "request";
    private static final String ATTR_REQUEST_TIMESTAMP = "request_timestamp";
    public static final String ATTR_REQUEST_DATE = "request_date";
    public static final String ATTR_REQUEST_ID = "request_id";
    public static final String TIERS_GARANT = "TG";
    public static final String TIERS_PAYANT = "TP";
    public static final String ATTR_AMOUNT_PHYSIO = "amount_physio";
    public static final String ATTR_AMOUNT_MIGEL = "amount_migel";
    public static final String ATTR_AMOUNT_LAB = "amount_lab";
    public static final String ATTR_AMOUNT_DRUG = "amount_drug";
    public static final String ATTR_AMOUNT_UNCLASSIFIED = "amount_unclassified";
    public static final String ATTR_AMOUNT_CANTONAL = "amount_cantonal";
    public static final String ATTR_AMOUNT_TARMED_TT = "amount_tarmed.tt";
    public static final String ATTR_AMOUNT_TARMED_MT = "amount_tarmed.mt";
    public static final String ATTR_AMOUNT_TARMED = "amount_tarmed";
    public static final String ATTR_AMOUNT = "amount";
    public static final String ATTR_AMOUNT_REMINDER = "amount_reminder";
    public static final String ATTR_AMOUNT_TT = "amount_tt";
    public static final String ATTR_AMOUNT_MT = "amount_mt";
    public static final String ATTR_QUANTITY = "quantity";
    public static final String ATTR_AMOUNT_DUE = "amount_due";
    public static final String ATTR_AMOUNT_PREPAID = "amount_prepaid";
    public static final String ELEMENT_BALANCE = "balance";
    public static final String ELEMENT_INVOICE = "invoice";
    public static final String ELEMENT_BODY = "body";
    public static final String ATTR_BODY_ROLE = "role";
    public static final String ATTR_BODY_PLACE = "place";
    public static final String ELEMENT_ANNULMENT = "annulment";
    public static final String FIELDNAME_TIMESTAMPXML = "TimeStampXML";
    public static final String ELEMENT_REMINDER = "reminder";
    public static final String ATTR_REMINDER_LEVEL = "reminder_level";
    public static final Namespace ns = Namespace.getNamespace((String)"http://www.forum-datenaustausch.ch/invoice");
    public static final Namespace nsinvoice = Namespace.getNamespace((String)"invoice", (String)"http://www.forum-datenaustausch.ch/invoice");
    public static final Namespace nsxsi = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    public static final Namespace nsxenc = Namespace.getNamespace((String)"nsxenc", (String)"http://www.w3.org/2001/04/xmlenc#");
    public static final Namespace nsds = Namespace.getNamespace((String)"ds", (String)"http://www.w3.org/2000/09/xmldsig#");
    String tiers;
    IInvoice invoice;
    private ESR besr;
    static TarmedACL ta;
    private String outputDir;
    private boolean printAtIntermediate = true;
    public static final String PREFIX = "TarmedRn:";
    private Tarmed45Exporter exporter;
    private Tarmed45Validator validator;
    private Tarmed50Exporter exporter50;
    private Tarmed50Validator validator50;
    private Tarmed45Exporter.EsrType esrType;

    public XMLExporter() {
        ta = TarmedACL.getInstance();
        this.exporter = new Tarmed45Exporter();
        this.validator = new Tarmed45Validator();
        this.exporter50 = new Tarmed50Exporter();
        this.validator50 = new Tarmed50Validator();
    }

    public Result<Rechnung> doOutput(final IRnOutputter.TYPE type, final Collection<Rechnung> rnn, Properties props) {
        SWTHelper.SimpleDialog dlg;
        final Result ret = new Result();
        if (this.outputDir == null && (dlg = new SWTHelper.SimpleDialog(new SWTHelper.IControlProvider(){

            public Control getControl(Composite parent) {
                return XMLExporter.this.createSettingsControl(parent);
            }

            public void beforeClosing() {
            }
        })).open() != 0) {
            return ret;
        }
        ProgressMonitorDialog progress = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
        try {
            progress.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.RechnungsDrucker_PrintingBills, rnn.size());
                    XMLExporter.this.exporter.setUpdateElectronicDelivery(true);
                    for (Rechnung rn : rnn) {
                        if (XMLExporter.this.doExport(rn, String.valueOf(XMLExporter.this.outputDir) + File.separator + rn.getNr() + ".xml", type, false) == null) {
                            ret.add(Result.SEVERITY.ERROR, 1, String.valueOf(Messages.XMLExporter_ErrorInBill) + rn.getNr(), (Object)rn, true);
                        }
                        monitor.worked(1);
                        if (monitor.isCanceled()) break;
                    }
                    XMLExporter.this.exporter.setUpdateElectronicDelivery(false);
                    monitor.done();
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            LoggerFactory.getLogger(XMLExporter.class).error("Error outputting bills", (Throwable)e);
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.RechnungsDrucker_MessageErrorWhilePrinting, (String)(String.valueOf(Messages.RechnungsDrucker_MessageErrorWhilePrinting) + "[" + e.getMessage() + "]"));
        }
        return ret;
    }

    public boolean canStorno(Rechnung rn) {
        return true;
    }

    public boolean isPrintAtIntermediate() {
        return this.printAtIntermediate;
    }

    public void setPrintAtIntermediate(boolean value) {
        this.printAtIntermediate = value;
    }

    private void negate(Element el, String attr) {
        String v = el.getAttributeValue(attr);
        if (!StringTool.isNothing((Object)v) && !v.equals("0.00")) {
            v = v.startsWith("-") ? v.substring(1) : "-" + v;
            el.setAttribute(attr, v);
        }
    }

    protected Document doExport450(Rechnung rechnung, String dest, IRnOutputter.TYPE type, boolean doVerify) {
        this.invoice = (IInvoice)CoreModelServiceHolder.get().load(rechnung.getId(), IInvoice.class).orElseThrow(() -> new IllegalStateException("Could not load invoice [" + rechnung.getId() + "]"));
        return null;
    }

    public Document doExport(Rechnung rechnung, String dest, IRnOutputter.TYPE type, boolean doVerify) {
        this.invoice = (IInvoice)CoreModelServiceHolder.get().load(rechnung.getId(), IInvoice.class).orElseThrow(() -> new IllegalStateException("Could not load invoice [" + rechnung.getId() + "]"));
        this.exporter.setEsrType(this.getEsrTypeOrFallback(this.invoice));
        if (this.xmlBillExists(this.invoice)) {
            logger.info("Updating existing bill for " + this.invoice.getNumber());
            Document updated = this.updateExistingXmlBill(this.invoice, dest, type, doVerify);
            if (updated != null) {
                return updated;
            }
        }
        if (type.equals((Object)IRnOutputter.TYPE.STORNO)) {
            SWTHelper.showError((String)Messages.XMLExporter_StornoImpossibleCaption, (String)Messages.XMLExporter_StornoImpossibleText);
            return null;
        }
        logger.info("Creating new bill for " + rechnung.getNr());
        ByteArrayOutputStream xmlOutput = new ByteArrayOutputStream();
        if (this.containsTardocOrAllowance(this.invoice)) {
            if (this.exporter50.doExport(this.invoice, xmlOutput, type)) {
                Document xmlRn = this.getAsJdomDocument(xmlOutput).orElse(null);
                ch.fd.invoice450.request.RequestType invoiceRequest = TarmedJaxbUtil.unmarshalInvoiceRequest450((InputStream)new ByteArrayInputStream(xmlOutput.toByteArray()));
                if (doVerify) {
                    Result<IInvoice> result = this.validator.checkInvoice(this.invoice, invoiceRequest);
                }
                CoreModelServiceHolder.get().save((Identifiable)this.invoice);
                this.checkXML(xmlRn, dest, this.invoice, doVerify);
                if (this.invoice.getState() != InvoiceState.DEFECTIVE) {
                    try {
                        this.setExistingXml(this.invoice, xmlRn);
                        if (dest != null) {
                            this.writeFile(xmlRn, dest);
                        }
                    }
                    catch (Exception ex) {
                        ExHandler.handle((Throwable)ex);
                        SWTHelper.alert((String)Messages.XMLExporter_ErrorCaption, (String)MessageFormat.format(Messages.XMLExporter_CouldNotWriteFile, dest));
                        return null;
                    }
                }
                return xmlRn;
            }
        } else if (this.exporter.doExport(this.invoice, xmlOutput, type)) {
            Document xmlRn = this.getAsJdomDocument(xmlOutput).orElse(null);
            ch.fd.invoice450.request.RequestType invoiceRequest = TarmedJaxbUtil.unmarshalInvoiceRequest450((InputStream)new ByteArrayInputStream(xmlOutput.toByteArray()));
            if (doVerify) {
                Result<IInvoice> ex = this.validator.checkInvoice(this.invoice, invoiceRequest);
            }
            CoreModelServiceHolder.get().save((Identifiable)this.invoice);
            this.checkXML(xmlRn, dest, this.invoice, doVerify);
            if (this.invoice.getState() != InvoiceState.DEFECTIVE) {
                try {
                    this.setExistingXml(this.invoice, xmlRn);
                    if (dest != null) {
                        this.writeFile(xmlRn, dest);
                    }
                }
                catch (Exception ex) {
                    ExHandler.handle((Throwable)ex);
                    SWTHelper.alert((String)Messages.XMLExporter_ErrorCaption, (String)MessageFormat.format(Messages.XMLExporter_CouldNotWriteFile, dest));
                    return null;
                }
            }
            return xmlRn;
        }
        return null;
    }

    private boolean containsTardocOrAllowance(IInvoice invoice) {
        return invoice.getBilled().stream().filter(b -> "007".equals(b.getBillable().getCodeSystemCode()) || "005".equals(b.getBillable().getCodeSystemCode())).findAny().isPresent();
    }

    public Tarmed45Exporter.EsrType getEsrTypeOrFallback(IInvoice invoice) {
        String iban;
        if ((this.esrType == null || this.esrType == Tarmed45Exporter.EsrType.esrQR) && StringUtils.isEmpty((CharSequence)(iban = (String)invoice.getMandator().getBiller().getExtInfo((Object)"IBAN")))) {
            logger.warn("No IBAN for ESRQR with biller [" + invoice.getMandator().getBiller().getLabel() + "] fallback to ESR9 for invoice [" + invoice.getNumber() + "]");
            return Tarmed45Exporter.EsrType.esr9;
        }
        return this.esrType;
    }

    private String getInvoiceId(IInvoice invoice) {
        IPatient patient = invoice.getCoverage().getPatient();
        String pid = StringTool.pad((int)1, (char)'0', (String)patient.getPatientNr(), (int)6);
        String nr = StringTool.pad((int)1, (char)'0', (String)invoice.getNumber(), (int)6);
        return String.valueOf(pid) + nr;
    }

    private Document updateExistingXmlBill(IInvoice invoice, String dest, IRnOutputter.TYPE type, boolean doVerify) {
        Document ret;
        block41: {
            try {
                String xmlVersion;
                ret = this.getExistingXml(invoice).get();
                Element root = ret.getRootElement();
                if (XMLExporter.getXmlVersion(root).equals("4.4") && !CoreUtil.isTestMode()) {
                    XmlVersionUpdate44to45 versionUpdate = new XmlVersionUpdate44to45(invoice);
                    versionUpdate.update();
                    ret = this.getExistingXml(invoice).get();
                    root = ret.getRootElement();
                }
                if ((xmlVersion = XMLExporter.getXmlVersion(root)).equals("4.0")) {
                    this.updateExisting4Xml(root, type, invoice);
                    break block41;
                }
                if (xmlVersion.equals("4.4")) {
                    this.updateExisting44Xml(root, type, invoice);
                    InvoiceState state = invoice.getState();
                    if (state == InvoiceState.DEMAND_NOTE_1 || state == InvoiceState.DEMAND_NOTE_1_PRINTED) {
                        if (dest != null) {
                            dest = dest.toLowerCase().replaceFirst("\\.xml$", "_m1.xml");
                        }
                        this.addReminderEntry(root, invoice, "1");
                    } else if (state == InvoiceState.DEMAND_NOTE_2 || state == InvoiceState.DEMAND_NOTE_2_PRINTED) {
                        if (dest != null) {
                            dest = dest.toLowerCase().replaceFirst("\\.xml$", "_m2.xml");
                        }
                        this.addReminderEntry(root, invoice, "2");
                    } else if (state == InvoiceState.DEMAND_NOTE_3 || state == InvoiceState.DEMAND_NOTE_3_PRINTED) {
                        if (dest != null) {
                            dest = dest.toLowerCase().replaceFirst("\\.xml$", "_m3.xml");
                        }
                        this.addReminderEntry(root, invoice, "3");
                    }
                    break block41;
                }
                if (xmlVersion.equals("4.5")) {
                    Optional<?> invoiceRequest = this.getExistingXmlModel(invoice, "4.5");
                    if (invoiceRequest.isPresent()) {
                        this.exporter.updateExistingXml((ch.fd.invoice450.request.RequestType)invoiceRequest.get(), type, invoice, this);
                        InvoiceState state = invoice.getState();
                        if (state == InvoiceState.DEMAND_NOTE_1 || state == InvoiceState.DEMAND_NOTE_1_PRINTED) {
                            if (dest != null) {
                                dest = dest.toLowerCase().replaceFirst("\\.xml$", "_m1.xml");
                            }
                            this.exporter.addReminderEntry((ch.fd.invoice450.request.RequestType)invoiceRequest.get(), invoice, "1");
                        } else if (state == InvoiceState.DEMAND_NOTE_2 || state == InvoiceState.DEMAND_NOTE_2_PRINTED) {
                            if (dest != null) {
                                dest = dest.toLowerCase().replaceFirst("\\.xml$", "_m2.xml");
                            }
                            this.exporter.addReminderEntry((ch.fd.invoice450.request.RequestType)invoiceRequest.get(), invoice, "2");
                        } else if (state == InvoiceState.DEMAND_NOTE_3 || state == InvoiceState.DEMAND_NOTE_3_PRINTED) {
                            if (dest != null) {
                                dest = dest.toLowerCase().replaceFirst("\\.xml$", "_m3.xml");
                            }
                            this.exporter.addReminderEntry((ch.fd.invoice450.request.RequestType)invoiceRequest.get(), invoice, "3");
                        } else if (state.getState() < InvoiceState.DEMAND_NOTE_1.getState() && this.exporter.isReminder((ch.fd.invoice450.request.RequestType)invoiceRequest.get())) {
                            this.exporter.removeReminderEntry((ch.fd.invoice450.request.RequestType)invoiceRequest.get(), invoice);
                        }
                        ret = this.getAsJdomDocument((ch.fd.invoice450.request.RequestType)invoiceRequest.get()).orElse(null);
                    }
                    break block41;
                }
                if (xmlVersion.equals("5.0")) {
                    Optional<?> invoiceRequest = this.getExistingXmlModel(invoice, "5.0");
                    if (invoiceRequest.isPresent()) {
                        this.exporter50.updateExistingXml((RequestType)invoiceRequest.get(), type, invoice, this);
                        InvoiceState state = invoice.getState();
                        if (state == InvoiceState.DEMAND_NOTE_1 || state == InvoiceState.DEMAND_NOTE_1_PRINTED) {
                            if (dest != null) {
                                dest = dest.toLowerCase().replaceFirst("\\.xml$", "_m1.xml");
                            }
                            this.exporter50.addReminderEntry((RequestType)invoiceRequest.get(), invoice, "1");
                        } else if (state == InvoiceState.DEMAND_NOTE_2 || state == InvoiceState.DEMAND_NOTE_2_PRINTED) {
                            if (dest != null) {
                                dest = dest.toLowerCase().replaceFirst("\\.xml$", "_m2.xml");
                            }
                            this.exporter50.addReminderEntry((RequestType)invoiceRequest.get(), invoice, "2");
                        } else if (state == InvoiceState.DEMAND_NOTE_3 || state == InvoiceState.DEMAND_NOTE_3_PRINTED) {
                            if (dest != null) {
                                dest = dest.toLowerCase().replaceFirst("\\.xml$", "_m3.xml");
                            }
                            this.exporter50.addReminderEntry((RequestType)invoiceRequest.get(), invoice, "3");
                        } else if (state.getState() < InvoiceState.DEMAND_NOTE_1.getState() && this.exporter50.isReminder((RequestType)invoiceRequest.get())) {
                            this.exporter50.removeReminderEntry((RequestType)invoiceRequest.get(), invoice);
                        }
                        ret = this.getAsJdomDocument((RequestType)invoiceRequest.get()).orElse(null);
                    }
                    break block41;
                }
                logger.warn("Bill in unknown XML version " + XMLExporter.getXmlVersion(root) + ", recreating bill.");
                return null;
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
                SWTHelper.showError((String)Messages.XMLExporter_ReadErrorCaption, (String)Messages.XMLExporter_ReadErrorText);
                return null;
            }
        }
        this.checkXML(ret, dest, invoice, doVerify);
        if (dest != null) {
            if (type.equals((Object)IRnOutputter.TYPE.STORNO) && !dest.toLowerCase().endsWith("_storno.xml")) {
                this.writeFile(ret, dest.toLowerCase().replaceFirst("\\.xml$", "_storno.xml"));
            } else {
                this.writeFile(ret, dest);
            }
        }
        this.setExistingXml(invoice, ret);
        return ret;
    }

    protected Optional<?> getExistingXmlModel(IInvoice invoice, String version) {
        IBlob blob = CoreModelServiceHolder.get().load(PREFIX + invoice.getNumber(), IBlob.class).orElse(null);
        if (blob != null && blob.getStringContent() != null && !blob.getStringContent().isEmpty()) {
            if ("4.5".equals(version)) {
                ch.fd.invoice450.request.RequestType invoiceRequest = TarmedJaxbUtil.unmarshalInvoiceRequest450((InputStream)new ByteArrayInputStream(blob.getStringContent().getBytes()));
                return Optional.ofNullable(invoiceRequest);
            }
            if ("5.0".equals(version)) {
                RequestType invoiceRequest = TarmedJaxbUtil.unmarshalInvoiceRequest500((InputStream)new ByteArrayInputStream(blob.getStringContent().getBytes()));
                return Optional.ofNullable(invoiceRequest);
            }
        }
        return Optional.empty();
    }

    public Optional<Document> getAsJdomDocument(ByteArrayOutputStream outputStream) {
        if (outputStream != null) {
            SAXBuilder builder = new SAXBuilder();
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());){
                    return Optional.of(builder.build((InputStream)inputStream));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | JDOMException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error loading as jdom document", e);
            }
        }
        return Optional.empty();
    }

    public Optional<Document> getAsJdomDocument(ch.fd.invoice450.request.RequestType request) {
        if (request != null) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            TarmedJaxbUtil.marshallInvoiceRequest((ch.fd.invoice450.request.RequestType)request, (OutputStream)outputStream);
            return this.getAsJdomDocument(outputStream);
        }
        return Optional.empty();
    }

    public Optional<Document> getAsJdomDocument(RequestType request) {
        if (request != null) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            TarmedJaxbUtil.marshallInvoiceRequest((RequestType)request, (OutputStream)outputStream);
            return this.getAsJdomDocument(outputStream);
        }
        return Optional.empty();
    }

    public Optional<Document> getExistingXml(IInvoice invoice) {
        IBlob blob = CoreModelServiceHolder.get().load(PREFIX + invoice.getNumber(), IBlob.class).orElse(null);
        if (blob != null && blob.getStringContent() != null && !blob.getStringContent().isEmpty()) {
            SAXBuilder builder = new SAXBuilder();
            try {
                return Optional.of(builder.build((Reader)new StringReader(blob.getStringContent())));
            }
            catch (IOException | JDOMException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error loadgin existing xml document", e);
            }
        }
        return Optional.empty();
    }

    public void setExistingXml(IInvoice invoice, Document document) throws IOException {
        StringWriter stringWriter = new StringWriter();
        XMLOutputter xout = new XMLOutputter(Format.getCompactFormat());
        xout.output(document, (Writer)stringWriter);
        IBlob blob = CoreModelServiceHolder.get().load(PREFIX + invoice.getNumber(), IBlob.class).orElseGet(() -> {
            IBlob newBlob = (IBlob)CoreModelServiceHolder.get().create(IBlob.class);
            newBlob.setId(PREFIX + invoice.getNumber());
            return newBlob;
        });
        blob.setStringContent(stringWriter.toString());
        CoreModelServiceHolder.get().save((Identifiable)blob);
    }

    private void addReminderEntry(Element root, IInvoice invoice, String reminderLevel) {
        boolean firstReminder = false;
        Element payload = root.getChild(ELEMENT_PAYLOAD, nsinvoice);
        payload.setAttribute(ATTR_PAYLOAD_TYPE, ELEMENT_REMINDER);
        TimeTool tt = new TimeTool(new Date());
        String timestamp = Long.toString(tt.getTimeInMillis() / 1000L);
        String dateString = String.valueOf(tt.toString(6)) + "T00:00:00";
        Element reminder = payload.getChild(ELEMENT_REMINDER, nsinvoice);
        if (reminder == null) {
            reminder = new Element(ELEMENT_REMINDER, nsinvoice);
            firstReminder = true;
        }
        reminder.setAttribute(ATTR_REQUEST_TIMESTAMP, timestamp);
        reminder.setAttribute(ATTR_REQUEST_DATE, dateString);
        reminder.setAttribute(ATTR_REQUEST_ID, this.getInvoiceId(invoice));
        reminder.setAttribute(ATTR_REMINDER_LEVEL, reminderLevel);
        Element body = payload.getChild(ELEMENT_BODY, nsinvoice);
        if (body != null) {
            Element balance = body.getChild(ELEMENT_BALANCE, nsinvoice);
            Money amountReminder = invoice.getDemandAmount();
            balance.setAttribute(ATTR_AMOUNT_REMINDER, XMLTool.moneyToXmlDouble((Money)amountReminder));
            Money mDue = new Money(invoice.getTotalAmount());
            mDue.addMoney(amountReminder);
            mDue.subtractMoney(invoice.getPayedAmount());
            balance.setAttribute(ATTR_AMOUNT_DUE, XMLTool.moneyToXmlDouble((Money)mDue));
        }
        if (firstReminder) {
            List children = payload.getChildren();
            ArrayList<Element> newChildren = new ArrayList<Element>();
            int i = 0;
            while (i < children.size()) {
                newChildren.add((Element)children.get(i));
                if (((Element)children.get(i)).getName().equals(ELEMENT_INVOICE)) {
                    newChildren.add(reminder);
                }
                ++i;
            }
            payload.removeContent();
            payload.setContent(newChildren);
        }
    }

    private void updateExisting44Xml(Element root, IRnOutputter.TYPE type, IInvoice existingInvoice) {
        Element guarantorUpdate;
        IContact guarantorContact;
        Element patientUpdate;
        Money mPaid = existingInvoice.getPayedAmount();
        Element processing = root.getChild("processing", nsinvoice);
        String intermediatePrint = processing.getAttributeValue("print_at_intermediate");
        if (("1".equals(intermediatePrint) || "true".equals(intermediatePrint)) && !this.isPrintAtIntermediate()) {
            processing.setAttribute("print_at_intermediate", "0");
        } else if (("0".equals(intermediatePrint) || "false".equals(intermediatePrint)) && this.isPrintAtIntermediate()) {
            processing.setAttribute("print_at_intermediate", "1");
        }
        Element transport = processing.getChild("transport", nsinvoice);
        if (transport != null) {
            Element via = transport.getChild("via", nsinvoice);
            String iEAN = XMLExporterProcessing.getIntermediateEAN(existingInvoice, this);
            if (iEAN != null && !iEAN.isEmpty()) {
                via.setAttribute("via", iEAN);
            }
        }
        if (CoverageServiceHolder.get().getCopyForPatient(this.invoice.getCoverage())) {
            processing.setAttribute("print_patient_copy", "1");
        } else {
            processing.setAttribute("print_patient_copy", "0");
        }
        Element payload = root.getChild(ELEMENT_PAYLOAD, nsinvoice);
        Element body = payload.getChild(ELEMENT_BODY, nsinvoice);
        Element tiersGarant = body.getChild(ELEMENT_TIERS_GARANT, nsinvoice);
        if (tiersGarant != null && existingInvoice.getCoverage().getPatient() != null && (patientUpdate = this.buildPatient(existingInvoice.getCoverage())) != null) {
            List tiersChildren = tiersGarant.getChildren();
            ListIterator iterator = tiersChildren.listIterator();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (!(obj instanceof Element) || !"patient".equals(((Element)obj).getName())) continue;
                iterator.remove();
            }
            tiersChildren.add(this.getPatientIndex(tiersChildren), patientUpdate);
        }
        if (tiersGarant != null && (guarantorContact = XMLExporterUtil.getGuarantor(TIERS_GARANT, existingInvoice.getCoverage().getPatient(), existingInvoice.getCoverage())) != null && (guarantorUpdate = this.buildGuarantor(guarantorContact, (IContact)existingInvoice.getCoverage().getPatient())) != null) {
            List tiersChildren = tiersGarant.getChildren();
            ListIterator iterator = tiersChildren.listIterator();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (!(obj instanceof Element) || !"guarantor".equals(((Element)obj).getName())) continue;
                iterator.remove();
            }
            tiersChildren.add(this.getGuarantorIndex(tiersChildren), guarantorUpdate);
        }
        Element balance = body.getChild(ELEMENT_BALANCE, nsinvoice);
        XMLExporterBalance xmlBalance = new XMLExporterBalance(balance);
        this.tryToFixPrepaid(xmlBalance, mPaid);
        if (!mPaid.equals((Object)xmlBalance.getPrepaid())) {
            xmlBalance.setPrepaid(mPaid);
            Money mDue = xmlBalance.getAmount();
            mDue.addMoney(xmlBalance.getReminder());
            mDue.subtractMoney(mPaid);
            mDue.roundTo5();
            xmlBalance.setDue(mDue);
        }
        payload.setAttribute(ATTR_PAYLOAD_COPY, type.equals((Object)IRnOutputter.TYPE.COPY) ? "1" : "0");
        if (type.equals((Object)IRnOutputter.TYPE.STORNO)) {
            payload.setAttribute(ATTR_PAYLOAD_STORNO, Boolean.toString(true));
            processing.setAttribute("print_patient_copy", "0");
            Element services = body.getChild("services", nsinvoice);
            XMLExporterServices xmlServices = new XMLExporterServices(services);
            xmlServices.negateAll();
            xmlBalance.negateAmount();
            xmlBalance.negateAmountObligations();
            xmlBalance.setDue(new Money());
            xmlBalance.setPrepaid(new Money());
        }
    }

    private int getGuarantorIndex(List<Element> tiersChildren) {
        int index = 0;
        for (Element object : tiersChildren) {
            String name;
            if (!(object instanceof Element) || !"biller".equals(name = object.getName()) && !"provider".equals(name) && !"insurance".equals(name) && !"patient".equals(name) && !"insured".equals(name)) continue;
            ++index;
        }
        return index;
    }

    private int getPatientIndex(List<Element> tiersChildren) {
        int index = 0;
        for (Element object : tiersChildren) {
            String name;
            if (!(object instanceof Element) || !"biller".equals(name = object.getName()) && !"provider".equals(name) && !"insurance".equals(name)) continue;
            ++index;
        }
        return index;
    }

    private void tryToFixPrepaid(XMLExporterBalance xmlBalance, Money mPaid) {
        if (!xmlBalance.hasPrepaid()) {
            xmlBalance.setPrepaid(mPaid);
        }
        Money xmlAmount = xmlBalance.getAmount();
        Money xmlDue = xmlBalance.getDue();
        Money xmlPrepaid = xmlBalance.getPrepaid();
        Money xmlReminder = xmlBalance.getReminder();
        double diffDouble = xmlAmount.doubleValue() + xmlReminder.doubleValue() - (xmlPrepaid.doubleValue() + xmlDue.doubleValue());
        if (Math.abs(diffDouble) > 1.0) {
            xmlBalance.setDue(new Money(xmlAmount.doubleValue() + xmlReminder.doubleValue() - xmlPrepaid.doubleValue()).roundTo5());
        }
    }

    private void updateExisting4Xml(Element root, IRnOutputter.TYPE type, IInvoice existingInvoice) {
        Namespace namespace = Namespace.getNamespace((String)"http://www.xmlData.ch/xmlInvoice/XSD");
        Money mPaid = existingInvoice.getPayedAmount();
        Element invoice = root.getChild(ELEMENT_INVOICE, namespace);
        this.fixCanton(invoice, namespace);
        Element balance = invoice.getChild(ELEMENT_BALANCE, namespace);
        Money anzInBill = XMLTool.xmlDoubleToMoney((String)balance.getAttributeValue(ATTR_AMOUNT_PREPAID));
        if (!mPaid.equals((Object)anzInBill)) {
            Money mAmount = XMLTool.xmlDoubleToMoney((String)balance.getAttributeValue(ATTR_AMOUNT));
            if (mPaid.isMoreThan(mAmount)) {
                mPaid = mAmount;
            }
            balance.setAttribute(ATTR_AMOUNT_PREPAID, XMLTool.moneyToXmlDouble((Money)mPaid));
            Money mDue = new Money(mAmount).subtractMoney(mPaid).roundTo5();
            balance.setAttribute(ATTR_AMOUNT_DUE, XMLTool.moneyToXmlDouble((Money)mDue));
        }
        if (type.equals((Object)IRnOutputter.TYPE.COPY)) {
            invoice.setAttribute("resend", Boolean.toString(true));
        } else if (type.equals((Object)IRnOutputter.TYPE.STORNO)) {
            Element detail = invoice.getChild("detail", namespace);
            Element services = detail.getChild("services", namespace);
            List sr = services.getChildren();
            for (Element el : sr) {
                try {
                    this.negate(el, ATTR_QUANTITY);
                    this.negate(el, "amount.mt");
                    this.negate(el, "amount.tt");
                    this.negate(el, ATTR_AMOUNT);
                }
                catch (Exception ex) {
                    ExHandler.handle((Throwable)ex);
                }
            }
            this.negate(balance, ATTR_AMOUNT);
            this.negate(balance, ATTR_AMOUNT_TARMED);
            this.negate(balance, ATTR_AMOUNT_TARMED_MT);
            this.negate(balance, ATTR_AMOUNT_TARMED_TT);
            this.negate(balance, ATTR_AMOUNT_CANTONAL);
            this.negate(balance, ATTR_AMOUNT_UNCLASSIFIED);
            this.negate(balance, ATTR_AMOUNT_DRUG);
            this.negate(balance, ATTR_AMOUNT_LAB);
            this.negate(balance, ATTR_AMOUNT_MIGEL);
            this.negate(balance, ATTR_AMOUNT_PHYSIO);
            this.negate(balance, "amount_obligations");
            balance.setAttribute(ATTR_AMOUNT_DUE, "0.00");
            balance.setAttribute(ATTR_AMOUNT_PREPAID, "0.00");
            Element payant = invoice.getChild(ELEMENT_TIERS_PAYANT);
            if (payant != null) {
                payant.setAttribute("purpose", ELEMENT_ANNULMENT);
            }
        }
    }

    private void fixCanton(Element invoice, Namespace namespace) {
        Element detail = invoice.getChild("detail", namespace);
        String canton = detail.getAttributeValue("canton", namespace);
        if (canton == null || canton.isEmpty()) {
            detail.setAttribute("canton", "AG");
        }
    }

    public static String getXmlVersion(Element root) {
        String location = root.getAttributeValue("schemaLocation", Namespace.getNamespace((String)"http://www.w3.org/2001/XMLSchema-instance"));
        if (location != null && !location.isEmpty()) {
            if (location.contains("InvoiceRequest_400")) {
                return "4.0";
            }
            if (location.contains("InvoiceRequest_440")) {
                return "4.4";
            }
            if (location.contains("InvoiceRequest_450")) {
                return "4.5";
            }
            if (location.contains("InvoiceRequest_500")) {
                return "5.0";
            }
        }
        return location;
    }

    private boolean xmlBillExists(IInvoice invoice) {
        IBlob blob = CoreModelServiceHolder.get().load(PREFIX + invoice.getNumber(), IBlob.class).orElse(null);
        return blob != null && blob.getStringContent() != null && !blob.getStringContent().isEmpty();
    }

    protected Element buildGuarantor(IContact garant, IContact patient) {
        Element guarantor = new Element("guarantor", nsinvoice);
        guarantor.addContent((Content)XMLExporterUtil.buildAdressElement(garant));
        return guarantor;
    }

    protected Element buildPatient(ICoverage coverage) {
        Element patientElement = new Element("patient", nsinvoice);
        if (coverage.getPatient() == null) {
            MessageDialog.openError(null, (String)Messages.XMLExporter_ErrorCaption, (String)Messages.XMLExporter_NoPatientText);
            return null;
        }
        patientElement.setAttribute("gender", coverage.getPatient().getGender().toString().toLowerCase());
        LocalDateTime dateOfBirth = coverage.getPatient().getDateOfBirth();
        if (dateOfBirth == null) {
            patientElement.setAttribute(ATTR_BIRTHDATE, "0001-00-00T00:00:00");
        } else {
            patientElement.setAttribute(ATTR_BIRTHDATE, XMLExporterUtil.makeTarmedDatum(dateOfBirth.toLocalDate()));
        }
        patientElement.addContent((Content)XMLExporterUtil.buildAdressElement((IContact)coverage.getPatient()));
        if (StringUtils.isNotBlank((CharSequence)((String)coverage.getExtInfo((Object)"VEKANr"))) && StringUtils.isNotBlank((CharSequence)((String)coverage.getExtInfo((Object)"VEKAValid")))) {
            Element cardElement = new Element("card", nsinvoice);
            cardElement.setAttribute("card_id", (String)coverage.getExtInfo((Object)"VEKANr"));
            cardElement.setAttribute("expiry_date", XMLExporterUtil.makeTarmedDatum((String)coverage.getExtInfo((Object)"VEKAValid")));
            patientElement.addContent((Content)cardElement);
        }
        XMLExporterUtil.addSSNAttribute(patientElement, coverage.getPatient(), coverage, this.invoice, true);
        return patientElement;
    }

    public String getDescription() {
        return Messages.XMLExporter_TarmedForTrustCenter;
    }

    protected void checkXML(Document xmlDoc, String dest, IInvoice invoice, boolean doVerify) {
        if (ConfigServiceHolder.getUser((String)"billing/strict", (boolean)true)) {
            JDOMSource source = new JDOMSource(xmlDoc);
            String path = String.valueOf(PlatformHelper.getBasePath((String)"ch.elexis.base.ch.arzttarife")) + File.separator + "rsc";
            List<String> errs = null;
            if (XMLExporter.getXmlVersion(xmlDoc.getRootElement()).equals("4.0")) {
                logger.info("Validating XML against MDInvoiceRequest_400.xsd");
                errs = XMLTool.validateSchema((String)(String.valueOf(path) + File.separator + "MDInvoiceRequest_400.xsd"), (Source)source);
            } else if (XMLExporter.getXmlVersion(xmlDoc.getRootElement()).equals("4.4")) {
                logger.info("Validating XML against generalInvoiceRequest_440.xsd");
                errs = XMLTool.validateSchema((String)(String.valueOf(path) + File.separator + "generalInvoiceRequest_440.xsd"), (Source)source);
            } else if (XMLExporter.getXmlVersion(xmlDoc.getRootElement()).equals("4.5")) {
                logger.info("Validating XML against generalInvoiceRequest_450.xsd");
                errs = this.validator.validateRequest(this.toInputStream(xmlDoc));
            } else if (XMLExporter.getXmlVersion(xmlDoc.getRootElement()).equals("5.0")) {
                logger.info("Validating XML against generalInvoiceRequest_500.xsd");
                errs = this.validator50.validateRequest(this.toInputStream(xmlDoc));
            } else {
                errs = Collections.singletonList("Bill in unknown XML version " + XMLExporter.getXmlVersion(xmlDoc.getRootElement()));
            }
            if (!errs.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (String err : errs) {
                    sb.append(err).append("\n");
                }
                logger.error(sb.toString());
                invoice.reject(InvoiceState.REJECTCODE.VALIDATION_ERROR, sb.toString());
                CoreModelServiceHolder.get().save((Identifiable)invoice);
                XMLOutputter xout = new XMLOutputter(Format.getPrettyFormat());
                File invalidDir = new File(CoreHub.getWritableUserDir(), "validation_error");
                if (!invalidDir.exists()) {
                    invalidDir.mkdir();
                }
                File invalidFile = new File(invalidDir, String.valueOf(invoice.getNumber()) + "_invalid_tarmed.xml");
                invalidDir.deleteOnExit();
                invalidFile.deleteOnExit();
                try {
                    Throwable throwable = null;
                    Object var13_15 = null;
                    try (FileWriter writer = new FileWriter(invalidFile);){
                        xout.output(xmlDoc, (Writer)writer);
                        logger.info("Temporary invalid xml written to [" + invalidFile.getAbsolutePath() + "]");
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    logger.error("Failed writing invalid xml", (Throwable)e);
                }
            }
        }
    }

    public Control createSettingsControl(Object parent) {
        final Composite parentInc = (Composite)parent;
        Composite ret = new Composite(parentInc, 0);
        ret.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label(ret, 0);
        l.setText(Messages.XMLExporter_PleaseEnterOutputDirectoryForBills);
        l.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        Button b = new Button(ret, 8);
        b.setText(Messages.XMLExporter_Change);
        GridData buttonData = new GridData();
        buttonData.widthHint = 75;
        b.setLayoutData((Object)buttonData);
        final Text text = new Text(ret, 2056);
        text.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLExporter.this.outputDir = new DirectoryDialog(parentInc.getShell(), 4096).open();
                LocalConfigService.set((String)"TarmedExport_Directory", (String)XMLExporter.this.outputDir);
                text.setText(XMLExporter.this.outputDir);
            }
        });
        this.outputDir = LocalConfigService.get((String)"TarmedExport_Directory", (String)CoreUtil.getDefaultDBPath());
        text.setText(this.outputDir);
        return ret;
    }

    protected void writeFile(Document doc, String dest) throws IOException {
        FileOutputStream fout = new FileOutputStream(dest);
        OutputStreamWriter cout = new OutputStreamWriter((OutputStream)fout, "UTF-8");
        XMLOutputter xout = new XMLOutputter(Format.getPrettyFormat());
        xout.output(doc, (Writer)cout);
        cout.close();
        fout.close();
        InvoiceState previousState = this.invoice.getState();
        if (previousState == InvoiceState.OPEN || previousState == InvoiceState.DEMAND_NOTE_1 || previousState == InvoiceState.DEMAND_NOTE_2 || previousState == InvoiceState.DEMAND_NOTE_3) {
            InvoiceState newState = InvoiceState.fromState((int)(previousState.numericValue() + 1));
            this.invoice.setState(newState);
            CoreModelServiceHolder.get().save((Identifiable)this.invoice);
        }
        this.invoice.addTrace("Ausgegeben", String.valueOf(this.getDescription()) + ": " + this.invoice.getState().getLocaleText());
        CoreModelServiceHolder.get().save((Identifiable)this.invoice);
    }

    protected InputStream toInputStream(Document doc) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            OutputStreamWriter cout = new OutputStreamWriter((OutputStream)out, "UTF-8");
            XMLOutputter xout = new XMLOutputter(Format.getPrettyFormat());
            xout.output(doc, (Writer)cout);
            cout.close();
            out.close();
            return new ByteArrayInputStream(out.toByteArray());
        }
        catch (IOException e) {
            LoggerFactory.getLogger(XMLExporter.class).error("Error converting document to input stream", (Throwable)e);
            return null;
        }
    }

    public boolean canBill(Fall fall) {
        Kontakt garant = fall.getGarant();
        Kontakt kostentraeger = fall.getCostBearer();
        return garant != null && kostentraeger != null && garant.isValid() && kostentraeger.isValid() && kostentraeger.istOrganisation();
    }

    public void saveComposite() {
    }

    protected String getIntermediateEAN(ICoverage coverage) {
        String trustCenter;
        String iEAN = TarmedRequirements.getIntermediateEAN(coverage);
        if (iEAN.length() == 0 && TarmedRequirements.hasTCContract((IContact)this.invoice.getMandator()) && (trustCenter = TarmedRequirements.getTCName((IContact)this.invoice.getMandator())).length() > 0) {
            iEAN = TrustCenters.getTCEAN(trustCenter);
        }
        return iEAN;
    }

    protected String getSenderEAN(IMandator actMandant) {
        return TarmedRequirements.getEAN((IContact)actMandant);
    }

    public ESR getBesr() {
        return this.besr;
    }

    protected String getRole(ICoverage coverage) {
        return "production";
    }

    public void setEsrType(Tarmed45Exporter.EsrType esrType) {
        this.esrType = esrType;
    }

    public void openOutput(IInvoice invoice, LocalDateTime timestamp, InvoiceState invoiceState) {
        String outputDir = LocalConfigService.get((String)"TarmedExport_Directory", (String)CoreUtil.getDefaultDBPath());
        XMLFileUtil.lookupFile(outputDir, invoice, timestamp, invoiceState).ifPresent(xmlFile -> {
            if (xmlFile.exists()) {
                Program.launch((String)xmlFile.getAbsolutePath());
            } else {
                LoggerFactory.getLogger(this.getClass()).info("File [" + xmlFile.getAbsolutePath() + "] does not exist");
            }
        });
    }

    public void customizeDialog(Object rnOutputDialog) {
        if (rnOutputDialog instanceof RnOutputDialog) {
            ((RnOutputDialog)rnOutputDialog).setOkButtonText(Messages.Core_DoSend);
        }
    }

    class VatRateSum {
        HashMap<Double, VatRateElement> rates = new HashMap();
        double sumvat = 0.0;

        VatRateSum() {
        }

        public void add(double scale, double amount) {
            VatRateElement element = this.rates.get(scale);
            if (element == null) {
                element = new VatRateElement(scale);
                this.rates.put(scale, element);
            }
            element.add(amount);
            this.sumvat += amount / (100.0 + scale) * scale;
        }

        class VatRateElement
        implements Comparable<VatRateElement> {
            double scale;
            double sumamount;
            double sumvat;

            VatRateElement(double scale) {
                this.scale = scale;
                this.sumamount = 0.0;
                this.sumvat = 0.0;
            }

            void add(double amount) {
                this.sumamount += amount;
                this.sumvat += amount / (100.0 + this.scale) * this.scale;
            }

            @Override
            public int compareTo(VatRateElement other) {
                if (this.scale < other.scale) {
                    return -1;
                }
                if (this.scale > other.scale) {
                    return 1;
                }
                return 0;
            }
        }
    }
}

