/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.tarmed.model.importer;

import ch.elexis.core.jpa.entities.TarmedLeistung;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.TimeTool;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChapterImporter {
    private static final Logger logger = LoggerFactory.getLogger(ChapterImporter.class);
    private JdbcLink cacheDb;
    private String lang;
    private String law;
    private int chapterCount;
    private HashMap<String, List<TarmedLeistung>> importedChapters;
    private TimeTool validFrom;
    private TimeTool validTo;

    public ChapterImporter(JdbcLink cacheDb, String lang, String law) {
        this.cacheDb = cacheDb;
        this.lang = lang;
        this.law = law;
        this.importedChapters = new HashMap();
        this.validFrom = new TimeTool();
        this.validTo = new TimeTool();
    }

    public void setChapterCount(int count) {
        this.chapterCount = count;
    }

    /*
     * Exception decompiling
     */
    public IStatus doImport(IProgressMonitor ipm) throws SQLException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 9[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addToImportedChapters(TarmedLeistung tl) {
        String code = tl.getCode();
        List<TarmedLeistung> list = this.importedChapters.get(code);
        if (list == null) {
            list = new ArrayList<TarmedLeistung>();
        }
        list.add(tl);
        list.sort((l, r) -> l.getGueltigVon().compareTo(r.getGueltigVon()));
        this.importedChapters.put(code, list);
        logger.debug("Imported " + tl.getCode());
    }

    private String getParentId(String parentCode) throws SQLException {
        JdbcLink.Stm source = null;
        ArrayList<TimeTool> parentValidFroms = new ArrayList<TimeTool>();
        try {
            source = this.cacheDb.getStatement();
            Throwable throwable = null;
            Object var5_6 = null;
            try (ResultSet res = source.query(String.format("SELECT * FROM %sKAPITEL_TEXT WHERE SPRACHE='%s' AND KNR='%s'", "TARMED_IMPORT_", this.lang, parentCode));){
                while (res != null && res.next()) {
                    String code = res.getString("KNR");
                    if (code.trim().equals("I")) continue;
                    parentValidFroms.add(new TimeTool(res.getString("GUELTIG_VON")));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            if (source != null) {
                this.cacheDb.releaseStatement(source);
            }
        }
        if (parentValidFroms.isEmpty()) {
            throw new IllegalStateException("No parent valid from found for " + parentCode);
        }
        TimeTool latestParentValidFrom = null;
        for (TimeTool parentValidFrom : parentValidFroms) {
            if (latestParentValidFrom == null && parentValidFrom.isBeforeOrEqual(this.validFrom)) {
                latestParentValidFrom = parentValidFrom;
                continue;
            }
            if (!parentValidFrom.isBeforeOrEqual(this.validTo) || !parentValidFrom.isAfter(latestParentValidFrom)) continue;
            latestParentValidFrom = parentValidFrom;
        }
        if (latestParentValidFrom == null) {
            throw new IllegalStateException("No parent valid from found for " + parentCode + " in " + parentValidFroms.size() + " values");
        }
        return String.valueOf(parentCode) + "-" + latestParentValidFrom.toString(9) + this.getLawIdExtension();
    }

    private String getId(ResultSet res) throws SQLException {
        return String.valueOf(res.getString("KNR")) + "-" + this.validFrom.toString(9) + this.getLawIdExtension();
    }

    private String getLawIdExtension() {
        if (this.law != null && !this.law.isEmpty()) {
            return "-" + this.law;
        }
        return "";
    }

    public String getIdForCode(String lookupCode, LocalDate lookupValidFrom, String lookupLaw) {
        List<TarmedLeistung> list = this.importedChapters.get(lookupCode);
        if (!list.isEmpty()) {
            if (list.size() == 1) {
                return list.get(0).getId();
            }
            for (TarmedLeistung tarmedLeistung : list) {
                String currLaw = tarmedLeistung.getLaw();
                LocalDate currValidFrom = tarmedLeistung.getGueltigVon();
                if (!currValidFrom.isAfter(lookupValidFrom) && !currValidFrom.isEqual(lookupValidFrom) || !currLaw.equals(lookupLaw)) continue;
                return tarmedLeistung.getId();
            }
            TarmedLeistung latestLeistung = list.get(list.size() - 1);
            String latestLaw = latestLeistung.getLaw();
            if (latestLaw.equals(lookupLaw)) {
                return latestLeistung.getId();
            }
        }
        return null;
    }
}

