/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.tarmed.model;

import ch.elexis.arzttarife_schweiz.Messages;
import ch.elexis.base.ch.arzttarife.model.service.ConfigServiceHolder;
import ch.elexis.base.ch.arzttarife.model.service.CoreModelServiceHolder;
import ch.elexis.base.ch.arzttarife.tarmed.ITarmedGroup;
import ch.elexis.base.ch.arzttarife.tarmed.TarmedKumulationArt;
import ch.elexis.base.ch.arzttarife.tarmed.model.TarmedExclusion;
import ch.elexis.base.ch.arzttarife.tarmed.model.TarmedExclusive;
import ch.elexis.base.ch.arzttarife.tarmed.model.TarmedGroup;
import ch.elexis.base.ch.arzttarife.tarmed.model.TarmedKumulation;
import ch.elexis.base.ch.arzttarife.tarmed.model.TarmedLeistung;
import ch.elexis.base.ch.arzttarife.tarmed.model.TarmedLimitation;
import ch.elexis.base.ch.arzttarife.tarmed.model.TarmedUtil;
import ch.elexis.base.ch.arzttarife.tarmed.model.TarmedVerifier;
import ch.elexis.core.jpa.entities.TarmedLeistung;
import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBillableOptifier;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IBillingSystemFactor;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.IBilledBuilder;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.holder.BillingServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.rgw.tools.Result;
import ch.rgw.tools.TimeTool;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.LoggerFactory;

public class TarmedOptifier
implements IBillableOptifier<TarmedLeistung> {
    private static final String TL = "TL";
    private static final String AL = "AL";
    private static final String AL_NOTSCALED = "AL_NOTSCALED";
    private static final String AL_SCALINGFACTOR = "AL_SCALINGFACTOR";
    public static final int OK = 0;
    public static final int PREISAENDERUNG = 1;
    public static final int KUMULATION = 2;
    public static final int KOMBINATION = 3;
    public static final int EXKLUSION = 4;
    public static final int INKLUSION = 5;
    public static final int LEISTUNGSTYP = 6;
    public static final int NOTYETVALID = 7;
    public static final int NOMOREVALID = 8;
    public static final int PATIENTAGE = 9;
    public static final int EXKLUSIVE = 10;
    public static final int EXKLUSIONSIDE = 11;
    private static final String CHAPTER_XRAY = "39.02";
    private static final String DEFAULT_TAX_XRAY_ROOM = "39.2000";
    boolean save = true;
    boolean bOptify = true;
    boolean bAllowOverrideStrict = false;
    private IBilled newVerrechnet;
    private String newVerrechnetSide;
    private Map<String, Object> contextMap;
    private TarmedVerifier verifier = new TarmedVerifier();

    public synchronized void putContext(String key, Object value) {
        if (this.contextMap == null) {
            this.contextMap = new HashMap<String, Object>();
        }
        this.contextMap.put(key, value);
    }

    public void clearContext() {
        if (this.contextMap != null) {
            this.contextMap.clear();
        }
    }

    public Result<IBilled> add(TarmedLeistung code, IEncounter kons, double amount, boolean save) {
        this.save = save;
        int amountInt = this.doubleToInt(amount);
        boolean setNonIntAmount = amount % 1.0 != 0.0;
        Result<IBilled> result = null;
        try {
            if (!code.isChapter() && amountInt >= 1) {
                result = this.add(code, kons);
                if (amountInt == 1) {
                    Result<IBilled> result2 = result;
                    return result2;
                }
                int i = 2;
                while (i <= amountInt) {
                    Result<IBilled> intermediateResult = this.add(code, kons);
                    if (!intermediateResult.isOK()) {
                        result.addMessage(Result.SEVERITY.WARNING, intermediateResult.toString(), (Object)((IBilled)result.get()));
                        Result<IBilled> result3 = result;
                        return result3;
                    }
                    result = intermediateResult;
                    ++i;
                }
                Result<IBilled> result4 = result;
                return result4;
            }
            Result result5 = Result.OK();
            return result5;
        }
        finally {
            if (setNonIntAmount && result != null && result.get() != null) {
                ((IBilled)result.get()).setAmount(amount);
                if (save) {
                    CoreModelServiceHolder.get().save((Identifiable)result.get());
                }
            }
        }
    }

    public Result<IBilled> add(TarmedLeistung code, IEncounter kons) {
        Result<IBilled> limitResult;
        TarmedLeistung loaded;
        Optional<String> increasedCode;
        this.bOptify = TarmedUtil.getConfigValue(this.getClass(), IMandator.class, "billing/optify", true);
        this.bAllowOverrideStrict = TarmedUtil.getConfigValue(this.getClass(), IUser.class, "billing/allowoverride/strict", false);
        TarmedLeistung tc = code;
        List lst = kons.getBilled();
        Map<String, String> ext = tc.getExtension().getLimits();
        if (this.bOptify) {
            TimeTool tBis;
            TimeTool tVon;
            TimeTool date = new TimeTool(kons.getDate());
            LocalDate dVon = code.getValidFrom();
            if (dVon != null && date.isBefore(tVon = new TimeTool(dVon))) {
                return new Result(Result.SEVERITY.WARNING, 7, String.valueOf(code.getCode()) + Messages.TarmedOptifier_NotYetValid, null, false);
            }
            LocalDate dBis = code.getValidTo();
            if (dBis != null && date.isAfter(tBis = new TimeTool(dBis))) {
                return new Result(Result.SEVERITY.WARNING, 8, String.valueOf(code.getCode()) + Messages.TarmedOptifier_NoMoreValid, null, false);
            }
            Result<IBilled> checkAgeResult = this.verifier.checkAge(kons, tc, null);
            if (!checkAgeResult.isOK()) {
                return checkAgeResult;
            }
        }
        if (TarmedUtil.isIncreasedTreatment(kons.getPatient()) && (increasedCode = TarmedUtil.getIncreasedTreatmentCode(code)).isPresent() && (loaded = this.getKonsVerrechenbar(increasedCode.get(), kons)) != null) {
            code = loaded;
        }
        this.newVerrechnet = null;
        this.newVerrechnetSide = null;
        if (tc.getCode().matches("39.002[01]") || tc.getCode().matches("39.001[0156]")) {
            String gesetz = kons.getCoverage().getBillingSystem().getLaw().name();
            if (gesetz.equalsIgnoreCase("KVG") && tc.getCode().matches("39.0011")) {
                return this.add(this.getKonsVerrechenbar("39.0010", kons), kons);
            }
            if (!gesetz.equalsIgnoreCase("KVG") && tc.getCode().matches("39.0010")) {
                return this.add(this.getKonsVerrechenbar("39.0011", kons), kons);
            }
            if (gesetz.equalsIgnoreCase("KVG") && tc.getCode().matches("39.0016")) {
                return this.add(this.getKonsVerrechenbar("39.0015", kons), kons);
            }
            if (!gesetz.equalsIgnoreCase("KVG") && tc.getCode().matches("39.0015")) {
                return this.add(this.getKonsVerrechenbar("39.0016", kons), kons);
            }
            if (gesetz.equalsIgnoreCase("KVG") && tc.getCode().matches("39.0021")) {
                return this.add(this.getKonsVerrechenbar("39.0020", kons), kons);
            }
            if (!gesetz.equalsIgnoreCase("KVG") && tc.getCode().matches("39.0020")) {
                return this.add(this.getKonsVerrechenbar("39.0021", kons), kons);
            }
        }
        if (tc.getCode().matches("35.0020")) {
            Object opReduction;
            List<IBilled> opCodes = this.getOPList(lst);
            List<IBilled> availableCodes = this.updateOPReductions(opCodes, (List<IBilled>)(opReduction = this.getVerrechnetMatchingCode(lst, "35.0020")));
            if (availableCodes.isEmpty()) {
                return new Result(Result.SEVERITY.WARNING, 3, code.getCode(), null, false);
            }
            for (IBilled verrechnet : availableCodes) {
                this.newVerrechnet = this.initializeBilled(code, kons);
                this.mapOpReduction(verrechnet, this.newVerrechnet);
            }
            return new Result(null);
        }
        for (IBilled v : lst) {
            if (!this.isInstance(v, (ICodeElement)code) || tc.requiresSide()) continue;
            this.newVerrechnet = v;
            if (!",00.2530,00.2570,00.2550,00.2590,04.0620,04.1930,06.0430,06.0440,06.0730,06.0740,07.0300,24.0250,24.3250,28.0020,".contains("," + code.getCode())) {
                this.newVerrechnet.setAmount(this.newVerrechnet.getAmount() + 1.0);
            }
            this.saveBilled();
            break;
        }
        if (tc.requiresSide()) {
            this.newVerrechnetSide = this.getNewVerrechnetSideOrIncrement((IBillable)code, lst);
        }
        if (this.newVerrechnet == null) {
            this.newVerrechnet = this.initializeBilled(code, kons);
            if (tc.requiresSide()) {
                this.newVerrechnet.setExtInfo((Object)"Seite", (Object)this.newVerrechnetSide);
            }
            if (this.bOptify) {
                TarmedLeistung newTarmed = code;
                for (IBilled v : lst) {
                    Object tarmed;
                    if (!(v.getBillable() instanceof TarmedLeistung) || (tarmed = (TarmedLeistung)v.getBillable()) == null) continue;
                    Iterator<IBilled> resCompatible = this.isCompatible(v, (TarmedLeistung)tarmed, this.newVerrechnet, newTarmed, kons);
                    if (resCompatible.isOK()) {
                        resCompatible = this.isCompatible(this.newVerrechnet, newTarmed, v, (TarmedLeistung)tarmed, kons);
                    }
                    if (resCompatible.isOK()) continue;
                    this.deleteBilled(this.newVerrechnet);
                    return resCompatible;
                }
                if (this.newVerrechnet.getCode().equals("00.0750") || this.newVerrechnet.getCode().equals("00.0010")) {
                    String excludeCode = null;
                    excludeCode = this.newVerrechnet.getCode().equals("00.0010") ? "00.0750" : "00.0010";
                    for (IBilled v : lst) {
                        if (!v.getCode().equals(excludeCode)) continue;
                        this.deleteBilled(this.newVerrechnet);
                        return new Result(Result.SEVERITY.WARNING, 4, "00.0750 ist nicht im Rahmen einer \u00e4rztlichen Beratung 00.0010 verrechnenbar.", null, false);
                    }
                }
            }
            this.newVerrechnet.setExtInfo((Object)AL, (Object)Integer.toString(tc.getAL(kons.getMandator())));
            this.setALScalingInfo(tc, this.newVerrechnet, kons.getMandator(), false);
            this.newVerrechnet.setExtInfo((Object)TL, (Object)Integer.toString(tc.getTL()));
            lst.add(this.newVerrechnet);
        }
        if (this.isReferenceInfoAvailable() && tc.isZuschlagsleistung()) {
            List<IBilled> masters = this.getPossibleMasters(this.newVerrechnet, lst);
            if (masters.isEmpty()) {
                this.decrementOrDelete(this.newVerrechnet);
                return new Result(Result.SEVERITY.WARNING, 3, "F\u00fcr die Zuschlagsleistung " + code.getCode() + " konnte keine passende Hauptleistung gefunden werden.", null, false);
            }
            if (!masters.isEmpty()) {
                String bezug = (String)this.newVerrechnet.getExtInfo((Object)"Bezug");
                if (bezug == null) {
                    this.newVerrechnet.setExtInfo((Object)"Bezug", (Object)masters.get(0).getCode());
                } else {
                    boolean found = false;
                    for (IBilled mVerr : masters) {
                        if (!mVerr.getCode().equals(bezug)) continue;
                        found = true;
                    }
                    if (!found) {
                        this.newVerrechnet.setAmount(this.newVerrechnet.getAmount() - 1.0);
                        this.saveBilled();
                        this.newVerrechnet = this.initializeBilled(code, kons);
                        this.newVerrechnet.setExtInfo((Object)"Bezug", (Object)masters.get(0).getCode());
                    }
                }
            }
        }
        if (this.bOptify && !(limitResult = this.verifier.checkLimitations(kons, tc, this.newVerrechnet)).isOK()) {
            this.decrementOrDelete(this.newVerrechnet);
            return limitResult;
        }
        Optional<Object> percentScalingInfo = Optional.empty();
        String tcid = code.getCode();
        if (!tc.getCode().equals(DEFAULT_TAX_XRAY_ROOM) && !tc.getCode().matches("39.002[01]") && tc.getParent().getId().startsWith(CHAPTER_XRAY)) {
            if (TarmedUtil.getConfigValue(this.getClass(), IUser.class, "billing/optify/XRAY", true)) {
                this.saveBilled();
                this.add(this.getKonsVerrechenbar(DEFAULT_TAX_XRAY_ROOM, kons), kons);
                this.saveBilled();
                this.add(this.getKonsVerrechenbar("39.0020", kons), kons);
            }
        } else if (tcid.equals("29.2090")) {
            double sumAL = 0.0;
            double sumTL = 0.0;
            for (IBilled v : lst) {
                if (!(v.getBillable() instanceof TarmedLeistung)) continue;
                tl = (TarmedLeistung)v.getBillable();
                tlc = tl.getCode();
                z = v.getAmount();
                if (!tlc.matches("29.20[12345678]0") && !tlc.equals("29.2200")) continue;
                sumAL += z * (double)tl.getAL(kons.getMandator()) / 2.0;
                sumTL += z * (double)tl.getTL() / 4.0;
            }
            this.newVerrechnet.setPoints((int)Math.round(sumAL + sumTL));
            this.newVerrechnet.setExtInfo((Object)AL, (Object)Double.toString(sumAL));
            this.newVerrechnet.setExtInfo((Object)TL, (Object)Double.toString(sumTL));
        } else if (tcid.equals("00.0010") || tcid.equals("00.0060")) {
            int alter;
            IPatient p;
            ICoverage f;
            if (TarmedUtil.getConfigValue(this.getClass(), IMandator.class, "tarmed/addchildrentp", false) && (f = kons.getCoverage()) != null && (p = f.getPatient()) != null && (alter = p.getAgeInYears()) < 6) {
                TarmedLeistung tl = this.getKonsVerrechenbar("00.0040", kons);
                this.saveBilled();
                this.add(tl, kons);
            }
        } else if (tcid.equals("04.1930")) {
            percentScalingInfo = PercentScalingInfo.ifNeeded(kons.getMandator());
            double sumAL = 0.0;
            double sumTL = 0.0;
            for (IBilled v : lst) {
                if (!(v.getBillable() instanceof TarmedLeistung)) continue;
                tl = (TarmedLeistung)v.getBillable();
                tlc = tl.getCode();
                z = v.getAmount();
                if (!tlc.equals("04.1910") && !tlc.equals("04.1920") && !tlc.equals("04.1940") && !tlc.equals("04.1950")) continue;
                sumAL += (double)tl.getAL(kons.getMandator()) * z;
                sumTL += (double)tl.getTL() * z;
                percentScalingInfo.ifPresent(scalingInfo -> scalingInfo.addAL(v));
            }
            this.newVerrechnet.setPoints((int)Math.round(sumAL + sumTL));
            this.newVerrechnet.setExtInfo((Object)AL, (Object)Double.toString(sumAL));
            this.newVerrechnet.setExtInfo((Object)TL, (Object)Double.toString(sumTL));
            this.newVerrechnet.setPrimaryScale(50);
        } else if (tcid.equals("04.0620")) {
            percentScalingInfo = PercentScalingInfo.ifNeeded(kons.getMandator());
            double sumAL = 0.0;
            double sumTL = 0.0;
            for (IBilled v : lst) {
                if (!(v.getBillable() instanceof TarmedLeistung)) continue;
                tl = (TarmedLeistung)v.getBillable();
                tlc = tl.getCode();
                z = v.getAmount();
                if (!tlc.equals("04.0610") && !tlc.equals("04.0630") && !tlc.equals("04.0640")) continue;
                sumAL += (double)tl.getAL(kons.getMandator()) * z;
                sumTL += (double)tl.getTL() * z;
                percentScalingInfo.ifPresent(scalingInfo -> scalingInfo.addAL(v));
            }
            this.newVerrechnet.setPoints((int)Math.round(sumAL + sumTL));
            this.newVerrechnet.setExtInfo((Object)AL, (Object)Double.toString(sumAL));
            this.newVerrechnet.setExtInfo((Object)TL, (Object)Double.toString(sumTL));
            this.newVerrechnet.setPrimaryScale(70);
        }
        if (tcid.startsWith("00.25")) {
            percentScalingInfo = PercentScalingInfo.ifNeeded(kons.getMandator());
            double sum = 0.0;
            int subcode = Integer.parseInt(tcid.substring(5));
            switch (subcode) {
                case 10: {
                    break;
                }
                case 20: {
                    break;
                }
                case 30: 
                case 70: {
                    TarmedLeistung tl;
                    for (IBilled v : lst) {
                        if (!(v.getBillable() instanceof TarmedLeistung) || (tl = (TarmedLeistung)v.getBillable()).getCode().startsWith("00.25")) continue;
                        sum += (double)tl.getAL(kons.getMandator()) * v.getAmount();
                        percentScalingInfo.ifPresent(scalingInfo -> scalingInfo.addAL(v));
                    }
                    this.newVerrechnet.setPoints((int)Math.round(sum));
                    this.newVerrechnet.setExtInfo((Object)AL, (Object)Double.toString(sum));
                    this.newVerrechnet.setPrimaryScale(25);
                    break;
                }
                case 40: {
                    break;
                }
                case 50: 
                case 90: {
                    TarmedLeistung tl;
                    for (IBilled v : lst) {
                        if (!(v.getBillable() instanceof TarmedLeistung) || (tl = (TarmedLeistung)v.getBillable()).getCode().startsWith("00.25")) continue;
                        sum += (double)tl.getAL(kons.getMandator()) * v.getAmount();
                        percentScalingInfo.ifPresent(scalingInfo -> scalingInfo.addAL(v));
                    }
                    this.newVerrechnet.setPoints((int)Math.round(sum));
                    this.newVerrechnet.setExtInfo((Object)AL, (Object)Double.toString(sum));
                    this.newVerrechnet.setPrimaryScale(50);
                    break;
                }
                case 60: {
                    break;
                }
            }
        }
        percentScalingInfo.ifPresent(scalingInfo -> this.setALScalingInfo((PercentScalingInfo)scalingInfo));
        this.saveBilled();
        return new Result((Object)this.newVerrechnet);
    }

    private IBilled initializeBilled(TarmedLeistung code, IEncounter kons) {
        IContact biller = (IContact)ContextServiceHolder.get().getActiveUserContact().get();
        IBilled ret = (IBilled)new IBilledBuilder(CoreModelServiceHolder.get(), (IBillable)code, kons, biller).build();
        ret.setPoints(code.getAL(kons.getMandator()) + code.getTL());
        Optional<IBillingSystemFactor> systemFactor = this.getFactor(kons);
        if (systemFactor.isPresent()) {
            ret.setFactor(systemFactor.get().getFactor());
        } else {
            ret.setFactor(1.0);
        }
        if (this.save) {
            CoreModelServiceHolder.get().save((Identifiable)ret);
        }
        return ret;
    }

    public Optional<IBillingSystemFactor> getFactor(IEncounter encounter) {
        return BillingServiceHolder.get().getBillingSystemFactor(encounter.getCoverage().getBillingSystem().getName(), encounter.getDate());
    }

    private void saveBilled() {
        if (this.newVerrechnet != null && this.save) {
            CoreModelServiceHolder.get().save((Identifiable)this.newVerrechnet);
        } else {
            LoggerFactory.getLogger(TarmedOptifier.class).warn("Call on null", new Throwable("Diagnosis"));
        }
    }

    private void deleteBilled(IBilled billed) {
        if (!this.bAllowOverrideStrict) {
            if (this.save) {
                CoreModelServiceHolder.get().delete((Deleteable)billed);
            } else {
                billed.setDeleted(true);
            }
        }
    }

    private void decrementOrDelete(IBilled verrechnet) {
        if (!this.bAllowOverrideStrict) {
            double zahl = verrechnet.getAmount();
            if (zahl > 1.0) {
                verrechnet.setAmount(zahl - 1.0);
                if (this.save) {
                    CoreModelServiceHolder.get().save((Identifiable)verrechnet);
                }
            } else {
                this.deleteBilled(verrechnet);
            }
        }
    }

    private boolean isContext(String key) {
        return this.getContextValue(key) != null;
    }

    private Object getContextValue(String key) {
        if (this.contextMap != null) {
            return this.contextMap.get(key);
        }
        return null;
    }

    private void setALScalingInfo(TarmedLeistung tarmed, IBilled verrechnet, IMandator mandant, boolean isComposite) {
        double scaling = tarmed.getALScaling(mandant);
        if (scaling != 100.0) {
            this.newVerrechnet.setExtInfo((Object)AL_NOTSCALED, (Object)Integer.toString(tarmed.getAL()));
            this.newVerrechnet.setExtInfo((Object)AL_SCALINGFACTOR, (Object)Double.toString(scaling / 100.0));
        }
    }

    private void setALScalingInfo(PercentScalingInfo scalingInfo) {
        if (scalingInfo != null && scalingInfo.getScalingFactor() > 0.001) {
            this.newVerrechnet.setExtInfo((Object)AL_NOTSCALED, (Object)Double.toString(scalingInfo.getNotScaled()));
            this.newVerrechnet.setExtInfo((Object)AL_SCALINGFACTOR, (Object)Double.toString(scalingInfo.getScalingFactor()));
        }
    }

    private int doubleToInt(double value) {
        BigDecimal bd = new BigDecimal(value);
        if ((bd = bd.setScale(0, RoundingMode.HALF_UP)).intValue() > 0) {
            return bd.intValue();
        }
        return 1;
    }

    private TarmedLeistung getKonsVerrechenbar(String code, IEncounter kons) {
        if (kons.getCoverage() != null) {
            String law = kons.getCoverage().getBillingSystem().getLaw().name();
            return TarmedLeistung.getFromCode(code, kons.getDate(), law);
        }
        return null;
    }

    private boolean isReferenceInfoAvailable() {
        boolean result = false;
        IConfigService cfgs = ConfigServiceHolder.get().orElse(null);
        if (cfgs != null) {
            result = cfgs.get("ch.elexis.data.importer.TarmedReferenceDataImporter/referenceinfoavailable", false);
        }
        return result;
    }

    private List<IBilled> getAvailableMasters(TarmedLeistung slave, List<IBilled> lst) {
        LinkedList<IBilled> ret = new LinkedList<IBilled>();
        LocalDate konsDate = null;
        for (IBilled v : lst) {
            TarmedLeistung tl;
            if (konsDate == null) {
                konsDate = v.getEncounter().getDate();
            }
            if (!(v.getBillable() instanceof TarmedLeistung) || !(tl = (TarmedLeistung)v.getBillable()).getHierarchy(konsDate).contains(slave.getCode())) continue;
            ret.add(v);
        }
        return ret;
    }

    private List<IBilled> getPossibleMasters(IBilled newSlave, List<IBilled> lst) {
        TarmedLeistung slaveTarmed = (TarmedLeistung)newSlave.getBillable();
        List<IBilled> masters = this.getAvailableMasters(slaveTarmed, lst);
        int maxPerMaster = this.getMaxPerMaster(slaveTarmed);
        if (maxPerMaster > 0) {
            Map<IBilled, List<IBilled>> masterSlavesMap = this.getMasterToSlavesMap(newSlave, lst);
            for (IBilled master : masterSlavesMap.keySet()) {
                double masterCount = master.getAmount();
                int slaveCount = 0;
                for (IBilled slave : masterSlavesMap.get(master)) {
                    slaveCount = (int)((double)slaveCount + slave.getAmount());
                    if (!slave.equals(newSlave)) continue;
                    --slaveCount;
                }
                if (!(masterCount <= (double)(slaveCount * maxPerMaster))) continue;
                masters.remove(master);
            }
        }
        return masters;
    }

    private Map<IBilled, List<IBilled>> getMasterToSlavesMap(IBilled newSlave, List<IBilled> lst) {
        HashMap<IBilled, List<IBilled>> ret = new HashMap<IBilled, List<IBilled>>();
        TarmedLeistung slaveTarmed = (TarmedLeistung)newSlave.getBillable();
        List<IBilled> masters = this.getAvailableMasters(slaveTarmed, lst);
        for (IBilled verrechnet : masters) {
            ret.put(verrechnet, new ArrayList());
        }
        List<IBilled> slaves = this.getVerrechnetMatchingCode(lst, newSlave.getCode());
        for (IBilled slave : slaves) {
            String bezug = (String)slave.getExtInfo((Object)"Bezug");
            if (bezug == null || bezug.isEmpty()) continue;
            for (IBilled master : ret.keySet()) {
                if (!master.getCode().equals(bezug)) continue;
                ((List)ret.get(master)).add(slave);
            }
        }
        return ret;
    }

    private int getMaxPerMaster(TarmedLeistung slave) {
        List<TarmedLimitation> limits = slave.getLimitations();
        for (TarmedLimitation limit : limits) {
            if (limit.getLimitationUnit() != TarmedLimitation.LimitationUnit.MAINSERVICE) continue;
            return limit.getAmount();
        }
        return -1;
    }

    private void mapOpReduction(IBilled opVerrechnet, IBilled reductionVerrechnet) {
        TarmedLeistung opVerrechenbar = (TarmedLeistung)opVerrechnet.getBillable();
        reductionVerrechnet.setAmount(opVerrechnet.getAmount());
        reductionVerrechnet.setExtInfo((Object)TL, (Object)Double.toString(opVerrechenbar.getTL()));
        reductionVerrechnet.setExtInfo((Object)AL, (Object)Double.toString(0.0));
        reductionVerrechnet.setPoints(Math.round(opVerrechenbar.getTL()));
        reductionVerrechnet.setPrimaryScale(-40);
        reductionVerrechnet.setExtInfo((Object)"Bezug", (Object)opVerrechenbar.getCode());
        if (this.save) {
            CoreModelServiceHolder.get().save((Identifiable)reductionVerrechnet);
        }
    }

    private List<IBilled> updateOPReductions(List<IBilled> opCodes, List<IBilled> opReduction) {
        ArrayList<IBilled> notMappedCodes = new ArrayList<IBilled>();
        notMappedCodes.addAll(opCodes);
        for (IBilled reductionVerrechnet : opReduction) {
            boolean isMapped = false;
            String bezug = (String)reductionVerrechnet.getExtInfo((Object)"Bezug");
            if (bezug != null && !bezug.isEmpty()) {
                for (IBilled opVerrechnet : opCodes) {
                    TarmedLeistung opVerrechenbar = (TarmedLeistung)opVerrechnet.getBillable();
                    String opCodeString = opVerrechenbar.getCode();
                    if (!bezug.equals(opCodeString)) continue;
                    reductionVerrechnet.setAmount(opVerrechnet.getAmount());
                    reductionVerrechnet.setExtInfo((Object)TL, (Object)Double.toString(opVerrechenbar.getTL()));
                    reductionVerrechnet.setExtInfo((Object)AL, (Object)Double.toString(0.0));
                    reductionVerrechnet.setPrimaryScale(-40);
                    notMappedCodes.remove(opVerrechnet);
                    isMapped = true;
                    break;
                }
            }
            if (isMapped) continue;
            reductionVerrechnet.setAmount(0.0);
            reductionVerrechnet.setExtInfo((Object)"Bezug", (Object)"");
            this.saveBilled();
        }
        return notMappedCodes;
    }

    private List<IBilled> getOPList(List<IBilled> lst) {
        ArrayList<IBilled> ret = new ArrayList<IBilled>();
        for (IBilled v : lst) {
            TarmedLeistung tl;
            if (!(v.getBillable() instanceof TarmedLeistung) || !(tl = (TarmedLeistung)v.getBillable()).getSparteAsText().equals("OP I")) continue;
            ret.add(v);
        }
        return ret;
    }

    private List<IBilled> getVerrechnetMatchingCode(List<IBilled> lst, String code) {
        ArrayList<IBilled> ret = new ArrayList<IBilled>();
        for (IBilled v : lst) {
            TarmedLeistung tl;
            if (!(v.getBillable() instanceof TarmedLeistung) || !(tl = (TarmedLeistung)v.getBillable()).getCode().equals(code)) continue;
            ret.add(v);
        }
        return ret;
    }

    private List<IBilled> getVerrechnetWithBezugMatchingCode(List<IBilled> lst, String code) {
        ArrayList<IBilled> ret = new ArrayList<IBilled>();
        for (IBilled v : lst) {
            if (!(v.getBillable() instanceof TarmedLeistung) || !code.equals(v.getExtInfo((Object)"Bezug"))) continue;
            ret.add(v);
        }
        return ret;
    }

    private boolean isInstance(IBilled billed, ICodeElement billable) {
        boolean sameCode = billed.getBillable().getCode().equals(billable.getCode());
        boolean sameCodeSystemCode = billed.getBillable().getCodeSystemCode().equals(billable.getCodeSystemCode());
        return sameCodeSystemCode && sameCode;
    }

    private String getNewVerrechnetSideOrIncrement(IBillable code, List<IBilled> lst) {
        int countSideLeft = 0;
        IBilled leftVerrechnet = null;
        int countSideRight = 0;
        IBilled rightVerrechnet = null;
        for (IBilled v : lst) {
            if (!this.isInstance(v, (ICodeElement)code)) continue;
            String side = (String)v.getExtInfo((Object)"Seite");
            if (side.equals("l")) {
                countSideLeft = (int)((double)countSideLeft + v.getAmount());
                leftVerrechnet = v;
                continue;
            }
            countSideRight = (int)((double)countSideRight + v.getAmount());
            rightVerrechnet = v;
        }
        if (this.isContext("Seite")) {
            String side = (String)this.getContextValue("Seite");
            if ("l".equals(side) && countSideLeft > 0) {
                this.newVerrechnet = leftVerrechnet;
                this.newVerrechnet.setAmount(this.newVerrechnet.getAmount() + 1.0);
            } else if ("r".equals(side) && countSideRight > 0) {
                this.newVerrechnet = rightVerrechnet;
                this.newVerrechnet.setAmount(this.newVerrechnet.getAmount() + 1.0);
            }
            return side;
        }
        if (countSideLeft > 0 || countSideRight > 0) {
            if (countSideLeft > countSideRight && rightVerrechnet != null) {
                this.newVerrechnet = rightVerrechnet;
                this.newVerrechnet.setAmount(this.newVerrechnet.getAmount() + 1.0);
                this.saveBilled();
            } else if (countSideLeft <= countSideRight && leftVerrechnet != null) {
                this.newVerrechnet = leftVerrechnet;
                this.newVerrechnet.setAmount(this.newVerrechnet.getAmount() + 1.0);
                this.saveBilled();
            } else if (countSideLeft > countSideRight && rightVerrechnet == null) {
                return "r";
            }
        }
        return "l";
    }

    public Result<IBilled> isCompatible(TarmedLeistung tarmedCode, TarmedLeistung tarmed, IEncounter kons) {
        return this.isCompatible(null, tarmedCode, null, tarmed, kons);
    }

    public Result<IBilled> isCompatible(IBilled tarmedCodeVerrechnet, TarmedLeistung tarmedCode, IBilled tarmedVerrechnet, TarmedLeistung tarmed, IEncounter kons) {
        TimeTool date = new TimeTool(kons.getDate());
        List<TarmedExclusion> exclusions = tarmed.getExclusions(kons);
        for (TarmedExclusion tarmedExclusion : exclusions) {
            if (!tarmedExclusion.isMatching(tarmedCode, kons.getDate())) continue;
            if (tarmedExclusion.isValidSide() && tarmedCodeVerrechnet != null && tarmedVerrechnet != null) {
                String tarmedCodeSide = (String)tarmedCodeVerrechnet.getExtInfo((Object)"Seite");
                String tarmedSide = (String)tarmedVerrechnet.getExtInfo((Object)"Seite");
                if (tarmedSide != null && tarmedCodeSide != null) {
                    if (!tarmedSide.equals(tarmedCodeSide)) continue;
                    return new Result(Result.SEVERITY.WARNING, 11, String.valueOf(tarmed.getCode()) + " nicht kombinierbar mit " + tarmedExclusion.toString() + " auf der selben Seite", null, false);
                }
            }
            return new Result(Result.SEVERITY.WARNING, 4, String.valueOf(tarmed.getCode()) + " nicht kombinierbar mit " + tarmedExclusion.toString(), null, false);
        }
        if (!tarmedCode.getCode().equals(tarmed.getCode())) {
            List<String> groups = tarmed.getServiceGroups(kons.getDate());
            for (String groupName : groups) {
                Optional<ITarmedGroup> group = TarmedGroup.find(groupName, tarmed.getLaw(), kons.getDate());
                if (!group.isPresent() || tarmedCode.getServiceTyp().equals("Z")) continue;
                List<TarmedExclusion> groupExclusions = group.get().getExclusions(kons);
                for (TarmedExclusion tarmedExclusion : groupExclusions) {
                    if (!tarmedExclusion.isMatching(tarmedCode, kons.getDate())) continue;
                    return new Result(Result.SEVERITY.WARNING, 4, String.valueOf(tarmed.getCode()) + " nicht kombinierbar mit " + tarmedExclusion.toString(), null, false);
                }
            }
        }
        List<String> blocks = tarmed.getServiceBlocks(kons.getDate());
        for (String blockName : blocks) {
            List<TarmedExclusive> exclusives;
            if (this.skipBlockExclusives(blockName) || !this.canHandleAllExculives(exclusives = TarmedKumulation.getExclusives(blockName, TarmedKumulationArt.BLOCK, kons.getDate(), tarmed.getLaw())) || this.isMatchingHierarchy(tarmedCode, tarmed, kons.getDate()) || tarmedCode.getServiceTyp().equals("Z")) continue;
            boolean included = false;
            for (TarmedExclusive tarmedExclusive : exclusives) {
                if (!tarmedExclusive.isMatching(tarmedCode, date)) continue;
                included = true;
            }
            if (included) continue;
            return new Result(Result.SEVERITY.WARNING, 10, String.valueOf(tarmed.getCode()) + " nicht kombinierbar mit " + tarmedCode.getCode() + ", wegen Block Kumulation", null, false);
        }
        return new Result(Result.SEVERITY.OK, 0, "compatible", null, false);
    }

    private boolean skipBlockExclusives(String blockName) {
        try {
            Integer blockNumber = Integer.valueOf(blockName);
            if (blockNumber > 50 && blockNumber < 60) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    private boolean isMatchingHierarchy(TarmedLeistung tarmedCode, TarmedLeistung tarmed, LocalDate date) {
        return tarmed.getHierarchy(date).contains(tarmedCode.getCode());
    }

    private boolean canHandleAllExculives(List<TarmedExclusive> exclusives) {
        for (TarmedExclusive tarmedExclusive : exclusives) {
            if (tarmedExclusive.getSlaveType() == TarmedKumulationArt.BLOCK || tarmedExclusive.getSlaveType() == TarmedKumulationArt.CHAPTER || tarmedExclusive.getSlaveType() == TarmedKumulationArt.SERVICE) continue;
            return false;
        }
        return true;
    }

    public Result<IBilled> remove(IBilled code, IEncounter kons) {
        List l = kons.getBilled();
        l.remove(code);
        this.deleteBilled(code);
        List<IBilled> left = this.getVerrechnetMatchingCode(l, code.getCode());
        if (left.isEmpty()) {
            List<IBilled> verrechnetWithBezug = this.getVerrechnetWithBezugMatchingCode(kons.getBilled(), code.getCode());
            for (IBilled verrechnet : verrechnetWithBezug) {
                this.remove(verrechnet, kons);
            }
        }
        return new Result((Object)code);
    }

    private static class PercentScalingInfo {
        private double notScaledSum = 0.0;
        private double scalingFactor = 0.0;

        private PercentScalingInfo() {
        }

        public static Optional<PercentScalingInfo> ifNeeded(IMandator mandator) {
            if (TarmedLeistung.getMandantType(mandator) == TarmedLeistung.MandantType.PRACTITIONER) {
                return Optional.of(new PercentScalingInfo());
            }
            return Optional.empty();
        }

        public static Optional<PercentScalingInfo> ifNeeded(IMandator mandator, double scalingFactor) {
            if (TarmedLeistung.getMandantType(mandator) == TarmedLeistung.MandantType.PRACTITIONER) {
                return Optional.of(new PercentScalingInfo().withScalingFactor(scalingFactor));
            }
            return Optional.empty();
        }

        public PercentScalingInfo withScalingFactor(double scalingFactor) {
            this.scalingFactor = scalingFactor;
            return this;
        }

        public double getNotScaled() {
            return this.notScaledSum;
        }

        public double getScalingFactor() {
            return this.scalingFactor;
        }

        public void addAL(IBilled v) {
            TarmedLeistung tl = (TarmedLeistung)v.getBillable();
            this.notScaledSum += (double)tl.getAL() * v.getAmount();
            if (this.scalingFactor == 0.0) {
                this.scalingFactor = this.getALScalingFactor(v);
            }
        }

        private double getALScalingFactor(IBilled billed) {
            String scalingFactor = (String)billed.getExtInfo((Object)TarmedOptifier.AL_SCALINGFACTOR);
            if (scalingFactor != null && !scalingFactor.isEmpty()) {
                try {
                    return Double.parseDouble(scalingFactor);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return 0.0;
        }
    }
}

