/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.tarmed.model;

import ch.elexis.base.ch.arzttarife.model.service.ArzttarifeModelServiceHolder;
import ch.elexis.base.ch.arzttarife.tarmed.ITarmedExtension;
import ch.elexis.base.ch.arzttarife.tarmed.ITarmedKumulation;
import ch.elexis.base.ch.arzttarife.tarmed.ITarmedLeistung;
import ch.elexis.base.ch.arzttarife.tarmed.TarmedKumulationArt;
import ch.elexis.base.ch.arzttarife.tarmed.model.TarmedExclusion;
import ch.elexis.base.ch.arzttarife.tarmed.model.TarmedKumulation;
import ch.elexis.base.ch.arzttarife.tarmed.model.TarmedLimitation;
import ch.elexis.base.ch.arzttarife.tarmed.model.TarmedOptifier;
import ch.elexis.base.ch.arzttarife.tarmed.model.TarmedVerifier;
import ch.elexis.base.ch.arzttarife.util.ArzttarifeUtil;
import ch.elexis.base.ch.arzttarife.util.TarmedDefinitionenUtil;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.TarmedLeistung;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBillableOptifier;
import ch.elexis.core.model.IBillableVerifier;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IBillingSystemFactor;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.BillingServiceHolder;
import ch.elexis.core.services.holder.XidServiceHolder;
import ch.elexis.core.types.VatInfo;
import ch.rgw.tools.Money;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class TarmedLeistung
extends AbstractIdDeleteModelAdapter<ch.elexis.core.jpa.entities.TarmedLeistung>
implements Identifiable,
ITarmedLeistung {
    public static final String STS_CLASS = "ch.elexis.data.TarmedLeistung";
    private IBillableOptifier<TarmedLeistung> tarmedOptifier;
    private IBillableVerifier verifier = new TarmedVerifier();
    private ITarmedExtension extension;
    public static LocalDate curTimeHelper = LocalDate.now();

    public TarmedLeistung(ch.elexis.core.jpa.entities.TarmedLeistung entity) {
        super((EntityWithId)entity);
    }

    public VatInfo getVatInfo() {
        return VatInfo.VAT_CH_ISTREATMENT;
    }

    public int getMinutes() {
        double min = NumberUtils.toDouble((String)((String)this.getExtension().getExtInfo("LSTGIMES_MIN")));
        min += NumberUtils.toDouble((String)((String)this.getExtension().getExtInfo("VBNB_MIN")));
        min += NumberUtils.toDouble((String)((String)this.getExtension().getExtInfo("BEFUND_MIN")));
        return (int)Math.round(min += NumberUtils.toDouble((String)((String)this.getExtension().getExtInfo("WECHSEL_MIN"))));
    }

    @Override
    public int getAL() {
        String tp_al = this.getExtension().getLimits().get("TP_AL");
        return (int)Math.round(NumberUtils.toDouble((String)tp_al) * 100.0);
    }

    @Override
    public int getAL(IMandator mandant) {
        String tp_al = this.getExtension().getLimits().get("TP_AL");
        return (int)Math.round(NumberUtils.toDouble((String)tp_al) * this.getALScaling(mandant));
    }

    public double getALScaling(IMandator mandant) {
        String f_al_r;
        double alScaling;
        TarmedLeistung.MandantType type;
        double scaling = 100.0;
        if (mandant != null && (type = TarmedLeistung.getMandantType(mandant)) == TarmedLeistung.MandantType.PRACTITIONER && (alScaling = NumberUtils.toDouble((String)(f_al_r = this.getExtension().getLimits().get("F_AL_R")))) > 0.1) {
            scaling *= alScaling;
        }
        return scaling;
    }

    @Override
    public int getTL() {
        String tp_tl = this.getExtension().getLimits().get("TP_TL");
        return (int)Math.round(NumberUtils.toDouble((String)tp_tl) * 100.0);
    }

    @Override
    public String getDigniQuali() {
        return ((ch.elexis.core.jpa.entities.TarmedLeistung)this.getEntity()).getDigniQuali();
    }

    @Override
    public String getDigniQuanti() {
        return ((ch.elexis.core.jpa.entities.TarmedLeistung)this.getEntity()).getDigniQuanti();
    }

    @Override
    public String getExclusion() {
        curTimeHelper = LocalDate.now();
        return this.getExclusion(curTimeHelper);
    }

    public synchronized IBillableOptifier<TarmedLeistung> getOptifier() {
        if (this.tarmedOptifier == null) {
            this.tarmedOptifier = new TarmedOptifier();
        }
        return this.tarmedOptifier;
    }

    public IBillableVerifier getVerifier() {
        return this.verifier;
    }

    public String getCodeSystemName() {
        return "Tarmed";
    }

    public String getCodeSystemCode() {
        return "001";
    }

    public String getCode() {
        return ((ch.elexis.core.jpa.entities.TarmedLeistung)this.getEntity()).getCode_();
    }

    public void setCode(String value) {
        ((ch.elexis.core.jpa.entities.TarmedLeistung)this.getEntity()).setCode_(value);
    }

    public String getText() {
        return ((ch.elexis.core.jpa.entities.TarmedLeistung)this.getEntity()).getTx255();
    }

    public void setText(String value) {
        ((ch.elexis.core.jpa.entities.TarmedLeistung)this.getEntity()).setTx255(value);
    }

    @Override
    public ITarmedExtension getExtension() {
        if (this.extension == null) {
            INamedQuery query = ArzttarifeModelServiceHolder.get().getNamedQuery(ITarmedExtension.class, new String[]{"code"});
            List found = query.executeWithParameters(query.getParameterMap(new Object[]{"code", this.getId()}));
            if (!found.isEmpty()) {
                this.extension = (ITarmedExtension)found.get(0);
            }
        }
        return this.extension;
    }

    @Override
    public ITarmedLeistung getParent() {
        String parent = ((ch.elexis.core.jpa.entities.TarmedLeistung)this.getEntity()).getParent();
        if (parent != null && !"NIL".equals(parent)) {
            return (ITarmedLeistung)ArzttarifeModelServiceHolder.get().load(parent, ITarmedLeistung.class).get();
        }
        return null;
    }

    @Override
    public LocalDate getValidFrom() {
        return ((ch.elexis.core.jpa.entities.TarmedLeistung)this.getEntity()).getGueltigVon();
    }

    @Override
    public LocalDate getValidTo() {
        return ((ch.elexis.core.jpa.entities.TarmedLeistung)this.getEntity()).getGueltigBis();
    }

    @Override
    public boolean requiresSide() {
        if (this.getExtension() != null) {
            String value = this.getExtension().getLimits().get("Seite".toUpperCase());
            return "1".equals(value);
        }
        return false;
    }

    @Override
    public String getServiceTyp() {
        return StringUtils.defaultString((String)this.getExtension().getLimits().get("LEISTUNG_TYP"));
    }

    @Override
    public String getLaw() {
        return ((ch.elexis.core.jpa.entities.TarmedLeistung)this.getEntity()).getLaw();
    }

    @Override
    public String getSparte() {
        return ((ch.elexis.core.jpa.entities.TarmedLeistung)this.getEntity()).getSparte();
    }

    @Override
    public boolean isChapter() {
        return ((ch.elexis.core.jpa.entities.TarmedLeistung)this.getEntity()).isChapter();
    }

    public static String getSide(IBilled v) {
        IBillable vv = v.getBillable();
        if (vv instanceof TarmedLeistung) {
            String side = (String)v.getExtInfo((Object)"Seite");
            if ("l".equalsIgnoreCase(side)) {
                return "left";
            }
            if ("r".equalsIgnoreCase(side)) {
                return "right";
            }
        }
        return "none";
    }

    public List<TarmedLimitation> getLimitations() {
        String lim = this.getExtension().getLimits().get("limits");
        if (lim != null && !lim.isEmpty()) {
            String[] lines;
            ArrayList<TarmedLimitation> ret = new ArrayList<TarmedLimitation>();
            String[] stringArray = lines = lim.split("#");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                ret.add(TarmedLimitation.of(line).setTarmedLeistung(this));
                ++n2;
            }
            this.fix9533(ret);
            return ret;
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getServiceBlocks(LocalDate date) {
        ArrayList<String> ret = new ArrayList<String>();
        List<String> blocks = this.getExtStringListField("ServiceBlocks");
        if (!blocks.isEmpty()) {
            for (String string : blocks) {
                int dateStart = string.indexOf(91);
                String datesString = string.substring(dateStart + 1, string.length() - 1);
                String blockString = string.substring(0, dateStart);
                if (!this.isDateWithinDatesString(date, datesString)) continue;
                ret.add(blockString);
            }
        }
        return ret;
    }

    @Override
    public List<String> getServiceGroups(LocalDate date) {
        ArrayList<String> ret = new ArrayList<String>();
        List<String> groups = this.getExtStringListField("ServiceGroups");
        if (!groups.isEmpty()) {
            for (String string : groups) {
                int dateStart = string.indexOf(91);
                String datesString = string.substring(dateStart + 1, string.length() - 1);
                String groupString = string.substring(0, dateStart);
                if (!this.isDateWithinDatesString(date, datesString)) continue;
                ret.add(groupString);
            }
        }
        return ret;
    }

    @Override
    public List<String> getHierarchy(LocalDate date) {
        ArrayList<String> ret = new ArrayList<String>();
        List<String> hierarchy = this.getExtStringListField("HierarchySlaves");
        if (!hierarchy.isEmpty()) {
            for (String string : hierarchy) {
                int dateStart = string.indexOf(91);
                String datesString = string.substring(dateStart + 1, string.length() - 1);
                String codeString = string.substring(0, dateStart);
                if (!this.isDateWithinDatesString(date, datesString)) continue;
                ret.add(codeString);
            }
        }
        return ret;
    }

    public List<TarmedExclusion> getExclusions(IEncounter kons) {
        curTimeHelper = kons == null ? LocalDate.now() : kons.getDate();
        return this.getExclusions(curTimeHelper);
    }

    public List<TarmedExclusion> getExclusions(LocalDate date) {
        return TarmedKumulation.getExclusions(this.getCode(), this.isChapter() ? TarmedKumulationArt.CHAPTER : TarmedKumulationArt.SERVICE, date, this.getLaw());
    }

    public String getExclusion(LocalDate date) {
        String exclusions = TarmedKumulation.getExclusions(this.getCode(), date);
        if (exclusions == null) {
            Map<String, String> map = this.getExtension().getLimits();
            if (map == null) {
                return "";
            }
            return StringUtils.defaultString((String)map.get("exclusion"));
        }
        return StringUtils.defaultString((String)exclusions);
    }

    private boolean isDateWithinDatesString(LocalDate localDate, String datesString) {
        String[] parts = datesString.split("\\|");
        if (parts.length == 2) {
            LocalDate from = LocalDate.parse(parts[0]);
            LocalDate to = LocalDate.parse(parts[1]);
            return !(!from.isBefore(localDate) && !from.isEqual(localDate) || !to.isAfter(localDate) && !to.isEqual(localDate));
        }
        return false;
    }

    private List<String> getExtStringListField(String extKey) {
        ArrayList<String> ret = new ArrayList<String>();
        Map<String, String> map = this.getExtension().getLimits();
        String values = map.get(extKey);
        if (values != null && !values.isEmpty()) {
            String[] parts;
            String[] stringArray = parts = values.split(", ");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                ret.add(string);
                ++n2;
            }
        }
        return ret;
    }

    private void fix9533(List<TarmedLimitation> ret) {
        boolean sessionfound = false;
        for (TarmedLimitation tarmedLimitation : ret) {
            if (tarmedLimitation.getLimitationUnit() != TarmedLimitation.LimitationUnit.SESSION) continue;
            sessionfound = true;
            break;
        }
        if (sessionfound) {
            for (TarmedLimitation tarmedLimitation : ret) {
                if (tarmedLimitation.getLimitationUnit() != TarmedLimitation.LimitationUnit.COVERAGE) continue;
                tarmedLimitation.setSkip(true);
            }
        }
    }

    public String getSparteAsText() {
        return StringUtils.defaultString((String)TarmedDefinitionenUtil.getTextForSparte(this.getSparte()));
    }

    @Override
    public boolean isZuschlagsleistung() {
        boolean becauseOfType;
        String typ = this.getServiceTyp();
        boolean bl = becauseOfType = typ != null && typ.equals("Z");
        if (becauseOfType) {
            String text = this.getText();
            return text.startsWith("+") || text.startsWith("-");
        }
        return false;
    }

    public static TarmedLeistung.MandantType getMandantType(IMandator mandant) {
        Object typeObj = mandant.getExtInfo((Object)ch.elexis.core.jpa.entities.TarmedLeistung.MANDANT_TYPE_EXTINFO_KEY);
        if (typeObj instanceof String) {
            return TarmedLeistung.MandantType.valueOf((String)((String)typeObj));
        }
        return TarmedLeistung.MandantType.SPECIALIST;
    }

    public static TarmedLeistung getFromCode(String code, LocalDate date, String law) {
        IQuery query = ArzttarifeModelServiceHolder.get().getQuery(ITarmedLeistung.class);
        query.and("code_", IQuery.COMPARATOR.EQUALS, (Object)code);
        if (law != null) {
            if (!ArzttarifeUtil.isAvailableLaw(law)) {
                query.startGroup();
                query.or("law", IQuery.COMPARATOR.EQUALS, (Object)"");
                query.or("law", IQuery.COMPARATOR.EQUALS, null);
                query.andJoinGroups();
            } else {
                query.and("law", IQuery.COMPARATOR.EQUALS, (Object)law, true);
            }
        }
        List leistungen = query.execute();
        for (ITarmedLeistung tarmedLeistung : leistungen) {
            if (!date.isAfter(tarmedLeistung.getValidFrom()) && !date.equals(tarmedLeistung.getValidFrom()) || !date.isBefore(tarmedLeistung.getValidTo()) && !date.equals(tarmedLeistung.getValidTo())) continue;
            return (TarmedLeistung)tarmedLeistung;
        }
        return null;
    }

    public static TarmedLeistung getFromCode(String code, String law) {
        return TarmedLeistung.getFromCode(code, LocalDate.now(), law);
    }

    @Override
    public String getNickname() {
        return StringUtils.defaultString((String)((ch.elexis.core.jpa.entities.TarmedLeistung)this.getEntity()).getNickname());
    }

    @Override
    public void setNickname(String value) {
        ((ch.elexis.core.jpa.entities.TarmedLeistung)this.getEntity()).setNickname(value);
    }

    @Override
    public List<ITarmedKumulation> getKumulations(TarmedKumulationArt type) {
        IQuery query = ArzttarifeModelServiceHolder.get().getQuery(ITarmedKumulation.class);
        if (this.getLaw() != null && !this.getLaw().isEmpty()) {
            query.and("law", IQuery.COMPARATOR.EQUALS, (Object)this.getLaw());
        }
        query.startGroup();
        query.and("masterCode", IQuery.COMPARATOR.EQUALS, (Object)this.getCode());
        query.and("masterArt", IQuery.COMPARATOR.EQUALS, (Object)type.getArt());
        query.startGroup();
        query.and("slaveCode", IQuery.COMPARATOR.EQUALS, (Object)this.getCode());
        query.and("slaveArt", IQuery.COMPARATOR.EQUALS, (Object)type.getArt());
        query.orJoinGroups();
        query.andJoinGroups();
        List kumulations = query.execute();
        if (kumulations == null || kumulations.isEmpty()) {
            return Collections.emptyList();
        }
        return kumulations.stream().filter(k -> k.isValidKumulation(this.getValidFrom())).collect(Collectors.toList());
    }

    public String getLabel() {
        return String.valueOf(this.getCode()) + " " + this.getText() + (this.getLaw() != null && !this.getLaw().isEmpty() ? " (" + this.getLaw() + ")" : "");
    }

    public Money getPrice() {
        Money ret = this.getNetPrice();
        Optional systemFactor = BillingServiceHolder.get().getBillingSystemFactor(this.getCodeSystemName(), LocalDate.now());
        if (systemFactor.isPresent()) {
            return ret.multiply(((IBillingSystemFactor)systemFactor.get()).getFactor());
        }
        return ret;
    }

    public void setPrice(Money value) {
        throw new UnsupportedOperationException();
    }

    public Money getNetPrice() {
        return new Money(this.getAL() + this.getTL());
    }

    public void setNetPrice(Money value) {
        throw new UnsupportedOperationException();
    }

    public void setMinutes(int value) {
        throw new UnsupportedOperationException();
    }

    public boolean addXid(String domain, String id, boolean updateIfExists) {
        return XidServiceHolder.get().addXid((Identifiable)this, domain, id, updateIfExists);
    }

    public IXid getXid(String domain) {
        return XidServiceHolder.get().getXid((Identifiable)this, domain);
    }
}

