/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.tardoc.model;

import ch.elexis.arzttarife_schweiz.Messages;
import ch.elexis.base.ch.arzttarife.model.service.CoreModelServiceHolder;
import ch.elexis.base.ch.arzttarife.tardoc.model.TardocGroup;
import ch.elexis.base.ch.arzttarife.tardoc.model.TardocLeistung;
import ch.elexis.base.ch.arzttarife.tarmed.model.TarmedUtil;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.ch.BillingLaw;
import ch.elexis.core.services.INativeQuery;
import ch.rgw.tools.Result;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;

public class TardocLimitation {
    private int amount;
    private String per;
    private String operator;
    private LimitationUnit limitationUnit;
    private int limitationAmount;
    private int electronicBilling;
    private boolean skip = false;
    private TardocLeistung tardocLeistung;
    private TardocGroup tarmedGroup;
    private static final String VERRECHNET_BYPATIENT_ANDCODE = "SELECT leistungen.ID FROM leistungen, behandlungen, faelle WHERE leistungen.deleted = '0' AND leistungen.deleted = behandlungen.deleted AND leistungen.BEHANDLUNG = behandlungen.ID AND leistungen.KLASSE = 'ch.elexis.data.TardocLeistung' AND faelle.ID = behandlungen.fallID AND faelle.PatientID = ?1 AND leistungen.LEISTG_CODE like ?2 ORDER BY behandlungen.Datum ASC";
    private static final String VERRECHNET_BYMANDANT_ANDCODE_DURING = "SELECT leistungen.ID FROM leistungen, behandlungen, faelle WHERE leistungen.deleted = '0' AND leistungen.deleted = behandlungen.deleted AND leistungen.BEHANDLUNG = behandlungen.ID AND leistungen.KLASSE = 'ch.elexis.data.TardocLeistung' AND faelle.ID = behandlungen.fallID AND faelle.PatientID = ?1 AND leistungen.LEISTG_CODE like ?2 AND behandlungen.Datum >= ?3 AND behandlungen.MandantID = ?4";
    private static final String VERRECHNET_BYCOVERAGE_ANDCODE = "SELECT leistungen.ID FROM leistungen, behandlungen WHERE leistungen.deleted = '0' AND leistungen.deleted = behandlungen.deleted AND leistungen.BEHANDLUNG = behandlungen.ID AND leistungen.KLASSE = 'ch.elexis.data.TardocLeistung' AND leistungen.LEISTG_CODE like ?1 AND behandlungen.FallID = ?2";

    public static TardocLimitation of(String limitation) {
        TardocLimitation ret = new TardocLimitation();
        String[] parts = limitation.split(",");
        if (parts.length >= 5) {
            if (parts[0] != null && !parts[0].isEmpty()) {
                ret.operator = parts[0].trim();
            }
            if (parts[1] != null && !parts[1].isEmpty()) {
                ret.amount = Float.valueOf(parts[1].trim()).intValue();
            }
            if (parts[2] != null && !parts[2].isEmpty()) {
                ret.limitationAmount = Float.valueOf(parts[2].trim()).intValue();
            }
            if (parts[3] != null && !parts[3].isEmpty()) {
                ret.per = parts[3].trim();
            }
            if (parts[4] != null && !parts[4].isEmpty()) {
                ret.limitationUnit = LimitationUnit.from(Float.valueOf(parts[4].trim()).intValue());
            }
        }
        if (parts.length >= 6) {
            if (parts[5] != null && !parts[5].isEmpty()) {
                ret.electronicBilling = Float.valueOf(parts[5].trim()).intValue();
            }
        } else {
            ret.electronicBilling = 0;
        }
        return ret;
    }

    public TardocLimitation setTardocLeistung(TardocLeistung tarmedLeistung) {
        this.tardocLeistung = tarmedLeistung;
        return this;
    }

    public TardocLimitation setTardocGroup(TardocGroup tarmedGroup) {
        this.tarmedGroup = tarmedGroup;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.limitationUnit == LimitationUnit.SESSION) {
            sb.append(String.valueOf(Messages.TarmedOptifier_codemax) + this.amount + Messages.TarmedOptifier_perSession);
        } else if (this.limitationUnit == LimitationUnit.SIDE) {
            sb.append(String.valueOf(Messages.TarmedOptifier_codemax) + this.amount + Messages.TarmedOptifier_perSide);
        } else if (this.limitationUnit == LimitationUnit.DAY && this.limitationAmount == 1) {
            sb.append(String.valueOf(Messages.TarmedOptifier_codemax) + this.amount + Messages.TarmedOptifier_perDay);
        } else if (this.limitationUnit == LimitationUnit.DAY && this.limitationAmount > 1) {
            if (this.tarmedGroup != null) {
                sb.append(String.valueOf(String.format(Messages.TarmedOptifier_groupmax, this.tarmedGroup.getCode())) + this.amount + String.format(Messages.TarmedOptifier_perDays, this.limitationAmount));
            } else {
                sb.append(String.valueOf(Messages.TarmedOptifier_codemax) + this.amount + String.format(Messages.TarmedOptifier_perDays, this.limitationAmount));
            }
        } else if (this.limitationUnit == LimitationUnit.WEEK) {
            if (this.tarmedGroup != null) {
                sb.append(String.valueOf(String.format(Messages.TarmedOptifier_groupmax, this.tarmedGroup.getCode())) + this.amount + String.format(Messages.TarmedOptifier_perWeeks, this.limitationAmount));
            } else {
                sb.append(String.valueOf(Messages.TarmedOptifier_codemax) + this.amount + String.format(Messages.TarmedOptifier_perWeeks, this.limitationAmount));
            }
        } else if (this.limitationUnit == LimitationUnit.MONTH) {
            if (this.tarmedGroup != null) {
                sb.append(String.valueOf(String.format(Messages.TarmedOptifier_groupmax, this.tarmedGroup.getCode())) + this.amount + String.format(Messages.TarmedOptifier_perMonth, this.limitationAmount));
            } else {
                sb.append(String.valueOf(Messages.TarmedOptifier_codemax) + this.amount + String.format(Messages.TarmedOptifier_perMonth, this.limitationAmount));
            }
        } else if (this.limitationUnit == LimitationUnit.YEAR) {
            if (this.tarmedGroup != null) {
                sb.append(String.valueOf(String.format(Messages.TarmedOptifier_groupmax, this.tarmedGroup.getCode())) + this.amount + String.format(Messages.TarmedOptifier_perYears, this.limitationAmount));
            } else {
                sb.append(String.valueOf(Messages.TarmedOptifier_codemax) + this.amount + String.format(Messages.TarmedOptifier_perYears, this.limitationAmount));
            }
        } else if (this.limitationUnit == LimitationUnit.COVERAGE) {
            sb.append(String.valueOf(Messages.TarmedOptifier_codemax) + this.amount + Messages.TarmedOptifier_perCoverage);
        } else if (this.limitationUnit == LimitationUnit.PATIENT_SESSION) {
            sb.append(String.valueOf(Messages.TarmedOptifier_codemax) + this.amount + Messages.TarmedOptifier_perPatient);
        } else {
            sb.append("amount " + this.amount + "x unit " + this.limitationAmount + "x" + (Object)((Object)this.limitationUnit));
        }
        return sb.toString();
    }

    public boolean isTestable() {
        return this.limitationUnit == LimitationUnit.SIDE || this.limitationUnit == LimitationUnit.SESSION || this.limitationUnit == LimitationUnit.DAY || this.limitationUnit == LimitationUnit.WEEK || this.limitationUnit == LimitationUnit.MONTH || this.limitationUnit == LimitationUnit.YEAR || this.limitationUnit == LimitationUnit.COVERAGE || this.limitationUnit == LimitationUnit.PATIENT_SESSION;
    }

    public Result<IBilled> test(IEncounter kons, IBilled newVerrechnet) {
        if (this.limitationUnit == LimitationUnit.SIDE || this.limitationUnit == LimitationUnit.SESSION) {
            return this.testSideOrSession(kons, newVerrechnet);
        }
        if (this.limitationUnit == LimitationUnit.DAY && this.limitationAmount == 1) {
            return this.testDay(kons, newVerrechnet);
        }
        if (this.limitationUnit == LimitationUnit.DAY && this.limitationAmount > 1 || this.limitationUnit == LimitationUnit.WEEK || this.limitationUnit == LimitationUnit.MONTH || this.limitationUnit == LimitationUnit.YEAR) {
            return this.testDuration(kons, newVerrechnet);
        }
        if (this.limitationUnit == LimitationUnit.COVERAGE) {
            return this.testCoverage(kons, newVerrechnet);
        }
        if (this.limitationUnit == LimitationUnit.PATIENT_SESSION) {
            return this.testPatientSession(kons, newVerrechnet);
        }
        return new Result(null);
    }

    private Result<IBilled> testPatientSession(IEncounter kons, IBilled newVerrechnet) {
        IPatient patient;
        List encounters;
        List alreadyBilled;
        double alreadyBilledAmount;
        Result ret = new Result(null);
        if (this.shouldSkipTest()) {
            return ret;
        }
        if (this.limitationAmount == 1 && this.operator.equals("<=") && (alreadyBilledAmount = (alreadyBilled = (encounters = (patient = kons.getPatient()).getCoverages().stream().flatMap(c -> c.getEncounters().stream()).collect(Collectors.toList())).stream().flatMap(e -> this.filterWithSameCode(newVerrechnet, e.getBilled()).stream()).collect(Collectors.toList())).stream().mapToDouble(b -> b.getAmount()).sum()) > (double)this.amount) {
            ret = new Result(Result.SEVERITY.WARNING, 2, this.toString(), null, false);
        }
        return ret;
    }

    private Result<IBilled> testCoverage(IEncounter kons, IBilled verrechnet) {
        Result ret = new Result(null);
        if (this.shouldSkipTest()) {
            return ret;
        }
        if (this.operator.equals("<=")) {
            if (this.tarmedGroup == null) {
                List<IBilled> verrechnetByCoverage = this.getVerrechnetByCoverageAndCode(kons, this.tardocLeistung.getCode());
                if (this.getVerrechnetCount(verrechnetByCoverage = this.filterWithSameCode(verrechnet, verrechnetByCoverage)) > this.amount) {
                    ret = new Result(Result.SEVERITY.WARNING, 2, this.toString(), null, false);
                }
            } else {
                ArrayList<IBilled> allVerrechnetOfGroup = new ArrayList<IBilled>();
                List<String> serviceCodes = this.tarmedGroup.getServices();
                for (String code : serviceCodes) {
                    List<IBilled> verrechnetByCoverageAndCode = this.getVerrechnetByCoverageAndCode(kons, code);
                    allVerrechnetOfGroup.addAll(verrechnetByCoverageAndCode);
                }
                int verrechnetCount = this.getVerrechnetCount(allVerrechnetOfGroup);
                if (verrechnetCount > this.amount) {
                    ret = new Result(Result.SEVERITY.WARNING, 2, this.toString(), null, false);
                }
            }
        }
        return ret;
    }

    private Result<IBilled> testDuration(IEncounter kons, IBilled verrechnet) {
        Result ret = new Result(null);
        if (this.shouldSkipTest()) {
            return ret;
        }
        if (this.operator.equals("<=")) {
            if (this.tarmedGroup == null) {
                List<IBilled> verrechnetByMandant = this.getVerrechnetByRechnungsstellerAndCodeDuringPeriod(kons, verrechnet.getBillable().getCode());
                if (this.getVerrechnetCount(verrechnetByMandant) > this.amount) {
                    ret = new Result(Result.SEVERITY.WARNING, 2, this.toString(), (Object)verrechnet, false);
                }
            } else {
                ArrayList<IBilled> allVerrechnetOfGroup = new ArrayList<IBilled>();
                List<String> serviceCodes = this.tarmedGroup.getServices();
                for (String code : serviceCodes) {
                    allVerrechnetOfGroup.addAll(this.getVerrechnetByRechnungsstellerAndCodeDuringPeriod(kons, code));
                }
                if (this.getVerrechnetCount(allVerrechnetOfGroup) > this.amount) {
                    ret = new Result(Result.SEVERITY.WARNING, 2, this.toString(), (Object)verrechnet, false);
                }
            }
        }
        return ret;
    }

    private int getVerrechnetCount(List<IBilled> verrechnete) {
        int ret = 0;
        for (IBilled verrechnet : verrechnete) {
            ret = (int)((double)ret + verrechnet.getAmount());
        }
        return ret;
    }

    public static List<IBilled> findVerrechnetByPatientCodeDuringPeriod(IPatient patient, String code) {
        ArrayList<IBilled> all = new ArrayList<IBilled>();
        INativeQuery nativeQuery = CoreModelServiceHolder.get().getNativeQuery(VERRECHNET_BYPATIENT_ANDCODE);
        Map parameterMap = nativeQuery.getIndexedParameterMap(new Object[]{1, patient.getId(), 2, String.valueOf(code) + "%"});
        Iterator result = nativeQuery.executeWithParameters(parameterMap).iterator();
        while (result.hasNext()) {
            String next = result.next().toString();
            IBilled load = (IBilled)CoreModelServiceHolder.get().load(next, IBilled.class).get();
            all.add(load);
        }
        return all;
    }

    private List<IBilled> getVerrechnetByRechnungsstellerAndCodeDuringPeriod(IEncounter kons, String code) {
        IContact rechnungssteller = kons.getMandator().getBiller();
        if (rechnungssteller != null) {
            List<Object> all = TardocLimitation.findVerrechnetByPatientCodeDuringPeriod(kons.getCoverage().getPatient(), code);
            all = all.parallelStream().filter(billed -> {
                IEncounter encounter = billed.getEncounter();
                IMandator mandator = null;
                IContact biller = null;
                if (encounter != null && (mandator = encounter.getMandator()) != null && (biller = mandator.getBiller()) != null) {
                    return biller.equals(rechnungssteller);
                }
                LoggerFactory.getLogger(this.getClass()).warn("Missing object in chain for IBilled [{}]: [{}], [{}], [{}]", new Object[]{billed.getId(), encounter, mandator, biller});
                return false;
            }).collect(Collectors.toList());
            all = this.filterValidCodeForKonsultation(code, kons, all);
            LocalDate konsDate = kons.getDate();
            List<VerrechnetPeriod> grouped = this.getGroupedByPeriod(all);
            for (VerrechnetPeriod verrechnetPeriod : grouped) {
                if (!verrechnetPeriod.isDateInPeriod(konsDate)) continue;
                return verrechnetPeriod.getVerrechnete();
            }
        }
        return Collections.emptyList();
    }

    private List<VerrechnetPeriod> getGroupedByPeriod(List<IBilled> verrechnete) {
        if (!verrechnete.isEmpty()) {
            ArrayList<VerrechnetPeriod> ret = new ArrayList<VerrechnetPeriod>();
            for (IBilled verrechnet : verrechnete) {
                if (ret.isEmpty()) {
                    ret.add(new VerrechnetPeriod(verrechnet));
                    continue;
                }
                boolean added = false;
                for (VerrechnetPeriod verrechnetPeriod : ret) {
                    if (!verrechnetPeriod.isInPeriod(verrechnet)) continue;
                    verrechnetPeriod.addVerrechnet(verrechnet);
                    added = true;
                    break;
                }
                if (added) continue;
                ret.add(new VerrechnetPeriod(verrechnet));
            }
            return ret;
        }
        return Collections.emptyList();
    }

    private List<IBilled> getVerrechnetByMandantAndCodeDuring(IEncounter kons, String code) {
        LocalDate fromDate = this.getDuringStartDate(kons);
        IMandator mandant = kons.getMandator();
        ArrayList<IBilled> ret = new ArrayList<IBilled>();
        if (fromDate != null && mandant != null) {
            INativeQuery nativeQuery = CoreModelServiceHolder.get().getNativeQuery(VERRECHNET_BYMANDANT_ANDCODE_DURING);
            Map parameterMap = nativeQuery.getIndexedParameterMap(new Object[]{1, kons.getCoverage().getPatient().getId(), 2, String.valueOf(code) + "%", 3, fromDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")), 4, mandant.getId()});
            Iterator result = nativeQuery.executeWithParameters(parameterMap).iterator();
            while (result.hasNext()) {
                String next = result.next().toString();
                IBilled load = (IBilled)CoreModelServiceHolder.get().load(next, IBilled.class).get();
                ret.add(load);
            }
        }
        return ret;
    }

    private List<IBilled> getVerrechnetByCoverageAndCode(IEncounter kons, String code) {
        ArrayList<IBilled> ret = new ArrayList<IBilled>();
        if (kons != null && kons.getCoverage() != null) {
            INativeQuery nativeQuery = CoreModelServiceHolder.get().getNativeQuery(VERRECHNET_BYCOVERAGE_ANDCODE);
            Map parameterMap = nativeQuery.getIndexedParameterMap(new Object[]{1, String.valueOf(code) + "%", 2, kons.getCoverage().getId()});
            Iterator result = nativeQuery.executeWithParameters(parameterMap).iterator();
            while (result.hasNext()) {
                String next = result.next().toString();
                IBilled load = (IBilled)CoreModelServiceHolder.get().load(next, IBilled.class).get();
                ret.add(load);
            }
        }
        return ret;
    }

    private LocalDate getDuringStartDate(IEncounter kons) {
        LocalDate leistungDate;
        LocalDate konsDate = kons.getDate();
        LocalDate ret = null;
        if (this.limitationUnit == LimitationUnit.WEEK) {
            ret = konsDate.minus(this.limitationAmount, ChronoUnit.WEEKS);
        } else if (this.limitationUnit == LimitationUnit.MONTH) {
            ret = konsDate.minus(this.limitationAmount, ChronoUnit.MONTHS);
        } else if (this.limitationUnit == LimitationUnit.YEAR) {
            ret = konsDate.minus(this.limitationAmount, ChronoUnit.YEARS);
        }
        if (this.tardocLeistung != null && ret != null && ret.isBefore(leistungDate = this.tardocLeistung.getValidFrom())) {
            ret = leistungDate;
        }
        return ret;
    }

    private List<IBilled> filterWithSameCode(IBilled verrechnet, List<IBilled> list) {
        ArrayList<IBilled> ret = new ArrayList<IBilled>();
        String matchCode = verrechnet.getCode();
        if (matchCode != null && !matchCode.isEmpty()) {
            for (IBilled element : list) {
                if (!matchCode.equals(element.getCode())) continue;
                ret.add(element);
            }
        }
        return ret;
    }

    private List<IBilled> filterValidCodeForKonsultation(String code, IEncounter kons, List<IBilled> list) {
        ArrayList<IBilled> ret = new ArrayList<IBilled>();
        BillingLaw law = kons.getCoverage().getBillingSystem().getLaw();
        TardocLeistung validForKons = TardocLeistung.getFromCode(code, kons.getDate(), law.name());
        if (validForKons != null) {
            String matchCode = validForKons.getCode();
            if (matchCode != null && !matchCode.isEmpty()) {
                for (IBilled element : list) {
                    if (!matchCode.equals(element.getCode())) continue;
                    ret.add(element);
                }
            }
        } else {
            ret.addAll(list);
        }
        return ret;
    }

    private Result<IBilled> testDay(IEncounter kons, IBilled verrechnet) {
        Result ret = new Result(null);
        if (this.shouldSkipTest()) {
            return ret;
        }
        if (this.limitationAmount == 1 && this.operator.equals("<=") && this.getVerrechnetAmount(verrechnet) > this.amount) {
            ret = new Result(Result.SEVERITY.WARNING, 2, this.toString(), null, false);
        }
        return ret;
    }

    private Result<IBilled> testSideOrSession(IEncounter kons, IBilled verrechnet) {
        Result ret = new Result(null);
        if (this.shouldSkipTest()) {
            return ret;
        }
        if (this.limitationAmount == 1 && this.operator.equals("<=") && this.getVerrechnetAmount(verrechnet) > this.amount) {
            if (this.limitationUnit == LimitationUnit.SESSION) {
                ret = new Result(Result.SEVERITY.WARNING, 2, this.toString(), null, false);
            } else if (this.limitationUnit == LimitationUnit.SIDE) {
                ret = new Result(Result.SEVERITY.WARNING, 2, this.toString(), null, false);
            }
        }
        return ret;
    }

    private List<IBilled> getSameVerrechnetOfKons(IBilled verrechnet) {
        ArrayList<IBilled> ret = new ArrayList<IBilled>();
        Class<?> verrechnetClass = verrechnet.getClass();
        String verrechnetCode = verrechnet.getCode();
        if (verrechnetClass != null && verrechnetCode != null) {
            IEncounter kons = verrechnet.getEncounter();
            for (IBilled leistung : kons.getBilled()) {
                if (!verrechnetClass.equals(verrechnet.getClass()) || !verrechnetCode.equals(leistung.getCode())) continue;
                if (this.limitationUnit == LimitationUnit.SIDE) {
                    if (!TardocLeistung.getSide(verrechnet).equals(TardocLeistung.getSide(leistung))) continue;
                    ret.add(leistung);
                    continue;
                }
                ret.add(leistung);
            }
        }
        return ret;
    }

    private int getVerrechnetAmount(IBilled verrechnet) {
        List<IBilled> sameVerrechnet = this.getSameVerrechnetOfKons(verrechnet);
        return this.getVerrechnetCount(sameVerrechnet);
    }

    private boolean shouldSkipTest() {
        if (this.skip) {
            return this.skip;
        }
        return this.shouldSkipElectronicBilling();
    }

    private boolean shouldSkipElectronicBilling() {
        if (this.electronicBilling > 0) {
            return TarmedUtil.getConfigValue(this.getClass(), IMandator.class, "TarmedBillElectronic", false);
        }
        return false;
    }

    public LimitationUnit getLimitationUnit() {
        return this.limitationUnit;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setSkip(boolean value) {
        this.skip = true;
    }

    public static enum LimitationUnit {
        LOCATION_SESSION,
        SIDE,
        SESSION,
        PATIENT_SESSION,
        COVERAGE,
        STAY,
        TESTSERIES,
        PREGNANCY,
        BIRTH,
        RADIANTEXPOSURE,
        TRANSMITTAL,
        AUTOPSY,
        EXPERTISE,
        INTERVENTION_SESSION,
        CATEGORY_DAY,
        DAY,
        WEEK,
        MONTH,
        YEAR,
        JOINTREGION,
        REGION_SIDE,
        JOINTREGION_SIDE,
        MAINSERVICE,
        SESSION_YEAR,
        SESSION_COVERAGE,
        SESSION_PATIENT;


        public static LimitationUnit from(int parseInt) {
            switch (parseInt) {
                case 6: {
                    return LOCATION_SESSION;
                }
                case 7: {
                    return SESSION;
                }
                case 8: {
                    return COVERAGE;
                }
                case 9: {
                    return PATIENT_SESSION;
                }
                case 10: {
                    return SIDE;
                }
                case 11: {
                    return STAY;
                }
                case 12: {
                    return TESTSERIES;
                }
                case 13: {
                    return PREGNANCY;
                }
                case 14: {
                    return BIRTH;
                }
                case 15: 
                case 31: {
                    return RADIANTEXPOSURE;
                }
                case 16: {
                    return TRANSMITTAL;
                }
                case 17: {
                    return AUTOPSY;
                }
                case 18: {
                    return EXPERTISE;
                }
                case 19: {
                    return INTERVENTION_SESSION;
                }
                case 20: {
                    return CATEGORY_DAY;
                }
                case 21: {
                    return DAY;
                }
                case 22: {
                    return WEEK;
                }
                case 23: {
                    return MONTH;
                }
                case 26: {
                    return YEAR;
                }
                case 40: {
                    return JOINTREGION;
                }
                case 41: {
                    return REGION_SIDE;
                }
                case 42: {
                    return JOINTREGION_SIDE;
                }
                case 45: {
                    return MAINSERVICE;
                }
                case 51: {
                    return SESSION_YEAR;
                }
                case 52: {
                    return SESSION_COVERAGE;
                }
                case 53: 
                case 54: {
                    return SESSION_PATIENT;
                }
            }
            return null;
        }
    }

    private class VerrechnetPeriod {
        private LocalDate start;
        private LocalDate end;
        private List<IBilled> verrechnete;

        private VerrechnetPeriod(IBilled verrechnet) {
            this.start = verrechnet.getEncounter().getDate();
            if (TardocLimitation.this.limitationUnit == LimitationUnit.DAY) {
                this.end = this.start.plus(TardocLimitation.this.limitationAmount, ChronoUnit.DAYS);
            } else if (TardocLimitation.this.limitationUnit == LimitationUnit.WEEK) {
                this.end = this.start.plus(TardocLimitation.this.limitationAmount, ChronoUnit.WEEKS);
            } else if (TardocLimitation.this.limitationUnit == LimitationUnit.MONTH) {
                this.end = this.start.plus(TardocLimitation.this.limitationAmount, ChronoUnit.MONTHS);
            } else if (TardocLimitation.this.limitationUnit == LimitationUnit.YEAR) {
                this.end = this.start.plus(TardocLimitation.this.limitationAmount, ChronoUnit.YEARS);
            }
            this.verrechnete = new ArrayList<IBilled>();
            this.verrechnete.add(verrechnet);
        }

        public List<IBilled> getVerrechnete() {
            return this.verrechnete;
        }

        private boolean isInPeriod(IBilled verrechnet) {
            LocalDate matchDate = verrechnet.getEncounter().getDate();
            return this.isDateInPeriod(matchDate);
        }

        private boolean isDateInPeriod(LocalDate date) {
            return !(!date.isAfter(this.start) && !date.isEqual(this.start) || !date.isBefore(this.end) && !date.isEqual(this.end));
        }

        private void addVerrechnet(IBilled verrechnet) {
            this.verrechnete.add(verrechnet);
        }
    }
}

