/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.tardoc.model;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.codes.ICodingContribution;
import ch.elexis.core.findings.util.model.TransientCoding;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.LoggerFactory;

@Component
public class TardocDignitaetCodingContribution
implements ICodingContribution {
    private List<ICoding> codes;

    @Activate
    public void activate() {
        this.codes = new ArrayList<ICoding>();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (CSVReader reader = new CSVReaderBuilder((Reader)new InputStreamReader(this.getClass().getResourceAsStream("/rsc/tardoc_dignitaet_uniq.csv"))).withCSVParser((ICSVParser)new CSVParserBuilder().withSeparator(',').withQuoteChar('\"').build()).withKeepCarriageReturn(false).build();){
                for (String[] line : reader.readAll()) {
                    this.codes.add((ICoding)new TransientCoding("tardoc_dignitaet", StringUtils.leftPad((String)line[0], (int)4, (char)'0'), line[1]));
                }
                this.codes.sort((l, r) -> l.getCode().compareTo(r.getCode()));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Exception on activation", (Throwable)e);
        }
    }

    public String getCodeSystem() {
        return "tardoc_dignitaet";
    }

    public List<ICoding> getCodes() {
        return this.codes;
    }

    public Optional<ICoding> getCode(String code) {
        return this.codes.stream().filter(c -> c.getCode().equals(code)).findAny();
    }
}

