/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.physio.model;

import ch.elexis.base.ch.arzttarife.model.service.CoreModelServiceHolder;
import ch.elexis.base.ch.arzttarife.physio.IPhysioLeistung;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.model.IBillableOptifier;
import ch.elexis.core.model.IBillableVerifier;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IBillingSystemFactor;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.billable.AbstractOptifier;
import ch.elexis.core.model.billable.DefaultVerifier;
import ch.elexis.core.services.holder.BillingServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.XidServiceHolder;
import java.time.LocalDate;
import java.util.Optional;

public class PhysioLeistung
extends AbstractIdDeleteModelAdapter<ch.elexis.core.jpa.entities.PhysioLeistung>
implements Identifiable,
IPhysioLeistung {
    public static final String STS_CLASS = "ch.elexis.data.PhysioLeistung";
    private static IBillableOptifier<PhysioLeistung> optifier;
    private IBillableVerifier verifier = new DefaultVerifier();

    public PhysioLeistung(ch.elexis.core.jpa.entities.PhysioLeistung entity) {
        super((EntityWithId)entity);
    }

    public synchronized IBillableOptifier<PhysioLeistung> getOptifier() {
        if (optifier == null) {
            optifier = new AbstractOptifier<PhysioLeistung>(CoreModelServiceHolder.get(), ContextServiceHolder.get()){

                protected void setPrice(PhysioLeistung billable, IBilled billed) {
                    Optional<IBillingSystemFactor> billingFactor = this.getFactor(billed.getEncounter());
                    if (billingFactor.isPresent()) {
                        billed.setFactor(billingFactor.get().getFactor());
                    } else {
                        billed.setFactor(1.0);
                    }
                    int points = 0;
                    if (billable.getTP() != null) {
                        try {
                            points = Integer.valueOf(billable.getTP());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    billed.setPoints(points);
                }

                public Optional<IBillingSystemFactor> getFactor(IEncounter encounter) {
                    return BillingServiceHolder.get().getBillingSystemFactor(encounter.getCoverage().getBillingSystem().getName(), encounter.getDate());
                }
            };
        }
        return optifier;
    }

    public IBillableVerifier getVerifier() {
        return this.verifier;
    }

    public String getCodeSystemName() {
        return "Physiotherapie";
    }

    public String getCodeSystemCode() {
        return "311";
    }

    public String getCode() {
        return this.getZiffer();
    }

    public void setCode(String value) {
    }

    public String getText() {
        return ((ch.elexis.core.jpa.entities.PhysioLeistung)this.getEntity()).getTitel();
    }

    public void setText(String value) {
        ((ch.elexis.core.jpa.entities.PhysioLeistung)this.getEntity()).setTitel(value);
    }

    @Override
    public LocalDate getValidFrom() {
        return ((ch.elexis.core.jpa.entities.PhysioLeistung)this.getEntity()).getValidFrom();
    }

    @Override
    public void setValidFrom(LocalDate value) {
        ((ch.elexis.core.jpa.entities.PhysioLeistung)this.getEntity()).setValidFrom(value);
    }

    @Override
    public LocalDate getValidTo() {
        return ((ch.elexis.core.jpa.entities.PhysioLeistung)this.getEntity()).getValidUntil();
    }

    @Override
    public void setValidTo(LocalDate value) {
        ((ch.elexis.core.jpa.entities.PhysioLeistung)this.getEntity()).setValidUntil(value);
    }

    @Override
    public String getTP() {
        return ((ch.elexis.core.jpa.entities.PhysioLeistung)this.getEntity()).getTp();
    }

    @Override
    public void setTP(String value) {
        ((ch.elexis.core.jpa.entities.PhysioLeistung)this.getEntity()).setTp(value);
    }

    @Override
    public String getZiffer() {
        return ((ch.elexis.core.jpa.entities.PhysioLeistung)this.getEntity()).getZiffer();
    }

    @Override
    public void setZiffer(String value) {
        ((ch.elexis.core.jpa.entities.PhysioLeistung)this.getEntity()).setZiffer(value);
    }

    @Override
    public String getDescription() {
        return ((ch.elexis.core.jpa.entities.PhysioLeistung)this.getEntity()).getDescription();
    }

    @Override
    public void setDescription(String value) {
        ((ch.elexis.core.jpa.entities.PhysioLeistung)this.getEntity()).setDescription(value);
    }

    public String getLabel() {
        return String.valueOf(this.getCode()) + " " + this.getText() + (((ch.elexis.core.jpa.entities.PhysioLeistung)this.getEntity()).getLaw() != null && !((ch.elexis.core.jpa.entities.PhysioLeistung)this.getEntity()).getLaw().isEmpty() ? " (" + ((ch.elexis.core.jpa.entities.PhysioLeistung)this.getEntity()).getLaw() + ")" : "");
    }

    public boolean addXid(String domain, String id, boolean updateIfExists) {
        return XidServiceHolder.get().addXid((Identifiable)this, domain, id, updateIfExists);
    }

    public IXid getXid(String domain) {
        return XidServiceHolder.get().getXid((Identifiable)this, domain);
    }

    @Override
    public String getLaw() {
        return ((ch.elexis.core.jpa.entities.PhysioLeistung)this.getEntity()).getLaw();
    }
}

