/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.occupational.model.importer;

import ch.elexis.base.ch.arzttarife.tarmed.model.importer.EntityUtil;
import ch.elexis.core.importer.div.importers.ExcelWrapper;
import ch.elexis.core.interfaces.AbstractReferenceDataImporter;
import ch.elexis.core.interfaces.IReferenceDataImporter;
import ch.elexis.core.jpa.entities.OccupationalLeistung;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.osgi.service.component.annotations.Component;
import org.slf4j.LoggerFactory;

@Component(property={"referenceDataId=occupational"})
public class OccupationalReferenceDataImporter
extends AbstractReferenceDataImporter
implements IReferenceDataImporter {
    public IStatus performImport(IProgressMonitor monitor, InputStream input, Integer newVersion) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IStatus ret = Status.OK_STATUS;
        ExcelWrapper exw = new ExcelWrapper();
        exw.setFieldTypes(new Class[]{String.class, String.class, String.class});
        if (exw.load(input, 0)) {
            int first = exw.getFirstRow();
            int last = exw.getLastRow();
            int count = last - first;
            monitor.beginTask("Arbeitsmedizinische Vorsorgeuntersuchungen Import", count);
            ArrayList<Object> imported = new ArrayList<Object>();
            ArrayList<Object> closed = new ArrayList<Object>();
            int i = 0;
            while (i < last) {
                List line = exw.getRow(i);
                if (line == null) break;
                if (!line.isEmpty() && ((String)line.get(0)).length() >= 4 && !((String)line.get(0)).startsWith("Ziffer")) {
                    LocalDate validFrom = LocalDate.of(2018, 1, 1);
                    List<String> codes = this.parseCode((String)line.get(0));
                    for (String code : codes) {
                        List<OccupationalLeistung> existing = this.getExisting(code, validFrom);
                        if (!existing.isEmpty()) continue;
                        OccupationalLeistung occupationalLeistung = new OccupationalLeistung();
                        occupationalLeistung.setCode(code);
                        occupationalLeistung.setCodeText(StringUtils.abbreviate((String)((String)line.get(1)).replace("\n", "").replace("\r", ""), (int)255));
                        occupationalLeistung.setValidFrom(validFrom);
                        occupationalLeistung.setTp(this.parseTp(code, (String)line.get(2)));
                        imported.add(occupationalLeistung);
                    }
                }
                ++i;
            }
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Closing " + closed.size() + " and creating " + imported.size() + " tarifs");
            EntityUtil.save(closed);
            EntityUtil.save(imported);
            monitor.done();
            if (newVersion != null) {
                OccupationalReferenceDataImporter.setCurrentVersion(newVersion);
            }
        } else {
            ret = Status.CANCEL_STATUS;
        }
        return ret;
    }

    private List<String> parseCode(String code) {
        String[] parts;
        ArrayList<String> ret = new ArrayList<String>();
        String codes = code.replaceAll(",", ".").replaceAll("(\r\n|\r|\n)", "");
        String[] stringArray = parts = codes.split("\\+");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if ((string = string.trim()).indexOf(46) == -1) {
                string = String.valueOf(string) + ".00";
            } else {
                try {
                    Float value = Float.valueOf(Float.parseFloat(string));
                    string = String.format("%.02f", value).replaceAll(",", ".");
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ret.add(string);
            ++n2;
        }
        return ret;
    }

    private String parseTp(String code, String string) {
        try {
            Float value = Float.valueOf(Float.parseFloat(string.replaceAll(",", ".")));
            value = Float.valueOf(value.floatValue() * 100.0f);
            return Integer.toString(value.intValue());
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalStateException("Could not parse tp [" + string + "] for code [" + code + "]");
        }
    }

    private List<OccupationalLeistung> getExisting(String code, LocalDate validFrom) {
        LinkedHashMap<String, Object> propertyMap = new LinkedHashMap<String, Object>();
        propertyMap.put("code", code);
        propertyMap.put("validFrom", validFrom);
        return EntityUtil.loadByNamedQuery(propertyMap, OccupationalLeistung.class);
    }

    public int getCurrentVersion() {
        String versionString;
        OccupationalLeistung versionEntry = EntityUtil.load("VERSION", OccupationalLeistung.class);
        if (versionEntry != null && StringUtils.isNumeric((CharSequence)(versionString = versionEntry.getCodeText()))) {
            return Integer.parseInt(versionString);
        }
        return -1;
    }

    public static void setCurrentVersion(int newVersion) {
        OccupationalLeistung versionEntry = EntityUtil.load("VERSION", OccupationalLeistung.class);
        if (versionEntry != null) {
            versionEntry.setCodeText(Integer.toString(newVersion));
            EntityUtil.save(Collections.singletonList(versionEntry));
            return;
        }
        throw new IllegalArgumentException("No Version entry");
    }
}

