/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.nutrition.model.importer;

import ch.elexis.base.ch.arzttarife.model.service.ArzttarifeModelServiceHolder;
import ch.elexis.base.ch.arzttarife.nutrition.INutritionLeistung;
import ch.elexis.base.ch.arzttarife.tarmed.model.importer.EntityUtil;
import ch.elexis.core.interfaces.AbstractReferenceDataImporter;
import ch.elexis.core.interfaces.IReferenceDataImporter;
import ch.elexis.core.jpa.entities.NutritionLeistung;
import ch.elexis.core.services.IQuery;
import ch.rgw.tools.TimeTool;
import com.opencsv.CSVReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.osgi.service.component.annotations.Component;
import org.slf4j.LoggerFactory;

@Component(property={"referenceDataId=nutrition"})
public class NutritionReferenceDataImporter
extends AbstractReferenceDataImporter
implements IReferenceDataImporter {
    private LocalDate validFrom;
    private LocalDate endOfEpoch = new TimeTool("20380118").toLocalDate();

    public IStatus performImport(IProgressMonitor monitor, InputStream input, Integer newVersion) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.validFrom = this.getValidFromVersion(newVersion).toLocalDate();
        try {
            CSVReader reader = new CSVReader((Reader)new InputStreamReader(input, "UTF-8"), ';');
            monitor.beginTask("Importiere Ern\u00e4hrungsberatung", 100);
            String[] line = reader.readNext();
            while ((line = reader.readNext()) != null) {
                if (line.length < 4 || !StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{line[0]}) || !Character.isDigit(line[0].charAt(0))) continue;
                monitor.subTask(line[1]);
                this.updateOrCreateFromLine(line);
            }
            this.closeAllOlder();
            monitor.done();
            return Status.OK_STATUS;
        }
        catch (IOException uee) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Could not import nutrition tarif", (Throwable)uee);
            return Status.CANCEL_STATUS;
        }
    }

    private TimeTool getValidFromVersion(Integer newVersion) {
        String intString = Integer.toString(newVersion);
        if (intString.length() != 6) {
            throw new IllegalStateException("Version " + newVersion + " can not be parsed to valid date.");
        }
        String year = intString.substring(0, 2);
        String month = intString.substring(2, 4);
        String day = intString.substring(4, 6);
        TimeTool ret = new TimeTool();
        ret.set(1, Integer.parseInt(year) + 2000);
        ret.set(2, Integer.parseInt(month) - 1);
        ret.set(5, Integer.parseInt(day));
        return ret;
    }

    private void closeAllOlder() {
        LocalDate defaultValidFrom = LocalDate.of(1970, 1, 1);
        List<NutritionLeistung> entries = EntityUtil.loadAll(NutritionLeistung.class);
        for (NutritionLeistung nutrition : entries) {
            LocalDate pValidFrom = nutrition.getValidFrom();
            LocalDate pValidUntil = nutrition.getValidUntil();
            if (pValidFrom == null) {
                nutrition.setValidFrom(defaultValidFrom);
                nutrition.setValidUntil(this.validFrom);
                continue;
            }
            if (this.validFrom.equals(pValidFrom)) continue;
            if (pValidUntil == null) {
                nutrition.setValidUntil(this.validFrom);
                continue;
            }
            if (!pValidUntil.isEqual(this.endOfEpoch)) continue;
            nutrition.setValidUntil(this.validFrom);
        }
    }

    private void updateOrCreateFromLine(String[] line) {
        List<NutritionLeistung> entries = EntityUtil.loadByNamedQuery(Collections.singletonMap("code", line[0]), NutritionLeistung.class);
        ArrayList<NutritionLeistung> openEntries = new ArrayList<NutritionLeistung>();
        for (NutritionLeistung nutrition : entries) {
            LocalDate pValidUntil = nutrition.getValidUntil();
            if (pValidUntil == null) {
                openEntries.add(nutrition);
                continue;
            }
            if (!pValidUntil.isEqual(this.endOfEpoch)) continue;
            openEntries.add(nutrition);
        }
        if (openEntries.isEmpty()) {
            NutritionLeistung nutrition;
            nutrition = new NutritionLeistung();
            nutrition.setCode(line[0]);
            nutrition.setCodeText(line[1]);
            nutrition.setDescription(line[2]);
            nutrition.setTp(line[3]);
            nutrition.setValidFrom(this.validFrom);
            nutrition.setValidUntil(null);
            if (this.lineHasFixPrice(line)) {
                this.applyFixPrice(nutrition, line[4]);
            }
            EntityUtil.save(Collections.singletonList(nutrition));
        } else {
            for (NutritionLeistung nutrition : openEntries) {
                if (nutrition.getValidFrom().equals(this.validFrom)) {
                    nutrition.setCodeText(line[1]);
                    nutrition.setDescription(line[2]);
                    nutrition.setTp(line[3]);
                    if (!this.lineHasFixPrice(line)) continue;
                    this.applyFixPrice(nutrition, line[4]);
                    continue;
                }
                nutrition.setValidUntil(this.validFrom);
                EntityUtil.save(Collections.singletonList(nutrition));
                NutritionLeistung newNutrition = new NutritionLeistung();
                newNutrition.setCode(line[0]);
                newNutrition.setCodeText(line[1]);
                newNutrition.setDescription(line[2]);
                newNutrition.setTp(line[3]);
                newNutrition.setValidFrom(this.validFrom);
                newNutrition.setValidUntil(null);
                if (this.lineHasFixPrice(line)) {
                    this.applyFixPrice(newNutrition, line[4]);
                }
                EntityUtil.save(Collections.singletonList(newNutrition));
            }
        }
    }

    private void applyFixPrice(NutritionLeistung nutrition, String string) {
        nutrition.setTp(string);
        StringBuilder sb = new StringBuilder();
        String existingText = nutrition.getText();
        if (existingText != null) {
            sb.append(existingText);
        }
        sb.append("\n[FIXPRICE]");
        nutrition.setCodeText(sb.toString());
    }

    private boolean lineHasFixPrice(String[] line) {
        return line.length > 4 && line[4] != null && !line[4].isEmpty() && Character.isDigit(line[4].charAt(0));
    }

    public int getCurrentVersion() {
        LocalDate validFrom;
        IQuery query = ArzttarifeModelServiceHolder.get().getQuery(INutritionLeistung.class);
        query.and("validFrom", IQuery.COMPARATOR.NOT_EQUALS, null);
        query.and("validUntil", IQuery.COMPARATOR.EQUALS, null);
        List nutritionLeistungen = query.execute();
        if (!nutritionLeistungen.isEmpty() && (validFrom = ((INutritionLeistung)nutritionLeistungen.get(0)).getValidFrom()) != null) {
            DateTimeFormatter ofPattern = DateTimeFormatter.ofPattern("yyMMdd");
            int version = Integer.valueOf(ofPattern.format(validFrom));
            return version;
        }
        return -1;
    }
}

