/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.model.service;

import ch.elexis.base.ch.arzttarife.model.service.ArzttarifeModelAdapterFactory;
import ch.elexis.base.ch.arzttarife.model.service.ArzttarifeModelServiceHolder;
import ch.elexis.base.ch.arzttarife.physio.IPhysioLeistung;
import ch.elexis.base.ch.arzttarife.physio.model.PhysioLeistung;
import ch.elexis.base.ch.arzttarife.util.ArzttarifeUtil;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.ICodeElementServiceContribution;
import ch.elexis.core.services.IElexisEntityManager;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IStoreToStringContribution;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component
public class PhysioLeistungCodeElementService
implements ICodeElementServiceContribution,
IStoreToStringContribution {
    @Reference(target="(id=default)")
    private IElexisEntityManager entityManager;

    public String getSystem() {
        return "Physiotherapie";
    }

    public ICodeElementService.CodeElementTyp getTyp() {
        return ICodeElementService.CodeElementTyp.SERVICE;
    }

    public Optional<ICodeElement> loadFromCode(String code, Map<Object, Object> context) {
        String law = this.getLaw(context);
        LocalDate date = this.getDate(context);
        IQuery query = ArzttarifeModelServiceHolder.get().getQuery(IPhysioLeistung.class);
        query.and("ziffer", IQuery.COMPARATOR.EQUALS, (Object)code);
        if (law != null) {
            if (!ArzttarifeUtil.isAvailableLaw(law)) {
                query.startGroup();
                query.or("law", IQuery.COMPARATOR.EQUALS, (Object)"");
                query.or("law", IQuery.COMPARATOR.EQUALS, null);
                query.andJoinGroups();
            } else {
                query.and("law", IQuery.COMPARATOR.EQUALS, (Object)law, true);
            }
        }
        List leistungen = query.execute();
        for (IPhysioLeistung leistung : leistungen) {
            if (!date.isAfter(leistung.getValidFrom()) && !date.equals(leistung.getValidFrom())) continue;
            if (leistung.getValidTo() != null) {
                if (!date.isBefore(leistung.getValidTo()) && !date.equals(leistung.getValidTo())) continue;
                return Optional.of(leistung);
            }
            return Optional.of(leistung);
        }
        return Optional.empty();
    }

    private LocalDate getDate(Map<Object, Object> context) {
        if (context != null) {
            Object date = context.get(ICodeElementService.ContextKeys.DATE);
            if (date instanceof LocalDate) {
                return (LocalDate)date;
            }
            IEncounter encounter = (IEncounter)context.get(ICodeElementService.ContextKeys.CONSULTATION);
            if (encounter != null) {
                return encounter.getDate();
            }
        }
        return LocalDate.now();
    }

    private String getLaw(Map<Object, Object> context) {
        if (context != null) {
            Object law = context.get(ICodeElementService.ContextKeys.LAW);
            if (law instanceof String) {
                return (String)law;
            }
            Object coverage = context.get(ICodeElementService.ContextKeys.COVERAGE);
            if (coverage instanceof ICoverage) {
                return ((ICoverage)coverage).getBillingSystem().getLaw().name();
            }
            Object consultation = context.get(ICodeElementService.ContextKeys.CONSULTATION);
            if (consultation instanceof IEncounter && ((IEncounter)consultation).getCoverage() != null) {
                return ((IEncounter)consultation).getCoverage().getBillingSystem().getLaw().name();
            }
        }
        return null;
    }

    public List<ICodeElement> getElements(Map<Object, Object> context) {
        return null;
    }

    public Optional<String> storeToString(Identifiable identifiable) {
        if (identifiable instanceof PhysioLeistung) {
            return Optional.of("ch.elexis.data.PhysioLeistung::" + ((PhysioLeistung)identifiable).getId());
        }
        return Optional.empty();
    }

    public Optional<Identifiable> loadFromString(String storeToString) {
        if (storeToString.startsWith("ch.elexis.data.PhysioLeistung::")) {
            String[] split = this.splitIntoTypeAndId(storeToString);
            String id = split[1];
            EntityManager em = (EntityManager)this.entityManager.getEntityManager();
            EntityWithId dbObject = (EntityWithId)em.find(ch.elexis.core.jpa.entities.PhysioLeistung.class, (Object)id);
            return Optional.ofNullable(ArzttarifeModelAdapterFactory.getInstance().getModelAdapter(dbObject, null, false).orElse(null));
        }
        return Optional.empty();
    }

    public List<Identifiable> loadFromStringWithIdPart(String partialStoreToString) {
        if (!partialStoreToString.startsWith("ch.elexis.data.PhysioLeistung::")) {
            return Collections.emptyList();
        }
        String[] split = this.splitIntoTypeAndId(partialStoreToString);
        if (split != null && split.length == 2) {
            String id = split[1];
            Class<ch.elexis.core.jpa.entities.PhysioLeistung> clazz = ch.elexis.core.jpa.entities.PhysioLeistung.class;
            EntityManager em = (EntityManager)this.entityManager.getEntityManager();
            TypedQuery query = em.createQuery("SELECT entity FROM " + clazz.getSimpleName() + " entity WHERE entity.id LIKE :idpart", clazz);
            query.setParameter("idpart", (Object)(String.valueOf(id) + "%"));
            List found = query.getResultList();
            if (!found.isEmpty()) {
                ArzttarifeModelAdapterFactory adapterFactory = ArzttarifeModelAdapterFactory.getInstance();
                return found.parallelStream().map(e -> adapterFactory.getModelAdapter((EntityWithId)e, null, false).orElse(null)).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    public Class<?> getEntityForType(String type) {
        if ("ch.elexis.data.PhysioLeistung".equals(type)) {
            return ch.elexis.core.jpa.entities.PhysioLeistung.class;
        }
        return null;
    }

    public String getTypeForEntity(Object entityInstance) {
        if (entityInstance instanceof ch.elexis.core.jpa.entities.PhysioLeistung) {
            return "ch.elexis.data.PhysioLeistung";
        }
        return null;
    }

    public String getTypeForModel(Class<?> interfaze) {
        Class entityClass = ArzttarifeModelAdapterFactory.getInstance().getEntityClass(interfaze);
        if (entityClass != null) {
            try {
                return this.getTypeForEntity(entityClass.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error getting type for model [" + interfaze + "]", (Throwable)e);
            }
        }
        return null;
    }
}

