/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.befunde.findings.migrator;

import ch.elexis.base.befunde.findings.migrator.messwert.MesswertFieldMapping;
import ch.elexis.base.befunde.findings.migrator.strategy.IMigrationStrategy;
import ch.elexis.base.befunde.findings.migrator.strategy.MesswertMigrationStrategyFactory;
import ch.elexis.befunde.Messwert;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IFindingsService;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.UriType;
import ch.elexis.core.findings.migration.IMigratorContribution;
import ch.elexis.core.findings.templates.service.IFindingsTemplateService;
import ch.elexis.core.findings.util.commands.UpdateFindingTextCommand;
import ch.elexis.data.DBConnection;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.TimeTool;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class MesswertMigrator
implements IMigratorContribution {
    private static Logger logger = LoggerFactory.getLogger(MesswertMigrator.class);
    private IFindingsTemplateService templateService;
    private IFindingsService findingsService;

    @Reference(unbind="-")
    public void setFindingsTemplateService(IFindingsTemplateService templateService) {
        this.templateService = templateService;
    }

    @Reference(unbind="-")
    public void setFindingsService(IFindingsService findingsService) {
        this.findingsService = findingsService;
    }

    @Activate
    public void activate() {
        if (this.initialized()) {
            MesswertMigrationStrategyFactory.clearCodeToTemplateCache();
            MesswertMigrationStrategyFactory.setFindingsTemplateService(this.templateService);
            logger.debug("Initialized, activation successful");
        } else {
            logger.error("Not initialized, activation failed");
        }
    }

    public boolean initialized() {
        return this.templateService != null && this.findingsService != null;
    }

    public void migratePatientMesswerte(String patientId) {
        Map<String, MesswertFieldMapping> mappingsMap = this.buildMappingsMap(MesswertFieldMapping.getMappings());
        for (Messwert messwert : this.getMesswerte(patientId)) {
            this.migrateMesswert(messwert, mappingsMap);
        }
    }

    private Map<String, MesswertFieldMapping> buildMappingsMap(List<MesswertFieldMapping> list) {
        HashMap<String, MesswertFieldMapping> ret = new HashMap<String, MesswertFieldMapping>();
        for (MesswertFieldMapping messwertFieldMapping : list) {
            ret.put(String.valueOf(messwertFieldMapping.getLocalBefund()) + messwertFieldMapping.getLocalBefundField(), messwertFieldMapping);
        }
        return ret;
    }

    private void migrateMesswert(Messwert messwert, Map<String, MesswertFieldMapping> mappingsMap) {
        String name = messwert.get("Name");
        TimeTool timeTool = new TimeTool();
        ArrayList<IObservation> observations = new ArrayList<IObservation>();
        boolean migrationError = false;
        if (this.isNotMigrated(messwert)) {
            Map values = messwert.getMap("Befunde");
            for (Object key : values.keySet()) {
                MesswertFieldMapping mapping = mappingsMap.get(String.valueOf(name) + (String)key);
                if (mapping != null) {
                    Optional<IObservation> observation = this.migrateMesswert(messwert, mapping, observations);
                    if (!observation.isPresent()) {
                        migrationError = true;
                        break;
                    }
                    timeTool.set(messwert.getDate());
                    observation.get().setEffectiveTime(timeTool.toLocalDateTime());
                    observation.get().setOriginUri(UriType.DB.toString(messwert.storeToString()));
                    observations.add(observation.get());
                    try {
                        new UpdateFindingTextCommand((IFinding)observation.get()).execute();
                    }
                    catch (ElexisException e) {
                        logger.warn("Updating finding text [" + name + (String)key + "] failed");
                    }
                    continue;
                }
                logger.warn("No mapping for [" + name + (String)key + "], not migrated");
            }
            if (migrationError) {
                this.deleteObservations(observations);
            }
        }
    }

    private void deleteObservations(List<IObservation> observations) {
        if (!observations.isEmpty()) {
            DBConnection connection = PersistentObject.getDefaultConnection();
            JdbcLink.Stm stm = connection.getStatement();
            try {
                for (IObservation observation : observations) {
                    stm.exec("DELETE FROM CH_ELEXIS_CORE_FINDINGS_OBSERVATION WHERE ID='" + observation.getId() + "';");
                }
            }
            finally {
                connection.releaseStatement(stm);
            }
        }
    }

    private Optional<IObservation> migrateMesswert(Messwert messwert, MesswertFieldMapping mapping, List<IObservation> createdObservations) {
        String result = messwert.getResult(mapping.getLocalBefundField());
        if (result != null && !result.isEmpty()) {
            IMigrationStrategy strategy = MesswertMigrationStrategyFactory.get(mapping, messwert, createdObservations);
            return strategy.migrate();
        }
        return Optional.empty();
    }

    private List<Messwert> getMesswerte(String patientId) {
        Query query = new Query(Messwert.class);
        query.add("PatientID", "=", patientId);
        return query.execute();
    }

    private boolean isNotMigrated(Messwert messwert) {
        return this.lookupMigratedObservations(UriType.DB.toString(messwert.storeToString())).isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<IObservation> lookupMigratedObservations(String originuri) {
        ArrayList<IObservation> ret = new ArrayList<IObservation>();
        JdbcLink.Stm stm = PersistentObject.getDefaultConnection().getStatement();
        if (stm == null) return ret;
        try {
            try {
                ResultSet result = stm.query("SELECT ID FROM CH_ELEXIS_CORE_FINDINGS_OBSERVATION WHERE originuri = '" + originuri + "';");
                while (result != null) {
                    if (!result.next()) {
                        return ret;
                    }
                    String id = result.getString(1);
                    this.findingsService.findById(id, IObservation.class, true).ifPresent(o -> {
                        boolean bl = ret.add((IObservation)o);
                    });
                }
                return ret;
            }
            catch (SQLException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error on migrated lookup", (Throwable)e);
                PersistentObject.getDefaultConnection().releaseStatement(stm);
                return ret;
            }
        }
        finally {
            PersistentObject.getDefaultConnection().releaseStatement(stm);
        }
    }

    public boolean canHandlePatientsFindings(Class<? extends IFinding> filter, ICoding coding) {
        return filter.isAssignableFrom(IObservation.class);
    }

    public void migratePatientsFindings(String patientId, Class<? extends IFinding> filter, ICoding coding) {
        if (filter.isAssignableFrom(IObservation.class)) {
            this.migratePatientMesswerte(patientId);
        }
    }
}

