/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.befunde;

import ch.elexis.base.befunde.Messages;
import ch.elexis.befunde.Messwert;
import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Query;
import ch.elexis.scripting.ScriptEditor;
import ch.rgw.tools.StringTool;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PrefsPage
extends Composite {
    String[] mNames;
    Text[] texts;
    Button[] checkboxes;
    Label[] labels;
    Map<Object, Object> hash;
    String name;

    PrefsPage(Composite parent, Map<Object, Object> fields, String name) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(3, false));
        this.hash = fields;
        this.name = name;
        this.load();
    }

    void load() {
        String fields;
        if (this.texts != null) {
            int i = 0;
            while (i < this.texts.length) {
                this.texts[i].dispose();
                this.checkboxes[i].dispose();
                this.labels[i].dispose();
                ++i;
            }
            this.mNames = null;
            this.checkboxes = null;
            this.labels = null;
            this.texts = null;
        }
        if (StringTool.isNothing((Object)(fields = (String)this.hash.get(String.valueOf(this.name) + "_FIELDS")))) {
            this.texts = new Text[1];
            this.checkboxes = new Button[1];
            this.labels = new Label[1];
            this.labels[0] = new Label((Composite)this, 0);
            this.labels[0].setText("F1");
            this.texts[0] = SWTHelper.createText((Composite)this, (int)1, (int)0);
            this.checkboxes[0] = new Button((Composite)this, 32);
            this.checkboxes[0].setText(Messages.PrefsPage_multilineCaption);
        } else {
            this.mNames = fields.split(";;");
            this.texts = new Text[this.mNames.length + 1];
            this.checkboxes = new Button[this.texts.length];
            this.labels = new Label[this.texts.length];
            int i = 0;
            while (i < this.texts.length) {
                this.labels[i] = new Label((Composite)this, 0);
                this.labels[i].setText("F" + Integer.toString(i + 1));
                this.labels[i].setForeground(UiDesk.getColor((String)"blau"));
                this.labels[i].addMouseListener((MouseListener)new ScriptListener(i));
                this.texts[i] = SWTHelper.createText((Composite)this, (int)1, (int)0);
                this.checkboxes[i] = new Button((Composite)this, 32);
                this.checkboxes[i].setText(Messages.PrefsPage_multilineCaption);
                if (i < this.mNames.length) {
                    String[] line = this.mNames[i].split(":/:");
                    this.texts[i].setText(line[0]);
                    if (line.length > 1) {
                        this.checkboxes[i].setSelection(line[1].equals("m"));
                    }
                }
                ++i;
            }
        }
        this.layout();
    }

    void flush() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.texts.length) {
            String n = this.texts[i].getText();
            if (!StringTool.isNothing((Object)n)) {
                String m = "m";
                if (!this.checkboxes[i].getSelection()) {
                    m = "s";
                }
                sb.append(n).append(":/:").append(m).append(";;");
            }
            ++i;
        }
        if (sb.length() > ";;".length()) {
            sb.setLength(sb.length() - ";;".length());
            this.hash.put(String.valueOf(this.name) + "_FIELDS", sb.toString());
        }
    }

    boolean remove() {
        if (AccessControlServiceHolder.get().evaluate((EvaluatableACE)EvACE.of(IFinding.class, (Right)Right.DELETE)) && SWTHelper.askYesNo((String)Messages.PrefsPage_warningNotUndoableCaption, (String)Messages.PrefsPage_warningConfirmMessage)) {
            Query qbe = new Query(Messwert.class);
            qbe.add("Name", "=", this.name);
            for (Messwert m : qbe.execute()) {
                m.delete();
            }
            this.hash.remove(String.valueOf(this.name) + "_FIELDS");
            return true;
        }
        return false;
    }

    public boolean rename(String newName) {
        if (SWTHelper.askYesNo((String)Messages.PrefsPage_warningNotUndoableCaption, (String)Messages.PrefsPage_warningConfirmRename)) {
            Query qbe = new Query(Messwert.class);
            qbe.add("Name", "=", this.name);
            List list = qbe.execute();
            for (Messwert m : list) {
                m.set("Name", newName);
            }
            Object value = this.hash.get(String.valueOf(this.name) + "_FIELDS");
            this.hash.remove(String.valueOf(this.name) + "_FIELDS");
            this.hash.put(String.valueOf(newName) + "_FIELDS", value);
            this.name = newName;
            return true;
        }
        return false;
    }

    private class ScriptListener
    extends MouseAdapter {
        private int i;

        ScriptListener(int x) {
            this.i = x;
        }

        public void mouseUp(MouseEvent e) {
            ScriptEditor se = new ScriptEditor(PrefsPage.this.getShell(), PrefsPage.this.texts[this.i].getText(), Messages.PrefsPage_enterCalculationForThis);
            if (se.open() == 0) {
                PrefsPage.this.texts[this.i].setText(se.getScript());
            }
            super.mouseUp(e);
        }
    }
}

