/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.befunde;

import ch.elexis.base.befunde.EditFindingDialog;
import ch.elexis.base.befunde.Messages;
import ch.elexis.base.befunde.PrintFindingsDialog;
import ch.elexis.befunde.Messwert;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.Log;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.ViewPart;

public class FindingsView
extends ViewPart
implements IRefreshable {
    private static Log log = Log.get((String)FindingsView.class.getName());
    public static final String ID = "elexis-befunde.findingsView";
    private CTabFolder ctabs;
    private ScrolledForm form;
    private Map hash;
    private Action newValueAction;
    private Action editValueAction;
    private Action deleteValueAction;
    private Action printValuesAction;
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener((ViewPart)this);

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.form = UiDesk.getToolkit().createScrolledForm(parent);
        this.form.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        Composite body = this.form.getBody();
        body.setLayout((Layout)new FillLayout());
        this.ctabs = new CTabFolder(body, 0);
        this.ctabs.setLayout((Layout)new FillLayout());
        Messwert setup = Messwert.getSetup();
        this.hash = setup.getMap("Befunde");
        String names = (String)this.hash.get("names");
        if (!StringTool.isNothing((Object)names)) {
            String[] stringArray = names.split(";;");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String n3 = stringArray[n2];
                CTabItem ci = new CTabItem(this.ctabs, 0);
                ci.setText(n3);
                FindingsPage fp = new FindingsPage((Composite)this.ctabs, n3);
                ci.setControl((Control)fp);
                ++n2;
            }
        }
        this.makeActions();
        ViewMenus menu = new ViewMenus(this.getViewSite());
        menu.createToolbar(new IAction[]{this.newValueAction, this.editValueAction, this.printValuesAction, this.deleteValueAction});
        this.ctabs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CTabItem it = FindingsView.this.ctabs.getSelection();
                if (it != null) {
                    FindingsPage page = (FindingsPage)it.getControl();
                    page.setPatient(ElexisEventDispatcher.getSelectedPatient());
                }
            }
        });
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
        if (this.ctabs.getItemCount() > 0) {
            this.ctabs.setSelection(0);
            ((FindingsPage)this.ctabs.getItem(0).getControl()).setPatient(ElexisEventDispatcher.getSelectedPatient());
        }
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
    }

    public void setFocus() {
    }

    private void setPatient(Patient p) {
        if (p == null) {
            this.form.setText(Messages.FindingsView_noPatientSelected);
        } else {
            this.form.setText(p.getLabel());
        }
        int idx = this.ctabs.getSelectionIndex();
        if (idx != -1) {
            CTabItem item = this.ctabs.getItem(idx);
            FindingsPage fp = (FindingsPage)item.getControl();
            fp.setPatient(p);
        }
    }

    private void makeActions() {
        this.newValueAction = new Action(Messages.MesswerteView_enterNewValue){
            {
                this.setImageDescriptor(Images.IMG_ADDITEM.getImageDescriptor());
                this.setToolTipText(Messages.FindingsView_addNewMeasure);
            }

            public void run() {
                CTabItem ci = FindingsView.this.ctabs.getSelection();
                if (ci != null) {
                    FindingsPage page = (FindingsPage)ci.getControl();
                    EditFindingDialog dlg = new EditFindingDialog(FindingsView.this.getSite().getShell(), null, page.myparm);
                    if (dlg.open() == 0) {
                        page.setPatient(ElexisEventDispatcher.getSelectedPatient());
                    }
                }
            }
        };
        this.editValueAction = new Action(Messages.FindingsView_editActionCaption){
            {
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
                this.setToolTipText(Messages.FindingsView_editActionToolTip);
            }

            public void run() {
                CTabItem ci = FindingsView.this.ctabs.getSelection();
                if (ci != null) {
                    EditFindingDialog dlg;
                    FindingsPage page = (FindingsPage)ci.getControl();
                    TableItem[] it = page.table.getSelection();
                    if (it.length == 1 && (dlg = new EditFindingDialog(FindingsView.this.getSite().getShell(), (Messwert)((Object)it[0].getData()), page.myparm)).open() == 0) {
                        page.setPatient(ElexisEventDispatcher.getSelectedPatient());
                    }
                }
            }
        };
        this.deleteValueAction = new Action(Messages.FindingsView_deleteActionCaption){
            {
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
                this.setToolTipText(Messages.FindingsView_deleteActionToolTip);
            }

            public void run() {
                CTabItem ci;
                if (SWTHelper.askYesNo((String)Messages.FindingsView_deleteConfirmCaption, (String)Messages.FindingsView_deleteConfirmMessage) && (ci = FindingsView.this.ctabs.getSelection()) != null) {
                    FindingsPage page = (FindingsPage)ci.getControl();
                    TableItem[] it = page.table.getSelection();
                    if (it.length == 1) {
                        Messwert mw = (Messwert)((Object)it[0].getData());
                        mw.delete();
                        page.setPatient(ElexisEventDispatcher.getSelectedPatient());
                    }
                }
            }
        };
        this.printValuesAction = new Action(Messages.FindingsView_printActionCaptiob){
            {
                this.setImageDescriptor(Images.IMG_PRINTER.getImageDescriptor());
                this.setToolTipText(Messages.FindingsView_printActionMessage);
            }

            public void run() {
                CTabItem top = FindingsView.this.ctabs.getSelection();
                if (top != null) {
                    FindingsPage fp = (FindingsPage)top.getControl();
                    String[][] table = fp.getFields();
                    new PrintFindingsDialog(FindingsView.this.getViewSite().getShell(), table).open();
                }
            }
        };
    }

    @Inject
    void activePatient(@Optional IPatient patient) {
        CoreUiUtil.runAsyncIfActive(() -> this.setPatient((Patient)NoPoUtil.loadAsPersistentObject((Identifiable)patient)), (Object)this.form);
    }

    public void refresh() {
        this.activePatient(ContextServiceHolder.get().getActivePatient().orElse(null));
    }

    public void selectTab(String tabName) {
        CTabItem[] cTabItemArray = this.ctabs.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            if (item.getText().equalsIgnoreCase(tabName)) {
                this.ctabs.setSelection(item);
                FindingsPage page = (FindingsPage)item.getControl();
                page.setPatient(ElexisEventDispatcher.getSelectedPatient());
                break;
            }
            ++n2;
        }
    }

    class FindingsPage
    extends Composite {
        boolean sortDescending;
        Table table;
        TableColumn[] tc;
        TableItem[] items;
        String myparm;
        String[] flds;

        FindingsPage(Composite parent, String param) {
            super(parent, 0);
            this.sortDescending = true;
            this.flds = null;
            parent.setLayout((Layout)new FillLayout());
            this.myparm = param;
            this.setLayout((Layout)new GridLayout());
            this.table = new Table((Composite)this, 68096);
            this.table.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
            this.table.setHeaderVisible(true);
            this.table.setLinesVisible(true);
            String vals = (String)FindingsView.this.hash.get(String.valueOf(param) + "_FIELDS");
            if (vals != null) {
                this.flds = vals.split(";;");
                this.tc = new TableColumn[this.flds.length + 1];
                this.tc[0] = new TableColumn(this.table, 0);
                this.tc[0].setText("Datum");
                this.tc[0].setWidth(80);
                this.tc[0].addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        FindingsPage.this.items = FindingsPage.this.table.getItems();
                        int i = 0;
                        while (i < FindingsPage.this.items.length) {
                            SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy");
                            Date date1 = null;
                            Date date2 = null;
                            try {
                                date1 = formatter.parse(FindingsPage.this.items[i].getText());
                                int j = 0;
                                while (j < i) {
                                    date2 = formatter.parse(FindingsPage.this.items[j].getText());
                                    if (FindingsPage.this.sortDescending) {
                                        if (date1.before(date2)) {
                                            FindingsPage.this.sort(i, j);
                                            break;
                                        }
                                    } else if (date1.after(date2)) {
                                        FindingsPage.this.sort(i, j);
                                        break;
                                    }
                                    ++j;
                                }
                            }
                            catch (ParseException e) {
                                log.log((Throwable)e, "Date parsing exception", 3);
                            }
                            ++i;
                        }
                        FindingsPage.this.sortDescending = !FindingsPage.this.sortDescending;
                        FindingsPage.this.table.setSortColumn(FindingsPage.this.tc[0]);
                        FindingsPage.this.table.update();
                    }
                });
                int i = 1;
                while (i <= this.flds.length) {
                    this.tc[i] = new TableColumn(this.table, 0);
                    this.flds[i - 1] = this.flds[i - 1].split(":/:")[0];
                    String[] header = this.flds[i - 1].split("=", 2);
                    this.tc[i].setText(header[0]);
                    if (header.length > 1) {
                        this.tc[i].setData("script", (Object)header[1]);
                    }
                    this.tc[i].setWidth(80);
                    ++i;
                }
                this.tc[this.flds.length].setWidth(600);
            }
            this.table.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    EditFindingDialog dlg;
                    TableItem[] it = FindingsPage.this.table.getSelection();
                    if (it.length == 1 && (dlg = new EditFindingDialog(FindingsView.this.getSite().getShell(), (Messwert)((Object)it[0].getData()), FindingsPage.this.myparm)).open() == 0) {
                        FindingsPage.this.setPatient(ElexisEventDispatcher.getSelectedPatient());
                    }
                }
            });
        }

        private void sort(int i, int j) {
            if (this.flds != null) {
                int columnCount = this.table.getColumnCount();
                String[] values = new String[columnCount];
                int fldIdx = 0;
                while (fldIdx < columnCount) {
                    values[fldIdx] = this.items[i].getText(fldIdx);
                    ++fldIdx;
                }
                this.items[i].dispose();
                TableItem item = new TableItem(this.table, 0, j);
                item.setText(values);
                this.items = this.table.getItems();
            }
        }

        public String[][] getFields() {
            if (this.flds != null) {
                String[][] ret = new String[this.table.getItemCount() + 1][this.flds.length + 1];
                ret[0][0] = "Datum";
                int i = 1;
                while (i <= this.flds.length) {
                    ret[0][i] = this.flds[i - 1];
                    ++i;
                }
                i = 0;
                while (i < this.table.getItemCount()) {
                    int j = 0;
                    while (j <= this.flds.length) {
                        ret[i + 1][j] = this.table.getItem(i).getText(j);
                        ++j;
                    }
                    ++i;
                }
                return ret;
            }
            return new String[0][0];
        }

        void setPatient(Patient pat) {
            if (pat != null) {
                Query qbe = new Query(Messwert.class);
                qbe.add("PatientID", "=", pat.getId());
                qbe.add("Name", "=", this.myparm);
                List list = qbe.execute();
                this.table.removeAll();
                Collections.sort(list, new Comparator<Messwert>(){

                    @Override
                    public int compare(Messwert o1, Messwert o2) {
                        TimeTool t1 = new TimeTool(o1.getDate());
                        TimeTool t2 = new TimeTool(o2.getDate());
                        return t1.compareTo((Calendar)t2);
                    }
                });
                for (Messwert m : list) {
                    TableItem item = new TableItem(this.table, 0);
                    item.setText(0, m.getDate());
                    item.setData((Object)m);
                    Map hash = m.getMap("Befunde");
                    int i = 0;
                    while (i < this.flds.length) {
                        item.setText(i + 1, PersistentObject.checkNull((Object)((String)hash.get(this.flds[i]))));
                        ++i;
                    }
                }
            }
        }
    }
}

