/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.befunde;

import ch.elexis.base.befunde.Messages;
import ch.elexis.befunde.Messwert;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.scripting.Interpreter;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Script;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import com.tiff.common.ui.datepicker.DatePickerCombo;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;

public class EditFindingDialog
extends TitleAreaDialog {
    Messwert mw;
    String name;
    DatePickerCombo dp;
    Map names;
    String[] flds;
    boolean[] multiline;
    String[] values;
    Text[] inputs;

    EditFindingDialog(Shell parent, Messwert m, String n) {
        super(parent);
        this.mw = m;
        this.name = n;
        this.names = Messwert.getSetup().getMap("Befunde");
        String key = String.valueOf(n) + "_FIELDS";
        if (this.names.containsKey(key)) {
            this.flds = ((String)this.names.get(key)).split(";;");
            this.multiline = new boolean[this.flds.length];
            this.values = new String[this.flds.length];
            this.inputs = new Text[this.flds.length];
            int i = 0;
            while (i < this.flds.length) {
                String[] line = this.flds[i].split(":/:");
                this.flds[i] = line[0];
                this.multiline[i] = line.length < 2 ? false : line[1].equals("m");
                ++i;
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        Patient pat = ElexisEventDispatcher.getSelectedPatient();
        if (pat != null) {
            ret.setLayout((Layout)new GridLayout());
            ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
            this.dp = new DatePickerCombo(ret, 0);
            if (this.mw == null) {
                this.dp.setDate(new Date());
            }
            if (this.mw != null) {
                this.dp.setDate(new TimeTool(this.mw.get("Datum")).getTime());
                Map vals = this.mw.getMap("Befunde");
                int i = 0;
                while (i < this.flds.length) {
                    this.values[i] = (String)vals.get(this.flds[i]);
                    ++i;
                }
            }
            if (this.flds != null) {
                int i = 0;
                while (i < this.flds.length) {
                    String[] heading = this.flds[i].split("=", 2);
                    if (heading.length == 1) {
                        new Label(ret, 0).setText(this.flds[i]);
                    } else {
                        Label hl = SWTHelper.createHyperlink((Composite)ret, (String)heading[0], (IHyperlinkListener)new ScriptListener(heading[1], i));
                        hl.setForeground(UiDesk.getColor((String)"blau"));
                    }
                    this.inputs[i] = SWTHelper.createText((Composite)ret, (int)(this.multiline[i] ? 4 : 1), (int)0);
                    this.inputs[i].setText(this.values[i] == null ? "" : this.values[i]);
                    if (heading.length > 1) {
                        this.inputs[i].setEditable(false);
                    }
                    ++i;
                }
            } else {
                MessageDialog.openWarning((Shell)this.getParentShell(), (String)"Warnung", (String)("Es sind keine Metriken f\u00fcr die Messung " + this.name + " vorhanden."));
                this.close();
            }
        }
        return ret;
    }

    public void create() {
        super.create();
        this.getShell().setText(Messages.EditFindingDialog_captionBefundEditDlg);
        Patient pat = ElexisEventDispatcher.getSelectedPatient();
        if (pat == null) {
            this.setTitle(Messages.EditFindingDialog_noPatientSelected);
        } else {
            this.setTitle(pat.getLabel());
        }
        this.setMessage(MessageFormat.format(Messages.EditFindingDialog_enterTextForBefund, this.name));
        this.setTitleImage(Images.IMG_LOGO.getImage());
    }

    protected void okPressed() {
        Map<String, String> hash;
        if (this.mw == null) {
            hash = new Hashtable();
            this.mw = new Messwert(ElexisEventDispatcher.getSelectedPatient(), this.name, this.dp.getText(), hash);
        } else {
            hash = this.mw.getMap("Befunde");
        }
        int i = 0;
        while (i < this.flds.length) {
            String val = this.inputs[i].getText();
            if (StringTool.isNothing((Object)val)) {
                hash.remove(this.flds[i]);
            } else {
                hash.put(this.flds[i], val);
            }
            ++i;
        }
        this.mw.setDate(this.dp.getDate());
        this.mw.setMap("Befunde", hash);
        super.okPressed();
    }

    class ScriptListener
    extends HyperlinkAdapter {
        int v;
        String script;

        ScriptListener(String scr, int i) {
            this.script = scr;
            this.v = i;
        }

        public void linkActivated(HyperlinkEvent e) {
            int vals = 0;
            while (vals < EditFindingDialog.this.inputs.length) {
                String sval = EditFindingDialog.this.inputs[vals].getText();
                if (!StringTool.isNothing((Object)sval)) {
                    double dval = 0.0;
                    try {
                        dval = Double.parseDouble(sval);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    this.script = this.script.replaceAll("F" + Integer.toString(vals + 1), Double.toString(dval));
                }
                ++vals;
            }
            try {
                Object result = null;
                if (this.script.startsWith("SCRIPT:")) {
                    String scriptname = this.script.substring("SCRIPT:".length());
                    result = Script.executeScript((String)scriptname, (PersistentObject[])new PersistentObject[0]);
                } else {
                    Interpreter scripter = Script.getInterpreterFor((String)this.script);
                    result = scripter.run(this.script, false);
                }
                EditFindingDialog.this.values[this.v] = result.toString();
            }
            catch (ElexisException e1) {
                ExHandler.handle((Throwable)e1);
                EditFindingDialog.this.values[this.v] = "?eval?";
            }
            EditFindingDialog.this.inputs[this.v].setText(EditFindingDialog.this.values[this.v]);
        }
    }
}

