/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.barcode.scanner.internal;

import ch.elexis.barcode.scanner.BarcodeScannerMessage;
import ch.elexis.barcode.scanner.internal.ToggleHandler;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.serial.Connection;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.util.SWTHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.State;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputHandler
extends ToggleHandler
implements Connection.ComPortListener {
    private static Logger logger = LoggerFactory.getLogger(InputHandler.class);
    List<Connection> connections = new ArrayList<Connection>();
    ExecutorService executorService = Executors.newSingleThreadExecutor();

    @Override
    protected void executeToggle(ExecutionEvent event, boolean newState) {
        if (newState) {
            final HashSet usedComPorts = new HashSet();
            this.setBaseEnabled(false);
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    int i = 0;
                    while (i < 2) {
                        String postfix = i > 0 ? String.valueOf(i) : "";
                        String comPort = CoreHub.localCfg.get("barcode/Symbol/port" + postfix, "");
                        String comSettings = CoreHub.localCfg.get("barcode/Symbol/settings" + postfix, "9600,8,n,1");
                        boolean waitForNewline = CoreHub.localCfg.get("barcode/Symbol/waitfornewline" + postfix, false);
                        boolean writeDataBufferDebugFile = CoreHub.localCfg.get("barcode/Symbol/writedatabufferdebugfile" + postfix, false);
                        if (!comPort.isEmpty()) {
                            if (usedComPorts.add(comPort)) {
                                InputHandler.this.openConnection(i, postfix, comPort, comSettings, waitForNewline, writeDataBufferDebugFile);
                            } else {
                                logger.debug("barcode scanner " + (i + 1) + " com port already in use: " + comPort);
                            }
                        }
                        ++i;
                    }
                    if (InputHandler.this.connections.isEmpty()) {
                        InputHandler.this.toggleButtonOff();
                        SWTHelper.showInfo((String)"Barcode Scanner", (String)"Die Verbindung zum Barcode Scanner konnte nicht aufgebaut werden.\nProbieren Sie es erneut oder \u00fcberpr\u00fcfen Sie bitte die Einstellungen des Barcode Scanners.");
                    }
                    InputHandler.this.setBaseEnabled(true);
                }
            });
        } else {
            this.closeAllConnections();
            this.toggleButtonOff();
            this.setBaseEnabled(true);
        }
    }

    private void openConnection(int i, String postfix, String comPort, String comSettings, boolean waitForNewline, boolean writeDataBufferDebugFile) {
        Connection barcodeScannerConn = new Connection("Barcode Scanner@" + comPort, comPort, comSettings, (Connection.ComPortListener)this).writeDataBufferDebugFile(writeDataBufferDebugFile);
        if (waitForNewline) {
            barcodeScannerConn.withEndOfChunk((byte[][])new byte[][]{{10}}).excludeDelimiters(true);
        }
        if (barcodeScannerConn.connect()) {
            logger.debug("barcode scanner " + (i + 1) + " connected to port: " + comPort);
            this.connections.add(barcodeScannerConn);
        } else {
            SWTHelper.showError((String)"Fehler mit Port", (String)("Konnte Verbindung zu Barcode Scanner " + (i + 1) + " auf Port " + comPort + " nicht \u00f6ffnen."));
        }
    }

    private void closeAllConnections() {
        int i = 0;
        for (Connection con : this.connections) {
            if (!con.isOpen()) continue;
            con.close(2000);
            ++i;
        }
        this.connections.clear();
        final int barcodeScannerSize = i;
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(barcodeScannerSize * 2500);
                    logger.debug("closed barcode scanners size: " + barcodeScannerSize);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
    }

    public void gotChunk(Connection conn, String chunk) {
        logger.debug(String.valueOf(conn.getName()) + ": gotChunk(): " + chunk);
        ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)new BarcodeScannerMessage(conn.getName(), conn.getMyPort(), chunk));
    }

    private void toggleButtonOff() {
        final ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        final Command toggleCommand = commandService.getCommand("ch.elexis.base.barcode.scanner.ListenerProcess");
        State state = toggleCommand.getState("STYLE");
        boolean currentState = (Boolean)state.getValue();
        if (currentState) {
            state.setValue((Object)(!currentState ? 1 : 0));
            UiDesk.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    commandService.refreshElements(toggleCommand.getId(), null);
                }
            });
        }
    }

    public void closed() {
        logger.info("Closed");
    }
}

