/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.archie.wzw;

import ch.elexis.archie.wzw.BaseStats;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.rgw.tools.Money;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class AlleLeistungen
extends BaseStats {
    static final String NAME = "Leistungen-Hitliste";
    static final String DESC = "Listet s\u00e4mtliche Leistungen im gegebenen Zeitraum";
    static final String[] HEADINGS = new String[]{"Codesystem", "Code", "Text", "Anzahl", "Umsatz"};

    public AlleLeistungen() {
        super(NAME, DESC, HEADINGS);
    }

    protected IStatus createContent(IProgressMonitor monitor) {
        ArrayList<Comparable[]> result = new ArrayList<Comparable[]>();
        List<IEncounter> conses = this.getConses(monitor);
        if (conses.size() > 0) {
            int clicksPerRound = this.HUGE_NUMBER / conses.size();
            HashMap<String, TarifStat> tstats = new HashMap<String, TarifStat>();
            for (IEncounter k : conses) {
                IPatient pat;
                IMandator m = k.getMandator();
                if (m == null) continue;
                ICoverage fall = k.getCoverage();
                if (fall != null && (pat = fall.getPatient()) != null) {
                    List vr = k.getBilled();
                    for (IBilled v : vr) {
                        IBillable vv = v.getBillable();
                        if (vv == null) {
                            System.out.println(v.getLabel());
                            continue;
                        }
                        String sname = vv.getCodeSystemName();
                        String scode = vv.getCode() == null ? "?" : vv.getCode();
                        TarifStat ts = (TarifStat)tstats.get(String.valueOf(sname) + scode);
                        if (ts == null) {
                            ts = new TarifStat();
                            ts.tarif = vv.getCodeSystemName();
                            ts.ziffer = vv.getCode() == null ? "?" : vv.getCode();
                            ts.text = vv.getText();
                            tstats.put(String.valueOf(sname) + scode, ts);
                        }
                        ts.count = (int)((double)ts.count + v.getAmount());
                        ts.umsatz += v.getTotal().doubleValue();
                    }
                }
                monitor.worked(clicksPerRound);
                if (!monitor.isCanceled()) continue;
                return Status.CANCEL_STATUS;
            }
            for (TarifStat ts : tstats.values()) {
                Comparable[] row = new Comparable[this.dataSet.getHeadings().size()];
                row[0] = ts.tarif;
                row[1] = ts.ziffer;
                row[2] = ts.text;
                row[3] = new Integer(ts.count);
                row[4] = new Money(ts.umsatz);
                result.add(row);
            }
        }
        this.dataSet.setContent(result);
        return Status.OK_STATUS;
    }

    class TarifStat {
        String tarif;
        String ziffer;
        String text;
        int count;
        double umsatz;

        TarifStat() {
        }
    }
}

