/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.archie.patientstatistik;

import ch.elexis.archie.patientstatistik.Counter;
import ch.elexis.archie.patientstatistik.Messages;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Money;
import ch.rgw.tools.StringTool;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.part.ViewPart;

public class VerrechnungsStatistikView
extends ViewPart
implements IRefreshable,
Counter.IJobFinishedListener {
    private Action recalcAction;
    private Action exportCSVAction;
    Form form;
    Table table;
    private TableColumn textColumn;
    String[] tableHeaders = new String[]{Messages.VerrechnungsStatistikView_CODESYSTEM, Messages.VerrechnungsStatistikView_CODE, Messages.VerrechnungsStatistikView_TEXT, Messages.VerrechnungsStatistikView_NUMBER, Messages.VerrechnungsStatistikView_AMOUNT};
    int[] columnWidths = new int[]{130, 60, 160, 40, 50};
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener((ViewPart)this);

    @Inject
    void activePatient(@Optional IPatient patient) {
        CoreUiUtil.runAsyncIfActive(() -> {
            if (patient != null) {
                Patient pat = (Patient)NoPoUtil.loadAsPersistentObject((Identifiable)patient);
                if (pat != null) {
                    this.form.setText(pat.getLabel());
                } else {
                    this.form.setText(Messages.VerrechnungsStatistikView_NoPatientSelected);
                }
                this.recalc();
            } else {
                this.form.setText(Messages.VerrechnungsStatistikView_NoPatientSelected);
            }
        }, (Object)this.form);
    }

    public void createPartControl(Composite parent) {
        this.form = UiDesk.getToolkit().createForm(parent);
        this.form.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.form.getBody().setLayout((Layout)new GridLayout());
        this.table = new Table(this.form.getBody(), 0);
        this.table.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        int i = 0;
        while (i < this.tableHeaders.length) {
            final TableColumn tc = new TableColumn(this.table, 0);
            tc.setText(this.tableHeaders[i]);
            tc.setWidth(this.columnWidths[i]);
            if (this.tableHeaders[i].equals(Messages.VerrechnungsStatistikView_CODESYSTEM) || this.tableHeaders[i].equals(Messages.VerrechnungsStatistikView_TEXT)) {
                final int columnIndex = i;
                this.textColumn = tc;
                tc.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        VerrechnungsStatistikView.this.sortTable(columnIndex, tc);
                    }
                });
            }
            ++i;
        }
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.makeActions();
        ViewMenus menu = new ViewMenus(this.getViewSite());
        menu.createToolbar(new IAction[]{this.exportCSVAction, this.recalcAction});
        menu.createMenu(new IAction[]{this.exportCSVAction});
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
    }

    private void sortTable(final int columnIndex, TableColumn column) {
        this.table.setSortColumn(column);
        final int sortDirection = this.table.getSortDirection() == 128 ? 1024 : 128;
        this.table.setSortDirection(sortDirection);
        TableItem[] items = this.table.getItems();
        List<TableItem> itemList = Arrays.asList(items);
        Collections.sort(itemList, new Comparator<TableItem>(){

            @Override
            public int compare(TableItem item1, TableItem item2) {
                String text1 = item1.getText(columnIndex);
                String text2 = item2.getText(columnIndex);
                int compareResult = text1.compareTo(text2);
                return sortDirection == 128 ? compareResult : -compareResult;
            }
        });
        String[][] data = new String[items.length][this.table.getColumnCount()];
        int i = 0;
        while (i < items.length) {
            int j = 0;
            while (j < this.table.getColumnCount()) {
                data[i][j] = items[i].getText(j);
                ++j;
            }
            ++i;
        }
        this.table.setRedraw(false);
        this.table.removeAll();
        String[][] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String[] rowData = stringArray[n2];
            TableItem newItem = new TableItem(this.table, 0);
            newItem.setText(rowData);
            ++n2;
        }
        this.table.setRedraw(true);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
        super.dispose();
    }

    public void setFocus() {
    }

    public void clearEvent(Class<? extends PersistentObject> template) {
    }

    private void recalc() {
        Patient pat = ElexisEventDispatcher.getSelectedPatient();
        if (pat != null) {
            Counter counter = new Counter(pat, null, null, this);
            this.table.removeAll();
            counter.schedule();
        }
    }

    @Override
    public void jobFinished(Counter counter) {
        HashMap<IBillable, List<IBilled>> cnt = counter.getValues();
        HashMap<String, Money> totals = new HashMap<String, Money>();
        ArrayList<IBillable> set = new ArrayList<IBillable>(cnt.keySet());
        Collections.sort(set, new Comparator<IBillable>(){

            @Override
            public int compare(IBillable o1, IBillable o2) {
                if (o1 != null && o2 != null) {
                    String csname2;
                    String csname1 = o1.getCodeSystemName();
                    int res = csname1.compareTo(csname2 = o2.getCodeSystemName());
                    if (res == 0) {
                        String cscode1 = o1.getCode();
                        String cscode2 = o2.getCode();
                        res = cscode1.compareTo(cscode2);
                    }
                    return res;
                }
                return 0;
            }
        });
        for (IBillable iv : set) {
            if (iv == null) continue;
            TableItem ti = new TableItem(this.table, 0);
            String codename = iv.getCodeSystemName();
            Money tCode = (Money)totals.get(codename);
            if (tCode == null) {
                tCode = new Money();
                totals.put(codename, tCode);
            }
            ti.setText(0, StringTool.unNull((String)codename));
            ti.setText(1, StringTool.unNull((String)iv.getCode()));
            ti.setText(2, StringTool.unNull((String)iv.getText()));
            Money total = new Money();
            int count = 0;
            for (IBilled vv : cnt.get(iv)) {
                total.addMoney(vv.getTotal());
                count = (int)((double)count + vv.getAmount());
            }
            tCode.addMoney(total);
            ti.setText(3, Integer.toString(count));
            ti.setText(4, total.getAmountAsString());
        }
        Money sumAll = new Money();
        for (String n : totals.keySet()) {
            TableItem ti = new TableItem(this.table, 0);
            ti.setText(0, String.valueOf(Messages.VerrechnungsStatistikView_SUM) + n);
            Money sumClass = (Money)totals.get(n);
            ti.setText(4, sumClass.getAmountAsString());
            sumAll.addMoney(sumClass);
        }
        TableItem ti = new TableItem(this.table, 1);
        ti.setText(0, Messages.VerrechnungsStatistikView_SUMTOTAL);
        ti.setText(4, sumAll.getAmountAsString());
    }

    public void refresh() {
        this.activePatient(ContextServiceHolder.get().getActivePatient().orElse(null));
    }

    private void makeActions() {
        this.recalcAction = new Action(Messages.VerrechnungsStatistikView_REFRESH, Images.IMG_REFRESH.getImageDescriptor()){

            public void run() {
                VerrechnungsStatistikView.this.recalc();
            }
        };
        this.exportCSVAction = new Action(Messages.VerrechnungsStatistikView_ExportToCSV, Images.IMG_EXPORT.getImageDescriptor()){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                FileDialog fd = new FileDialog(VerrechnungsStatistikView.this.getViewSite().getShell(), 8192);
                fd.setFilterExtensions(new String[]{"*.csv", "*.*"});
                fd.setFilterNames(new String[]{"CSV", Messages.VerrechnungsStatistikView_AllFiles});
                fd.setFileName("elexis-verr.csv");
                String fname = fd.open();
                if (fname == null) return;
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try {
                        FileOutputStream fos = new FileOutputStream(fname);
                        try {
                            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fos, "ISO-8859-1");){
                                String headers = String.valueOf(String.join((CharSequence)";", VerrechnungsStatistikView.this.tableHeaders)) + "\r\n";
                                writer.write(headers);
                                TableItem[] tableItemArray = VerrechnungsStatistikView.this.table.getItems();
                                int n = tableItemArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    TableItem it = tableItemArray[n2];
                                    ArrayList<String> row = new ArrayList<String>();
                                    int i = 0;
                                    while (i < VerrechnungsStatistikView.this.table.getColumnCount()) {
                                        String cellText = it.getText(i);
                                        if (i == 4) {
                                            cellText = cellText.replace("\u2019", "").replace("'", "");
                                        }
                                        row.add(cellText);
                                        ++i;
                                    }
                                    String line = String.valueOf(String.join((CharSequence)";", row)) + "\r\n";
                                    writer.write(line);
                                    ++n2;
                                }
                            }
                            if (fos == null) return;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (fos == null) throw throwable;
                            ((OutputStream)fos).close();
                            throw throwable;
                        }
                        ((OutputStream)fos).close();
                        return;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        } else {
                            if (throwable == throwable3) throw throwable;
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    ExHandler.handle((Throwable)e);
                }
            }
        };
    }
}

