/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.util;

import ch.elexis.agenda.data.Termin;
import ch.elexis.agenda.util.Messages;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.data.Query;
import ch.rgw.tools.TimeTool;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class TermineLockedTimesUpdater
implements IRunnableWithProgress {
    private TimeTool _startDate;
    private TimeTool.DAYS _applyForDay;
    private String _newValues;
    private String _bereich;

    public TermineLockedTimesUpdater(TimeTool startChangeDate, TimeTool.DAYS selectedDay, String reservedSlots, String terminBereich) {
        this._startDate = startChangeDate;
        this._applyForDay = selectedDay;
        this._newValues = reservedSlots;
        this._bereich = terminBereich;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        Query qbe = new Query(Termin.class);
        qbe.add("BeiWem", "LIKE", this._bereich);
        List appointments = qbe.execute();
        monitor.beginTask(Messages.TermineLockedTimesUpdater_0, 2 * appointments.size());
        List<String> skipUpdate = this.checkAppointmentCollision(appointments, monitor);
        for (Termin t : appointments) {
            if (skipUpdate.contains(t.getDay())) continue;
            TimeTool day = new TimeTool(t.getDay());
            if (this._startDate.isBeforeOrEqual(day) && t.getType().equals(Termin.typReserviert())) {
                t.delete();
            }
            monitor.worked(1);
        }
        monitor.done();
        ContextServiceHolder.get().sendEvent("info/elexis/model/invalidatecache", IAppointment.class);
    }

    private List<String> checkAppointmentCollision(List<Termin> appointments, IProgressMonitor monitor) {
        ArrayList<String> skipUpdate = new ArrayList<String>();
        String[] closedTimes = this._newValues.split("\n");
        TimeTool day = new TimeTool();
        for (Termin t : appointments) {
            if (t.getId().equals("1") || t.getDay() == null || t.getDay().length() < 3) continue;
            day.set(t.getDay());
            if (this._startDate.isBeforeOrEqual(day) && day.get(7) == this._applyForDay.numericDayValue && !t.getType().equals(Termin.typReserviert())) {
                String[] stringArray = closedTimes;
                int n = closedTimes.length;
                int n2 = 0;
                while (n2 < n) {
                    boolean keepOldLocktimes;
                    int bis;
                    String s = stringArray[n2];
                    int von = TimeTool.minutesStringToInt((String)s.split("-")[0]);
                    if (t.crossesTimeFrame(von, (bis = TimeTool.minutesStringToInt((String)s.split("-")[1])) - von) && (keepOldLocktimes = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.TermineLockedTimesUpdater_4, (String)(String.valueOf(Messages.TermineLockedTimesUpdater_5) + t.getLabel() + Messages.TermineLockedTimesUpdater_6 + s + ". " + Messages.TermineLockedTimesUpdater_7)))) {
                        skipUpdate.add(t.getDay());
                    }
                    ++n2;
                }
            }
            monitor.worked(1);
        }
        return skipUpdate;
    }
}

