/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.composite;

import ch.elexis.agenda.commands.EmailEditHandler;
import ch.elexis.agenda.ui.Messages;
import ch.elexis.core.mail.MailAccount;
import ch.elexis.core.mail.MailTextTemplate;
import ch.elexis.core.mail.ui.client.MailClientComponent;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.ITextTemplate;
import ch.elexis.core.services.IContext;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.ITextReplacementService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;

public class EmailComposite
extends Composite {
    private static final String TEMPLATE_TEXT = "[Pea.SiteUrl]";
    private static final String TEMPLATE = "Terminbest\u00e4tigung inkl. Anmeldeformular";
    private static final String URL = "https://medelexis.ch/pea/";
    private static final String HYPERLINK = "<a href=\"https://medelexis.ch/pea/\">Weitere Informationen finden Sie hier.</a>";
    private static final String QUERY_SYMBOL = "?";
    private String preparedMessageText;
    @Inject
    private ITextReplacementService textReplacement;
    @Inject
    private IContextService contextService;
    private EmailEditHandler emailEdith;
    private Button chkEmail;
    private Label emailTemplatesLabel;
    private ComboViewer emailTemplatesViewer;
    private ITextTemplate previousTemplate = null;
    private boolean isEmailConfigured;
    private boolean isPatientSelected;
    private boolean hasEmail;
    private IContact pat;
    private Color blue = Display.getCurrent().getSystemColor(9);
    private Label emailHyperlink;

    public EmailComposite(Composite parent, int style, IContact selectedContact, final IAppointment appointment) {
        super(parent, style);
        CoreUiUtil.injectServicesWithContext((Object)((Object)this));
        this.pat = selectedContact;
        this.setLayout((Layout)new GridLayout(4, false));
        this.chkEmail = new Button((Composite)this, 32);
        this.chkEmail.setText(Messages.Appointment_Confirmation);
        this.chkEmail.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.chkEmail.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = EmailComposite.this.chkEmail.getSelection();
                EmailComposite.this.emailTemplatesViewer.getControl().setEnabled(selected);
                EmailComposite.this.emailTemplatesLabel.setEnabled(selected);
                EmailComposite.this.emailHyperlink.setEnabled(selected);
            }
        });
        this.emailTemplatesLabel = new Label((Composite)this, 0);
        this.emailTemplatesLabel.setText(String.valueOf(Messages.Core_E_Mail) + " " + Messages.Core_Temlate);
        this.emailTemplatesLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.emailTemplatesViewer = new ComboViewer((Composite)this, 12);
        this.emailTemplatesViewer.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.emailTemplatesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.emailTemplatesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ITextTemplate) {
                    ITextTemplate template = (ITextTemplate)element;
                    return String.valueOf(template.getName()) + (template.getMandator() != null ? " (" + template.getMandator().getLabel() + ")" : "");
                }
                return super.getText(element);
            }
        });
        this.emailTemplatesViewer.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Object selectedElement = selection.getFirstElement();
            if (selectedElement instanceof ITextTemplate) {
                ITextTemplate template = (ITextTemplate)selectedElement;
                String test = this.calculateTestValue();
                if (this.shouldNotExecute(template.getName(), test)) {
                    Shell shell = this.emailTemplatesViewer.getControl().getShell();
                    MessageDialog dialog = this.createMessageDialog(shell);
                    if (dialog.open() == 0 && this.previousTemplate != null) {
                        this.emailTemplatesViewer.setSelection((ISelection)new StructuredSelection((Object)this.previousTemplate), true);
                    }
                } else {
                    this.previousTemplate = template;
                }
            }
        });
        this.emailHyperlink = SWTHelper.createHyperlink((Composite)this, (String)"E-Mail bearbeiten", (IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                String emailTemplate = EmailComposite.this.getSelectedEmailTemplateViewerDetails().getTemplate();
                if (emailTemplate != null) {
                    IContext context = EmailComposite.this.contextService.createNamedContext("appointment_reminder_context");
                    context.setTyped((Object)appointment);
                    context.setTyped((Object)EmailComposite.this.pat);
                    EmailComposite.this.preparedMessageText = EmailComposite.this.textReplacement.performReplacement(context, emailTemplate);
                }
                if (EmailComposite.this.emailEdith == null) {
                    EmailComposite.this.emailEdith = new EmailEditHandler();
                }
                String subject = EmailComposite.this.getSelectedEmailTemplateViewerDetails().getName();
                EmailComposite.this.emailEdith.openSendMailDialogWithContent(appointment, EmailComposite.this.pat, EmailComposite.this.preparedMessageText, subject);
            }
        });
        this.emailHyperlink.setForeground(this.blue);
        this.emailHyperlink.setEnabled(false);
        this.updateTemplatesCombo();
    }

    private void updateTemplatesCombo() {
        this.emailTemplatesViewer.setInput((Object)MailTextTemplate.load());
    }

    public boolean isCheckboxChecked() {
        return this.chkEmail.getSelection();
    }

    private void selectSavedEmailTemplate() {
        String savedTemplate = ConfigServiceHolder.get().get("agenda/appointmenttemplate", null);
        String test = this.calculateTestValue();
        List templates = (List)this.emailTemplatesViewer.getInput();
        if (templates == null || templates.isEmpty()) {
            return;
        }
        if (this.shouldNotExecute(savedTemplate, test)) {
            this.emailTemplatesViewer.setSelection((ISelection)new StructuredSelection(templates.get(0)));
            return;
        }
        this.findAndSelectTemplate(savedTemplate, templates);
    }

    private void findAndSelectTemplate(String savedTemplate, List<ITextTemplate> templates) {
        if (savedTemplate != null && !savedTemplate.trim().isEmpty()) {
            for (ITextTemplate template : templates) {
                if (!savedTemplate.equals(template.getName())) continue;
                this.emailTemplatesViewer.setSelection((ISelection)new StructuredSelection((Object)template));
                return;
            }
        }
        this.emailTemplatesViewer.setSelection((ISelection)new StructuredSelection((Object)templates.get(0)));
    }

    public Object getSelectedTemplate() {
        return this.emailTemplatesViewer != null && this.emailTemplatesViewer.getStructuredSelection() != null ? this.emailTemplatesViewer.getStructuredSelection().getFirstElement() : null;
    }

    private boolean shouldNotExecute(String savedTemplate, String test) {
        return TEMPLATE.equals(savedTemplate) && QUERY_SYMBOL.equals(test);
    }

    private String calculateTestValue() {
        this.textReplacement = (ITextReplacementService)OsgiServiceUtil.getService(ITextReplacementService.class).orElseThrow(() -> new IllegalStateException());
        return this.textReplacement.performReplacement(ContextServiceHolder.get().getRootContext(), TEMPLATE_TEXT);
    }

    private MessageDialog createMessageDialog(Shell shell) {
        return new MessageDialog(shell, Messages.Warnung, null, Messages.Warning_Kein_Pea, 4, new String[]{Messages.Core_Ok}, 0){

            protected Control createCustomArea(Composite parent) {
                Link link = new Link(parent, 0);
                link.setText(EmailComposite.HYPERLINK);
                link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Program.launch((String)EmailComposite.URL);
                    }
                });
                return link;
            }
        };
    }

    public ITextTemplate getSelectedEmailTemplateViewerDetails() {
        IStructuredSelection selection = (IStructuredSelection)this.emailTemplatesViewer.getSelection();
        Object selectedElement = selection.getFirstElement();
        if (selectedElement instanceof ITextTemplate) {
            return (ITextTemplate)selectedElement;
        }
        return null;
    }

    public void updateStatus(boolean isEmailConfigured, boolean isPatientSelected, boolean hasEmail) {
        this.chkEmail.setEnabled(isEmailConfigured && isPatientSelected && hasEmail);
        boolean isEmailControlEnabled = this.chkEmail.getSelection() && isEmailConfigured && isPatientSelected && hasEmail;
        this.emailTemplatesViewer.getControl().setEnabled(isEmailControlEnabled);
        this.emailTemplatesLabel.setEnabled(isEmailControlEnabled);
        this.selectSavedEmailTemplate();
    }

    void updateEmailControlsStatus(IContact iContact) {
        List<String> validAccounts = this.getSendMailAccounts();
        String defaultMailAccountAppointment = ConfigServiceHolder.get().get("agenda/appointment", null);
        String defaultMailAccount = ConfigServiceHolder.get().get("account", null);
        this.isEmailConfigured = this.isValidEmailConfiguration(validAccounts, defaultMailAccountAppointment, defaultMailAccount);
        this.isPatientSelected = iContact instanceof IPatient;
        this.hasEmail = this.hasValidEmail(iContact);
        this.updateStatus(this.isEmailConfigured, this.isPatientSelected, this.hasEmail);
        this.pat = iContact;
    }

    private List<String> getSendMailAccounts() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(this.filterAccounts(MailClientComponent.getMailClient().getAccountsLocal()));
        ret.addAll(this.filterAccounts(MailClientComponent.getMailClient().getAccounts()));
        return ret;
    }

    private List<String> filterAccounts(List<String> accounts) {
        return accounts.stream().filter(aid -> MailClientComponent.getMailClient().getAccount(aid).isPresent()).filter(aid -> ((MailAccount)MailClientComponent.getMailClient().getAccount(aid).get()).getType() == MailAccount.TYPE.SMTP).collect(Collectors.toList());
    }

    private boolean isValidEmailConfiguration(List<String> validAccounts, String defaultMailAccountAppointment, String defaultMailAccount) {
        return validAccounts.contains(defaultMailAccountAppointment) || validAccounts.contains(defaultMailAccount);
    }

    private boolean hasValidEmail(IContact selectedContact) {
        return selectedContact != null && StringUtils.isNotBlank((CharSequence)selectedContact.getEmail());
    }

    public IPatient getSelectedPatient() {
        if (this.pat instanceof IPatient) {
            return (IPatient)this.pat;
        }
        return null;
    }

    public EmailDetails extractEmailDetails() {
        IPatient selectedPatient;
        ITextTemplate selectedTemplateViewerDetails = this.getSelectedEmailTemplateViewerDetails();
        if (selectedTemplateViewerDetails != null && (selectedPatient = this.getSelectedPatient()) != null) {
            return new EmailDetails(selectedTemplateViewerDetails, selectedPatient);
        }
        return null;
    }

    public static class EmailDetails {
        private IPatient patient;
        private ITextTemplate template;

        public EmailDetails(ITextTemplate template, IPatient patient) {
            this.template = template;
            this.patient = patient;
        }

        public String getTemplateContent() {
            return this.template.getTemplate();
        }

        public String getTemplateName() {
            return this.template.getName();
        }

        public IPatient patient() {
            return this.patient.asIPatient();
        }
    }
}

