/*
 * Decompiled with CFR 0.152.
 */
package ch.docbox.model;

import ch.docbox.cdach.CdaChXPath;
import ch.docbox.elexis.UserDocboxPreferences;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.data.Anwender;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.VersionInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdaMessage
extends PersistentObject {
    private static Logger logger = LoggerFactory.getLogger(CdaMessage.class);
    public static final String TABLENAME = "CH_DOCBOX_ELEXIS_CDAMESSAGE";
    public static final String DBVERSION = "1.1.0";
    public static final String createDB = "CREATE TABLE CH_DOCBOX_ELEXIS_CDAMESSAGE (ID\t\t\tVARCHAR(25) primary key,CreationDate VARCHAR(15),Deleted      CHAR(1) default '0',DeletedDocs  CHAR(1) default '0',lastupdate   BIGINT,PatID\t\tVARCHAR(25),DocumentID\tVARCHAR(25),AnwenderID\tVARCHAR(25),KonsultationID\tVARCHAR(25),Downloaded   CHAR(1) default '0',Date \t\tCHAR(24),Unread       CHAR(1) default '1',Title \t\tVARCHAR(255),Sender \t\tVARCHAR(255),Patient \t\tVARCHAR(255),FilesListing\tVARCHAR(2048),Cda\t\t\tBLOB);CREATE INDEX CH_DOCBOX_ELEXIS_CDAMESSAGEI1 ON CH_DOCBOX_ELEXIS_CDAMESSAGE (PatID);CREATE INDEX CH_DOCBOX_ELEXIS_CDAMESSAGEI2 ON CH_DOCBOX_ELEXIS_CDAMESSAGE (DocumentID);CREATE INDEX CH_DOCBOX_ELEXIS_CDAMESSAGEI3 ON CH_DOCBOX_ELEXIS_CDAMESSAGE (AnwenderID);CREATE INDEX CH_DOCBOX_ELEXIS_CDAMESSAGEI4 ON CH_DOCBOX_ELEXIS_CDAMESSAGE (ID);INSERT INTO CH_DOCBOX_ELEXIS_CDAMESSAGE (ID, TITLE) VALUES ('1','1.1.0');";
    public static final String upd110 = "ALTER TABLE CH_DOCBOX_ELEXIS_CDAMESSAGE MODIFY Title VARCHAR(255);ALTER TABLE CH_DOCBOX_ELEXIS_CDAMESSAGE MODIFY Sender VARCHAR(255);ALTER TABLE CH_DOCBOX_ELEXIS_CDAMESSAGE MODIFY Patient VARCHAR(255);";

    static {
        CdaMessage.addMapping((String)TABLENAME, (String[])new String[]{"CreationDate", "DeletedDocs", "PatID", "DocumentID", "AnwenderID", "KonsultationID", "Downloaded", "Unread", "Date", "Title", "Sender", "Patient", "FilesListing", "Cda"});
        CdaMessage start = CdaMessage.load("1");
        if (start == null) {
            CdaMessage.init();
        } else {
            VersionInfo vi = new VersionInfo(start.get("Title"));
            if (vi.isOlder(DBVERSION)) {
                if (vi.isOlder(DBVERSION)) {
                    CdaMessage.createOrModifyTable((String)upd110);
                    start.set("Title", DBVERSION);
                } else {
                    MessageDialog.openError((Shell)UiDesk.getTopShell(), (String)"Versionskonsflikt", (String)"Die Datentabelle f\u00fcr CH_DOCBOX_ELEXIS_CDAMESSAGE hat eine zu alte Versionsnummer. Dies kann zu Fehlern f\u00fchren");
                }
            }
        }
    }

    public static CdaMessage load(String id) {
        CdaMessage ret = new CdaMessage(id);
        if (ret.exists()) {
            return ret;
        }
        return null;
    }

    public static CdaMessage getCdaMessageEvenIfDocsDeleted(String documentId) {
        return CdaMessage.getCdaMessage((Anwender)CoreHub.actMandant, documentId, true);
    }

    public static CdaMessage getCdaMessage(String documentId) {
        return CdaMessage.getCdaMessage((Anwender)CoreHub.actMandant, documentId, false);
    }

    public static CdaMessage getCdaMessage(Anwender anwender, String documentId, boolean alsoDeletedDoc) {
        Object[] cdaMessages;
        Query cdaMessageQuery = new Query(CdaMessage.class);
        cdaMessageQuery.add("AnwenderID", "=", anwender.getId());
        cdaMessageQuery.add("DocumentID", "=", documentId);
        if (!alsoDeletedDoc) {
            cdaMessageQuery.add("DeletedDocs", "=", "0");
        }
        if ((cdaMessages = cdaMessageQuery.execute().toArray()) == null || cdaMessages.length == 0) {
            return null;
        }
        if (cdaMessages.length > 1) {
            logger.error("CdaMessage Query should give only one object back but got multiple with AnwenderID=  " + anwender.getId() + ", documentID " + documentId);
        }
        return (CdaMessage)((Object)cdaMessages[0]);
    }

    public static Object[] getCdaMessages() {
        return CdaMessage.getCdaMessages((Anwender)CoreHub.actMandant, false);
    }

    public static Object[] getCdaMessages(Anwender anwender, boolean alsoDeletedDoc) {
        if (anwender != null) {
            logger.debug("getCdaMessages for " + anwender.getId());
            Query cdaMessageQuery = new Query(CdaMessage.class);
            cdaMessageQuery.add("AnwenderID", "=", anwender.getId());
            if (!alsoDeletedDoc) {
                cdaMessageQuery.add("DeletedDocs", "=", "0");
            }
            cdaMessageQuery.orderBy(true, new String[]{"CreationDate"});
            Object[] objects = cdaMessageQuery.execute().toArray();
            logger.debug("returned cdaMessages" + objects.length);
            return objects;
        }
        return new CdaMessage[0];
    }

    public CdaMessage(String documentId, String title, GregorianCalendar date) {
        this.create(null);
        TimeTool timeTool = new TimeTool();
        timeTool.set(date);
        this.set(new String[]{"AnwenderID", "DocumentID", "Title", "Date", "CreationDate", "Unread"}, new String[]{CoreHub.actMandant.getId(), documentId, title, timeTool.toString(4), timeTool.toString(13), "1"});
    }

    public boolean setDownloaded(String sender, String patient) {
        return this.set(new String[]{"Sender", "Patient", "Downloaded"}, new String[]{sender, patient, "1"});
    }

    public boolean setCda(String cda) {
        if (cda != null) {
            try {
                this.setBinary("Cda", cda.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                return false;
            }
        }
        return true;
    }

    public String getCda() {
        try {
            return new String(this.getBinary("Cda"), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public static void init() {
        CdaMessage.createOrModifyTable((String)createDB);
    }

    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.get("Date")).append(" ").append(this.get("Title"));
        return sb.toString();
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    CdaMessage.deleteDirectory(files[i]);
                } else {
                    files[i].delete();
                }
                ++i;
            }
        }
        return path.delete();
    }

    public boolean deleteDocs() {
        if (this.getFiles() != null && this.getFiles().length > 0) {
            try {
                CdaMessage.deleteDirectory(new File(this.getPath()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setDeletedDocs();
        return true;
    }

    public boolean execute() {
        String[] files = this.getFiles();
        if (files != null && files.length > 0) {
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String path;
                String file = stringArray[n2];
                int pos = file.lastIndexOf(".");
                String ext = "";
                if (pos > 0) {
                    ext = file.substring(pos);
                }
                if (ext != null) {
                    ext = ext.trim();
                }
                if ((path = this.getPath(file)) != null) {
                    path = path.trim();
                }
                try {
                    Program program = Program.findProgram((String)ext);
                    if (program != null) {
                        program.execute(path);
                    } else if (!Program.launch((String)path)) {
                        Runtime.getRuntime().exec(path);
                    }
                }
                catch (Exception ex) {
                    ExHandler.handle((Throwable)ex);
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    protected String getTableName() {
        return TABLENAME;
    }

    protected CdaMessage(String id) {
        super(id);
    }

    protected CdaMessage() {
    }

    public boolean isDownloaded() {
        return this.getInt("Downloaded") != 0;
    }

    public boolean isDeletedDocs() {
        return this.getInt("DeletedDocs") != 0;
    }

    public void setDeletedDocs() {
        this.set(new String[]{"DeletedDocs"}, new String[]{"1"});
    }

    public void setRead() {
        this.set(new String[]{"Unread"}, new String[]{"0"});
    }

    public boolean isUnread() {
        return this.getInt("Unread") != 0;
    }

    public String getDate() {
        return this.get("Date");
    }

    public String getCreationDate() {
        return this.get("CreationDate");
    }

    public String getTitle() {
        return this.get("Title");
    }

    public String getSender() {
        return this.get("Sender");
    }

    public String getPatient() {
        return this.get("Patient");
    }

    public String getFilesListing() {
        return this.get("FilesListing");
    }

    public String[] getFiles() {
        return this.getFilesListing().split("\n");
    }

    public boolean hasAssignedToOmnivore() {
        return "ok".equals(this.getKonsultationId());
    }

    private String getKonsultationId() {
        return this.get("KonsultationID");
    }

    public void setAssignedToOmnivore() {
        this.set(new String[]{"KonsultationID"}, new String[]{"ok"});
    }

    public String getPath(String fileName) {
        String pathSeparator;
        String path = UserDocboxPreferences.getPathFiles();
        if (!path.endsWith(pathSeparator = System.getProperty("file.separator"))) {
            path = String.valueOf(path) + pathSeparator;
        }
        path = String.valueOf(path) + this.getId();
        if (fileName != null) {
            path = String.valueOf(path) + pathSeparator + fileName;
        }
        return path;
    }

    private String getPath() {
        return this.getPath(null);
    }

    public boolean unzipAttachment(byte[] attachment) {
        ArrayList<String> fileList = new ArrayList<String>();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(attachment);
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipEntry zipEntry = null;
        String path = this.getPath();
        try {
            File directory = new File(path);
            if (!directory.exists()) {
                directory.mkdir();
            }
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!zipEntry.isDirectory()) {
                    String fileName = zipEntry.getName();
                    fileList.add(fileName);
                    if (fileName.contains("/")) {
                        fileName = fileName.replaceAll("/", "");
                    }
                    if (fileName.contains("\\")) {
                        fileName = fileName.replaceAll("\\\\", "");
                    }
                    logger.debug("exporting file out of attachment to " + path + "," + fileName);
                    File file = new File(directory, fileName);
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    byte[] bytesEntry = new byte[1024];
                    int read = 0;
                    while ((read = zipInputStream.read(bytesEntry)) != -1) {
                        fileOutputStream.write(bytesEntry, 0, read);
                    }
                    fileOutputStream.close();
                }
                zipInputStream.closeEntry();
            }
            zipInputStream.close();
            String fileListConcatenated = "";
            int i = 0;
            while (i < fileList.size()) {
                fileListConcatenated = String.valueOf(fileListConcatenated) + (String)fileList.get(i);
                if (i < fileList.size() - 1) {
                    fileListConcatenated = String.valueOf(fileListConcatenated) + " \n";
                }
                ++i;
            }
            return this.set("FilesListing", fileListConcatenated);
        }
        catch (Exception e) {
            logger.error("Exception " + e.toString());
            return false;
        }
    }

    public boolean isDragOK() {
        return true;
    }

    public boolean isEqualsPatient(Patient patient) {
        CdaChXPath cdaChXPath = new CdaChXPath();
        String cda = this.getCda();
        if (patient == null) {
            return false;
        }
        if (cda != null) {
            cdaChXPath.setPatientDocument(cda);
            String lastName = cdaChXPath.getPatientLastName();
            String firstName = cdaChXPath.getPatientFirstName();
            String patientId = cdaChXPath.getPatientNumber();
            if (patientId != null && patientId.equals(patient.getId())) {
                return true;
            }
            if ((lastName == null || lastName.equals(patient.getName())) && (firstName == null || firstName.equals(patient.getVorname()))) {
                return true;
            }
        }
        return false;
    }

    public static boolean deleteCdaMessages(Anwender anwender) {
        Object[] cdaMessages = CdaMessage.getCdaMessages(anwender, true);
        if (cdaMessages != null) {
            logger.debug("trying to remove cdamessage " + cdaMessages.length);
            try {
                Object[] objectArray = cdaMessages;
                int n = cdaMessages.length;
                int n2 = 0;
                while (n2 < n) {
                    Object cdaMessageObject = objectArray[n2];
                    CdaMessage cdaMessage = (CdaMessage)((Object)cdaMessageObject);
                    logger.debug("deleting docs with id" + cdaMessage.getId());
                    cdaMessage.deleteDocs();
                    logger.debug("deleting cdaMessage with id" + cdaMessage.getId());
                    cdaMessage.delete();
                    ++n2;
                }
            }
            catch (Exception e) {
                logger.debug("deleting message failed");
            }
        }
        return true;
    }
}

